/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingSettingsPerFile;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.markup.InspectionsLevel;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0013H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/codeInsight/daemon/impl/LevelAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "level", "Lcom/intellij/openapi/editor/markup/InspectionsLevel;", "provider", "Lcom/intellij/psi/FileViewProvider;", "language", "Lcom/intellij/lang/Language;", "(Lcom/intellij/openapi/editor/markup/InspectionsLevel;Lcom/intellij/psi/FileViewProvider;Lcom/intellij/lang/Language;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "getLevel", "()Lcom/intellij/openapi/editor/markup/InspectionsLevel;", "getProvider", "()Lcom/intellij/psi/FileViewProvider;", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "e", "intellij.platform.lang.impl"})
final class LevelAction
extends ToggleAction
implements DumbAware {
    @NotNull
    private final InspectionsLevel level;
    @NotNull
    private final FileViewProvider provider;
    @NotNull
    private final Language language;

    public boolean isSelected(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PsiFile psiFile = this.provider.getPsi(this.language);
        if (psiFile == null) {
            return false;
        }
        PsiFile file2 = psiFile;
        HighlightingSettingsPerFile highlightingSettingsPerFile = HighlightingSettingsPerFile.getInstance(file2.getProject());
        if (highlightingSettingsPerFile == null) {
            return false;
        }
        HighlightingSettingsPerFile manager = highlightingSettingsPerFile;
        InspectionsLevel inspectionsLevel = FileHighlightingSetting.toInspectionsLevel(manager.getHighlightingSettingForRoot(file2));
        Intrinsics.checkNotNullExpressionValue((Object)inspectionsLevel, (String)"FileHighlightingSetting.\u2026tingSettingForRoot(file))");
        InspectionsLevel configuredLevel = inspectionsLevel;
        return this.level == configuredLevel;
    }

    public void setSelected(@NotNull AnActionEvent event, boolean state) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!state) {
            return;
        }
        PsiFile psiFile = this.provider.getPsi(this.language);
        if (psiFile == null) {
            return;
        }
        PsiFile file2 = psiFile;
        HighlightLevelUtil.forceRootHighlighting(file2, FileHighlightingSetting.fromInspectionsLevel(this.level));
        InjectedLanguageManager.getInstance(file2.getProject()).dropFileCaches(file2);
        DaemonCodeAnalyzer.getInstance(file2.getProject()).restart();
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        e.getPresentation().setDescription(EditorBundle.message((String)"hector.highlighting.level.title", (Object[])new Object[0]) + ": " + this.level.getDescription());
    }

    @NotNull
    public final InspectionsLevel getLevel() {
        return this.level;
    }

    @NotNull
    public final FileViewProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    public LevelAction(@NotNull InspectionsLevel level, @NotNull FileViewProvider provider2, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        super(level.toString());
        this.level = level;
        this.provider = provider2;
        this.language = language;
    }
}

