/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.codeInsight.hints.HintWidthAdjustment;
import com.intellij.codeInsight.hints.InlayHintsUtilsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Alarm;
import java.awt.FontMetrics;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class ParameterHintsPresentationManager
implements Disposable {
    private static final Key<AnimationStep> ANIMATION_STEP = Key.create("ParameterHintAnimationStep");
    private static final Key<Boolean> PREVIEW_MODE = Key.create("ParameterHintsPreviewMode");
    private static final int ANIMATION_STEP_MS = 25;
    private static final int ANIMATION_CHARS_PER_STEP = 3;
    private final Alarm myAlarm = new Alarm((Disposable)this);

    public static ParameterHintsPresentationManager getInstance() {
        return ApplicationManager.getApplication().getService(ParameterHintsPresentationManager.class);
    }

    private ParameterHintsPresentationManager() {
    }

    public List<Inlay<?>> getParameterHintsInRange(@NotNull Editor editor2, int startOffset, int endOffset) {
        if (editor2 == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(0);
        }
        return editor2.getInlayModel().getInlineElementsInRange(startOffset, endOffset, MyRenderer.class);
    }

    public boolean isParameterHint(@NotNull Inlay inlay) {
        if (inlay == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(1);
        }
        return inlay.getRenderer() instanceof MyRenderer;
    }

    public String getHintText(@NotNull Inlay inlay) {
        EditorCustomElementRenderer renderer;
        if (inlay == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(2);
        }
        return (renderer = inlay.getRenderer()) instanceof MyRenderer ? ((MyRenderer)renderer).getText() : null;
    }

    public Inlay addHint(@NotNull Editor editor2, int offset, boolean relatesToPrecedingText, @NotNull String hintText, @Nullable HintWidthAdjustment widthAdjuster, boolean useAnimation) {
        if (editor2 == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(3);
        }
        if (hintText == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(4);
        }
        MyRenderer renderer = new MyRenderer(editor2, hintText, widthAdjuster, useAnimation);
        Inlay inlay = editor2.getInlayModel().addInlineElement(offset, relatesToPrecedingText, (EditorCustomElementRenderer)renderer);
        if (inlay != null && useAnimation) {
            this.scheduleRendererUpdate(editor2, inlay);
        }
        return inlay;
    }

    public void deleteHint(@NotNull Editor editor2, @NotNull Inlay hint, boolean useAnimation) {
        if (editor2 == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(5);
        }
        if (hint == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(6);
        }
        if (useAnimation) {
            this.updateRenderer(editor2, hint, null, null, true);
        } else {
            Disposer.dispose((Disposable)hint);
        }
    }

    public void replaceHint(@NotNull Editor editor2, @NotNull Inlay hint, @NotNull String newText, @Nullable HintWidthAdjustment widthAdjuster, boolean useAnimation) {
        if (editor2 == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(7);
        }
        if (hint == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(8);
        }
        if (newText == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(9);
        }
        this.updateRenderer(editor2, hint, newText, widthAdjuster, useAnimation);
    }

    public void setHighlighted(@NotNull Inlay hint, boolean highlighted) {
        if (hint == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(10);
        }
        if (!this.isParameterHint(hint)) {
            throw new IllegalArgumentException("Not a parameter hint");
        }
        MyRenderer renderer = (MyRenderer)hint.getRenderer();
        boolean oldValue = renderer.highlighted;
        if (highlighted != oldValue) {
            renderer.highlighted = highlighted;
            hint.repaint();
        }
    }

    public boolean isHighlighted(@NotNull Inlay hint) {
        if (hint == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(11);
        }
        if (!this.isParameterHint(hint)) {
            throw new IllegalArgumentException("Not a parameter hint");
        }
        MyRenderer renderer = (MyRenderer)hint.getRenderer();
        return renderer.highlighted;
    }

    public void setCurrent(@NotNull Inlay hint, boolean current) {
        if (hint == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(12);
        }
        if (!this.isParameterHint(hint)) {
            throw new IllegalArgumentException("Not a parameter hint");
        }
        MyRenderer renderer = (MyRenderer)hint.getRenderer();
        boolean oldValue = renderer.current;
        if (current != oldValue) {
            renderer.current = current;
            hint.repaint();
        }
    }

    public boolean isCurrent(@NotNull Inlay hint) {
        if (hint == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(13);
        }
        if (!this.isParameterHint(hint)) {
            throw new IllegalArgumentException("Not a parameter hint");
        }
        MyRenderer renderer = (MyRenderer)hint.getRenderer();
        return renderer.current;
    }

    public void setPreviewMode(Editor editor2, boolean b) {
        PREVIEW_MODE.set((UserDataHolder)editor2, b);
    }

    private void updateRenderer(@NotNull Editor editor2, @NotNull Inlay hint, @Nullable String newText, HintWidthAdjustment widthAdjuster, boolean useAnimation) {
        if (editor2 == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(14);
        }
        if (hint == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(15);
        }
        MyRenderer renderer = (MyRenderer)hint.getRenderer();
        renderer.update(editor2, newText, widthAdjuster, useAnimation);
        hint.update();
        if (useAnimation) {
            this.scheduleRendererUpdate(editor2, hint);
        }
    }

    @Override
    public void dispose() {
    }

    private void scheduleRendererUpdate(@NotNull Editor editor2, @NotNull Inlay inlay) {
        if (editor2 == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(16);
        }
        if (inlay == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        AnimationStep step = (AnimationStep)editor2.getUserData(ANIMATION_STEP);
        if (step == null) {
            step = new AnimationStep(editor2);
            editor2.putUserData(ANIMATION_STEP, (Object)step);
        }
        step.inlays.add(inlay);
        this.scheduleAnimationStep(step);
    }

    private void scheduleAnimationStep(@NotNull AnimationStep step) {
        if (step == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(18);
        }
        this.myAlarm.cancelRequest((Runnable)step);
        this.myAlarm.addRequest((Runnable)step, 25, ModalityState.any());
    }

    @TestOnly
    public boolean isAnimationInProgress(@NotNull Editor editor2) {
        if (editor2 == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(19);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        return editor2.getUserData(ANIMATION_STEP) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintText";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameterHintsInRange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isParameterHint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getHintText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addHint";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteHint";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceHint";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "setHighlighted";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isHighlighted";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "setCurrent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isCurrent";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "updateRenderer";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleRendererUpdate";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleAnimationStep";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "isAnimationInProgress";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class AnimationStep
    implements Runnable {
        private final Editor myEditor;
        private final Set<Inlay> inlays;

        AnimationStep(Editor editor2) {
            if (editor2 == null) {
                AnimationStep.$$$reportNull$$$0(0);
            }
            this.inlays = new HashSet<Inlay>();
            this.myEditor = editor2;
            Disposer.register(((EditorImpl)editor2).getDisposable(), () -> ParameterHintsPresentationManager.this.myAlarm.cancelRequest((Runnable)this));
        }

        @Override
        public void run() {
            Iterator<Inlay> it = this.inlays.iterator();
            while (it.hasNext()) {
                Inlay inlay = it.next();
                if (inlay.isValid()) {
                    MyRenderer renderer = (MyRenderer)inlay.getRenderer();
                    if (!renderer.nextStep()) {
                        it.remove();
                    }
                    if (renderer.calcWidthInPixels(inlay) == 0) {
                        Disposer.dispose((Disposable)inlay);
                        continue;
                    }
                    inlay.update();
                    continue;
                }
                it.remove();
            }
            if (this.inlays.isEmpty()) {
                this.myEditor.putUserData(ANIMATION_STEP, null);
            } else {
                ParameterHintsPresentationManager.this.scheduleAnimationStep(this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager$AnimationStep", "<init>"));
        }
    }

    private static final class MyRenderer
    extends HintRenderer {
        private int startWidth;
        private int steps;
        private int step;
        private boolean highlighted;
        private boolean current;

        private MyRenderer(Editor editor2, String text2, HintWidthAdjustment widthAdjustment, boolean animated) {
            super(text2);
            this.updateState(editor2, text2, widthAdjustment, animated);
        }

        public String toString() {
            return "[" + this.getText() + "]";
        }

        public void update(Editor editor2, String newText, HintWidthAdjustment widthAdjustment, boolean animated) {
            this.updateState(editor2, newText, widthAdjustment, animated);
        }

        @Nullable
        protected TextAttributes getTextAttributes(@NotNull Editor editor2) {
            if (editor2 == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            if (this.step > this.steps || this.startWidth != 0) {
                TextAttributes attributes = editor2.getColorsScheme().getAttributes(this.current ? DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT_CURRENT : (this.highlighted ? DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT_HIGHLIGHTED : DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT));
                Boolean aBoolean = PREVIEW_MODE.get((UserDataHolder)editor2);
                return aBoolean != null && aBoolean != false ? InlayHintsUtilsKt.strikeOutBuilder(editor2).applyTo(attributes.clone()) : attributes;
            }
            return null;
        }

        @NotNull
        public String getContextMenuGroupId(@NotNull Inlay inlay) {
            if (inlay == null) {
                MyRenderer.$$$reportNull$$$0(1);
            }
            return "ParameterNameHints";
        }

        private void updateState(Editor editor2, String text2, HintWidthAdjustment widthAdjustment, boolean animated) {
            this.setWidthAdjustment(widthAdjustment);
            FontMetrics metrics = MyRenderer.getFontMetrics((Editor)editor2, (boolean)this.useEditorFont()).getMetrics();
            this.startWidth = MyRenderer.calcHintTextWidth((String)this.getText(), (FontMetrics)metrics);
            this.setText(text2);
            int endWidth = MyRenderer.calcHintTextWidth((String)this.getText(), (FontMetrics)metrics);
            this.steps = Math.max(1, Math.abs(endWidth - this.startWidth) / metrics.charWidth('a') / 3);
            this.step = animated ? 1 : this.steps + 1;
        }

        public boolean nextStep() {
            return ++this.step <= this.steps;
        }

        public int calcWidthInPixels(@NotNull Inlay inlay) {
            if (inlay == null) {
                MyRenderer.$$$reportNull$$$0(2);
            }
            int endWidth = super.calcWidthInPixels(inlay);
            return this.step <= this.steps ? Math.max(1, this.startWidth + (endWidth - this.startWidth) / this.steps * this.step) : endWidth;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager$MyRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTextAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getContextMenuGroupId";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcWidthInPixels";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

