/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobLauncher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Functions;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class PassExecutorService
implements Disposable {
    static final Logger LOG = Logger.getInstance(PassExecutorService.class);
    private static final boolean CHECK_CONSISTENCY = ApplicationManager.getApplication().isUnitTestMode();
    private final Map<ScheduledPass, Job<Void>> mySubmittedPasses;
    private final Project myProject;
    private volatile boolean isDisposed;
    private final AtomicInteger nextAvailablePassId;
    private static final Key<Throwable> THROWABLE_KEY = Key.create("THROWABLE_KEY");

    PassExecutorService(@NotNull Project project2) {
        if (project2 == null) {
            PassExecutorService.$$$reportNull$$$0(0);
        }
        this.mySubmittedPasses = new ConcurrentHashMap<ScheduledPass, Job<Void>>();
        this.myProject = project2;
        this.nextAvailablePassId = ((TextEditorHighlightingPassRegistrarImpl)TextEditorHighlightingPassRegistrar.getInstance(this.myProject)).getNextAvailableId();
    }

    @Override
    public void dispose() {
        this.cancelAll(true);
        ForkJoinPool.commonPool().awaitQuiescence(1L, TimeUnit.SECONDS);
        this.isDisposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAll(boolean waitForTermination) {
        for (Map.Entry<ScheduledPass, Job<Void>> entry : this.mySubmittedPasses.entrySet()) {
            Job<Void> job = entry.getValue();
            ScheduledPass pass2 = entry.getKey();
            pass2.myUpdateProgress.cancel();
            job.cancel();
        }
        try {
            if (waitForTermination) {
                while (!this.waitFor(50)) {
                    boolean bl = false;
                }
            }
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            LOG.error(throwable);
        }
        finally {
            this.mySubmittedPasses.clear();
        }
    }

    void submitPasses(@NotNull List<? extends DaemonCodeAnalyzerImpl.FileEditorInfo> fileEditorInfos, @NotNull DaemonProgressIndicator updateProgress) {
        FileEditor fileEditor;
        if (fileEditorInfos == null) {
            PassExecutorService.$$$reportNull$$$0(1);
        }
        if (updateProgress == null) {
            PassExecutorService.$$$reportNull$$$0(2);
        }
        if (this.isDisposed()) {
            return;
        }
        assert (!ApplicationManager.getApplication().isDispatchThread());
        HashMap<FileEditor, List> documentBoundPasses = new HashMap<FileEditor, List>();
        HashMap<FileEditor, List> editorBoundPasses = new HashMap<FileEditor, List>();
        HashMap<FileEditor, Int2ObjectMap<TextEditorHighlightingPass>> id2Pass = new HashMap<FileEditor, Int2ObjectMap<TextEditorHighlightingPass>>();
        ArrayList<ScheduledPass> freePasses = new ArrayList<ScheduledPass>(fileEditorInfos.size() * 5);
        AtomicInteger threadsToStartCountdown = new AtomicInteger(0);
        for (DaemonCodeAnalyzerImpl.FileEditorInfo fileEditorInfo : fileEditorInfos) {
            for (DaemonCodeAnalyzerImpl.FileEditorInfo.FileEditorHighlightingInfo fileEditorHighlightingInfo : fileEditorInfo.myFileEditors) {
                fileEditor = fileEditorHighlightingInfo.myFileEditor;
                HighlightingPass[] passes = fileEditorHighlightingInfo.myHighlightingPasses;
                for (HighlightingPass pass2 : passes) {
                    Int2ObjectMap thisEditorId2Pass = id2Pass.computeIfAbsent(fileEditor, __ -> new Int2ObjectOpenHashMap(30));
                    if (pass2 instanceof EditorBoundHighlightingPass) {
                        EditorBoundHighlightingPass editorPass = (EditorBoundHighlightingPass)pass2;
                        this.assignUniqueId(editorPass, thisEditorId2Pass);
                        editorBoundPasses.computeIfAbsent(fileEditor, __ -> new ArrayList()).add(editorPass);
                        continue;
                    }
                    if (pass2 instanceof TextEditorHighlightingPass) {
                        TextEditorHighlightingPass tePass = (TextEditorHighlightingPass)pass2;
                        this.assignUniqueId(tePass, thisEditorId2Pass);
                        documentBoundPasses.computeIfAbsent(fileEditor, __ -> new ArrayList()).add(tePass);
                        continue;
                    }
                    freePasses.add(new ScheduledPass(fileEditor, pass2, updateProgress, threadsToStartCountdown));
                }
            }
        }
        ArrayList<ScheduledPass> dependentPasses = new ArrayList<ScheduledPass>(fileEditorInfos.size() * 10);
        HashMap<FileEditor, Int2ObjectMap<ScheduledPass>> hashMap = new HashMap<FileEditor, Int2ObjectMap<ScheduledPass>>(fileEditorInfos.size());
        for (DaemonCodeAnalyzerImpl.FileEditorInfo fileEditorInfo : fileEditorInfos) {
            Document document = fileEditorInfo.myDocument;
            VirtualFile virtualFile2 = fileEditorInfo.myVirtualFile;
            FileEditor preferredFileEditor = fileEditorInfo.myFileEditors.get((int)0).myFileEditor;
            List passes = (List)documentBoundPasses.get(preferredFileEditor);
            if (passes == null || passes.isEmpty()) continue;
            PassExecutorService.sortById(passes);
            for (TextEditorHighlightingPass pass2 : passes) {
                this.createScheduledPass(preferredFileEditor, document, virtualFile2, pass2, hashMap, id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
            }
        }
        for (Map.Entry entry : editorBoundPasses.entrySet()) {
            fileEditor = (FileEditor)entry.getKey();
            Collection createdEditorBoundPasses = (Collection)entry.getValue();
            for (EditorBoundHighlightingPass pass3 : createdEditorBoundPasses) {
                Document document = pass3.getDocument();
                VirtualFile virtualFile3 = fileEditor.getFile();
                this.createScheduledPass(fileEditor, document, virtualFile3, pass3, hashMap, id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
            }
        }
        if (CHECK_CONSISTENCY && !ApplicationManagerEx.isInStressTest()) {
            this.assertConsistency(freePasses, hashMap, threadsToStartCountdown);
        }
        if (LOG.isDebugEnabled()) {
            Set<VirtualFile> vFiles = ContainerUtil.map2Set(fileEditorInfos, info -> info.myVirtualFile);
            PassExecutorService.log(updateProgress, null, vFiles + " ----- starting " + threadsToStartCountdown.get(), freePasses);
        }
        for (ScheduledPass scheduledPass : dependentPasses) {
            this.mySubmittedPasses.put(scheduledPass, Job.nullJob());
        }
        for (ScheduledPass scheduledPass : freePasses) {
            this.submit(scheduledPass);
        }
    }

    private void assignUniqueId(@NotNull TextEditorHighlightingPass pass2, @NotNull Int2ObjectMap<TextEditorHighlightingPass> id2Pass) {
        int id2;
        int oldId;
        if (pass2 == null) {
            PassExecutorService.$$$reportNull$$$0(3);
        }
        if (id2Pass == null) {
            PassExecutorService.$$$reportNull$$$0(4);
        }
        if ((oldId = pass2.getId()) == -1 || oldId == 0) {
            id2 = this.nextAvailablePassId.incrementAndGet();
            pass2.setId(id2);
        } else {
            id2 = oldId;
        }
        TextEditorHighlightingPass prevPass = id2Pass.put(id2, pass2);
        if (prevPass != null) {
            LOG.error("Duplicate pass id found: " + id2 + ". Both passes returned the same getId(): " + prevPass + " (" + prevPass.getClass() + ") and " + pass2 + " (" + pass2.getClass() + "). oldId=" + oldId);
        }
    }

    private void assertConsistency(@NotNull List<ScheduledPass> freePasses, @NotNull Map<FileEditor, Int2ObjectMap<ScheduledPass>> toBeSubmitted, @NotNull AtomicInteger threadsToStartCountdown) {
        if (freePasses == null) {
            PassExecutorService.$$$reportNull$$$0(5);
        }
        if (toBeSubmitted == null) {
            PassExecutorService.$$$reportNull$$$0(6);
        }
        if (threadsToStartCountdown == null) {
            PassExecutorService.$$$reportNull$$$0(7);
        }
        assert (threadsToStartCountdown.get() == toBeSubmitted.values().stream().mapToInt(m -> m.size()).sum());
        Map<ScheduledPass, Pair<ScheduledPass, Integer>> id2Visits = CollectionFactory.createCustomHashingStrategyMap(new HashingStrategy<ScheduledPass>(){

            @Override
            public int hashCode(@Nullable ScheduledPass sp) {
                if (sp == null) {
                    return 0;
                }
                return ((TextEditorHighlightingPass)sp.myPass).getId() * 31 + sp.myFileEditor.hashCode();
            }

            @Override
            public boolean equals(@Nullable ScheduledPass sp1, @Nullable ScheduledPass sp2) {
                int id2;
                if (sp1 == null || sp2 == null) {
                    return sp1 == sp2;
                }
                int id1 = ((TextEditorHighlightingPass)sp1.myPass).getId();
                return id1 == (id2 = ((TextEditorHighlightingPass)sp2.myPass).getId()) && sp1.myFileEditor == sp2.myFileEditor;
            }
        });
        for (ScheduledPass scheduledPass : freePasses) {
            HighlightingPass pass2 = scheduledPass.myPass;
            if (!(pass2 instanceof TextEditorHighlightingPass)) continue;
            id2Visits.put(scheduledPass, Pair.create(scheduledPass, 0));
            this.checkConsistency(scheduledPass, id2Visits);
        }
        for (Map.Entry entry : id2Visits.entrySet()) {
            int count2 = (Integer)((Pair)entry.getValue()).second;
            assert (count2 == 0) : (ScheduledPass)entry.getKey();
        }
        assert (id2Visits.size() == threadsToStartCountdown.get()) : "Expected " + threadsToStartCountdown + " but got " + id2Visits.size() + ": " + id2Visits;
    }

    private void checkConsistency(@NotNull ScheduledPass pass2, Map<ScheduledPass, Pair<ScheduledPass, Integer>> id2Visits) {
        if (pass2 == null) {
            PassExecutorService.$$$reportNull$$$0(8);
        }
        for (ScheduledPass successor : ContainerUtil.concat(pass2.mySuccessorsOnCompletion, pass2.mySuccessorsOnSubmit)) {
            Pair<ScheduledPass, Integer> pair = id2Visits.get(successor);
            if (pair == null) {
                pair = Pair.create(successor, successor.myRunningPredecessorsCount.get());
                id2Visits.put(successor, pair);
            }
            int newPred = (Integer)pair.second - 1;
            id2Visits.put(successor, Pair.create(successor, newPred));
            assert (newPred >= 0);
            if (newPred != 0) continue;
            this.checkConsistency(successor, id2Visits);
        }
    }

    @NotNull
    private ScheduledPass createScheduledPass(@NotNull FileEditor fileEditor, @NotNull Document document, @NotNull VirtualFile virtualFile2, @NotNull TextEditorHighlightingPass pass2, @NotNull Map<FileEditor, Int2ObjectMap<ScheduledPass>> toBeSubmitted, @NotNull Map<FileEditor, Int2ObjectMap<TextEditorHighlightingPass>> id2Pass, @NotNull List<ScheduledPass> freePasses, @NotNull List<ScheduledPass> dependentPasses, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger threadsToStartCountdown) {
        ScheduledPass predecessor;
        if (fileEditor == null) {
            PassExecutorService.$$$reportNull$$$0(9);
        }
        if (document == null) {
            PassExecutorService.$$$reportNull$$$0(10);
        }
        if (virtualFile2 == null) {
            PassExecutorService.$$$reportNull$$$0(11);
        }
        if (pass2 == null) {
            PassExecutorService.$$$reportNull$$$0(12);
        }
        if (toBeSubmitted == null) {
            PassExecutorService.$$$reportNull$$$0(13);
        }
        if (id2Pass == null) {
            PassExecutorService.$$$reportNull$$$0(14);
        }
        if (freePasses == null) {
            PassExecutorService.$$$reportNull$$$0(15);
        }
        if (dependentPasses == null) {
            PassExecutorService.$$$reportNull$$$0(16);
        }
        if (updateProgress == null) {
            PassExecutorService.$$$reportNull$$$0(17);
        }
        if (threadsToStartCountdown == null) {
            PassExecutorService.$$$reportNull$$$0(18);
        }
        Int2ObjectMap thisEditorId2ScheduledPass = toBeSubmitted.computeIfAbsent(fileEditor, __ -> new Int2ObjectOpenHashMap(20));
        Int2ObjectMap thisEditorId2Pass = id2Pass.computeIfAbsent(fileEditor, __ -> new Int2ObjectOpenHashMap(20));
        int passId = pass2.getId();
        ScheduledPass scheduledPass = (ScheduledPass)thisEditorId2ScheduledPass.get(passId);
        if (scheduledPass != null) {
            ScheduledPass scheduledPass2 = scheduledPass;
            if (scheduledPass2 == null) {
                PassExecutorService.$$$reportNull$$$0(19);
            }
            return scheduledPass2;
        }
        scheduledPass = new ScheduledPass(fileEditor, pass2, updateProgress, threadsToStartCountdown);
        threadsToStartCountdown.incrementAndGet();
        thisEditorId2ScheduledPass.put(passId, scheduledPass);
        for (int predecessorId : pass2.getCompletionPredecessorIds()) {
            predecessor = this.findOrCreatePredecessorPass(fileEditor, document, virtualFile2, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown, predecessorId, thisEditorId2ScheduledPass, thisEditorId2Pass);
            if (predecessor == null) continue;
            predecessor.addSuccessorOnCompletion(scheduledPass);
        }
        for (int predecessorId : pass2.getStartingPredecessorIds()) {
            predecessor = this.findOrCreatePredecessorPass(fileEditor, document, virtualFile2, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown, predecessorId, thisEditorId2ScheduledPass, thisEditorId2Pass);
            if (predecessor == null) continue;
            predecessor.addSuccessorOnSubmit(scheduledPass);
        }
        if (scheduledPass.myRunningPredecessorsCount.get() == 0 && !freePasses.contains(scheduledPass)) {
            freePasses.add(scheduledPass);
        } else if (!dependentPasses.contains(scheduledPass)) {
            dependentPasses.add(scheduledPass);
        }
        if (pass2.isRunIntentionPassAfter() && fileEditor instanceof TextEditor) {
            Editor editor2 = ((TextEditor)fileEditor).getEditor();
            PsiFile psiFile = ReadAction.compute(() -> DaemonCodeAnalyzerImpl.findFileToHighlight(this.myProject, virtualFile2));
            if (psiFile != null) {
                ShowIntentionsPass ip = new ShowIntentionsPass(psiFile, editor2, false);
                this.assignUniqueId(ip, thisEditorId2Pass);
                ip.setCompletionPredecessorIds(new int[]{passId});
                this.createScheduledPass(fileEditor, document, virtualFile2, ip, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
            }
        }
        ScheduledPass scheduledPass3 = scheduledPass;
        if (scheduledPass3 == null) {
            PassExecutorService.$$$reportNull$$$0(20);
        }
        return scheduledPass3;
    }

    private ScheduledPass findOrCreatePredecessorPass(@NotNull FileEditor fileEditor, @NotNull Document document, @NotNull VirtualFile virtualFile2, @NotNull Map<FileEditor, Int2ObjectMap<ScheduledPass>> toBeSubmitted, @NotNull Map<FileEditor, Int2ObjectMap<TextEditorHighlightingPass>> id2Pass, @NotNull List<ScheduledPass> freePasses, @NotNull List<ScheduledPass> dependentPasses, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger myThreadsToStartCountdown, int predecessorId, @NotNull Int2ObjectMap<ScheduledPass> thisEditorId2ScheduledPass, @NotNull Int2ObjectMap<? extends TextEditorHighlightingPass> thisEditorId2Pass) {
        ScheduledPass predecessor;
        if (fileEditor == null) {
            PassExecutorService.$$$reportNull$$$0(21);
        }
        if (document == null) {
            PassExecutorService.$$$reportNull$$$0(22);
        }
        if (virtualFile2 == null) {
            PassExecutorService.$$$reportNull$$$0(23);
        }
        if (toBeSubmitted == null) {
            PassExecutorService.$$$reportNull$$$0(24);
        }
        if (id2Pass == null) {
            PassExecutorService.$$$reportNull$$$0(25);
        }
        if (freePasses == null) {
            PassExecutorService.$$$reportNull$$$0(26);
        }
        if (dependentPasses == null) {
            PassExecutorService.$$$reportNull$$$0(27);
        }
        if (updateProgress == null) {
            PassExecutorService.$$$reportNull$$$0(28);
        }
        if (myThreadsToStartCountdown == null) {
            PassExecutorService.$$$reportNull$$$0(29);
        }
        if (thisEditorId2ScheduledPass == null) {
            PassExecutorService.$$$reportNull$$$0(30);
        }
        if (thisEditorId2Pass == null) {
            PassExecutorService.$$$reportNull$$$0(31);
        }
        if ((predecessor = (ScheduledPass)thisEditorId2ScheduledPass.get(predecessorId)) == null) {
            TextEditorHighlightingPass textEditorPass = (TextEditorHighlightingPass)thisEditorId2Pass.get(predecessorId);
            predecessor = textEditorPass == null ? null : this.createScheduledPass(fileEditor, document, virtualFile2, textEditorPass, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, myThreadsToStartCountdown);
        }
        return predecessor;
    }

    private void submit(@NotNull ScheduledPass pass2) {
        if (pass2 == null) {
            PassExecutorService.$$$reportNull$$$0(32);
        }
        if (!pass2.myUpdateProgress.isCanceled()) {
            Job<Void> job = JobLauncher.getInstance().submitToJobThread(pass2, future2 -> {
                try {
                    if (!future2.isCancelled()) {
                        future2.get();
                    }
                }
                catch (InterruptedException | CancellationException exception) {
                }
                catch (ExecutionException e) {
                    LOG.error(e.getCause());
                }
            });
            this.mySubmittedPasses.put(pass2, job);
        }
    }

    private void applyInformationToEditorsLater(@NotNull FileEditor fileEditor, @NotNull HighlightingPass pass2, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger threadsToStartCountdown, @NotNull Runnable callbackOnApplied) {
        if (fileEditor == null) {
            PassExecutorService.$$$reportNull$$$0(33);
        }
        if (pass2 == null) {
            PassExecutorService.$$$reportNull$$$0(34);
        }
        if (updateProgress == null) {
            PassExecutorService.$$$reportNull$$$0(35);
        }
        if (threadsToStartCountdown == null) {
            PassExecutorService.$$$reportNull$$$0(36);
        }
        if (callbackOnApplied == null) {
            PassExecutorService.$$$reportNull$$$0(37);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isDisposed() || !fileEditor.isValid()) {
                updateProgress.cancel();
            }
            if (updateProgress.isCanceled()) {
                PassExecutorService.log(updateProgress, pass2, " is canceled during apply, sorry");
                return;
            }
            try {
                if (UIUtil.isShowing(fileEditor.getComponent())) {
                    pass2.applyInformationToEditor();
                    this.repaintErrorStripeAndIcon(fileEditor);
                    if (pass2 instanceof TextEditorHighlightingPass) {
                        FileStatusMap fileStatusMap = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap();
                        Document document = ((TextEditorHighlightingPass)pass2).getDocument();
                        int passId = ((TextEditorHighlightingPass)pass2).getId();
                        fileStatusMap.markFileUpToDate(document, passId);
                    }
                    PassExecutorService.log(updateProgress, pass2, " Applied");
                }
            }
            catch (ProcessCanceledException e) {
                PassExecutorService.log(updateProgress, pass2, "Error " + e);
                throw e;
            }
            catch (RuntimeException e) {
                VirtualFile file2 = fileEditor.getFile();
                FileType fileType = file2 == null ? null : file2.getFileType();
                String message2 = "Exception while applying information to " + fileEditor + "(" + fileType + ")";
                PassExecutorService.log(updateProgress, pass2, message2 + e);
                throw new RuntimeException(message2, e);
            }
            if (threadsToStartCountdown.decrementAndGet() == 0) {
                HighlightingSessionImpl.waitForAllSessionsHighlightInfosApplied(updateProgress);
                PassExecutorService.log(updateProgress, pass2, "Stopping ");
                updateProgress.stopIfRunning();
                this.clearStaleEntries();
            } else {
                PassExecutorService.log(updateProgress, pass2, "Finished but there are passes in the queue: " + threadsToStartCountdown.get());
            }
            callbackOnApplied.run();
        }, updateProgress.getModalityState(), pass2.getExpiredCondition());
    }

    private void clearStaleEntries() {
        this.mySubmittedPasses.keySet().removeIf(pass2 -> pass2.myUpdateProgress.isCanceled());
    }

    private void repaintErrorStripeAndIcon(@NotNull FileEditor fileEditor) {
        if (fileEditor == null) {
            PassExecutorService.$$$reportNull$$$0(38);
        }
        if (fileEditor instanceof TextEditor) {
            DefaultHighlightInfoProcessor.repaintErrorStripeAndIcon(((TextEditor)fileEditor).getEditor(), this.myProject);
        }
    }

    private boolean isDisposed() {
        return this.isDisposed || this.myProject.isDisposed();
    }

    @NotNull
    List<HighlightingPass> getAllSubmittedPasses() {
        ArrayList<HighlightingPass> result2 = new ArrayList<HighlightingPass>(this.mySubmittedPasses.size());
        for (ScheduledPass scheduledPass : this.mySubmittedPasses.keySet()) {
            if (scheduledPass.myUpdateProgress.isCanceled()) continue;
            result2.add(scheduledPass.myPass);
        }
        ArrayList<HighlightingPass> arrayList = result2;
        if (arrayList == null) {
            PassExecutorService.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    private static void sortById(@NotNull List<? extends TextEditorHighlightingPass> result2) {
        if (result2 == null) {
            PassExecutorService.$$$reportNull$$$0(40);
        }
        ContainerUtil.quickSort(result2, Comparator.comparingInt(TextEditorHighlightingPass::getId));
    }

    private static int getThreadNum() {
        Matcher matcher = Pattern.compile("JobScheduler FJ pool (\\d*)/(\\d*)").matcher(Thread.currentThread().getName());
        String num = matcher.matches() ? matcher.group(1) : null;
        return StringUtil.parseInt(num, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void log(ProgressIndicator progressIndicator, HighlightingPass pass2, Object ... info) {
        if (info == null) {
            PassExecutorService.$$$reportNull$$$0(41);
        }
        if (!LOG.isDebugEnabled()) return;
        Document document = pass2 instanceof TextEditorHighlightingPass ? ((TextEditorHighlightingPass)pass2).getDocument() : null;
        String docText = document == null ? "" : ": '" + StringUtil.first(document.getCharsSequence(), 10, true) + "'";
        Class<PassExecutorService> clazz = PassExecutorService.class;
        synchronized (PassExecutorService.class) {
            String infos = StringUtil.join(info, Functions.TO_STRING(), " ");
            String message2 = StringUtil.repeatSymbol(' ', PassExecutorService.getThreadNum() * 4) + " " + pass2 + " " + infos + "; progress=" + (progressIndicator == null ? null : Integer.valueOf(progressIndicator.hashCode())) + " " + (progressIndicator == null ? "?" : (progressIndicator.isCanceled() ? "X" : "V")) + docText;
            LOG.debug(message2);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    static void saveException(@NotNull Throwable e, @NotNull DaemonProgressIndicator indicator) {
        if (e == null) {
            PassExecutorService.$$$reportNull$$$0(42);
        }
        if (indicator == null) {
            PassExecutorService.$$$reportNull$$$0(43);
        }
        indicator.putUserDataIfAbsent(THROWABLE_KEY, e);
    }

    @TestOnly
    static Throwable getSavedException(@NotNull DaemonProgressIndicator indicator) {
        if (indicator == null) {
            PassExecutorService.$$$reportNull$$$0(44);
        }
        return indicator.getUserData(THROWABLE_KEY);
    }

    boolean waitFor(int millis) throws Throwable {
        try {
            for (Job<Void> job : this.mySubmittedPasses.values()) {
                job.waitForCompletion(millis);
            }
            return true;
        }
        catch (TimeoutException ignored) {
            return false;
        }
        catch (InterruptedException e) {
            return true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 20: 
            case 39: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 20: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorInfos";
                break;
            }
            case 2: 
            case 17: 
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateProgress";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pass";
                break;
            }
            case 4: 
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id2Pass";
                break;
            }
            case 5: 
            case 15: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "freePasses";
                break;
            }
            case 6: 
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toBeSubmitted";
                break;
            }
            case 7: 
            case 18: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadsToStartCountdown";
                break;
            }
            case 9: 
            case 21: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 16: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPasses";
                break;
            }
            case 19: 
            case 20: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/PassExecutorService";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myThreadsToStartCountdown";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisEditorId2ScheduledPass";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisEditorId2Pass";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callbackOnApplied";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/PassExecutorService";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createScheduledPass";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSubmittedPasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "submitPasses";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "assignUniqueId";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "assertConsistency";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkConsistency";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createScheduledPass";
                break;
            }
            case 19: 
            case 20: 
            case 39: {
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreatePredecessorPass";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "applyInformationToEditorsLater";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "repaintErrorStripeAndIcon";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "sortById";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "log";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "saveException";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getSavedException";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 19: 
            case 20: 
            case 39: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class ScheduledPass
    implements Runnable {
        private final FileEditor myFileEditor;
        private final HighlightingPass myPass;
        private final AtomicInteger myThreadsToStartCountdown;
        private final AtomicInteger myRunningPredecessorsCount;
        private final List<ScheduledPass> mySuccessorsOnCompletion;
        private final List<ScheduledPass> mySuccessorsOnSubmit;
        @NotNull
        private final DaemonProgressIndicator myUpdateProgress;

        private ScheduledPass(@NotNull FileEditor fileEditor, @NotNull HighlightingPass pass2, @NotNull DaemonProgressIndicator progressIndicator, AtomicInteger threadsToStartCountdown) {
            if (fileEditor == null) {
                ScheduledPass.$$$reportNull$$$0(0);
            }
            if (pass2 == null) {
                ScheduledPass.$$$reportNull$$$0(1);
            }
            if (progressIndicator == null) {
                ScheduledPass.$$$reportNull$$$0(2);
            }
            if (threadsToStartCountdown == null) {
                ScheduledPass.$$$reportNull$$$0(3);
            }
            this.myRunningPredecessorsCount = new AtomicInteger(0);
            this.mySuccessorsOnCompletion = new ArrayList<ScheduledPass>();
            this.mySuccessorsOnSubmit = new ArrayList<ScheduledPass>();
            this.myFileEditor = fileEditor;
            this.myPass = pass2;
            this.myThreadsToStartCountdown = threadsToStartCountdown;
            this.myUpdateProgress = progressIndicator;
        }

        @Override
        public void run() {
            ((ApplicationImpl)ApplicationManager.getApplication()).executeByImpatientReader(() -> {
                try {
                    this.doRun();
                }
                catch (ApplicationUtil.CannotRunReadActionException e) {
                    this.myUpdateProgress.cancel();
                }
                catch (Error | RuntimeException e) {
                    PassExecutorService.saveException(e, this.myUpdateProgress);
                    throw e;
                }
            });
        }

        private void doRun() {
            if (this.myUpdateProgress.isCanceled()) {
                return;
            }
            PassExecutorService.log(this.myUpdateProgress, this.myPass, "Started. ");
            for (ScheduledPass successor : this.mySuccessorsOnSubmit) {
                int predecessorsToRun = successor.myRunningPredecessorsCount.decrementAndGet();
                if (predecessorsToRun != 0) continue;
                PassExecutorService.this.submit(successor);
            }
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                boolean success = ApplicationManagerEx.getApplicationEx().tryRunReadAction(() -> {
                    try {
                        if (DumbService.getInstance(PassExecutorService.this.myProject).isDumb() && !DumbService.isDumbAware(this.myPass)) {
                            return;
                        }
                        if (!this.myUpdateProgress.isCanceled() && !PassExecutorService.this.myProject.isDisposed()) {
                            this.myPass.collectInformation((ProgressIndicator)this.myUpdateProgress);
                        }
                    }
                    catch (ProcessCanceledException e) {
                        PassExecutorService.log(this.myUpdateProgress, this.myPass, "Canceled ");
                        if (!this.myUpdateProgress.isCanceled()) {
                            this.myUpdateProgress.cancel(e);
                        }
                    }
                    catch (Error | RuntimeException e) {
                        this.myUpdateProgress.cancel(e);
                        LOG.error(e);
                        throw e;
                    }
                });
                if (!success) {
                    this.myUpdateProgress.cancel();
                }
            }, this.myUpdateProgress);
            PassExecutorService.log(this.myUpdateProgress, this.myPass, "Finished. ");
            if (!this.myUpdateProgress.isCanceled()) {
                PassExecutorService.this.applyInformationToEditorsLater(this.myFileEditor, this.myPass, this.myUpdateProgress, this.myThreadsToStartCountdown, () -> {
                    for (ScheduledPass successor : this.mySuccessorsOnCompletion) {
                        int predecessorsToRun = successor.myRunningPredecessorsCount.decrementAndGet();
                        if (predecessorsToRun != 0) continue;
                        PassExecutorService.this.submit(successor);
                    }
                });
            }
        }

        @NonNls
        public String toString() {
            return "SP: " + this.myPass;
        }

        private void addSuccessorOnCompletion(@NotNull ScheduledPass successor) {
            if (successor == null) {
                ScheduledPass.$$$reportNull$$$0(4);
            }
            this.mySuccessorsOnCompletion.add(successor);
            successor.myRunningPredecessorsCount.incrementAndGet();
        }

        private void addSuccessorOnSubmit(@NotNull ScheduledPass successor) {
            if (successor == null) {
                ScheduledPass.$$$reportNull$$$0(5);
            }
            this.mySuccessorsOnSubmit.add(successor);
            successor.myRunningPredecessorsCount.incrementAndGet();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "threadsToStartCountdown";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "successor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/PassExecutorService$ScheduledPass";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addSuccessorOnCompletion";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addSuccessorOnSubmit";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

