/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.UtilBundle;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.ConfigureInspectionsAction;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonEditorPopup;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.StatusItemMerger;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingSettingsPerFile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.editor.HectorComponentPanelsProvider;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.AnalyzerStatus;
import com.intellij.openapi.editor.markup.AnalyzingType;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.InspectionsLevel;
import com.intellij.openapi.editor.markup.LanguageHighlightLevel;
import com.intellij.openapi.editor.markup.PassWrapper;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeverityStatusItem;
import com.intellij.openapi.editor.markup.StatusItem;
import com.intellij.openapi.editor.markup.UIController;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrafficLightRenderer
implements ErrorStripeRenderer,
Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Document myDocument;
    private final DaemonCodeAnalyzerImpl myDaemonCodeAnalyzer;
    private final SeverityRegistrar mySeverityRegistrar;
    private final Object2IntMap<HighlightSeverity> errorCount;
    private int[] cachedErrors;

    public TrafficLightRenderer(@NotNull Project project2, @NotNull Document document) {
        if (project2 == null) {
            TrafficLightRenderer.$$$reportNull$$$0(0);
        }
        if (document == null) {
            TrafficLightRenderer.$$$reportNull$$$0(1);
        }
        this.errorCount = new Object2IntOpenHashMap<HighlightSeverity>();
        this.cachedErrors = ArrayUtilRt.EMPTY_INT_ARRAY;
        this.myProject = project2;
        this.myDaemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(project2);
        this.myDocument = document;
        this.mySeverityRegistrar = SeverityRegistrar.getSeverityRegistrar(this.myProject);
        this.refresh(null);
        MarkupModelEx model2 = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)document, (Project)project2, (boolean)true);
        model2.addMarkupModelListener((Disposable)this, new MarkupModelListener(){

            public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(0);
                }
                TrafficLightRenderer.this.incErrorCount((RangeHighlighter)highlighter, 1);
            }

            public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(1);
                }
                TrafficLightRenderer.this.incErrorCount((RangeHighlighter)highlighter, -1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "highlighter";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        UIUtil.invokeLaterIfNeeded(() -> {
            for (RangeHighlighter rangeHighlighter : model2.getAllHighlighters()) {
                this.incErrorCount(rangeHighlighter, 1);
            }
        });
    }

    private PsiFile getPsiFile() {
        return PsiDocumentManager.getInstance(this.myProject).getPsiFile(this.myDocument);
    }

    @NotNull
    public SeverityRegistrar getSeverityRegistrar() {
        SeverityRegistrar severityRegistrar = this.mySeverityRegistrar;
        if (severityRegistrar == null) {
            TrafficLightRenderer.$$$reportNull$$$0(2);
        }
        return severityRegistrar;
    }

    public int @NotNull [] getErrorCounts() {
        int[] nArray = (int[])this.cachedErrors.clone();
        if (nArray == null) {
            TrafficLightRenderer.$$$reportNull$$$0(3);
        }
        return nArray;
    }

    protected void refresh(@Nullable EditorMarkupModelImpl editorMarkupModel) {
        List<HighlightSeverity> severities = this.mySeverityRegistrar.getAllSeverities();
        if (this.cachedErrors.length != severities.size()) {
            this.cachedErrors = new int[severities.size()];
        }
        for (HighlightSeverity severity : severities) {
            int severityIndex = this.mySeverityRegistrar.getSeverityIdx(severity);
            this.cachedErrors[severityIndex] = this.errorCount.getInt(severity);
        }
    }

    @Override
    public void dispose() {
        this.errorCount.clear();
        this.cachedErrors = ArrayUtilRt.EMPTY_INT_ARRAY;
    }

    private void incErrorCount(@NotNull RangeHighlighter highlighter, int delta) {
        HighlightInfo info;
        if (highlighter == null) {
            TrafficLightRenderer.$$$reportNull$$$0(4);
        }
        if ((info = HighlightInfo.fromRangeHighlighter(highlighter)) == null) {
            return;
        }
        HighlightSeverity infoSeverity = info.getSeverity();
        if (infoSeverity.myVal <= HighlightSeverity.TEXT_ATTRIBUTES.myVal) {
            return;
        }
        this.errorCount.put(infoSeverity, this.errorCount.getInt(infoSeverity) + delta);
    }

    public boolean isValid() {
        return this.getPsiFile() != null;
    }

    @ApiStatus.Internal
    @NotNull
    public DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus() {
        DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = this.getDaemonCodeAnalyzerStatus(this.mySeverityRegistrar);
        if (daemonCodeAnalyzerStatus == null) {
            TrafficLightRenderer.$$$reportNull$$$0(5);
        }
        return daemonCodeAnalyzerStatus;
    }

    @NotNull
    protected DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus(@NotNull SeverityRegistrar severityRegistrar) {
        if (severityRegistrar == null) {
            TrafficLightRenderer.$$$reportNull$$$0(6);
        }
        DaemonCodeAnalyzerStatus status = new DaemonCodeAnalyzerStatus();
        status.errorAnalyzingFinished = true;
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null) {
            status.reasonWhyDisabled = DaemonBundle.message("process.title.no.file", new Object[0]);
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(7);
            }
            return daemonCodeAnalyzerStatus;
        }
        if (this.myProject.isDisposed()) {
            status.reasonWhyDisabled = DaemonBundle.message("process.title.project.is.disposed", new Object[0]);
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(8);
            }
            return daemonCodeAnalyzerStatus;
        }
        if (!this.myDaemonCodeAnalyzer.isHighlightingAvailable(psiFile)) {
            if (!psiFile.isPhysical()) {
                status.reasonWhyDisabled = DaemonBundle.message("process.title.file.is.generated", new Object[0]);
                DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
                if (daemonCodeAnalyzerStatus == null) {
                    TrafficLightRenderer.$$$reportNull$$$0(9);
                }
                return daemonCodeAnalyzerStatus;
            }
            if (psiFile instanceof PsiCompiledElement) {
                status.reasonWhyDisabled = DaemonBundle.message("process.title.file.is.decompiled", new Object[0]);
                DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
                if (daemonCodeAnalyzerStatus == null) {
                    TrafficLightRenderer.$$$reportNull$$$0(10);
                }
                return daemonCodeAnalyzerStatus;
            }
            FileType fileType = psiFile.getFileType();
            if (fileType.isBinary()) {
                status.reasonWhyDisabled = DaemonBundle.message("process.title.file.is.binary", new Object[0]);
                DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
                if (daemonCodeAnalyzerStatus == null) {
                    TrafficLightRenderer.$$$reportNull$$$0(11);
                }
                return daemonCodeAnalyzerStatus;
            }
            status.reasonWhyDisabled = DaemonBundle.message("process.title.highlighting.is.disabled.for.this.file", new Object[0]);
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(12);
            }
            return daemonCodeAnalyzerStatus;
        }
        FileViewProvider provider2 = psiFile.getViewProvider();
        Set<Language> languages = provider2.getLanguages();
        boolean shouldHighlight = languages.isEmpty();
        HighlightingSettingsPerFile hlManager = HighlightingSettingsPerFile.getInstance(this.getProject());
        for (Language language : languages) {
            PsiFile psiRoot = provider2.getPsi(language);
            FileHighlightingSetting level = hlManager.getHighlightingSettingForRoot(psiRoot);
            shouldHighlight |= hlManager.shouldHighlight(psiRoot);
            status.minimumLevel = status.minimumLevel.compareTo(level) < 0 ? status.minimumLevel : level;
        }
        if (!shouldHighlight) {
            status.reasonWhyDisabled = DaemonBundle.message("process.title.highlighting.level.is.none", new Object[0]);
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(13);
            }
            return daemonCodeAnalyzerStatus;
        }
        if (HeavyProcessLatch.INSTANCE.isRunning()) {
            HeavyProcessLatch.Operation op = (HeavyProcessLatch.Operation)((Object)ContainerUtil.find(HeavyProcessLatch.INSTANCE.getRunningOperations(), o -> o.getType() != HeavyProcessLatch.Type.Syncing));
            if (op == null) {
                status.reasonWhySuspended = DaemonBundle.message("process.title.heavy.operation.is.running", new Object[0]);
                status.heavyProcessType = HeavyProcessLatch.Type.Processing;
            } else {
                status.reasonWhySuspended = op.getDisplayName();
                status.heavyProcessType = op.getType();
            }
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(14);
            }
            return daemonCodeAnalyzerStatus;
        }
        status.errorCounts = this.getErrorCounts();
        status.passes = ContainerUtil.filter(this.myDaemonCodeAnalyzer.getPassesToShowProgressFor(this.myDocument), p -> !StringUtil.isEmpty(p.getPresentableName()) && p.getProgress() >= 0.0);
        status.errorAnalyzingFinished = this.myDaemonCodeAnalyzer.isAllAnalysisFinished(psiFile);
        if (!this.myDaemonCodeAnalyzer.isUpdateByTimerEnabled()) {
            status.reasonWhySuspended = DaemonBundle.message("process.title.highlighting.is.paused.temporarily", new Object[0]);
        }
        this.fillDaemonCodeAnalyzerErrorsStatus(status, severityRegistrar);
        DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
        if (daemonCodeAnalyzerStatus == null) {
            TrafficLightRenderer.$$$reportNull$$$0(15);
        }
        return daemonCodeAnalyzerStatus;
    }

    protected void fillDaemonCodeAnalyzerErrorsStatus(@NotNull DaemonCodeAnalyzerStatus status, @NotNull SeverityRegistrar severityRegistrar) {
        if (status == null) {
            TrafficLightRenderer.$$$reportNull$$$0(16);
        }
        if (severityRegistrar == null) {
            TrafficLightRenderer.$$$reportNull$$$0(17);
        }
    }

    @NotNull
    protected final Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            TrafficLightRenderer.$$$reportNull$$$0(18);
        }
        return project2;
    }

    @NotNull
    public AnalyzerStatus getStatus() {
        String details2;
        String title;
        if (PowerSaveMode.isEnabled()) {
            return new AnalyzerStatus(AllIcons.General.InspectionsPowerSaveMode, InspectionsBundle.message("code.analysis.is.disabled.in.power.save.mode", new Object[0]), "", this::createUIController);
        }
        DaemonCodeAnalyzerStatus status = this.getDaemonCodeAnalyzerStatus(this.mySeverityRegistrar);
        boolean isDumb = DumbService.isDumb(this.myProject);
        ArrayList<SeverityStatusItem> statusItems = new ArrayList<SeverityStatusItem>();
        int[] errorCounts = status.errorCounts;
        for (int i2 = errorCounts.length - 1; i2 >= 0; --i2) {
            SeverityStatusItem merged;
            HighlightSeverity severity;
            int count2 = errorCounts[i2];
            if (count2 <= 0 || (severity = this.mySeverityRegistrar.getSeverityByIndex(i2)) == null) continue;
            Icon icon2 = this.mySeverityRegistrar.getRendererIconBySeverity(severity, status.minimumLevel == FileHighlightingSetting.FORCE_HIGHLIGHTING);
            SeverityStatusItem next = new SeverityStatusItem(severity, icon2, count2, severity.getCountMessage(count2));
            while (!statusItems.isEmpty() && (merged = StatusItemMerger.runMerge((SeverityStatusItem)ContainerUtil.getLastItem(statusItems), next)) != null) {
                statusItems.remove(statusItems.size() - 1);
                next = merged;
            }
            statusItems.add(next);
        }
        if (status.errorAnalyzingFinished) {
            if (isDumb) {
                title = DaemonBundle.message("shallow.analysis.completed", new Object[0]);
                details2 = DaemonBundle.message("shallow.analysis.completed.details", new Object[0]);
            } else if (this.getPsiFile() != null && HighlightingSettingsPerFile.getInstance(this.myProject).getHighlightingSettingForRoot(this.getPsiFile()) == FileHighlightingSetting.ESSENTIAL) {
                title = DaemonBundle.message("essential.analysis.completed", new Object[0]);
                details2 = DaemonBundle.message("essential.analysis.completed.details", new Object[0]);
            } else {
                title = statusItems.isEmpty() ? DaemonBundle.message("no.errors.or.warnings.found", new Object[0]) : "";
                details2 = "";
            }
        } else {
            title = DaemonBundle.message("performing.code.analysis", new Object[0]);
            details2 = "";
        }
        if (!statusItems.isEmpty()) {
            AnalyzerStatus result2 = new AnalyzerStatus(((SeverityStatusItem)statusItems.get(0)).getIcon(), title, "", this::createUIController).withNavigation().withExpandedStatus(ContainerUtil.map(statusItems, i -> new StatusItem(Integer.toString(i.getProblemCount()), i.getIcon(), i.getCountMessage())));
            AnalyzerStatus analyzerStatus = status.errorAnalyzingFinished ? result2 : result2.withAnalyzingType(AnalyzingType.PARTIAL).withPasses(ContainerUtil.map(status.passes, pass2 -> new PassWrapper(pass2.getPresentableName(), pass2.getProgress(), pass2.isFinished())));
            if (analyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(19);
            }
            return analyzerStatus;
        }
        if (StringUtil.isNotEmpty(status.reasonWhyDisabled)) {
            AnalyzerStatus analyzerStatus = new AnalyzerStatus(AllIcons.General.InspectionsTrafficOff, DaemonBundle.message("no.analysis.performed", new Object[0]), status.reasonWhyDisabled, this::createUIController).withTextStatus(DaemonBundle.message("iw.status.off", new Object[0]));
            if (analyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(20);
            }
            return analyzerStatus;
        }
        if (StringUtil.isNotEmpty(status.reasonWhySuspended)) {
            AnalyzerStatus analyzerStatus = new AnalyzerStatus(AllIcons.General.InspectionsPause, DaemonBundle.message("analysis.suspended", new Object[0]), status.reasonWhySuspended, this::createUIController).withTextStatus(status.heavyProcessType != null ? status.heavyProcessType.toString() : DaemonBundle.message("iw.status.paused", new Object[0])).withAnalyzingType(AnalyzingType.SUSPENDED);
            if (analyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(21);
            }
            return analyzerStatus;
        }
        if (status.errorAnalyzingFinished) {
            Icon inspectionsCompletedIcon = status.minimumLevel == FileHighlightingSetting.FORCE_HIGHLIGHTING ? AllIcons.General.InspectionsOK : AllIcons.General.InspectionsOKEmpty;
            return isDumb ? new AnalyzerStatus(AllIcons.General.InspectionsPause, title, details2, this::createUIController).withTextStatus(UtilBundle.message("heavyProcess.type.indexing", new Object[0])).withAnalyzingType(AnalyzingType.SUSPENDED) : new AnalyzerStatus(inspectionsCompletedIcon, title, details2, this::createUIController);
        }
        AnalyzerStatus analyzerStatus = new AnalyzerStatus(AllIcons.General.InspectionsEye, DaemonBundle.message("no.errors.or.warnings.found", new Object[0]), details2, this::createUIController).withTextStatus(DaemonBundle.message("iw.status.analyzing", new Object[0])).withAnalyzingType(AnalyzingType.EMPTY).withPasses(ContainerUtil.map(status.passes, pass2 -> new PassWrapper(pass2.getPresentableName(), pass2.getProgress(), pass2.isFinished())));
        if (analyzerStatus == null) {
            TrafficLightRenderer.$$$reportNull$$$0(22);
        }
        return analyzerStatus;
    }

    @NotNull
    protected UIController createUIController() {
        return new SimplifiedUIController();
    }

    @NotNull
    protected final UIController createUIController(@NotNull Editor editor2) {
        if (editor2 == null) {
            TrafficLightRenderer.$$$reportNull$$$0(23);
        }
        boolean mergeEditor = editor2.getUserData(DiffUserDataKeys.MERGE_EDITOR_FLAG) == Boolean.TRUE;
        return editor2.getEditorKind() == EditorKind.DIFF && !mergeEditor ? new SimplifiedUIController() : new DefaultUIController();
    }

    private static void applyPanel(@NotNull HectorComponentPanel panel2) {
        if (panel2 == null) {
            TrafficLightRenderer.$$$reportNull$$$0(24);
        }
        try {
            panel2.apply();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverityRegistrar";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorCounts";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDaemonCodeAnalyzerStatus";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "incErrorCount";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDaemonCodeAnalyzerStatus";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fillDaemonCodeAnalyzerErrorsStatus";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createUIController";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "applyPanel";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public class SimplifiedUIController
    extends AbstractUIController {
        public boolean enableToolbar() {
            return false;
        }

        @NotNull
        public List<AnAction> getActions() {
            List<AnAction> list2 = Collections.emptyList();
            if (list2 == null) {
                SimplifiedUIController.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$SimplifiedUIController", "getActions"));
        }
    }

    public class DefaultUIController
    extends AbstractUIController {
        private final List<AnAction> myMenuActions;

        public DefaultUIController() {
            this.myMenuActions = this.initActions();
        }

        @NotNull
        private List<AnAction> initActions() {
            ArrayList<AnAction> result2 = new ArrayList<AnAction>();
            result2.add((AnAction)new ConfigureInspectionsAction());
            result2.add((AnAction)DaemonEditorPopup.createGotoGroup());
            result2.add((AnAction)Separator.create());
            result2.add((AnAction)new ShowImportTooltipAction());
            ArrayList<AnAction> arrayList = result2;
            if (arrayList == null) {
                DefaultUIController.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        @NotNull
        public List<AnAction> getActions() {
            List<AnAction> list2 = this.myMenuActions;
            if (list2 == null) {
                DefaultUIController.$$$reportNull$$$0(1);
            }
            return list2;
        }

        public boolean enableToolbar() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$DefaultUIController";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "initActions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }

        private class ShowImportTooltipAction
        extends ToggleAction {
            private ShowImportTooltipAction() {
                super(EditorBundle.message((String)"iw.show.import.tooltip", (Object[])new Object[0]));
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                PsiFile psiFile;
                if (e == null) {
                    ShowImportTooltipAction.$$$reportNull$$$0(0);
                }
                return (psiFile = TrafficLightRenderer.this.getPsiFile()) != null && TrafficLightRenderer.this.myDaemonCodeAnalyzer.isImportHintsEnabled(psiFile);
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                PsiFile psiFile;
                if (e == null) {
                    ShowImportTooltipAction.$$$reportNull$$$0(1);
                }
                if ((psiFile = TrafficLightRenderer.this.getPsiFile()) != null) {
                    TrafficLightRenderer.this.myDaemonCodeAnalyzer.setImportHintsEnabled(psiFile, state);
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    ShowImportTooltipAction.$$$reportNull$$$0(2);
                }
                super.update(e);
                PsiFile psiFile = TrafficLightRenderer.this.getPsiFile();
                e.getPresentation().setEnabled(psiFile != null && TrafficLightRenderer.this.myDaemonCodeAnalyzer.isAutohintsAvailable(psiFile));
            }

            public boolean isDumbAware() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$DefaultUIController$ShowImportTooltipAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    protected abstract class AbstractUIController
    implements UIController {
        private final boolean inLibrary;
        @NotNull
        private final List<LanguageHighlightLevel> myLevelList;
        @NotNull
        private List<HectorComponentPanel> myAdditionalPanels = Collections.emptyList();

        AbstractUIController() {
            PsiFile psiFile = TrafficLightRenderer.this.getPsiFile();
            if (psiFile == null) {
                this.inLibrary = false;
                this.myLevelList = Collections.emptyList();
            } else {
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance(TrafficLightRenderer.this.getProject()).getFileIndex();
                VirtualFile virtualFile2 = psiFile.getVirtualFile();
                assert (virtualFile2 != null);
                this.inLibrary = fileIndex.isInLibrary(virtualFile2) && !fileIndex.isInContent(virtualFile2);
                this.myLevelList = this.initLevels(psiFile);
            }
        }

        @NotNull
        private @NotNull List<@NotNull LanguageHighlightLevel> initLevels(@NotNull PsiFile psiFile) {
            if (psiFile == null) {
                AbstractUIController.$$$reportNull$$$0(0);
            }
            ArrayList<LanguageHighlightLevel> result2 = new ArrayList<LanguageHighlightLevel>();
            if (!psiFile.getProject().isDisposed()) {
                FileViewProvider viewProvider = psiFile.getViewProvider();
                for (Language language : viewProvider.getLanguages()) {
                    PsiFile psiRoot = viewProvider.getPsi(language);
                    FileHighlightingSetting setting = HighlightingSettingsPerFile.getInstance(psiFile.getProject()).getHighlightingSettingForRoot(psiRoot);
                    InspectionsLevel inspectionsLevel = FileHighlightingSetting.toInspectionsLevel(setting);
                    result2.add(new LanguageHighlightLevel(language.getID(), inspectionsLevel));
                }
            }
            ArrayList<LanguageHighlightLevel> arrayList = result2;
            if (arrayList == null) {
                AbstractUIController.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        @NotNull
        public List<InspectionsLevel> getAvailableLevels() {
            List<InspectionsLevel> list2 = this.inLibrary ? Arrays.asList(InspectionsLevel.NONE, InspectionsLevel.SYNTAX) : (ApplicationManager.getApplication().isInternal() ? Arrays.asList(InspectionsLevel.NONE, InspectionsLevel.SYNTAX, InspectionsLevel.ESSENTIAL, InspectionsLevel.ALL) : Arrays.asList(InspectionsLevel.NONE, InspectionsLevel.SYNTAX, InspectionsLevel.ALL));
            if (list2 == null) {
                AbstractUIController.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @NotNull
        public List<LanguageHighlightLevel> getHighlightLevels() {
            List<LanguageHighlightLevel> list2 = Collections.unmodifiableList(this.myLevelList);
            if (list2 == null) {
                AbstractUIController.$$$reportNull$$$0(3);
            }
            return list2;
        }

        public void setHighLightLevel(@NotNull LanguageHighlightLevel level) {
            PsiFile psiFile;
            if (level == null) {
                AbstractUIController.$$$reportNull$$$0(4);
            }
            if ((psiFile = TrafficLightRenderer.this.getPsiFile()) != null && !TrafficLightRenderer.this.getProject().isDisposed() && !this.myLevelList.contains(level)) {
                FileViewProvider viewProvider = psiFile.getViewProvider();
                Language language = Language.findLanguageByID(level.getLangID());
                if (language != null) {
                    PsiFile root = viewProvider.getPsi(language);
                    FileHighlightingSetting setting = FileHighlightingSetting.fromInspectionsLevel(level.getLevel());
                    HighlightLevelUtil.forceRootHighlighting(root, setting);
                    this.myLevelList.replaceAll(l -> l.getLangID().equals(level.getLangID()) ? level : l);
                    InjectedLanguageManager.getInstance(TrafficLightRenderer.this.getProject()).dropFileCaches(psiFile);
                    TrafficLightRenderer.this.myDaemonCodeAnalyzer.restart();
                }
            }
        }

        public void fillHectorPanels(@NotNull Container container, @NotNull GridBag gc) {
            PsiFile psiFile;
            if (container == null) {
                AbstractUIController.$$$reportNull$$$0(5);
            }
            if (gc == null) {
                AbstractUIController.$$$reportNull$$$0(6);
            }
            if ((psiFile = TrafficLightRenderer.this.getPsiFile()) != null) {
                this.myAdditionalPanels = HectorComponentPanelsProvider.EP_NAME.extensions(TrafficLightRenderer.this.getProject()).map(hp -> hp.createConfigurable(psiFile)).filter(p -> p != null).collect(Collectors.toList());
                for (HectorComponentPanel p2 : this.myAdditionalPanels) {
                    JComponent c;
                    try {
                        p2.reset();
                        c = p2.createComponent();
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        Logger.getInstance(TrafficLightRenderer.class).error(e);
                        continue;
                    }
                    if (c == null) continue;
                    container.add((Component)c, gc.nextLine().next().fillCellHorizontally().coverLine().weightx(1.0));
                }
            }
        }

        public boolean canClosePopup() {
            if (this.myAdditionalPanels.isEmpty()) {
                return true;
            }
            if (ContainerUtil.and(this.myAdditionalPanels, p -> p.canClose())) {
                PsiFile psiFile = TrafficLightRenderer.this.getPsiFile();
                if (this.myAdditionalPanels.stream().filter(p -> p.isModified()).peek(x$0 -> TrafficLightRenderer.applyPanel(x$0)).count() > 0L) {
                    if (psiFile != null) {
                        InjectedLanguageManager.getInstance(TrafficLightRenderer.this.getProject()).dropFileCaches(psiFile);
                    }
                    TrafficLightRenderer.this.myDaemonCodeAnalyzer.restart();
                }
                return true;
            }
            return false;
        }

        public void onClosePopup() {
            this.myAdditionalPanels.forEach(p -> p.disposeUIResources());
            this.myAdditionalPanels = Collections.emptyList();
        }

        public void toggleProblemsView() {
            PsiFile file2 = TrafficLightRenderer.this.getPsiFile();
            ProblemsView.toggleCurrentFileProblems(TrafficLightRenderer.this.getProject(), file2 == null ? null : file2.getVirtualFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$AbstractUIController";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gc";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$AbstractUIController";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "initLevels";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAvailableLevels";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlightLevels";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "initLevels";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setHighLightLevel";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "fillHectorPanels";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @ApiStatus.Internal
    public static final class DaemonCodeAnalyzerStatus {
        public boolean errorAnalyzingFinished;
        List<ProgressableTextEditorHighlightingPass> passes = Collections.emptyList();
        public int[] errorCounts = ArrayUtilRt.EMPTY_INT_ARRAY;
        @Nls
        public String reasonWhyDisabled;
        @Nls
        public String reasonWhySuspended;
        public HeavyProcessLatch.Type heavyProcessType;
        private FileHighlightingSetting minimumLevel = FileHighlightingSetting.FORCE_HIGHLIGHTING;

        DaemonCodeAnalyzerStatus() {
        }

        public String toString() {
            String s = "DS: finished=" + this.errorAnalyzingFinished + "; pass statuses: " + this.passes.size() + "; ";
            for (ProgressableTextEditorHighlightingPass passStatus : this.passes) {
                s = s + String.format("(%s %2.0f%% %b)", passStatus.getPresentableName(), passStatus.getProgress() * 100.0, passStatus.isFinished());
            }
            s = s + "; error counts: " + this.errorCounts.length + ": " + new IntArrayList(this.errorCounts);
            if (this.reasonWhyDisabled != null) {
                s = s + "; reasonWhyDisabled=" + this.reasonWhyDisabled;
            }
            if (this.reasonWhySuspended != null) {
                s = s + "; reasonWhySuspended" + this.reasonWhySuspended;
            }
            return s;
        }
    }
}

