/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.analysis.DefaultHighlightingSettingProvider;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSettingListener;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.lang.Language;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.markup.InspectionsLevel;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="HighlightingSettingsPerFile", storages={@Storage(value="$WORKSPACE_FILE$")})
public class HighlightingSettingsPerFile
extends HighlightingLevelManager
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String SETTING_TAG = "setting";
    @NonNls
    private static final String ROOT_ATT_PREFIX = "root";
    @NonNls
    private static final String FILE_ATT = "file";
    private final MessageBus myBus;
    private final Set<String> vcsIgnoreFileNames;
    private final Map<VirtualFile, FileHighlightingSetting[]> myHighlightSettings;

    public HighlightingSettingsPerFile(@NotNull Project project2, @NotNull MessageBus bus) {
        if (project2 == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(0);
        }
        if (bus == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(1);
        }
        this.myHighlightSettings = new HashMap<VirtualFile, FileHighlightingSetting[]>();
        this.myBus = bus;
        this.vcsIgnoreFileNames = VcsFacade.getInstance().getVcsIgnoreFileNames(project2);
    }

    public static HighlightingSettingsPerFile getInstance(@NotNull Project project2) {
        if (project2 == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(2);
        }
        return (HighlightingSettingsPerFile)project2.getService(HighlightingLevelManager.class);
    }

    private static int getRootIndex(@NotNull PsiFile file2) {
        FileViewProvider provider2;
        Set<Language> languages;
        if (file2 == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(3);
        }
        if ((languages = (provider2 = file2.getViewProvider()).getLanguages()).size() == 1) {
            return 0;
        }
        ArrayList<Language> array = new ArrayList<Language>(languages);
        array.sort(PsiUtilBase.LANGUAGE_COMPARATOR);
        for (int i = 0; i < array.size(); ++i) {
            Language language = (Language)array.get(i);
            if (provider2.getPsi(language) != file2) continue;
            return i;
        }
        throw new RuntimeException("Cannot find root for: " + file2);
    }

    @NotNull
    public FileHighlightingSetting getHighlightingSettingForRoot(@NotNull PsiElement root) {
        PsiFile containingFile;
        VirtualFile virtualFile2;
        if (root == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(4);
        }
        if ((virtualFile2 = (containingFile = root.getContainingFile()).getVirtualFile()) == null) {
            FileHighlightingSetting fileHighlightingSetting = FileHighlightingSetting.FORCE_HIGHLIGHTING;
            if (fileHighlightingSetting == null) {
                HighlightingSettingsPerFile.$$$reportNull$$$0(5);
            }
            return fileHighlightingSetting;
        }
        FileHighlightingSetting[] fileHighlightingSettings = this.myHighlightSettings.get(virtualFile2);
        int index = HighlightingSettingsPerFile.getRootIndex(containingFile);
        if (fileHighlightingSettings != null && index < fileHighlightingSettings.length) {
            FileHighlightingSetting fileHighlightingSetting = fileHighlightingSettings[index];
            if (fileHighlightingSetting == null) {
                HighlightingSettingsPerFile.$$$reportNull$$$0(6);
            }
            return fileHighlightingSetting;
        }
        return HighlightingSettingsPerFile.getDefaultHighlightingSetting(root.getProject(), virtualFile2);
    }

    @NotNull
    private static FileHighlightingSetting getDefaultHighlightingSetting(@NotNull Project project2, @NotNull VirtualFile virtualFile2) {
        if (project2 == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(7);
        }
        if (virtualFile2 == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(8);
        }
        DefaultHighlightingSettingProvider[] providers2 = DefaultHighlightingSettingProvider.EP_NAME.getExtensions();
        List<DefaultHighlightingSettingProvider> filtered = DumbService.getInstance(project2).filterByDumbAwareness(providers2);
        for (DefaultHighlightingSettingProvider p : filtered) {
            FileHighlightingSetting setting = p.getDefaultSetting(project2, virtualFile2);
            if (setting == null) continue;
            FileHighlightingSetting fileHighlightingSetting = setting;
            if (fileHighlightingSetting == null) {
                HighlightingSettingsPerFile.$$$reportNull$$$0(9);
            }
            return fileHighlightingSetting;
        }
        FileHighlightingSetting fileHighlightingSetting = FileHighlightingSetting.FORCE_HIGHLIGHTING;
        if (fileHighlightingSetting == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(10);
        }
        return fileHighlightingSetting;
    }

    private static FileHighlightingSetting @NotNull [] getDefaults(@NotNull PsiFile file2) {
        if (file2 == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(11);
        }
        int rootsCount = file2.getViewProvider().getLanguages().size();
        FileHighlightingSetting[] fileHighlightingSettings = new FileHighlightingSetting[rootsCount];
        Arrays.fill((Object[])fileHighlightingSettings, (Object)FileHighlightingSetting.FORCE_HIGHLIGHTING);
        if (fileHighlightingSettings == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(12);
        }
        return fileHighlightingSettings;
    }

    public void setHighlightingSettingForRoot(@NotNull PsiElement root, @NotNull FileHighlightingSetting setting) {
        PsiFile containingFile;
        VirtualFile virtualFile2;
        if (root == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(13);
        }
        if (setting == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(14);
        }
        if ((virtualFile2 = (containingFile = root.getContainingFile()).getVirtualFile()) == null) {
            return;
        }
        FileHighlightingSetting[] defaults = this.myHighlightSettings.get(virtualFile2);
        int rootIndex = HighlightingSettingsPerFile.getRootIndex(containingFile);
        if (defaults != null && rootIndex >= defaults.length) {
            defaults = null;
        }
        if (defaults == null) {
            defaults = HighlightingSettingsPerFile.getDefaults(containingFile);
        }
        defaults[rootIndex] = setting;
        boolean toRemove2 = true;
        for (FileHighlightingSetting aDefault : defaults) {
            if (aDefault == FileHighlightingSetting.NONE) continue;
            toRemove2 = false;
            break;
        }
        if (toRemove2) {
            this.myHighlightSettings.remove(virtualFile2);
        } else {
            this.myHighlightSettings.put(virtualFile2, defaults);
        }
        this.myBus.syncPublisher(FileHighlightingSettingListener.SETTING_CHANGE).settingChanged(root, setting);
        InspectionWidgetUsageCollector.HIGHLIGHT_LEVEL_CHANGED.log(root.getProject(), (Object)root.getLanguage(), (Object)FileHighlightingSetting.toInspectionsLevel(setting));
    }

    @Override
    public void loadState(@NotNull Element element2) {
        if (element2 == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(15);
        }
        List<Element> children2 = element2.getChildren(SETTING_TAG);
        for (Element child : children2) {
            VirtualFile fileByUrl;
            String url = child.getAttributeValue(FILE_ATT);
            if (url == null || (fileByUrl = VirtualFileManager.getInstance().findFileByUrl(url)) == null) continue;
            ArrayList<FileHighlightingSetting> settings = new ArrayList<FileHighlightingSetting>();
            int index = 0;
            while (child.getAttributeValue(ROOT_ATT_PREFIX + index) != null) {
                String attributeValue = child.getAttributeValue(ROOT_ATT_PREFIX + index++);
                settings.add(Enum.valueOf(FileHighlightingSetting.class, attributeValue));
            }
            this.myHighlightSettings.put(fileByUrl, settings.toArray(new FileHighlightingSetting[0]));
        }
    }

    @Override
    public Element getState() {
        Element element2 = new Element("state");
        ArrayList<Map.Entry<VirtualFile, FileHighlightingSetting[]>> entries2 = new ArrayList<Map.Entry<VirtualFile, FileHighlightingSetting[]>>(this.myHighlightSettings.entrySet());
        entries2.sort(Comparator.comparing(entry -> ((VirtualFile)entry.getKey()).getPath()));
        for (Map.Entry entry2 : entries2) {
            Element child = new Element(SETTING_TAG);
            VirtualFile vFile = (VirtualFile)entry2.getKey();
            if (!vFile.isValid()) continue;
            child.setAttribute(FILE_ATT, vFile.getUrl());
            for (int i = 0; i < ((FileHighlightingSetting[])entry2.getValue()).length; ++i) {
                FileHighlightingSetting fileHighlightingSetting = ((FileHighlightingSetting[])entry2.getValue())[i];
                child.setAttribute(ROOT_ATT_PREFIX + i, fileHighlightingSetting.toString());
            }
            element2.addContent(child);
        }
        return element2;
    }

    @Override
    public boolean shouldHighlight(@NotNull PsiElement psiRoot) {
        FileHighlightingSetting settingForRoot;
        if (psiRoot == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(16);
        }
        return (settingForRoot = this.getHighlightingSettingForRoot(psiRoot)) != FileHighlightingSetting.SKIP_HIGHLIGHTING;
    }

    @Override
    public boolean shouldInspect(@NotNull PsiElement psiRoot) {
        FileHighlightingSetting settingForRoot;
        if (psiRoot == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(17);
        }
        if ((settingForRoot = this.getHighlightingSettingForRoot(psiRoot)) == FileHighlightingSetting.SKIP_HIGHLIGHTING || settingForRoot == FileHighlightingSetting.SKIP_INSPECTION) {
            return false;
        }
        Project project2 = psiRoot.getProject();
        VirtualFile virtualFile2 = psiRoot.getContainingFile().getVirtualFile();
        if (virtualFile2 == null || !virtualFile2.isValid()) {
            return false;
        }
        if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile2) && !this.vcsIgnoreFileNames.contains(virtualFile2.getName())) {
            return false;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project2).getFileIndex();
        if (ProjectScope.getLibrariesScope(project2).contains(virtualFile2) && !fileIndex.isInContent(virtualFile2)) {
            return false;
        }
        return !SingleRootFileViewProvider.isTooLargeForIntelligence(virtualFile2);
    }

    @Override
    public boolean runEssentialHighlightingOnly(@NotNull PsiElement psiRoot) {
        if (psiRoot == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(18);
        }
        return this.getHighlightingSettingForRoot(psiRoot) == FileHighlightingSetting.ESSENTIAL && !((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(psiRoot.getProject())).isRestartToCompleteEssentialHighlightingRequested();
    }

    public int countRoots(@NotNull FileHighlightingSetting setting) {
        if (setting == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(19);
        }
        return this.myHighlightSettings.values().stream().flatMap(array -> Stream.of(array)).mapToInt(s -> s == setting ? 1 : 0).sum();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = FILE_ATT;
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = ROOT_ATT_PREFIX;
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightingSettingsPerFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = SETTING_TAG;
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightingSettingsPerFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingSettingForRoot";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultHighlightingSetting";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRootIndex";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightingSettingForRoot";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultHighlightingSetting";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDefaults";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightingSettingForRoot";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldHighlight";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runEssentialHighlightingOnly";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "countRoots";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class InspectionWidgetUsageCollector
    extends CounterUsagesCollector {
        private static final EventLogGroup GROUP = new EventLogGroup("inspection.widget", 3);
        private static final EventId2<Language, InspectionsLevel> HIGHLIGHT_LEVEL_CHANGED = GROUP.registerEvent("highlight.level.changed", (EventField)EventFields.Language, (EventField)EventFields.Enum((String)"level", InspectionsLevel.class));

        private InspectionWidgetUsageCollector() {
        }

        public EventLogGroup getGroup() {
            return GROUP;
        }
    }
}

