/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationFontSize$WhenMappings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.options.FontSize;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\n\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\n\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u0006\u0010\b\u001a\u00020\u0005\u001a\u001a\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005\u001a\f\u0010\u0010\u001a\u00020\u0005*\u00020\u0005H\u0002\u001a\f\u0010\u0011\u001a\u00020\u0005*\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"QUICK_DOC_FONT_SIZE_V1_PROPERTY", "", "QUICK_DOC_FONT_SIZE_V2_PROPERTY", "QUICK_DOC_FONT_SIZE_V3_PROPERTY", "fontSizeV1", "Lcom/intellij/openapi/options/FontSize;", "fontSizeV2", "fontSizeV3", "getDocumentationFontSize", "readFontSizeFromSettings", "propertyName", "unsetAfterReading", "", "setDocumentationFontSize", "", "x", "migrateV1ToV2", "migrateV2ToV3", "intellij.platform.lang.impl"})
@JvmName(name="DocumentationFontSize")
@ApiStatus.Internal
public final class DocumentationFontSize {
    private static final String QUICK_DOC_FONT_SIZE_V1_PROPERTY = "quick.doc.font.size";
    private static final String QUICK_DOC_FONT_SIZE_V2_PROPERTY = "quick.doc.font.size.v2";
    private static final String QUICK_DOC_FONT_SIZE_V3_PROPERTY = "quick.doc.font.size.v3";

    @NotNull
    public static final FontSize getDocumentationFontSize() {
        FontSize fontSize = DocumentationFontSize.fontSizeV3();
        if (fontSize == null) {
            fontSize = FontSize.SMALL;
        }
        return fontSize;
    }

    private static final FontSize fontSizeV3() {
        FontSize fontSize = DocumentationFontSize.readFontSizeFromSettings(QUICK_DOC_FONT_SIZE_V3_PROPERTY, false);
        if (fontSize == null) {
            FontSize fontSize2 = DocumentationFontSize.fontSizeV2();
            if (fontSize2 != null && (fontSize2 = DocumentationFontSize.migrateV2ToV3(fontSize2)) != null) {
                FontSize fontSize3;
                FontSize it = fontSize3 = fontSize2;
                boolean bl = false;
                DocumentationFontSize.setDocumentationFontSize(it);
                fontSize = fontSize3;
            } else {
                fontSize = null;
            }
        }
        return fontSize;
    }

    private static final FontSize fontSizeV2() {
        Object object = DocumentationFontSize.readFontSizeFromSettings(QUICK_DOC_FONT_SIZE_V2_PROPERTY, true);
        if (object == null) {
            FontSize fontSize = DocumentationFontSize.fontSizeV1();
            object = fontSize != null ? DocumentationFontSize.migrateV1ToV2(fontSize) : null;
        }
        return object;
    }

    private static final FontSize fontSizeV1() {
        return DocumentationFontSize.readFontSizeFromSettings(QUICK_DOC_FONT_SIZE_V1_PROPERTY, true);
    }

    private static final FontSize migrateV2ToV3(FontSize $this$migrateV2ToV3) {
        FontSize fontSize;
        switch (DocumentationFontSize$WhenMappings.$EnumSwitchMapping$0[$this$migrateV2ToV3.ordinal()]) {
            case 1: {
                fontSize = FontSize.XX_SMALL;
                break;
            }
            case 2: {
                fontSize = FontSize.X_SMALL;
                break;
            }
            default: {
                fontSize = $this$migrateV2ToV3;
            }
        }
        return fontSize;
    }

    private static final FontSize migrateV1ToV2(FontSize $this$migrateV1ToV2) {
        FontSize fontSize;
        switch (DocumentationFontSize$WhenMappings.$EnumSwitchMapping$1[$this$migrateV1ToV2.ordinal()]) {
            case 1: {
                fontSize = FontSize.XX_LARGE;
                break;
            }
            case 2: {
                fontSize = FontSize.X_LARGE;
                break;
            }
            default: {
                fontSize = $this$migrateV1ToV2;
            }
        }
        return fontSize;
    }

    private static final FontSize readFontSizeFromSettings(String propertyName, boolean unsetAfterReading) {
        FontSize fontSize;
        String string2 = PropertiesComponent.getInstance().getValue(propertyName);
        if (string2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PropertiesComponent.getI\u2026           ?: return null");
        String strValue = string2;
        if (unsetAfterReading) {
            PropertiesComponent.getInstance().unsetValue(propertyName);
        }
        try {
            fontSize = FontSize.valueOf((String)strValue);
        }
        catch (IllegalArgumentException ignored) {
            fontSize = null;
        }
        return fontSize;
    }

    public static final void setDocumentationFontSize(@NotNull FontSize x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        PropertiesComponent.getInstance().setValue(QUICK_DOC_FONT_SIZE_V3_PROPERTY, x.toString());
    }
}

