/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class PopupDragListener
extends MouseAdapter {
    @NotNull
    private final JBPopup myPopup;
    private Point initialClick;

    private PopupDragListener(@NotNull JBPopup popup2) {
        if (popup2 == null) {
            PopupDragListener.$$$reportNull$$$0(0);
        }
        this.myPopup = popup2;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.initialClick = e.getPoint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.initialClick == null) {
            return;
        }
        Point location = this.myPopup.getLocationOnScreen();
        this.myPopup.setLocation(new Point(location.x + e.getX() - this.initialClick.x, location.y + e.getY() - this.initialClick.y));
        e.consume();
    }

    @RequiresEdt
    public static void dragPopupByComponent(@NotNull JBPopup popup2, @NotNull JComponent component2) {
        if (popup2 == null) {
            PopupDragListener.$$$reportNull$$$0(1);
        }
        if (component2 == null) {
            PopupDragListener.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PopupDragListener listener2 = new PopupDragListener(popup2);
        component2.addMouseListener(listener2);
        component2.addMouseMotionListener(listener2);
        Disposer.register((Disposable)popup2, () -> {
            component2.removeMouseMotionListener(listener2);
            component2.removeMouseListener(listener2);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/PopupDragListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "dragPopupByComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

