/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocFontSizePopup;
import com.intellij.codeInsight.documentation.render.DocRenderDummyLineMarkerProvider;
import com.intellij.codeInsight.documentation.render.DocRenderItemUpdater;
import com.intellij.codeInsight.documentation.render.DocRenderManager;
import com.intellij.codeInsight.documentation.render.DocRenderMouseEventBridge;
import com.intellij.codeInsight.documentation.render.DocRenderPassFactory;
import com.intellij.codeInsight.documentation.render.DocRenderSelectionManager;
import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.codeInsight.documentation.render.InlineDocumentationImplKt;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.lang.documentation.DocumentationTarget;
import com.intellij.lang.documentation.InlineDocumentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DocRenderItem {
    private static final Key<Collection<DocRenderItem>> OUR_ITEMS = Key.create("doc.render.items");
    private static final Key<Disposable> LISTENERS_DISPOSABLE = Key.create("doc.render.listeners.disposable");
    final Editor editor;
    final RangeHighlighter highlighter;
    @Nls
    String textToRender;
    CustomFoldRegion foldRegion;

    static boolean isValidRange(@NotNull Editor editor2, @NotNull TextRange range) {
        if (editor2 == null) {
            DocRenderItem.$$$reportNull$$$0(0);
        }
        if (range == null) {
            DocRenderItem.$$$reportNull$$$0(1);
        }
        Document document = editor2.getDocument();
        CharSequence text2 = document.getImmutableCharSequence();
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        int startLine = document.getLineNumber(startOffset);
        int endLine = document.getLineNumber(endOffset);
        if (!CharArrayUtil.containsOnlyWhiteSpaces(text2.subSequence(document.getLineStartOffset(startLine), startOffset)) || !CharArrayUtil.containsOnlyWhiteSpaces(text2.subSequence(endOffset, document.getLineEndOffset(endLine)))) {
            return false;
        }
        return startLine < endLine || document.getLineStartOffset(startLine) < document.getLineEndOffset(endLine);
    }

    static void setItemsToEditor(@NotNull Editor editor2, @NotNull DocRenderPassFactory.Items itemsToSet, boolean collapseNewItems) {
        ArrayList items;
        ArrayList existing;
        if (editor2 == null) {
            DocRenderItem.$$$reportNull$$$0(2);
        }
        if (itemsToSet == null) {
            DocRenderItem.$$$reportNull$$$0(3);
        }
        if ((existing = (ArrayList)editor2.getUserData(OUR_ITEMS)) == null) {
            if (itemsToSet.isEmpty()) {
                return;
            }
            items = new ArrayList();
            editor2.putUserData(OUR_ITEMS, items);
        } else {
            items = existing;
        }
        DocRenderItem.keepScrollingPositionWhile(editor2, () -> {
            ArrayList<Runnable> foldingTasks = new ArrayList<Runnable>();
            ArrayList<DocRenderItem> itemsToUpdateRenderers = new ArrayList<DocRenderItem>();
            ArrayList<String> itemsToUpdateText = new ArrayList<String>();
            boolean updated = false;
            Iterator it = items.iterator();
            while (it.hasNext()) {
                DocRenderPassFactory.Item matchingNewItem;
                DocRenderItem existingItem = (DocRenderItem)it.next();
                DocRenderPassFactory.Item item = matchingNewItem = existingItem.isValid() ? itemsToSet.removeItem((Segment)existingItem.highlighter) : null;
                if (matchingNewItem == null) {
                    updated |= existingItem.remove(foldingTasks);
                    it.remove();
                    continue;
                }
                if (matchingNewItem.textToRender != null && !matchingNewItem.textToRender.equals(existingItem.textToRender)) {
                    itemsToUpdateRenderers.add(existingItem);
                    itemsToUpdateText.add(matchingNewItem.textToRender);
                    continue;
                }
                existingItem.updateIcon(foldingTasks);
            }
            ArrayList<DocRenderItem> newRenderItems = new ArrayList<DocRenderItem>();
            for (DocRenderPassFactory.Item item : itemsToSet) {
                DocRenderItem newItem = new DocRenderItem(editor2, item.textRange, collapseNewItems ? null : item.textToRender);
                newRenderItems.add(newItem);
                if (!collapseNewItems) continue;
                updated |= newItem.toggle(foldingTasks);
                itemsToUpdateRenderers.add(newItem);
                itemsToUpdateText.add(item.textToRender);
            }
            editor2.getFoldingModel().runBatchFoldingOperation(() -> foldingTasks.forEach(Runnable::run), true, false);
            for (int i = 0; i < itemsToUpdateRenderers.size(); ++i) {
                ((DocRenderItem)itemsToUpdateRenderers.get((int)i)).textToRender = (String)itemsToUpdateText.get(i);
            }
            DocRenderItem.updateRenderers(itemsToUpdateRenderers, true);
            items.addAll(newRenderItems);
            return updated;
        });
        DocRenderItem.setupListeners(editor2, items.isEmpty());
    }

    private static void setupListeners(final @NotNull Editor editor2, boolean disable) {
        if (editor2 == null) {
            DocRenderItem.$$$reportNull$$$0(4);
        }
        if (disable) {
            Disposable listenersDisposable = (Disposable)editor2.getUserData(LISTENERS_DISPOSABLE);
            if (listenersDisposable != null) {
                Disposer.dispose(listenersDisposable);
                editor2.putUserData(LISTENERS_DISPOSABLE, null);
            }
        } else if (editor2.getUserData(LISTENERS_DISPOSABLE) == null) {
            MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
            connection.setDefaultHandler(() -> DocRenderItem.updateRenderers(editor2, true));
            connection.subscribe(EditorColorsManager.TOPIC);
            connection.subscribe(LafManagerListener.TOPIC);
            EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

                public void editorReleased(@NotNull EditorFactoryEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event.getEditor() == editor2) {
                        DocRenderItem.setItemsToEditor(editor2, new DocRenderPassFactory.Items(), false);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/documentation/render/DocRenderItem$1", "editorReleased"));
                }
            }, (Disposable)connection);
            editor2.getCaretModel().addCaretListener((CaretListener)new MyCaretListener(), (Disposable)connection);
            DocRenderSelectionManager selectionManager = new DocRenderSelectionManager(editor2);
            Disposer.register(connection, selectionManager);
            DocRenderMouseEventBridge mouseEventBridge = new DocRenderMouseEventBridge(selectionManager);
            editor2.addEditorMouseListener((EditorMouseListener)mouseEventBridge, (Disposable)connection);
            editor2.addEditorMouseMotionListener((EditorMouseMotionListener)mouseEventBridge, (Disposable)connection);
            IconVisibilityController iconVisibilityController = new IconVisibilityController();
            editor2.addEditorMouseListener((EditorMouseListener)iconVisibilityController, (Disposable)connection);
            editor2.addEditorMouseMotionListener((EditorMouseMotionListener)iconVisibilityController, (Disposable)connection);
            editor2.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)iconVisibilityController, (Disposable)connection);
            Disposer.register(connection, iconVisibilityController);
            editor2.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)new MyVisibleAreaListener(editor2), (Disposable)connection);
            ((EditorEx)editor2).getFoldingModel().addListener((FoldingListener)new MyFoldingListener(), (Disposable)connection);
            Disposer.register(connection, () -> DocRenderer.clearCachedLoadingPane(editor2));
            editor2.putUserData(LISTENERS_DISPOSABLE, (Object)connection);
        }
    }

    private static void keepScrollingPositionWhile(@NotNull Editor editor2, @NotNull BooleanSupplier task2) {
        if (editor2 == null) {
            DocRenderItem.$$$reportNull$$$0(5);
        }
        if (task2 == null) {
            DocRenderItem.$$$reportNull$$$0(6);
        }
        EditorScrollingPositionKeeper keeper = new EditorScrollingPositionKeeper(editor2);
        keeper.savePosition();
        if (task2.getAsBoolean()) {
            keeper.restorePosition(false);
        }
    }

    @Nullable
    public static DocRenderItem getItemAroundOffset(@NotNull Editor editor2, int offset) {
        Collection items;
        if (editor2 == null) {
            DocRenderItem.$$$reportNull$$$0(7);
        }
        if ((items = (Collection)editor2.getUserData(OUR_ITEMS)) == null || items.isEmpty()) {
            return null;
        }
        Document document = editor2.getDocument();
        if (offset < 0 || offset > document.getTextLength()) {
            return null;
        }
        int line = document.getLineNumber(offset);
        DocRenderItem itemOnAdjacentLine = items.stream().filter(i -> {
            if (!i.isValid()) {
                return false;
            }
            int startLine = document.getLineNumber(i.highlighter.getStartOffset());
            int endLine = document.getLineNumber(i.highlighter.getEndOffset());
            return line >= startLine - 1 && line <= endLine + 1;
        }).min(Comparator.comparingInt(i -> i.highlighter.getStartOffset())).orElse(null);
        if (itemOnAdjacentLine != null) {
            return itemOnAdjacentLine;
        }
        Project project2 = editor2.getProject();
        if (project2 == null) {
            return null;
        }
        DocRenderItem foundItem = null;
        int foundStartOffset = 0;
        for (DocRenderItem item : items) {
            TextRange ownerTextRange;
            InlineDocumentation documentation;
            if (!item.isValid() || (documentation = item.getInlineDocumentation()) == null || (ownerTextRange = documentation.getDocumentationOwnerRange()) == null || !ownerTextRange.containsOffset(offset)) continue;
            int startOffset = ownerTextRange.getStartOffset();
            if (foundItem != null && foundStartOffset >= startOffset) continue;
            foundItem = item;
            foundStartOffset = startOffset;
        }
        return foundItem;
    }

    static void resetToDefaultState(@NotNull Editor editor2) {
        Collection items;
        if (editor2 == null) {
            DocRenderItem.$$$reportNull$$$0(8);
        }
        if ((items = (Collection)editor2.getUserData(OUR_ITEMS)) == null) {
            return;
        }
        boolean editorSetting = DocRenderManager.isDocRenderingEnabled(editor2);
        DocRenderItem.keepScrollingPositionWhile(editor2, () -> {
            ArrayList<Runnable> foldingTasks = new ArrayList<Runnable>();
            boolean updated = false;
            for (DocRenderItem item : items) {
                if (!item.isValid() || item.foldRegion == null != editorSetting) continue;
                updated |= item.toggle(foldingTasks);
            }
            editor2.getFoldingModel().runBatchFoldingOperation(() -> foldingTasks.forEach(Runnable::run), true, false);
            return updated;
        });
    }

    public static CustomFoldRegionRenderer createDemoRenderer(@NotNull Editor editor2) {
        if (editor2 == null) {
            DocRenderItem.$$$reportNull$$$0(9);
        }
        DocRenderItem item = new DocRenderItem(editor2, new TextRange(0, 0), CodeInsightBundle.message("documentation.rendered.documentation.with.href.link", new Object[0]));
        return new DocRenderer(item);
    }

    private DocRenderItem(@NotNull Editor editor2, @NotNull TextRange textRange, @Nullable @Nls String textToRender) {
        if (editor2 == null) {
            DocRenderItem.$$$reportNull$$$0(10);
        }
        if (textRange == null) {
            DocRenderItem.$$$reportNull$$$0(11);
        }
        this.editor = editor2;
        this.textToRender = textToRender;
        this.highlighter = editor2.getMarkupModel().addRangeHighlighter(null, textRange.getStartOffset(), textRange.getEndOffset(), 0, HighlighterTargetArea.EXACT_RANGE);
        this.updateIcon(null);
    }

    private boolean isValid() {
        return this.highlighter.isValid() && this.highlighter.getStartOffset() < this.highlighter.getEndOffset() && new ItemLocation(this.highlighter).matches(this.foldRegion);
    }

    private boolean remove(@NotNull Collection<Runnable> foldingTasks) {
        if (foldingTasks == null) {
            DocRenderItem.$$$reportNull$$$0(12);
        }
        this.highlighter.dispose();
        if (this.foldRegion != null && this.foldRegion.isValid()) {
            foldingTasks.add(() -> this.foldRegion.getEditor().getFoldingModel().removeFoldRegion((FoldRegion)this.foldRegion));
            return true;
        }
        return false;
    }

    void toggle() {
        this.toggle(null);
    }

    private boolean toggle(@Nullable Collection<Runnable> foldingTasks) {
        if (!(this.editor instanceof EditorEx)) {
            return false;
        }
        FoldingModelEx foldingModel = ((EditorEx)this.editor).getFoldingModel();
        if (this.foldRegion == null) {
            if (this.textToRender == null && foldingTasks == null) {
                this.generateHtmlInBackgroundAndToggle();
                return false;
            }
            ItemLocation offsets2 = new ItemLocation(this.highlighter);
            Runnable foldingTask = () -> {
                this.foldRegion = foldingModel.addCustomLinesFolding(offsets2.foldStartLine, offsets2.foldEndLine, (CustomFoldRegionRenderer)new DocRenderer(this));
            };
            if (foldingTasks == null) {
                foldingModel.runBatchFoldingOperation(foldingTask, true, false);
            } else {
                foldingTasks.add(foldingTask);
            }
        } else {
            Runnable foldingTask = () -> {
                int startOffset = this.foldRegion.getStartOffset();
                int endOffset = this.foldRegion.getEndOffset();
                foldingModel.removeFoldRegion((FoldRegion)this.foldRegion);
                for (FoldRegion region : foldingModel.getRegionsOverlappingWith(startOffset, endOffset)) {
                    if (region.getStartOffset() < startOffset || region.getEndOffset() > endOffset) continue;
                    region.setExpanded(true);
                }
                this.foldRegion = null;
            };
            if (foldingTasks == null) {
                foldingModel.runBatchFoldingOperation(foldingTask, true, false);
            } else {
                foldingTasks.add(foldingTask);
            }
            if (!DocRenderManager.isDocRenderingEnabled(this.editor)) {
                this.textToRender = null;
            }
        }
        return true;
    }

    private void generateHtmlInBackgroundAndToggle() {
        ReadAction.nonBlocking(() -> DocRenderPassFactory.calcText(this.getInlineDocumentation())).withDocumentsCommitted(Objects.requireNonNull(this.editor.getProject())).coalesceBy(this).finishOnUiThread(ModalityState.any(), html -> {
            this.textToRender = html;
            this.toggle();
        }).submit(AppExecutorUtil.getAppExecutorService());
    }

    @Nullable
    InlineDocumentation getInlineDocumentation() {
        PsiDocumentManager psiDocumentManager;
        PsiFile file2;
        if (this.highlighter.isValid() && (file2 = (psiDocumentManager = PsiDocumentManager.getInstance(Objects.requireNonNull(this.editor.getProject()))).getPsiFile(this.editor.getDocument())) != null) {
            return InlineDocumentationImplKt.findInlineDocumentation(file2, TextRange.create((Segment)this.highlighter));
        }
        return null;
    }

    @Nullable
    DocumentationTarget getInlineDocumentationTarget() {
        InlineDocumentation documentation = this.getInlineDocumentation();
        return documentation == null ? null : documentation.getOwnerTarget();
    }

    private static void updateRenderers(@NotNull Collection<DocRenderItem> items, boolean recreateContent) {
        if (items == null) {
            DocRenderItem.$$$reportNull$$$0(13);
        }
        DocRenderItemUpdater.getInstance().updateFoldRegions(ContainerUtil.mapNotNull(items, i -> i.foldRegion), recreateContent);
    }

    private static void updateRenderers(@NotNull Editor editor2, boolean recreateContent) {
        Collection items;
        if (editor2 == null) {
            DocRenderItem.$$$reportNull$$$0(14);
        }
        if (recreateContent) {
            DocRenderer.clearCachedLoadingPane(editor2);
        }
        if ((items = (Collection)editor2.getUserData(OUR_ITEMS)) != null) {
            DocRenderItem.updateRenderers(items, recreateContent);
        }
    }

    private void updateIcon(List<Runnable> foldingTasks) {
        boolean iconExists;
        boolean iconEnabled = DocRenderDummyLineMarkerProvider.isGutterIconEnabled();
        boolean bl = iconExists = this.highlighter.getGutterIconRenderer() != null;
        if (iconEnabled != iconExists) {
            if (iconEnabled) {
                this.highlighter.setGutterIconRenderer((GutterIconRenderer)new MyGutterIconRenderer(AllIcons.Gutter.JavadocRead, false));
            } else {
                this.highlighter.setGutterIconRenderer(null);
            }
            if (this.foldRegion != null) {
                ((DocRenderer)this.foldRegion.getRenderer()).update(false, false, foldingTasks);
            }
        }
    }

    AnAction createToggleAction() {
        return new ToggleRenderingAction(this);
    }

    private void setIconVisible(boolean visible) {
        MyGutterIconRenderer inlayIconRenderer;
        MyGutterIconRenderer iconRenderer = (MyGutterIconRenderer)this.highlighter.getGutterIconRenderer();
        if (iconRenderer != null) {
            iconRenderer.setIconVisible(visible);
            int y = this.editor.visualLineToY(((EditorImpl)this.editor).offsetToVisualLine(this.highlighter.getStartOffset()));
            this.repaintGutter(y);
        }
        if (this.foldRegion != null && (inlayIconRenderer = (MyGutterIconRenderer)this.foldRegion.getGutterIconRenderer()) != null) {
            inlayIconRenderer.setIconVisible(visible);
            this.repaintGutter(this.editor.offsetToXY((int)this.foldRegion.getStartOffset()).y);
        }
    }

    private void repaintGutter(int startY) {
        JComponent gutter = (JComponent)this.editor.getGutter();
        gutter.repaint(0, startY, gutter.getWidth(), startY + this.editor.getLineHeight());
    }

    @Nullable
    public String getTextToRender() {
        return this.textToRender;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemsToSet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingTasks";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderItem";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidRange";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setItemsToEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setupListeners";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "keepScrollingPositionWhile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getItemAroundOffset";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "resetToDefaultState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createDemoRenderer";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "updateRenderers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class IconVisibilityController
    implements EditorMouseListener,
    EditorMouseMotionListener,
    VisibleAreaListener,
    Disposable {
        private DocRenderItem myCurrentItem;
        private Editor myQueuedEditor;

        private IconVisibilityController() {
        }

        public void mouseMoved(@NotNull EditorMouseEvent e) {
            if (e == null) {
                IconVisibilityController.$$$reportNull$$$0(0);
            }
            this.doUpdate(e.getEditor(), e);
        }

        public void mouseExited(@NotNull EditorMouseEvent e) {
            if (e == null) {
                IconVisibilityController.$$$reportNull$$$0(1);
            }
            this.doUpdate(e.getEditor(), e);
        }

        public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
            Editor editor2;
            if (e == null) {
                IconVisibilityController.$$$reportNull$$$0(2);
            }
            if (((EditorImpl)(editor2 = e.getEditor())).isCursorHidden()) {
                return;
            }
            if (this.myQueuedEditor == null) {
                this.myQueuedEditor = editor2;
                SwingUtilities.invokeLater(() -> {
                    if (this.myQueuedEditor != null && !this.myQueuedEditor.isDisposed()) {
                        this.doUpdate(this.myQueuedEditor, null);
                    }
                    this.myQueuedEditor = null;
                });
            }
        }

        private void doUpdate(@NotNull Editor editor2, @Nullable EditorMouseEvent event) {
            DocRenderItem item;
            if (editor2 == null) {
                IconVisibilityController.$$$reportNull$$$0(3);
            }
            int y = 0;
            int offset = -1;
            if (event == null) {
                PointerInfo info = MouseInfo.getPointerInfo();
                if (info != null) {
                    Point screenPoint = info.getLocation();
                    JComponent component2 = editor2.getComponent();
                    Point componentPoint = new Point(screenPoint);
                    SwingUtilities.convertPointFromScreen(componentPoint, component2);
                    if (new Rectangle(component2.getSize()).contains(componentPoint)) {
                        Point editorPoint = new Point(screenPoint);
                        SwingUtilities.convertPointFromScreen(editorPoint, editor2.getContentComponent());
                        y = editorPoint.y;
                        offset = editor2.visualPositionToOffset(new VisualPosition(editor2.yToVisualLine(y), 0));
                    }
                }
            } else {
                y = event.getMouseEvent().getY();
                offset = event.getOffset();
            }
            DocRenderItem docRenderItem = item = offset < 0 ? null : IconVisibilityController.findItem(editor2, y, offset);
            if (item != this.myCurrentItem) {
                if (this.myCurrentItem != null) {
                    this.myCurrentItem.setIconVisible(false);
                }
                this.myCurrentItem = item;
                if (this.myCurrentItem != null) {
                    this.myCurrentItem.setIconVisible(true);
                }
            }
        }

        private static DocRenderItem findItem(Editor editor2, int y, int neighborOffset) {
            Document document = editor2.getDocument();
            int lineNumber = document.getLineNumber(neighborOffset);
            int searchStartOffset = document.getLineStartOffset(Math.max(0, lineNumber - 1));
            int searchEndOffset = document.getLineEndOffset(lineNumber);
            Collection items = (Collection)editor2.getUserData(OUR_ITEMS);
            assert (items != null);
            for (DocRenderItem item : items) {
                RangeHighlighter highlighter = item.highlighter;
                if (!highlighter.isValid() || highlighter.getStartOffset() > searchEndOffset || highlighter.getEndOffset() < searchStartOffset) continue;
                int itemStartY = 0;
                int itemEndY = 0;
                if (item.foldRegion == null) {
                    itemStartY = editor2.visualLineToY(editor2.offsetToVisualLine(highlighter.getStartOffset(), false));
                    itemEndY = editor2.visualLineToY(editor2.offsetToVisualLine(highlighter.getEndOffset(), true)) + editor2.getLineHeight();
                } else {
                    CustomFoldRegion cfr = item.foldRegion;
                    Point location = cfr.getLocation();
                    if (location != null) {
                        itemStartY = location.y;
                        itemEndY = itemStartY + cfr.getHeightInPixels();
                    }
                }
                if (y < itemStartY || y >= itemEndY) break;
                return item;
            }
            return null;
        }

        @Override
        public void dispose() {
            this.myCurrentItem = null;
            this.myQueuedEditor = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderItem$IconVisibilityController";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visibleAreaChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ChangeFontSize
    extends DumbAwareAction {
        ChangeFontSize() {
            super(CodeInsightBundle.messagePointer("javadoc.adjust.font.size", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Editor editor2;
            if (e == null) {
                ChangeFontSize.$$$reportNull$$$0(0);
            }
            if ((editor2 = (Editor)e.getData(CommonDataKeys.EDITOR)) != null) {
                DocFontSizePopup.show((Component)editor2.getContentComponent(), () -> DocRenderItem.updateRenderers(editor2, true));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/render/DocRenderItem$ChangeFontSize", "actionPerformed"));
        }
    }

    private static final class ToggleRenderingAction
    extends DumbAwareAction {
        private final DocRenderItem item;

        private ToggleRenderingAction(DocRenderItem item) {
            this.copyFrom(ActionManager.getInstance().getAction("ToggleRenderedDocPresentation"));
            this.item = item;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleRenderingAction.$$$reportNull$$$0(0);
            }
            if (this.item.isValid()) {
                this.item.toggle();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/render/DocRenderItem$ToggleRenderingAction", "actionPerformed"));
        }
    }

    class MyGutterIconRenderer
    extends GutterIconRenderer
    implements DumbAware {
        private final LayeredIcon icon;

        MyGutterIconRenderer(Icon icon2, boolean iconVisible) {
            this.icon = new LayeredIcon(new Icon[]{icon2});
            this.setIconVisible(iconVisible);
        }

        boolean isIconVisible() {
            return this.icon.isLayerEnabled(0);
        }

        void setIconVisible(boolean visible) {
            this.icon.setLayerEnabled(0, visible);
        }

        public boolean equals(Object obj) {
            return obj instanceof MyGutterIconRenderer;
        }

        public int hashCode() {
            return 0;
        }

        @NotNull
        public Icon getIcon() {
            LayeredIcon layeredIcon = this.icon;
            if (layeredIcon == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(0);
            }
            return layeredIcon;
        }

        @NotNull
        public String getAccessibleName() {
            String string2 = CodeInsightBundle.message("doc.render.icon.accessible.name", new Object[0]);
            if (string2 == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(1);
            }
            return string2;
        }

        @NotNull
        public GutterIconRenderer.Alignment getAlignment() {
            GutterIconRenderer.Alignment alignment = GutterIconRenderer.Alignment.RIGHT;
            if (alignment == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(2);
            }
            return alignment;
        }

        public boolean isNavigateAction() {
            return true;
        }

        @Nullable
        public String getTooltipText() {
            AnAction action2 = ActionManager.getInstance().getAction("ToggleRenderedDocPresentation");
            if (action2 == null) {
                return null;
            }
            String actionText = action2.getTemplateText();
            if (actionText == null) {
                return null;
            }
            return XmlStringUtil.wrapInHtml(actionText + HelpTooltip.getShortcutAsHtml((String)KeymapUtil.getFirstKeyboardShortcutText((AnAction)action2)));
        }

        @Nullable
        public AnAction getClickAction() {
            return DocRenderItem.this.createToggleAction();
        }

        public ActionGroup getPopupMenuActions() {
            return ObjectUtils.tryCast(ActionManager.getInstance().getAction("DocCommentGutterIconContextMenu"), ActionGroup.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/documentation/render/DocRenderItem$MyGutterIconRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAccessibleName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlignment";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class MyFoldingListener
    implements FoldingListener {
        private MyFoldingListener() {
        }

        public void beforeFoldRegionDisposed(@NotNull FoldRegion region) {
            CustomFoldRegionRenderer renderer;
            if (region == null) {
                MyFoldingListener.$$$reportNull$$$0(0);
            }
            if (region instanceof CustomFoldRegion && (renderer = ((CustomFoldRegion)region).getRenderer()) instanceof DocRenderer) {
                ((DocRenderer)renderer).dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/codeInsight/documentation/render/DocRenderItem$MyFoldingListener", "beforeFoldRegionDisposed"));
        }
    }

    private static final class MyVisibleAreaListener
    implements VisibleAreaListener {
        private int lastWidth;
        private AffineTransform lastFrcTransform;

        private MyVisibleAreaListener(@NotNull Editor editor2) {
            if (editor2 == null) {
                MyVisibleAreaListener.$$$reportNull$$$0(0);
            }
            this.lastWidth = DocRenderer.calcWidth(editor2);
            this.lastFrcTransform = MyVisibleAreaListener.getTransform(editor2);
        }

        private static AffineTransform getTransform(Editor editor2) {
            return FontInfo.getFontRenderContext((Component)editor2.getContentComponent()).getTransform();
        }

        public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
            if (e == null) {
                MyVisibleAreaListener.$$$reportNull$$$0(1);
            }
            if (e.getNewRectangle().isEmpty()) {
                return;
            }
            Editor editor2 = e.getEditor();
            int newWidth = DocRenderer.calcWidth(editor2);
            AffineTransform transform2 = MyVisibleAreaListener.getTransform(editor2);
            if (newWidth != this.lastWidth || !Objects.equals(transform2, this.lastFrcTransform)) {
                this.lastWidth = newWidth;
                this.lastFrcTransform = transform2;
                DocRenderItem.updateRenderers(editor2, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderItem$MyVisibleAreaListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visibleAreaChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyCaretListener
    implements CaretListener {
        private MyCaretListener() {
        }

        public void caretPositionChanged(@NotNull CaretEvent event) {
            if (event == null) {
                MyCaretListener.$$$reportNull$$$0(0);
            }
            MyCaretListener.onCaretUpdate(event);
        }

        public void caretAdded(@NotNull CaretEvent event) {
            if (event == null) {
                MyCaretListener.$$$reportNull$$$0(1);
            }
            MyCaretListener.onCaretUpdate(event);
        }

        private static void onCaretUpdate(@NotNull CaretEvent event) {
            CustomFoldRegionRenderer renderer;
            Caret caret;
            if (event == null) {
                MyCaretListener.$$$reportNull$$$0(2);
            }
            if ((caret = event.getCaret()) == null) {
                return;
            }
            int caretOffset = caret.getOffset();
            FoldRegion foldRegion = caret.getEditor().getFoldingModel().getCollapsedRegionAtOffset(caretOffset);
            if (foldRegion instanceof CustomFoldRegion && caretOffset > foldRegion.getStartOffset() && (renderer = ((CustomFoldRegion)foldRegion).getRenderer()) instanceof DocRenderer) {
                ((DocRenderer)renderer).myItem.toggle();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderItem$MyCaretListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "caretPositionChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "caretAdded";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCaretUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ItemLocation {
        private final int foldStartLine;
        private final int foldEndLine;

        private ItemLocation(@NotNull RangeHighlighter highlighter) {
            if (highlighter == null) {
                ItemLocation.$$$reportNull$$$0(0);
            }
            Document document = highlighter.getDocument();
            this.foldStartLine = document.getLineNumber(highlighter.getStartOffset());
            this.foldEndLine = document.getLineNumber(highlighter.getEndOffset());
        }

        private boolean matches(CustomFoldRegion foldRegion) {
            return foldRegion == null || foldRegion.isValid() && foldRegion.getStartOffset() == foldRegion.getEditor().getDocument().getLineStartOffset(this.foldStartLine) && foldRegion.getEndOffset() == foldRegion.getEditor().getDocument().getLineEndOffset(this.foldEndLine);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/codeInsight/documentation/render/DocRenderItem$ItemLocation", "<init>"));
        }
    }
}

