/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class BraceMatcherBasedSelectioner
extends ExtendWordSelectionHandlerBase {
    @Override
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor2) {
        VirtualFile file2;
        FileType fileType;
        if (e == null) {
            BraceMatcherBasedSelectioner.$$$reportNull$$$0(0);
        }
        if (editorText == null) {
            BraceMatcherBasedSelectioner.$$$reportNull$$$0(1);
        }
        if (editor2 == null) {
            BraceMatcherBasedSelectioner.$$$reportNull$$$0(2);
        }
        FileType fileType2 = fileType = (file2 = e.getContainingFile().getVirtualFile()) == null ? null : file2.getFileType();
        if (fileType == null) {
            return super.select(e, editorText, cursorOffset, editor2);
        }
        int textLength = editorText.length();
        TextRange totalRange = e.getTextRange();
        HighlighterIterator iterator = editor2.getHighlighter().createIterator(totalRange.getStartOffset());
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        LinkedList<Trinity<Integer, Integer, IElementType>> stack = new LinkedList<Trinity<Integer, Integer, IElementType>>();
        while (!iterator.atEnd() && iterator.getStart() < totalRange.getEndOffset()) {
            if (braceMatcher.isLBraceToken(iterator, editorText, fileType)) {
                stack.addLast(Trinity.create(iterator.getStart(), iterator.getEnd(), iterator.getTokenType()));
            } else if (braceMatcher.isRBraceToken(iterator, editorText, fileType) && !stack.isEmpty()) {
                Trinity last2 = (Trinity)stack.getLast();
                if (braceMatcher.isPairBraces((IElementType)last2.third, iterator.getTokenType())) {
                    int bodyStart;
                    stack.removeLast();
                    result2.addAll(BraceMatcherBasedSelectioner.expandToWholeLine(editorText, new TextRange((Integer)last2.first, iterator.getEnd())));
                    int bodyEnd = iterator.getStart();
                    for (bodyStart = ((Integer)last2.second).intValue(); bodyStart < textLength && Character.isWhitespace(editorText.charAt(bodyStart)); ++bodyStart) {
                    }
                    while (bodyEnd > 0 && bodyStart < bodyEnd && Character.isWhitespace(editorText.charAt(bodyEnd - 1))) {
                        --bodyEnd;
                    }
                    result2.addAll(BraceMatcherBasedSelectioner.expandToWholeLine(editorText, new TextRange(bodyStart, bodyEnd)));
                }
            }
            iterator.advance();
        }
        result2.add(e.getTextRange());
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "e";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editorText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/editorActions/BraceMatcherBasedSelectioner";
        objectArray[2] = "select";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

