/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorNavigationDelegate;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class EndHandler
extends EditorActionHandler.ForEachCaret {
    private final EditorActionHandler myOriginalHandler;

    public EndHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    protected void doExecute(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
        int offset1;
        EditorNavigationDelegate[] extensions2;
        if (editor2 == null) {
            EndHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            EndHandler.$$$reportNull$$$0(1);
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (!settings.SMART_END_ACTION) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor2, caret, dataContext);
            }
            return;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor2.getComponent()));
        if (project2 == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor2, caret, dataContext);
            }
            return;
        }
        Document document = editor2.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(document);
        if (file2 == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor2, caret, dataContext);
            }
            return;
        }
        for (EditorNavigationDelegate delegate2 : extensions2 = (EditorNavigationDelegate[])EditorNavigationDelegate.EP_NAME.getExtensions()) {
            if (delegate2.navigateToLineEnd(editor2, dataContext) != EditorNavigationDelegate.Result.STOP) continue;
            return;
        }
        CaretModel caretModel = editor2.getCaretModel();
        int caretOffset = caretModel.getOffset();
        CharSequence chars = editor2.getDocument().getCharsSequence();
        int length = editor2.getDocument().getTextLength();
        if (caretOffset < length && ((offset1 = CharArrayUtil.shiftBackward(chars, caretOffset - 1, " \t")) < 0 || chars.charAt(offset1) == '\n' || chars.charAt(offset1) == '\r')) {
            boolean isEmptyLine;
            int offset2 = CharArrayUtil.shiftForward(chars, offset1 + 1, " \t");
            boolean bl = isEmptyLine = offset2 >= length || chars.charAt(offset2) == '\n' || chars.charAt(offset2) == '\r';
            if (isEmptyLine) {
                boolean stopProcessing = true;
                PsiDocumentManager.getInstance(project2).commitAllDocuments();
                CodeStyleManager styleManager = CodeStyleManager.getInstance(project2);
                String lineIndent = styleManager.getLineIndent(file2, caretOffset);
                if (lineIndent != null) {
                    int col = EndHandler.calcColumnNumber(lineIndent, editor2.getSettings().getTabSize(project2));
                    int line = caretModel.getVisualPosition().line;
                    caretModel.moveToVisualPosition(new VisualPosition(line, col));
                    if (caretModel.getLogicalPosition().column != col) {
                        if (!ApplicationManager.getApplication().isWriteAccessAllowed() && !FileDocumentManager.getInstance().requestWriting(editor2.getDocument(), project2)) {
                            return;
                        }
                        editor2.getSelectionModel().removeSelection();
                        WriteAction.run(() -> document.replaceString(offset1 + 1, offset2, lineIndent));
                    }
                } else {
                    stopProcessing = false;
                }
                editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor2.getSelectionModel().removeSelection();
                if (stopProcessing) {
                    return;
                }
            }
        }
        if (this.myOriginalHandler != null) {
            this.myOriginalHandler.execute(editor2, caret, dataContext);
        }
    }

    private static int calcColumnNumber(String lineIndent, int tabSize) {
        int result2 = 0;
        for (char c : lineIndent.toCharArray()) {
            if (c == ' ') {
                ++result2;
            }
            if (c != '\t') continue;
            result2 += tabSize;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "caret";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/editorActions/EndHandler";
        objectArray[2] = "doExecute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

