/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.AbstractIndentingBackspaceHandler;
import com.intellij.codeInsight.editorActions.BackspaceHandler;
import com.intellij.codeInsight.editorActions.SmartBackspaceMode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.psi.PsiFile;

public class SimpleIndentingBackspaceHandler
extends AbstractIndentingBackspaceHandler {
    private LogicalPosition myTargetPosition;

    public SimpleIndentingBackspaceHandler() {
        super(SmartBackspaceMode.INDENT);
    }

    @Override
    protected void doBeforeCharDeleted(char c, PsiFile file2, Editor editor2) {
        this.myTargetPosition = BackspaceHandler.getBackspaceUnindentPosition(file2, editor2);
    }

    @Override
    protected boolean doCharDeleted(char c, PsiFile file2, Editor editor2) {
        if (this.myTargetPosition != null) {
            BackspaceHandler.deleteToTargetPosition(editor2, this.myTargetPosition);
            return true;
        }
        return false;
    }
}

