/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class EnterAfterUnmatchedBraceHandler
extends EnterHandlerDelegateAdapter {
    private static final Logger LOG = Logger.getInstance(EnterAfterUnmatchedBraceHandler.class);

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        int caretOffset;
        if (file2 == null) {
            EnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            EnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            EnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            EnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            EnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(4);
        }
        if (!this.isApplicable(file2, caretOffset = caretOffsetRef.get().intValue())) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int maxRBraceCount = this.getMaxRBraceCount(file2, editor2, caretOffset);
        if (maxRBraceCount > 0) {
            this.insertRBraces(file2, editor2, caretOffset, this.getRBraceOffset(file2, editor2, caretOffset), this.generateStringToInsert(editor2, caretOffset, maxRBraceCount));
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    public boolean isApplicable(@NotNull PsiFile file2, int caretOffset) {
        if (file2 == null) {
            EnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(5);
        }
        return true;
    }

    protected int getMaxRBraceCount(@NotNull PsiFile file2, @NotNull Editor editor2, int caretOffset) {
        if (file2 == null) {
            EnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(6);
        }
        if (editor2 == null) {
            EnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(7);
        }
        if (!CodeInsightSettings.getInstance().INSERT_BRACE_ON_ENTER) {
            return 0;
        }
        return Math.max(0, EnterAfterUnmatchedBraceHandler.getUnmatchedLBracesNumberBefore(editor2, caretOffset, file2.getFileType()));
    }

    @NotNull
    protected String generateStringToInsert(@NotNull Editor editor2, int caretOffset, int maxRBraceCount) {
        if (editor2 == null) {
            EnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(8);
        }
        assert (maxRBraceCount > 0);
        CharSequence text2 = editor2.getDocument().getCharsSequence();
        int bracesToInsert = 0;
        for (int i = caretOffset - 1; i >= 0 && bracesToInsert < maxRBraceCount; --i) {
            char c = text2.charAt(i);
            if (c == '{') {
                ++bracesToInsert;
                continue;
            }
            if (this.isStopChar(c)) break;
        }
        String string2 = StringUtil.repeatSymbol('}', Math.max(bracesToInsert, 1));
        if (string2 == null) {
            EnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(9);
        }
        return string2;
    }

    protected boolean isStopChar(char c) {
        return " \n\t".indexOf(c) < 0;
    }

    protected int getRBraceOffset(@NotNull PsiFile file2, @NotNull Editor editor2, int caretOffset) {
        int fileLength;
        CharSequence text2;
        int offset;
        if (file2 == null) {
            EnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(10);
        }
        if (editor2 == null) {
            EnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(11);
        }
        if ((offset = CharArrayUtil.shiftForward(text2 = editor2.getDocument().getCharsSequence(), caretOffset, " \t")) < (fileLength = text2.length()) && ")];,%<?".indexOf(text2.charAt(offset)) < 0) {
            offset = (Integer)this.calculateOffsetToInsertClosingBrace((PsiFile)file2, (CharSequence)text2, (int)offset).second;
        }
        return Math.min(offset, fileLength);
    }

    protected void insertRBraces(@NotNull PsiFile file2, @NotNull Editor editor2, int caretOffset, int rBracesInsertOffset, String generatedRBraces) {
        if (file2 == null) {
            EnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(12);
        }
        if (editor2 == null) {
            EnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(13);
        }
        Document document = editor2.getDocument();
        this.insertRBracesAtPosition(document, caretOffset, rBracesInsertOffset, generatedRBraces);
        this.formatCodeFragmentBetweenBraces(file2, document, editor2, caretOffset, rBracesInsertOffset, generatedRBraces);
    }

    protected void insertRBracesAtPosition(Document document, int caretOffset, int rBracesInsertOffset, String generatedRBraces) {
        document.insertString(rBracesInsertOffset, "\n" + generatedRBraces);
        document.insertString(caretOffset, "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void formatCodeFragmentBetweenBraces(@NotNull PsiFile file2, @NotNull Document document, @NotNull Editor editor2, int caretOffset, int rBracesInsertOffset, String generatedRBraces) {
        boolean closingBraceIndentAdjusted;
        if (file2 == null) {
            EnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(14);
        }
        if (document == null) {
            EnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(15);
        }
        if (editor2 == null) {
            EnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(16);
        }
        Project project2 = file2.getProject();
        long stamp = document.getModificationStamp();
        try {
            PsiDocumentManager.getInstance(project2).commitDocument(document);
            CodeStyleManager.getInstance(project2).adjustLineIndent(file2, new TextRange(caretOffset, rBracesInsertOffset + 2));
        }
        catch (IncorrectOperationException e) {
            try {
                LOG.error(e);
                closingBraceIndentAdjusted = stamp != document.getModificationStamp();
            }
            catch (Throwable throwable) {
                boolean closingBraceIndentAdjusted2 = stamp != document.getModificationStamp();
                document.deleteString(caretOffset, caretOffset + 1);
                throw throwable;
            }
            document.deleteString(caretOffset, caretOffset + 1);
        }
        closingBraceIndentAdjusted = stamp != document.getModificationStamp();
        document.deleteString(caretOffset, caretOffset + 1);
        if (!closingBraceIndentAdjusted) {
            char c;
            int line = document.getLineNumber(rBracesInsertOffset);
            StringBuilder buffer = new StringBuilder();
            int start2 = document.getLineStartOffset(line);
            int end = document.getLineEndOffset(line);
            CharSequence text2 = document.getCharsSequence();
            for (int i = start2; i < end && ((c = text2.charAt(i)) == ' ' || c == '\t'); ++i) {
                buffer.append(c);
            }
            if (buffer.length() > 0) {
                document.insertString(rBracesInsertOffset + 1, buffer);
            }
        }
    }

    protected Pair<PsiElement, Integer> calculateOffsetToInsertClosingBrace(@NotNull PsiFile file2, @NotNull CharSequence text2, int offset) {
        ASTNode parentNode;
        PsiElement element2;
        ASTNode node2;
        if (file2 == null) {
            EnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(17);
        }
        if (text2 == null) {
            EnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(18);
        }
        if ((node2 = (element2 = PsiUtilCore.getElementAtOffset(file2, offset)).getNode()) != null && node2.getElementType() == TokenType.WHITE_SPACE) {
            return Pair.create(null, CharArrayUtil.shiftForwardUntil(text2, offset, "\n"));
        }
        for (PsiElement parent = element2.getParent(); parent != null && (parentNode = parent.getNode()) != null && parentNode.getStartOffset() == offset; parent = parent.getParent()) {
            element2 = parent;
        }
        if (element2.getTextOffset() != offset) {
            return Pair.create(null, CharArrayUtil.shiftForwardUntil(text2, offset, "\n"));
        }
        return Pair.create(element2, this.calculateOffsetToInsertClosingBraceInsideElement(element2));
    }

    protected int calculateOffsetToInsertClosingBraceInsideElement(PsiElement element2) {
        return element2.getTextRange().getEndOffset();
    }

    public static boolean isAfterUnmatchedLBrace(Editor editor2, int offset, FileType fileType) {
        return EnterAfterUnmatchedBraceHandler.getUnmatchedLBracesNumberBefore(editor2, offset, fileType) > 0;
    }

    protected static int getUnmatchedLBracesNumberBefore(Editor editor2, int offset, FileType fileType) {
        if (offset == 0) {
            return -1;
        }
        CharSequence chars = editor2.getDocument().getCharsSequence();
        if (chars.charAt(offset - 1) != '{') {
            return -1;
        }
        EditorHighlighter highlighter = editor2.getHighlighter();
        HighlighterIterator iterator = highlighter.createIterator(offset - 1);
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        if (!braceMatcher.isLBraceToken(iterator, chars, fileType) || !braceMatcher.isStructuralBrace(iterator, chars, fileType)) {
            return -1;
        }
        Language language = iterator.getTokenType().getLanguage();
        iterator = highlighter.createIterator(0);
        int lBracesBeforeOffset = 0;
        int rBracesAfterOffset = 0;
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType.getLanguage().equals(language) && braceMatcher.isStructuralBrace(iterator, chars, fileType)) {
                boolean beforeOffset;
                boolean bl = beforeOffset = iterator.getStart() < offset;
                if (braceMatcher.isLBraceToken(iterator, chars, fileType)) {
                    if (beforeOffset) {
                        ++lBracesBeforeOffset;
                    } else {
                        --rBracesAfterOffset;
                    }
                } else if (braceMatcher.isRBraceToken(iterator, chars, fileType)) {
                    if (beforeOffset) {
                        if (lBracesBeforeOffset > 0) {
                            --lBracesBeforeOffset;
                        }
                    } else if (++rBracesAfterOffset == lBracesBeforeOffset) {
                        return 0;
                    }
                }
            }
            iterator.advance();
        }
        return lBracesBeforeOffset - rBracesAfterOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generateStringToInsert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMaxRBraceCount";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateStringToInsert";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRBraceOffset";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "insertRBraces";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "formatCodeFragmentBetweenBraces";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "calculateOffsetToInsertClosingBrace";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

