/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.injected.FoldingRegionWindow;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FoldingUpdate {
    private static final Logger LOG = Logger.getInstance(FoldingUpdate.class);
    private static final Key<CachedValue<Runnable>> CODE_FOLDING_KEY = Key.create("code folding");
    public static final Key<Boolean> INJECTED_CODE_FOLDING_ENABLED = Key.create("injected code folding is enabled");
    private static final Key<Object> LAST_UPDATE_INJECTED_STAMP_KEY = Key.create("LAST_UPDATE_INJECTED_STAMP_KEY");

    private FoldingUpdate() {
    }

    @Nullable
    static Runnable updateFoldRegions(@NotNull Editor editor2, @NotNull PsiFile file2, boolean applyDefaultState, boolean quick) {
        Getter cached;
        if (editor2 == null) {
            FoldingUpdate.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project2 = file2.getProject();
        Document document = editor2.getDocument();
        LOG.assertTrue(!PsiDocumentManager.getInstance(project2).isUncommited(document));
        if (document.getTextLength() != file2.getTextLength()) {
            LOG.error(DebugUtil.diagnosePsiDocumentInconsistency(file2, document));
            return EmptyRunnable.INSTANCE;
        }
        CachedValue value = (CachedValue)editor2.getUserData(CODE_FOLDING_KEY);
        if (value != null && !applyDefaultState && (cached = value.getUpToDateOrNull()) != null) {
            return (Runnable)cached.get();
        }
        if (quick || applyDefaultState) {
            return FoldingUpdate.getUpdateResult(file2, document, quick, project2, editor2, applyDefaultState).getValue();
        }
        return (Runnable)CachedValuesManager.getManager(project2).getCachedValue((UserDataHolder)editor2, CODE_FOLDING_KEY, () -> {
            PsiFile file1 = PsiDocumentManager.getInstance(project2).getPsiFile(document);
            return FoldingUpdate.getUpdateResult(file1, document, false, project2, editor2, false);
        }, false);
    }

    private static CachedValueProvider.Result<Runnable> getUpdateResult(@NotNull PsiFile file2, @NotNull Document document, boolean quick, Project project2, Editor editor2, boolean applyDefaultState) {
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(2);
        }
        if (document == null) {
            FoldingUpdate.$$$reportNull$$$0(3);
        }
        PsiUtilCore.ensureValid(file2);
        List<RegionInfo> elementsToFold = FoldingUpdate.getFoldingsFor(file2, quick);
        UpdateFoldRegionsOperation operation = new UpdateFoldRegionsOperation(project2, editor2, file2, elementsToFold, FoldingUpdate.applyDefaultStateMode(applyDefaultState), !applyDefaultState, false);
        int documentLength = document.getTextLength();
        AtomicBoolean alreadyExecuted = new AtomicBoolean();
        Runnable runnable = () -> {
            if (alreadyExecuted.compareAndSet(false, true)) {
                if (documentLength != document.getTextLength() || !PsiDocumentManager.getInstance(project2).isCommitted(document)) {
                    FoldingUpdate.reportUnexpectedDocumentChange(file2, document, documentLength);
                }
                editor2.getFoldingModel().runBatchFoldingOperationDoNotCollapseCaret((Runnable)operation);
            }
        };
        HashSet<Object> dependencies = new HashSet<Object>();
        dependencies.add(file2);
        dependencies.add(editor2.getFoldingModel());
        for (RegionInfo info : elementsToFold) {
            dependencies.addAll(info.descriptor.getDependencies());
        }
        return CachedValueProvider.Result.create(runnable, ArrayUtil.toObjectArray(dependencies));
    }

    private static void reportUnexpectedDocumentChange(@NotNull PsiFile file2, @NotNull Document document, int prevLength) {
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(4);
        }
        if (document == null) {
            FoldingUpdate.$$$reportNull$$$0(5);
        }
        Document fileDoc = file2.getViewProvider().getDocument();
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        PsiDocumentManager pdm = PsiDocumentManager.getInstance(file2.getProject());
        PsiFile docFile = pdm.getCachedPsiFile(document);
        LOG.error("Document has changed since fold regions were calculated:\n  lengths: " + prevLength + " vs " + document.getTextLength() + "\n  document=" + document + "\n  file.document=" + (fileDoc == document ? "same" : fileDoc) + "\n  document.file=" + (docFile == file2 ? "same" : docFile) + "\n  committed=" + pdm.isCommitted(document) + "\n  psiFile=" + file2 + "\n  vFile.length=" + (vFile.isValid() ? vFile.getLength() : -1L));
    }

    @NotNull
    private static UpdateFoldRegionsOperation.ApplyDefaultStateMode applyDefaultStateMode(boolean applyDefaultState) {
        UpdateFoldRegionsOperation.ApplyDefaultStateMode applyDefaultStateMode = applyDefaultState ? UpdateFoldRegionsOperation.ApplyDefaultStateMode.EXCEPT_CARET_REGION : UpdateFoldRegionsOperation.ApplyDefaultStateMode.NO;
        if (applyDefaultStateMode == null) {
            FoldingUpdate.$$$reportNull$$$0(6);
        }
        return applyDefaultStateMode;
    }

    @Nullable
    public static Runnable updateInjectedFoldRegions(@NotNull Editor editor2, @NotNull PsiFile file2, boolean applyDefaultState) {
        if (editor2 == null) {
            FoldingUpdate.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(8);
        }
        if (file2 instanceof PsiCompiledElement) {
            return null;
        }
        Boolean codeFoldingEnabled = (Boolean)editor2.getUserData(INJECTED_CODE_FOLDING_ENABLED);
        if (codeFoldingEnabled != null && !codeFoldingEnabled.booleanValue()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project2 = file2.getProject();
        Document document = editor2.getDocument();
        LOG.assertTrue(!PsiDocumentManager.getInstance(project2).isUncommited(document));
        FoldingModel foldingModel = editor2.getFoldingModel();
        long timeStamp = document.getModificationStamp();
        Object lastTimeStamp = editor2.getUserData(LAST_UPDATE_INJECTED_STAMP_KEY);
        if (lastTimeStamp instanceof Long && (Long)lastTimeStamp == timeStamp) {
            return null;
        }
        List<DocumentWindow> injectedDocuments = InjectedLanguageManager.getInstance(project2).getCachedInjectedDocumentsInRange(file2, file2.getTextRange());
        if (injectedDocuments.isEmpty()) {
            return null;
        }
        ArrayList injectedEditors = new ArrayList();
        ArrayList injectedFiles = new ArrayList();
        ArrayList lists = new ArrayList();
        for (DocumentWindow injectedDocument : injectedDocuments) {
            if (!injectedDocument.isValid()) continue;
            InjectedLanguageUtil.enumerate(injectedDocument, file2, (injectedFile, places) -> {
                if (!injectedFile.isValid()) {
                    return;
                }
                Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor2, injectedFile);
                if (!(injectedEditor instanceof EditorWindow)) {
                    return;
                }
                injectedEditors.add((EditorWindow)injectedEditor);
                injectedFiles.add(injectedFile);
                ArrayList map2 = new ArrayList();
                lists.add(map2);
                FoldingUpdate.getFoldingsFor(injectedFile, map2, false);
            });
        }
        return () -> {
            ArrayList<UpdateFoldRegionsOperation> updateOperations = new ArrayList<UpdateFoldRegionsOperation>(injectedEditors.size());
            for (int i = 0; i < injectedEditors.size(); ++i) {
                EditorWindow injectedEditor = (EditorWindow)injectedEditors.get(i);
                PsiFile injectedFile = (PsiFile)injectedFiles.get(i);
                if (!injectedEditor.getDocument().isValid()) continue;
                List list2 = (List)lists.get(i);
                updateOperations.add(new UpdateFoldRegionsOperation(project2, (Editor)injectedEditor, injectedFile, list2, FoldingUpdate.applyDefaultStateMode(applyDefaultState), !applyDefaultState, true));
            }
            foldingModel.runBatchFoldingOperation(() -> {
                for (Runnable operation : updateOperations) {
                    operation.run();
                }
            });
            EditorFoldingInfo info = EditorFoldingInfo.get(editor2);
            for (FoldRegion region : editor2.getFoldingModel().getAllFoldRegions()) {
                FoldingRegionWindow injectedRegion = FoldingRegionWindow.getInjectedRegion(region);
                if (injectedRegion == null || injectedRegion.isValid()) continue;
                info.removeRegion(region);
            }
            editor2.putUserData(LAST_UPDATE_INJECTED_STAMP_KEY, (Object)timeStamp);
        };
    }

    public static boolean supportsDumbModeFolding(@NotNull Editor editor2) {
        PsiFile file2;
        Project project2;
        if (editor2 == null) {
            FoldingUpdate.$$$reportNull$$$0(9);
        }
        if ((project2 = editor2.getProject()) != null && (file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument())) != null) {
            return FoldingUpdate.supportsDumbModeFolding(file2);
        }
        return true;
    }

    private static boolean supportsDumbModeFolding(@NotNull PsiFile file2) {
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(10);
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        for (Language language : viewProvider.getLanguages()) {
            FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
            if (foldingBuilder == null || DumbService.isDumbAware(foldingBuilder)) continue;
            return false;
        }
        return true;
    }

    static List<RegionInfo> getFoldingsFor(@NotNull PsiFile file2, boolean quick) {
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(11);
        }
        if (file2 instanceof PsiCompiledFile) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
        }
        ArrayList<RegionInfo> foldingMap = new ArrayList<RegionInfo>();
        FoldingUpdate.getFoldingsFor(file2, foldingMap, quick);
        return foldingMap;
    }

    private static void getFoldingsFor(@NotNull PsiFile file2, @NotNull List<? super RegionInfo> elementsToFold, boolean quick) {
        FileViewProvider viewProvider;
        Document document;
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(12);
        }
        if (elementsToFold == null) {
            FoldingUpdate.$$$reportNull$$$0(13);
        }
        if ((document = (viewProvider = file2.getViewProvider()).getDocument()) == null) {
            LOG.error("No document for " + viewProvider);
            return;
        }
        LOG.assertTrue(PsiDocumentManager.getInstance(file2.getProject()).isCommitted(document));
        int textLength = document.getTextLength();
        TextRange docRange = TextRange.from(0, textLength);
        Comparator<Language> preferBaseLanguage = Comparator.comparing(l -> l != viewProvider.getBaseLanguage());
        List<Language> languages = ContainerUtil.sorted(viewProvider.getLanguages(), preferBaseLanguage.thenComparing(Language::getID));
        boolean slashR = document instanceof DocumentImpl && ((DocumentImpl)document).acceptsSlashR();
        DocumentImpl copyDoc = languages.size() > 1 ? new DocumentImpl(document.getImmutableCharSequence(), slashR, true) : null;
        ArrayList hardRefToRangeMarkers = new ArrayList();
        for (Language language : languages) {
            PsiFile psi = viewProvider.getPsi(language);
            FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
            if (psi == null || foldingBuilder == null) continue;
            if (psi.getTextLength() != textLength) {
                LOG.error(DebugUtil.diagnosePsiDocumentInconsistency(psi, document));
                return;
            }
            for (FoldingDescriptor descriptor : LanguageFolding.buildFoldingDescriptors(foldingBuilder, psi, document, quick)) {
                PsiElement psiElement = descriptor.getElement().getPsi();
                if (psiElement == null) {
                    LOG.error("No PSI for folding descriptor " + descriptor);
                    continue;
                }
                TextRange range = descriptor.getRange();
                if (!docRange.contains(range)) {
                    FoldingUpdate.diagnoseIncorrectRange(psi, document, language, foldingBuilder, descriptor, psiElement);
                    continue;
                }
                if (copyDoc != null && !FoldingUpdate.addNonConflictingRegion(copyDoc, range, hardRefToRangeMarkers)) continue;
                RegionInfo regionInfo = new RegionInfo(descriptor, psiElement, foldingBuilder);
                elementsToFold.add(regionInfo);
            }
        }
    }

    private static boolean addNonConflictingRegion(DocumentEx document, TextRange range, List<? super RangeMarker> hardRefToRangeMarkers) {
        int end;
        int start2 = range.getStartOffset();
        if (!document.processRangeMarkersOverlappingWith(start2, end = range.getEndOffset(), rm -> !FoldingUpdate.areConflicting(range, TextRange.create(rm)))) {
            return false;
        }
        RangeMarker marker = document.createRangeMarker(start2, end);
        hardRefToRangeMarkers.add(marker);
        return true;
    }

    private static boolean areConflicting(TextRange range1, TextRange range2) {
        if (range1.equals(range2)) {
            return true;
        }
        if (range1.contains(range2) || range2.contains(range1)) {
            return false;
        }
        return range1.intersectsStrict(range2);
    }

    private static void diagnoseIncorrectRange(@NotNull PsiFile file2, @NotNull Document document, Language language, FoldingBuilder foldingBuilder, FoldingDescriptor descriptor, PsiElement psiElement) {
        Attachment[] attachmentArray;
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(14);
        }
        if (document == null) {
            FoldingUpdate.$$$reportNull$$$0(15);
        }
        String message2 = "Folding descriptor " + descriptor + " made by " + foldingBuilder + " for " + language + " is outside document range, PSI element: " + psiElement + ", PSI element range: " + psiElement.getTextRange() + "; " + DebugUtil.diagnosePsiDocumentInconsistency(psiElement, document);
        if (ApplicationManager.getApplication().isInternal()) {
            Attachment[] attachmentArray2 = new Attachment[2];
            attachmentArray2[0] = AttachmentFactory.createAttachment(document);
            attachmentArray = attachmentArray2;
            attachmentArray2[1] = new Attachment("psiTree.txt", DebugUtil.psiToString(file2, true, true));
        } else {
            attachmentArray = Attachment.EMPTY_ARRAY;
        }
        LOG.error(message2, attachmentArray);
    }

    static void clearFoldingCache(@NotNull Editor editor2) {
        if (editor2 == null) {
            FoldingUpdate.$$$reportNull$$$0(16);
        }
        editor2.putUserData(CODE_FOLDING_KEY, null);
        editor2.putUserData(LAST_UPDATE_INJECTED_STAMP_KEY, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/FoldingUpdate";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToFold";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/FoldingUpdate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "applyDefaultStateMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateFoldRegions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUpdateResult";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reportUnexpectedDocumentChange";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateInjectedFoldRegions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "supportsDumbModeFolding";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingsFor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "diagnoseIncorrectRange";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "clearFoldingCache";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class RegionInfo {
        @NotNull
        final FoldingDescriptor descriptor;
        final PsiElement element;
        final String signature;
        final boolean collapsedByDefault;

        private RegionInfo(@NotNull FoldingDescriptor descriptor, @NotNull PsiElement psiElement, @NotNull FoldingBuilder foldingBuilder) {
            if (descriptor == null) {
                RegionInfo.$$$reportNull$$$0(0);
            }
            if (psiElement == null) {
                RegionInfo.$$$reportNull$$$0(1);
            }
            if (foldingBuilder == null) {
                RegionInfo.$$$reportNull$$$0(2);
            }
            this.descriptor = descriptor;
            this.element = psiElement;
            Boolean hardCoded = descriptor.isCollapsedByDefault();
            this.collapsedByDefault = hardCoded == null ? FoldingPolicy.isCollapsedByDefault(descriptor, foldingBuilder) : hardCoded;
            this.signature = RegionInfo.createSignature(psiElement);
        }

        private static String createSignature(@NotNull PsiElement element2) {
            PsiFile containingFile;
            PsiElement restoredElement;
            String signature;
            if (element2 == null) {
                RegionInfo.$$$reportNull$$$0(3);
            }
            if ((signature = FoldingPolicy.getSignature(element2)) != null && Registry.is("folding.signature.validation") && !element2.equals(restoredElement = FoldingPolicy.restoreBySignature(containingFile = element2.getContainingFile(), signature))) {
                StringBuilder trace = new StringBuilder();
                PsiElement restoredAgain = FoldingPolicy.restoreBySignature(containingFile, signature, trace);
                LOG.error("element: " + element2 + "(" + element2.getText() + "); restoredElement: " + restoredElement + "; signature: '" + signature + "'; file: " + containingFile + "; injected: " + InjectedLanguageManager.getInstance(element2.getProject()).isInjectedFragment(containingFile) + "; languages: " + containingFile.getViewProvider().getLanguages() + "; restored again: " + restoredAgain + "; restore produces same results: " + (restoredAgain == restoredElement) + "; trace:\n" + trace);
            }
            return signature;
        }

        public String toString() {
            return this.descriptor + ", collapsedByDefault=" + this.collapsedByDefault;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foldingBuilder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/folding/impl/FoldingUpdate$RegionInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createSignature";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

