/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.CodeBlockSupportHandler;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCodeBlockSupportHandler
implements CodeBlockSupportHandler {
    @NotNull
    protected abstract TokenSet getTopLevelElementTypes();

    @NotNull
    protected abstract TokenSet getKeywordElementTypes();

    @NotNull
    protected abstract TokenSet getBlockElementTypes();

    @NotNull
    protected abstract TokenSet getDirectChildrenElementTypes(@Nullable IElementType var1);

    @Override
    @NotNull
    public List<TextRange> getCodeBlockMarkerRanges(@NotNull PsiElement elementAtCursor) {
        TokenSet keywordElementTypes;
        if (elementAtCursor == null) {
            AbstractCodeBlockSupportHandler.$$$reportNull$$$0(0);
        }
        if (!(keywordElementTypes = this.getKeywordElementTypes()).contains(PsiUtilCore.getElementType(elementAtCursor))) {
            List<TextRange> list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractCodeBlockSupportHandler.$$$reportNull$$$0(1);
            }
            return list2;
        }
        PsiElement rootElement = AbstractCodeBlockSupportHandler.getParentByTokenSet(elementAtCursor, this.getTopLevelElementTypes());
        if (rootElement == null) {
            List<TextRange> list3 = Collections.emptyList();
            if (list3 == null) {
                AbstractCodeBlockSupportHandler.$$$reportNull$$$0(2);
            }
            return list3;
        }
        return this.computeMarkersRanges(rootElement, keywordElementTypes);
    }

    @Override
    @NotNull
    public TextRange getCodeBlockRange(@NotNull PsiElement elementAtCursor) {
        PsiElement obj;
        if (elementAtCursor == null) {
            AbstractCodeBlockSupportHandler.$$$reportNull$$$0(3);
        }
        TextRange value = (obj = AbstractCodeBlockSupportHandler.getParentByTokenSet(elementAtCursor, this.getBlockElementTypes())) == null ? null : obj.getTextRange();
        TextRange textRange = value == null ? TextRange.EMPTY_RANGE : value;
        if (textRange == null) {
            AbstractCodeBlockSupportHandler.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @NotNull
    private List<TextRange> computeMarkersRanges(@NotNull PsiElement rootElement, @NotNull TokenSet keywordsElementTypes) {
        IElementType type;
        if (rootElement == null) {
            AbstractCodeBlockSupportHandler.$$$reportNull$$$0(5);
        }
        if (keywordsElementTypes == null) {
            AbstractCodeBlockSupportHandler.$$$reportNull$$$0(6);
        }
        if (keywordsElementTypes.contains(type = PsiUtilCore.getElementType(rootElement))) {
            List<TextRange> list2 = Collections.singletonList(rootElement.getTextRange());
            if (list2 == null) {
                AbstractCodeBlockSupportHandler.$$$reportNull$$$0(7);
            }
            return list2;
        }
        TokenSet directChildrenTypes = this.getDirectChildrenElementTypes(type);
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        for (PsiElement currentElement = rootElement.getFirstChild(); currentElement != null; currentElement = currentElement.getNextSibling()) {
            IElementType currentElementType = PsiUtilCore.getElementType(currentElement);
            if (!directChildrenTypes.contains(currentElementType)) continue;
            result2.addAll(this.computeMarkersRanges(currentElement, keywordsElementTypes));
        }
        ArrayList<TextRange> arrayList = result2;
        if (arrayList == null) {
            AbstractCodeBlockSupportHandler.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    private static PsiElement getParentByTokenSet(@NotNull PsiElement element2, @NotNull TokenSet tokenSet) {
        PsiElement run2;
        if (element2 == null) {
            AbstractCodeBlockSupportHandler.$$$reportNull$$$0(9);
        }
        if (tokenSet == null) {
            AbstractCodeBlockSupportHandler.$$$reportNull$$$0(10);
        }
        for (run2 = element2; run2 != null && !tokenSet.contains(PsiUtilCore.getElementType(run2)); run2 = run2.getParent()) {
        }
        return run2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAtCursor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/AbstractCodeBlockSupportHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordsElementTypes";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/AbstractCodeBlockSupportHandler";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeBlockMarkerRanges";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeBlockRange";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMarkersRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCodeBlockMarkerRanges";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCodeBlockRange";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeMarkersRanges";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParentByTokenSet";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

