/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPassFactory;
import com.intellij.codeInsight.highlighting.BackgroundHighlightingUtil;
import com.intellij.codeInsight.highlighting.BraceHighlightingHandler;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.Alarm;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

final class BackgroundHighlighter
implements StartupActivity.DumbAware {
    private final Alarm myAlarm = new Alarm();

    BackgroundHighlighter() {
    }

    @Override
    public void runActivity(@NotNull Project project2) {
        if (project2 == null) {
            BackgroundHighlighter.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode() || !IdentifierHighlighterPassFactory.isEnabled()) {
            return;
        }
        Disposable activityDisposable = ExtensionPointUtil.createExtensionDisposable(this, StartupActivity.POST_STARTUP_ACTIVITY);
        Disposer.register(project2, activityDisposable);
        this.registerListeners(project2, activityDisposable);
    }

    private void registerListeners(final @NotNull Project project2, @NotNull Disposable parentDisposable) {
        if (project2 == null) {
            BackgroundHighlighter.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            BackgroundHighlighter.$$$reportNull$$$0(2);
        }
        EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        eventMulticaster.addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.getCaret() != e.getEditor().getCaretModel().getPrimaryCaret()) {
                    return;
                }
                BackgroundHighlighter.this.onCaretUpdate(e.getEditor(), project2);
            }

            public void caretAdded(@NotNull CaretEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (e.getCaret() != e.getEditor().getCaretModel().getPrimaryCaret()) {
                    return;
                }
                BackgroundHighlighter.this.onCaretUpdate(e.getEditor(), project2);
            }

            public void caretRemoved(@NotNull CaretEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(2);
                }
                BackgroundHighlighter.this.onCaretUpdate(e.getEditor(), project2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/highlighting/BackgroundHighlighter$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretPositionChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretAdded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, parentDisposable);
        SelectionListener selectionListener = new SelectionListener(){

            public void selectionChanged(@NotNull SelectionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                BackgroundHighlighter.this.myAlarm.cancelAllRequests();
                Editor editor2 = e.getEditor();
                if (editor2.getProject() != project2) {
                    return;
                }
                TextRange oldRange = e.getOldRange();
                TextRange newRange = e.getNewRange();
                if (oldRange != null && newRange != null && oldRange.isEmpty() == newRange.isEmpty()) {
                    return;
                }
                BackgroundHighlighter.this.updateHighlighted(project2, editor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/highlighting/BackgroundHighlighter$2", "selectionChanged"));
            }
        };
        eventMulticaster.addSelectionListener(selectionListener, parentDisposable);
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                BackgroundHighlighter.this.myAlarm.cancelAllRequests();
                EditorFactory.getInstance().editors(e.getDocument(), project2).forEach(editor2 -> BackgroundHighlighter.this.updateHighlighted(project2, (Editor)editor2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/highlighting/BackgroundHighlighter$3", "documentChanged"));
            }
        };
        eventMulticaster.addDocumentListener(documentListener, parentDisposable);
        project2.getMessageBus().connect(parentDisposable).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, new FileEditorManagerListener(){

            @Override
            public void selectionChanged(@NotNull FileEditorManagerEvent e) {
                FileEditor newEditor;
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                BackgroundHighlighter.this.myAlarm.cancelAllRequests();
                FileEditor oldEditor = e.getOldEditor();
                if (oldEditor instanceof TextEditor) {
                    BackgroundHighlighter.this.clearBraces(project2, ((TextEditor)oldEditor).getEditor());
                }
                if ((newEditor = e.getNewEditor()) instanceof TextEditor) {
                    BackgroundHighlighter.this.updateHighlighted(project2, ((TextEditor)newEditor).getEditor());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/highlighting/BackgroundHighlighter$4", "selectionChanged"));
            }
        });
        project2.getMessageBus().connect(parentDisposable).subscribe(TemplateManager.TEMPLATE_STARTED_TOPIC, state -> {
            if (state.isFinished()) {
                return;
            }
            this.updateHighlighted(project2, state.getEditor());
            state.addTemplateStateListener(new TemplateEditingAdapter(){

                @Override
                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    if (template == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    BackgroundHighlighter.this.updateHighlighted(project2, state.getEditor());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/highlighting/BackgroundHighlighter$5", "templateFinished"));
                }
            });
        });
    }

    private void onCaretUpdate(@NotNull Editor editor2, @NotNull Project project2) {
        if (editor2 == null) {
            BackgroundHighlighter.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            BackgroundHighlighter.$$$reportNull$$$0(4);
        }
        this.myAlarm.cancelAllRequests();
        SelectionModel selectionModel = editor2.getSelectionModel();
        if (editor2.getProject() != project2 || selectionModel.hasSelection()) {
            return;
        }
        this.updateHighlighted(project2, editor2);
    }

    private void updateHighlighted(@NotNull Project project2, @NotNull Editor editor2) {
        if (project2 == null) {
            BackgroundHighlighter.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            BackgroundHighlighter.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (editor2.getDocument().isInBulkUpdate()) {
            return;
        }
        BackgroundHighlightingUtil.lookForInjectedFileInOtherThread(project2, editor2, (foundFile, newEditor) -> {
            IdentifierHighlighterPass pass2 = new IdentifierHighlighterPassFactory().createHighlightingPass((PsiFile)foundFile, (Editor)newEditor, TextRange.from(0, foundFile.getTextLength()));
            if (pass2 != null) {
                pass2.doCollectInformation();
            }
            return pass2;
        }, (foundFile, newEditor, pass2) -> {
            BraceHighlightingHandler handler = new BraceHighlightingHandler(project2, (Editor)newEditor, this.myAlarm, (PsiFile)foundFile);
            handler.updateBraces();
            if (pass2 != null) {
                pass2.doApplyInformationToEditor();
            }
        });
    }

    private void clearBraces(@NotNull Project project2, @NotNull Editor editor2) {
        if (project2 == null) {
            BackgroundHighlighter.$$$reportNull$$$0(7);
        }
        if (editor2 == null) {
            BackgroundHighlighter.$$$reportNull$$$0(8);
        }
        BackgroundHighlightingUtil.lookForInjectedFileInOtherThread(project2, editor2, (__, ___) -> null, (foundFile, newEditor, __) -> {
            BraceHighlightingHandler handler = new BraceHighlightingHandler(project2, (Editor)newEditor, this.myAlarm, (PsiFile)foundFile);
            handler.clearBraceHighlighters();
        });
    }

    @NotNull
    static Alarm getAlarm() {
        Alarm alarm2 = Objects.requireNonNull(BackgroundHighlighter.POST_STARTUP_ACTIVITY.findExtension(BackgroundHighlighter.class)).myAlarm;
        if (alarm2 == null) {
            BackgroundHighlighter.$$$reportNull$$$0(9);
        }
        return alarm2;
    }

    @TestOnly
    static void enableListenersInTest(@NotNull Project project2, @NotNull Disposable disposable) {
        if (project2 == null) {
            BackgroundHighlighter.$$$reportNull$$$0(10);
        }
        if (disposable == null) {
            BackgroundHighlighter.$$$reportNull$$$0(11);
        }
        POST_STARTUP_ACTIVITY.findExtension(BackgroundHighlighter.class).registerListeners(project2, disposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/BackgroundHighlighter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/BackgroundHighlighter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlarm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerListeners";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onCaretUpdate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateHighlighted";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "clearBraces";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "enableListenersInTest";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

