/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public abstract class HighlightHandlerBase {
    public static void setupFindModel(@NotNull Project project2) {
        FindManager findManager;
        FindModel model2;
        if (project2 == null) {
            HighlightHandlerBase.$$$reportNull$$$0(0);
        }
        if ((model2 = (findManager = FindManager.getInstance((Project)project2)).getFindNextModel()) == null) {
            model2 = findManager.getFindInFileModel();
        }
        model2.setSearchHighlighters(true);
        findManager.setFindWasPerformed();
        findManager.setFindNextModel(model2);
    }

    @NotNull
    @NlsContexts.Tooltip
    public static String getLineTextErrorStripeTooltip(@NotNull Document document, int offset, boolean escape) {
        if (document == null) {
            HighlightHandlerBase.$$$reportNull$$$0(1);
        }
        int lineNumber = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        int lineFragmentEndOffset = Math.min(lineStartOffset + 140, lineEndOffset);
        Object lineText = document.getImmutableCharSequence().subSequence(lineStartOffset, lineFragmentEndOffset).toString();
        if (lineFragmentEndOffset != lineEndOffset) {
            lineText = ((String)lineText).trim() + "...";
        }
        String string2 = "  " + (escape ? StringUtil.escapeXmlEntities(((String)lineText).trim()) : ((String)lineText).trim()) + "  ";
        if (string2 == null) {
            HighlightHandlerBase.$$$reportNull$$$0(2);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/HighlightHandlerBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/HighlightHandlerBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineTextErrorStripeTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupFindModel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLineTextErrorStripeTooltip";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

