/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateLanguageErrorFilter
extends HighlightErrorFilter {
    @NotNull
    private final TokenSet myTemplateExpressionEdgeTokens;
    @NotNull
    private final Class myTemplateFileViewProviderClass;
    private final Set<String> knownLanguageIdSet;
    private static final Key<FileViewProvider> TOP_LEVEL_VIEW_PROVIDER = Key.create("TOP_LEVEL_VIEW_PROVIDER");

    protected TemplateLanguageErrorFilter(@NotNull TokenSet templateExpressionEdgeTokens, @NotNull Class templateFileViewProviderClass) {
        if (templateExpressionEdgeTokens == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(0);
        }
        if (templateFileViewProviderClass == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(1);
        }
        this(templateExpressionEdgeTokens, templateFileViewProviderClass, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    protected TemplateLanguageErrorFilter(@NotNull TokenSet templateExpressionEdgeTokens, @NotNull Class templateFileViewProviderClass, String ... knownSubLanguageNames) {
        if (templateExpressionEdgeTokens == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(2);
        }
        if (templateFileViewProviderClass == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(3);
        }
        if (knownSubLanguageNames == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(4);
        }
        this.knownLanguageIdSet = new HashSet<String>();
        this.myTemplateExpressionEdgeTokens = TokenSet.create(templateExpressionEdgeTokens.getTypes());
        this.myTemplateFileViewProviderClass = templateFileViewProviderClass;
        Collections.addAll(this.knownLanguageIdSet, knownSubLanguageNames);
        this.knownLanguageIdSet.add("JavaScript");
        this.knownLanguageIdSet.add("CSS");
    }

    @Override
    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element2) {
        if (element2 == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(5);
        }
        if (this.isKnownSubLanguage(element2.getParent().getLanguage())) {
            TextRange range;
            FileViewProvider viewProvider = element2.getUserData(TOP_LEVEL_VIEW_PROVIDER);
            if (viewProvider == null) {
                viewProvider = InjectedLanguageManager.getInstance(element2.getProject()).getTopLevelFile(element2).getViewProvider();
                element2.putUserData(TOP_LEVEL_VIEW_PROVIDER, viewProvider);
            }
            if (!this.isTemplateViewProvider(viewProvider)) {
                return true;
            }
            PsiFile psiFile = element2.getContainingFile();
            if (this.isNearTemplateExpressions(psiFile, (range = element2.getTextRange()).getStartOffset(), range.getEndOffset()) || TemplateLanguageErrorFilter.hasErrorElementsBeforeAndUp(element2) || PsiTreeUtil.findChildOfType(element2, OuterLanguageElement.class) != null) {
                return false;
            }
        }
        return true;
    }

    protected boolean isTemplateViewProvider(FileViewProvider viewProvider) {
        return viewProvider.getClass() == this.myTemplateFileViewProviderClass;
    }

    private static boolean hasErrorElementsBeforeAndUp(@NotNull PsiElement element2) {
        if (element2 == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(6);
        }
        JBIterable<PsiErrorElement> previousErrors = JBIterable.generate(element2, e -> ObjectUtils.coalesce(e.getPrevSibling(), e.getParent())).skip(1).filter(PsiErrorElement.class);
        return previousErrors.isNotEmpty();
    }

    protected final boolean isNearTemplateExpressions(@NotNull PsiFile file2, int start2, int end) {
        InjectedLanguageManager injectedLanguageManager;
        PsiLanguageInjectionHost host;
        FileViewProvider viewProvider;
        if (file2 == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(7);
        }
        if (this.isTemplateViewProvider(viewProvider = file2.getViewProvider()) && file2.getLanguage() != viewProvider.getBaseLanguage()) {
            CharSequence fileText = viewProvider.getContents();
            PsiElement beforeWs = TemplateLanguageErrorFilter.findBaseLanguageElement(viewProvider, CharArrayUtil.shiftBackward(fileText, start2 - 1, " \t\n"));
            PsiElement afterWs = TemplateLanguageErrorFilter.findBaseLanguageElement(viewProvider, CharArrayUtil.shiftForward(fileText, end, " \t\n"));
            if (this.isTemplateEdge(afterWs) || this.isTemplateEdge(beforeWs) || this.hasTemplateInside(start2, end, viewProvider)) {
                return true;
            }
        }
        if ((host = (injectedLanguageManager = InjectedLanguageManager.getInstance(file2.getProject())).getInjectionHost(file2)) != null && (start2 = injectedLanguageManager.injectedToHost((PsiElement)file2, start2)) <= (end = injectedLanguageManager.injectedToHost((PsiElement)file2, end))) {
            return this.isNearTemplateExpressions(host.getContainingFile(), start2, end);
        }
        return false;
    }

    private boolean hasTemplateInside(int start2, int end, FileViewProvider viewProvider) {
        int dataEnd;
        PsiElement data2 = TemplateLanguageErrorFilter.findBaseLanguageElement(viewProvider, start2);
        return data2 != null && (dataEnd = data2.getTextRange().getEndOffset()) < end && this.isTemplateEdge(TemplateLanguageErrorFilter.findBaseLanguageElement(viewProvider, dataEnd));
    }

    @Nullable
    private static PsiElement findBaseLanguageElement(FileViewProvider viewProvider, int offset) {
        return viewProvider.findElementAt(offset, viewProvider.getBaseLanguage());
    }

    private boolean isTemplateEdge(PsiElement e) {
        return this.myTemplateExpressionEdgeTokens.contains(PsiUtilCore.getElementType(e));
    }

    protected boolean isKnownSubLanguage(@NotNull Language language) {
        if (language == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(8);
        }
        for (String knownLanguageId : this.knownLanguageIdSet) {
            Language knownLanguage = Language.findLanguageByID(knownLanguageId);
            if (knownLanguage == null || !language.is(knownLanguage) && !knownLanguage.getDialects().contains(language)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateExpressionEdgeTokens";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFileViewProviderClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "knownSubLanguageNames";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/highlighting/TemplateLanguageErrorFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldHighlightErrorElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hasErrorElementsBeforeAndUp";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isNearTemplateExpressions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isKnownSubLanguage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

