/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.hint.ParameterInfoControllerBase;
import com.intellij.codeInsight.hint.ParameterInfoControllerData;
import com.intellij.codeWithMe.ClientIdKt;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContextEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Function;
import com.intellij.util.SlowOperations;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.xml.util.XmlStringUtil;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMaps;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public class ParameterInfoComponent
extends JPanel {
    private final JPanel myMainPanel;
    private OneElementComponent[] myPanels;
    private JLabel myShortcutLabel;
    private final JLabel myDumbLabel = new JLabel(IdeBundle.message((String)"dumb.mode.results.might.be.incomplete", (Object[])new Object[0]));
    private final boolean myAllowSwitchLabel;
    private final Font NORMAL_FONT;
    private final Font BOLD_FONT;
    private static final Color BACKGROUND = JBColor.namedColor("ParameterInfo.background", HintUtil.getInformationColor());
    private static final Color FOREGROUND = JBColor.namedColor("ParameterInfo.foreground", new JBColor(0x1D1D1D, 0xBBBBBB));
    private static final Color HIGHLIGHTED_COLOR = JBColor.namedColor("ParameterInfo.currentParameterForeground", new JBColor(0x1D1D1D, 0xE8E8E8));
    private static final Color DISABLED_COLOR = JBColor.namedColor("ParameterInfo.disabledForeground", new JBColor(0xA8A8A8, 0x777777));
    private static final Color CONTEXT_HELP_FOREGROUND = JBColor.namedColor("ParameterInfo.infoForeground", new JBColor(0x787878, 0x878787));
    static final Color BORDER_COLOR = JBColor.namedColor("ParameterInfo.borderColor", HintUtil.INFORMATION_BORDER_COLOR);
    private static final Color HIGHLIGHTED_BACKGROUND = JBColor.namedColor("ParameterInfo.currentOverloadBackground", BORDER_COLOR);
    private static final Color SEPARATOR_COLOR = JBColor.namedColor("ParameterInfo.lineSeparatorColor", BORDER_COLOR);
    private static final Border EMPTY_BORDER = JBUI.Borders.empty(2, 10);
    private static final Border BOTTOM_BORDER = new CompoundBorder(JBUI.Borders.customLine(SEPARATOR_COLOR, 0, 0, 1, 0), EMPTY_BORDER);
    protected int myWidthLimit = 500;
    private final int myMaxVisibleRows = Registry.intValue("parameter.info.max.visible.rows");
    private static final Comparator<TextRange> TEXT_RANGE_COMPARATOR = (o1, o2) -> {
        int endResult = Integer.compare(o2.getEndOffset(), o1.getEndOffset());
        return endResult == 0 ? Integer.compare(o1.getStartOffset(), o2.getStartOffset()) : endResult;
    };
    private final ParameterInfoControllerData myParameterInfoControllerData;
    private final Editor myEditor;
    private final boolean myRequestFocus;

    @TestOnly
    public static ParameterInfoUIContextEx createContext(Object[] objects, @NotNull Editor editor2, @NotNull ParameterInfoHandler handler, int currentParameterIndex) {
        if (editor2 == null) {
            ParameterInfoComponent.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            ParameterInfoComponent.$$$reportNull$$$0(1);
        }
        return ParameterInfoComponent.createContext(objects, editor2, handler, currentParameterIndex, null);
    }

    @TestOnly
    public static ParameterInfoUIContextEx createContext(Object[] objects, @NotNull Editor editor2, @NotNull ParameterInfoHandler handler, int currentParameterIndex, @Nullable PsiElement parameterOwner) {
        ParameterInfoComponent infoComponent;
        if (editor2 == null) {
            ParameterInfoComponent.$$$reportNull$$$0(2);
        }
        if (handler == null) {
            ParameterInfoComponent.$$$reportNull$$$0(3);
        }
        ParameterInfoControllerData dataObject = new ParameterInfoControllerData(handler);
        dataObject.setDescriptors(objects);
        dataObject.setCurrentParameterIndex(currentParameterIndex);
        dataObject.setParameterOwner(parameterOwner);
        ParameterInfoComponent parameterInfoComponent = infoComponent = new ParameterInfoComponent(dataObject, editor2);
        Objects.requireNonNull(parameterInfoComponent);
        return parameterInfoComponent.new MyParameterContext(false);
    }

    private ParameterInfoComponent(ParameterInfoControllerData parameterInfoControllerData, Editor editor2) {
        this(parameterInfoControllerData, editor2, false, false);
    }

    ParameterInfoComponent(ParameterInfoControllerData parameterInfoControllerData, Editor editor2, boolean requestFocus, boolean allowSwitchLabel) {
        super(new BorderLayout());
        this.myParameterInfoControllerData = parameterInfoControllerData;
        this.myEditor = editor2;
        this.myRequestFocus = requestFocus;
        if (!(ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment() || ClientIdKt.isForeignClientOnServer())) {
            JComponent editorComponent = editor2.getComponent();
            JLayeredPane layeredPane2 = editorComponent.getRootPane().getLayeredPane();
            this.myWidthLimit = layeredPane2.getWidth();
        }
        this.NORMAL_FONT = editor2 != null && Registry.is("parameter.info.editor.font") ? editor2.getColorsScheme().getFont(EditorFontType.PLAIN) : StartupUiUtil.getLabelFont();
        this.BOLD_FONT = editor2 != null && Registry.is("parameter.info.editor.font") ? editor2.getColorsScheme().getFont(EditorFontType.BOLD) : this.NORMAL_FONT.deriveFont(1);
        this.setBackground(BACKGROUND);
        this.myMainPanel = new JPanel(new GridBagLayout());
        this.setPanels();
        if (this.myRequestFocus) {
            AccessibleContextUtil.setName((Component)this, CodeInsightBundle.message("accessible.name.parameter.info.press.tab", new Object[0]));
        }
        this.myDumbLabel.setForeground(CONTEXT_HELP_FOREGROUND);
        this.myDumbLabel.setIcon(AllIcons.General.Warning);
        this.myDumbLabel.setBorder(new CompoundBorder(JBUI.Borders.customLine(SEPARATOR_COLOR, 0, 0, 1, 0), JBUI.Borders.empty(2, 10, 6, 10)));
        this.add((Component)this.myDumbLabel, "North");
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myMainPanel, (boolean)true);
        this.add((Component)pane, "Center");
        this.myAllowSwitchLabel = allowSwitchLabel && !(editor2 instanceof EditorWindow);
        this.setShortcutLabel();
    }

    private void setPanels() {
        this.myMainPanel.removeAll();
        this.myPanels = new OneElementComponent[this.myParameterInfoControllerData.getDescriptors().length];
        for (int i = 0; i < this.myParameterInfoControllerData.getDescriptors().length; ++i) {
            this.myPanels[i] = new OneElementComponent();
            this.myMainPanel.add((Component)this.myPanels[i], new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 17, 2, JBInsets.emptyInsets(), 0, 0));
        }
    }

    private void setShortcutLabel() {
        if (this.myShortcutLabel != null) {
            this.remove(this.myShortcutLabel);
        }
        String upShortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"MethodOverloadSwitchUp");
        String downShortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"MethodOverloadSwitchDown");
        if (!this.myAllowSwitchLabel || this.myParameterInfoControllerData.getDescriptors().length <= 1 || !this.myParameterInfoControllerData.getHandler().supportsOverloadSwitching() || upShortcut.isEmpty() && downShortcut.isEmpty()) {
            this.myShortcutLabel = null;
        } else {
            this.myShortcutLabel = new JLabel(upShortcut.isEmpty() || downShortcut.isEmpty() ? CodeInsightBundle.message("parameter.info.switch.overload.shortcuts.single", upShortcut.isEmpty() ? downShortcut : upShortcut) : CodeInsightBundle.message("parameter.info.switch.overload.shortcuts", upShortcut, downShortcut));
            this.myShortcutLabel.setForeground(CONTEXT_HELP_FOREGROUND);
            Font labelFont = StartupUiUtil.getLabelFont();
            this.myShortcutLabel.setFont(labelFont.deriveFont(labelFont.getSize2D() - (float)(SystemInfo.isWindows ? 1 : 2)));
            this.myShortcutLabel.setBorder(JBUI.Borders.empty(6, 10, 0, 10));
            this.add((Component)this.myShortcutLabel, "South");
        }
    }

    void fireDescriptorsWereSet() {
        this.setPanels();
        this.setShortcutLabel();
    }

    @Override
    public Dimension getPreferredSize() {
        long visibleRows = Stream.of(this.myPanels).filter(Component::isVisible).count();
        Dimension preferredSize = super.getPreferredSize();
        if (visibleRows <= (long)this.myMaxVisibleRows) {
            return preferredSize;
        }
        return new Dimension(preferredSize.width + 20, 200);
    }

    @Override
    public String toString() {
        return Stream.of(this.myPanels).filter(Component::isVisible).map(c -> c + (c.getBorder() == BOTTOM_BORDER ? "\n-" : "")).collect(Collectors.joining("\n"));
    }

    ParameterInfoControllerBase.Model update(boolean singleParameterInfo) {
        return SlowOperations.allowSlowOperations(() -> this.doUpdate(singleParameterInfo));
    }

    private ParameterInfoControllerBase.Model doUpdate(boolean singleParameterInfo) {
        Project project2;
        MyParameterContext context2 = new MyParameterContext(singleParameterInfo);
        int highlightedComponentIdx = -1;
        for (int i = 0; i < this.myParameterInfoControllerData.getDescriptors().length; ++i) {
            context2.i = i;
            Object o = this.myParameterInfoControllerData.getDescriptors()[i];
            boolean isHighlighted = this.myParameterInfoControllerData.getDescriptors()[i].equals(this.myParameterInfoControllerData.getHighlighted());
            if (isHighlighted) {
                context2.result.highlightedSignature = i;
            }
            if (singleParameterInfo && this.myParameterInfoControllerData.getDescriptors().length > 1 && !context2.isHighlighted()) {
                this.setVisible(i, false);
                continue;
            }
            this.setVisible(i, true);
            DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> this.myParameterInfoControllerData.getHandler().updateUI(o, context2));
            if (!context2.isHighlighted()) continue;
            highlightedComponentIdx = i;
        }
        if (this.myShortcutLabel != null) {
            this.myShortcutLabel.setVisible(!singleParameterInfo);
        }
        if (highlightedComponentIdx != -1) {
            this.myMainPanel.scrollRectToVisible(new Rectangle());
            this.myMainPanel.scrollRectToVisible(this.myPanels[highlightedComponentIdx].getBounds());
        }
        this.myDumbLabel.setVisible((project2 = this.myEditor.getProject()) != null && DumbService.isDumb(project2));
        return context2.result;
    }

    void setEnabled(int index, boolean enabled) {
        this.myPanels[index].setEnabled(enabled);
    }

    void setVisible(int index, boolean visible) {
        this.myPanels[index].setVisible(visible);
    }

    boolean isEnabled(int index) {
        return this.myPanels[index].isEnabled();
    }

    private static String getOpeningTag(@NotNull String value) {
        if (value == null) {
            ParameterInfoComponent.$$$reportNull$$$0(4);
        }
        return "<" + value + ">";
    }

    private static String getClosingTag(@NotNull String value) {
        int index;
        if (value == null) {
            ParameterInfoComponent.$$$reportNull$$$0(5);
        }
        return "</" + (0 <= (index = value.indexOf(32)) ? value.substring(0, index) : value) + ">";
    }

    private static String getTagValue(@NotNull ParameterInfoUIContextEx.Flag flag) {
        if (flag == null) {
            ParameterInfoComponent.$$$reportNull$$$0(6);
        }
        if (flag == ParameterInfoUIContextEx.Flag.HIGHLIGHT) {
            return "b color=" + ColorUtil.toHex(HIGHLIGHTED_COLOR);
        }
        if (flag == ParameterInfoUIContextEx.Flag.DISABLE) {
            return "font color=" + ColorUtil.toHex(DISABLED_COLOR);
        }
        if (flag == ParameterInfoUIContextEx.Flag.STRIKEOUT) {
            return "strike";
        }
        throw new IllegalArgumentException("flag=" + flag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flag";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/hint/ParameterInfoComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getOpeningTag";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getClosingTag";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getTagValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class OneLineComponent
    extends JPanel {
        JLabel myLabel;

        private OneLineComponent() {
            super(new GridBagLayout());
            this.myLabel = new JLabel("", 2);
            this.myLabel.setOpaque(true);
            this.myLabel.setFont(ParameterInfoComponent.this.NORMAL_FONT);
            if (ParameterInfoComponent.this.myRequestFocus) {
                this.myLabel.setFocusable(true);
            }
            this.add((Component)this.myLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, JBInsets.emptyInsets(), 0, 0));
        }

        @Override
        public String toString() {
            return this.myLabel.getText();
        }

        private String setup(@NlsContexts.Label String text2, boolean isDisabled, boolean isStrikeout, Color background, @Nullable TextRange highlightRange, boolean disableBeforeHighlight) {
            TreeMap<TextRange, ParameterInfoUIContextEx.Flag> flagsMap = new TreeMap<TextRange, ParameterInfoUIContextEx.Flag>(TEXT_RANGE_COMPARATOR);
            if (highlightRange != null) {
                flagsMap.put(highlightRange, ParameterInfoUIContextEx.Flag.HIGHLIGHT);
            }
            if (isDisabled) {
                flagsMap.put(TextRange.create(0, text2.length()), ParameterInfoUIContextEx.Flag.DISABLE);
            }
            if (isStrikeout) {
                flagsMap.put(TextRange.create(0, text2.length()), ParameterInfoUIContextEx.Flag.STRIKEOUT);
            }
            if (disableBeforeHighlight) {
                flagsMap.put(new TextRange(0, highlightRange == null ? text2.length() : highlightRange.getStartOffset()), ParameterInfoUIContextEx.Flag.DISABLE);
            }
            return this.setup(text2, flagsMap, background);
        }

        private String setup(@NotNull @NlsContexts.Label String text2, @NotNull TreeMap<TextRange, ParameterInfoUIContextEx.Flag> flagsMap, @NotNull Color background) {
            if (text2 == null) {
                OneLineComponent.$$$reportNull$$$0(0);
            }
            if (flagsMap == null) {
                OneLineComponent.$$$reportNull$$$0(1);
            }
            if (background == null) {
                OneLineComponent.$$$reportNull$$$0(2);
            }
            if (flagsMap.isEmpty()) {
                return this.doSetup(text2, background);
            }
            String labelText = this.buildLabelText(text2, flagsMap);
            return this.doSetup(labelText, background);
        }

        private String doSetup(@NotNull @NlsContexts.Label String text2, @NotNull Color background) {
            if (text2 == null) {
                OneLineComponent.$$$reportNull$$$0(3);
            }
            if (background == null) {
                OneLineComponent.$$$reportNull$$$0(4);
            }
            this.myLabel.setBackground(background);
            this.setBackground(background);
            this.myLabel.setForeground(FOREGROUND);
            this.myLabel.setText(XmlStringUtil.wrapInHtml(text2));
            return this.myLabel.getText();
        }

        @Contract(pure=true)
        private String buildLabelText(@NotNull String text2, @NotNull TreeMap<TextRange, ParameterInfoUIContextEx.Flag> flagsMap) {
            if (text2 == null) {
                OneLineComponent.$$$reportNull$$$0(5);
            }
            if (flagsMap == null) {
                OneLineComponent.$$$reportNull$$$0(6);
            }
            StringBuilder labelText = new StringBuilder(text2);
            Int2IntOpenHashMap faultMap = new Int2IntOpenHashMap();
            for (Map.Entry<TextRange, ParameterInfoUIContextEx.Flag> entry : flagsMap.entrySet()) {
                TextRange highlightRange = entry.getKey();
                ParameterInfoUIContextEx.Flag flag = entry.getValue();
                String tagValue = ParameterInfoComponent.getTagValue(flag);
                String tag = ParameterInfoComponent.getOpeningTag(tagValue);
                String endTag = ParameterInfoComponent.getClosingTag(tagValue);
                int startOffset = highlightRange.getStartOffset();
                int endOffset = highlightRange.getEndOffset() + tag.length();
                for (Int2IntMap.Entry entry1 : Int2IntMaps.fastIterable(faultMap)) {
                    if (entry1.getIntKey() > highlightRange.getStartOffset()) continue;
                    startOffset += entry1.getIntValue();
                    endOffset += entry1.getIntValue();
                }
                labelText.insert(startOffset, tag);
                labelText.insert(endOffset, endTag);
                faultMap.put(startOffset, tag.length());
            }
            return labelText.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flagsMap";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "background";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/hint/ParameterInfoComponent$OneLineComponent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setup";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doSetup";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildLabelText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class OneElementComponent
    extends JPanel {
        OneElementComponent() {
            super(new GridBagLayout());
            this.setOpaque(true);
        }

        @Override
        public String toString() {
            boolean highlighted = this.getComponentCount() > 0 && !BACKGROUND.equals(this.getComponent(0).getBackground());
            String text2 = Stream.of(this.getComponents()).map(Object::toString).collect(Collectors.joining());
            return highlighted ? "[" + text2 + "]" : text2;
        }

        private OneLineComponent getOneLineComponent(int index) {
            for (int i = this.getComponentCount(); i <= index; ++i) {
                this.add((Component)new OneLineComponent(), new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 17, 2, JBInsets.emptyInsets(), 0, 0));
            }
            return (OneLineComponent)this.getComponent(index);
        }

        private void trimComponents(int count2) {
            for (int i = this.getComponentCount() - 1; i >= count2; --i) {
                this.remove(i);
            }
        }

        private void setup(@NlsContexts.Label String htmlText, Color background) {
            this.setBackground(background);
            this.getOneLineComponent(0).doSetup(htmlText, background);
            this.trimComponents(1);
        }

        private String setup(@NlsContexts.Label String text2, Function<? super String, String> escapeFunction, int highlightStartOffset, int highlightEndOffset, boolean isDisabled, boolean strikeout, boolean isDisabledBeforeHighlight, Color background) {
            StringBuilder buf = new StringBuilder(text2.length());
            this.setBackground(background);
            String[] lines2 = UIUtil.splitText(text2, this.getFontMetrics(ParameterInfoComponent.this.BOLD_FONT), ApplicationManager.getApplication().isUnitTestMode() ? Integer.MAX_VALUE : ParameterInfoComponent.this.myWidthLimit, ',');
            int lineOffset = 0;
            boolean hasHighlighting = highlightStartOffset >= 0 && highlightEndOffset > highlightStartOffset;
            TextRange highlightingRange = hasHighlighting ? new TextRange(highlightStartOffset, highlightEndOffset) : null;
            for (int i = 0; i < lines2.length; ++i) {
                String line = lines2[i];
                OneLineComponent component2 = this.getOneLineComponent(i);
                TextRange lRange = new TextRange(lineOffset, lineOffset + line.length());
                TextRange hr = highlightingRange == null ? null : lRange.intersection(highlightingRange);
                hr = hr == null ? null : hr.shiftRight(-lineOffset);
                String before2 = this.escapeString(hr == null ? line : line.substring(0, hr.getStartOffset()), escapeFunction);
                String in = hr == null ? "" : this.escapeString(hr.substring(line), escapeFunction);
                String after2 = hr == null ? "" : this.escapeString(line.substring(hr.getEndOffset()), escapeFunction);
                TextRange escapedHighlightingRange = in.isEmpty() ? null : TextRange.create(before2.length(), before2.length() + in.length());
                buf.append(component2.setup(before2 + in + after2, isDisabled, strikeout, background, escapedHighlightingRange, isDisabledBeforeHighlight && (highlightStartOffset < 0 || highlightEndOffset > lineOffset)));
                lineOffset += line.length();
            }
            this.trimComponents(lines2.length);
            return buf.toString();
        }

        @Contract(pure=true)
        private String escapeString(String line, Function<? super String, String> escapeFunction) {
            line = XmlStringUtil.escapeString(line);
            return escapeFunction == null ? line : escapeFunction.fun(line);
        }

        @NlsContexts.Label
        public String setup(ParameterInfoControllerBase.Model result2, String @NlsContexts.Label [] texts, Function<? super String, String> escapeFunction, EnumSet<ParameterInfoUIContextEx.Flag>[] flags, Color background) {
            String paramText;
            @NlsContexts.Label StringBuilder buf = new StringBuilder();
            this.setBackground(background);
            int index = 0;
            int curOffset = 0;
            ArrayList<Integer> startOffsets = new ArrayList<Integer>();
            ArrayList<Integer> endOffsets = new ArrayList<Integer>();
            TreeMap<TextRange, ParameterInfoUIContextEx.Flag> flagsMap = new TreeMap<TextRange, ParameterInfoUIContextEx.Flag>(TEXT_RANGE_COMPARATOR);
            StringBuilder fullLine = new StringBuilder();
            @NlsContexts.Label StringBuilder line = new StringBuilder();
            for (int i = 0; i < texts.length && (paramText = this.escapeString(texts[i], escapeFunction)) != null; ++i) {
                startOffsets.add(fullLine.length());
                fullLine.append(texts[i]);
                endOffsets.add(fullLine.length());
                line.append(texts[i]);
                EnumSet<ParameterInfoUIContextEx.Flag> flag = flags[i];
                if (flag.contains((Object)ParameterInfoUIContextEx.Flag.HIGHLIGHT)) {
                    result2.current = i;
                    flagsMap.put(TextRange.create(curOffset, curOffset + paramText.trim().length()), ParameterInfoUIContextEx.Flag.HIGHLIGHT);
                }
                if (flag.contains((Object)ParameterInfoUIContextEx.Flag.DISABLE)) {
                    flagsMap.put(TextRange.create(curOffset, curOffset + paramText.trim().length()), ParameterInfoUIContextEx.Flag.DISABLE);
                }
                if (flag.contains((Object)ParameterInfoUIContextEx.Flag.STRIKEOUT)) {
                    flagsMap.put(TextRange.create(curOffset, curOffset + paramText.trim().length()), ParameterInfoUIContextEx.Flag.STRIKEOUT);
                }
                curOffset += paramText.length();
                if (line.length() < 50) continue;
                OneLineComponent component2 = this.getOneLineComponent(index);
                buf.append(component2.setup(this.escapeString(line.toString(), escapeFunction), flagsMap, background));
                ++index;
                flagsMap.clear();
                curOffset = 0;
                line = new StringBuilder();
            }
            ParameterInfoControllerBase.SignatureItem item = new ParameterInfoControllerBase.SignatureItem(fullLine.toString(), false, false, startOffsets, endOffsets);
            result2.signatures.add(item);
            OneLineComponent component3 = this.getOneLineComponent(index);
            buf.append(component3.setup(this.escapeString(line.toString(), escapeFunction), flagsMap, background));
            this.trimComponents(index + 1);
            return buf.toString();
        }
    }

    class MyParameterContext
    implements ParameterInfoUIContextEx {
        private final boolean mySingleParameterInfo;
        private int i;
        private Function<? super String, String> myEscapeFunction;
        private final ParameterInfoControllerBase.Model result = new ParameterInfoControllerBase.Model();

        MyParameterContext(boolean singleParameterInfo) {
            this.mySingleParameterInfo = singleParameterInfo;
        }

        @Override
        public String setupUIComponentPresentation(@NlsContexts.Label String text2, int highlightStartOffset, int highlightEndOffset, boolean isDisabled, boolean strikeout, boolean isDisabledBeforeHighlight, Color background) {
            List<String> split2 = StringUtil.split(text2, ",", false);
            StringBuilder plainLine = new StringBuilder();
            ArrayList<Integer> startOffsets = new ArrayList<Integer>();
            ArrayList<Integer> endOffsets = new ArrayList<Integer>();
            TextRange highlightRange = highlightStartOffset >= 0 && highlightEndOffset >= highlightStartOffset ? new TextRange(highlightStartOffset, highlightEndOffset) : null;
            for (int j = 0; j < split2.size(); ++j) {
                String line = split2.get(j);
                int startOffset = plainLine.length();
                startOffsets.add(startOffset);
                plainLine.append(line);
                int endOffset = plainLine.length();
                endOffsets.add(endOffset);
                if (highlightRange == null || !highlightRange.intersects(new TextRange(startOffset, endOffset))) continue;
                this.result.current = j;
            }
            ParameterInfoControllerBase.SignatureItem item = new ParameterInfoControllerBase.SignatureItem(plainLine.toString(), strikeout, isDisabled, startOffsets, endOffsets);
            this.result.signatures.add(item);
            String resultedText = ParameterInfoComponent.this.myPanels[this.i].setup(text2, this.myEscapeFunction, highlightStartOffset, highlightEndOffset, isDisabled, strikeout, isDisabledBeforeHighlight, background);
            ParameterInfoComponent.this.myPanels[this.i].setBorder(this.isLastParameterOwner() || this.isSingleParameterInfo() ? EMPTY_BORDER : BOTTOM_BORDER);
            return resultedText;
        }

        @Override
        public void setupRawUIComponentPresentation(@NlsContexts.Label String htmlText) {
            ParameterInfoControllerBase.RawSignatureItem item = new ParameterInfoControllerBase.RawSignatureItem(htmlText);
            this.result.current = this.getCurrentParameterIndex();
            this.result.signatures.add(item);
            ParameterInfoComponent.this.myPanels[this.i].setup(htmlText, this.getDefaultParameterColor());
            ParameterInfoComponent.this.myPanels[this.i].setBorder(this.isLastParameterOwner() || this.isSingleParameterInfo() ? EMPTY_BORDER : BOTTOM_BORDER);
        }

        @Override
        public String setupUIComponentPresentation(String[] texts, EnumSet<ParameterInfoUIContextEx.Flag>[] flags, Color background) {
            String resultedText = ParameterInfoComponent.this.myPanels[this.i].setup(this.result, texts, this.myEscapeFunction, flags, background);
            ParameterInfoComponent.this.myPanels[this.i].setBorder(this.isLastParameterOwner() || this.isSingleParameterInfo() ? EMPTY_BORDER : BOTTOM_BORDER);
            return resultedText;
        }

        @Override
        public void setEscapeFunction(@Nullable Function<? super String, String> escapeFunction) {
            this.myEscapeFunction = escapeFunction;
        }

        @Override
        public boolean isUIComponentEnabled() {
            return ParameterInfoComponent.this.isEnabled(this.i);
        }

        @Override
        public void setUIComponentEnabled(boolean enabled) {
            ParameterInfoComponent.this.setEnabled(this.i, enabled);
        }

        public boolean isLastParameterOwner() {
            return this.i == ParameterInfoComponent.this.myPanels.length - 1;
        }

        @Override
        public int getCurrentParameterIndex() {
            return ParameterInfoComponent.this.myParameterInfoControllerData.getCurrentParameterIndex();
        }

        @Override
        public PsiElement getParameterOwner() {
            return ParameterInfoComponent.this.myParameterInfoControllerData.getParameterOwner();
        }

        @Override
        public boolean isSingleOverload() {
            return ParameterInfoComponent.this.myPanels.length == 1;
        }

        @Override
        public boolean isSingleParameterInfo() {
            return this.mySingleParameterInfo;
        }

        private boolean isHighlighted() {
            return ParameterInfoComponent.this.myParameterInfoControllerData.getDescriptors()[this.i].equals(ParameterInfoComponent.this.myParameterInfoControllerData.getHighlighted());
        }

        @Override
        public Color getDefaultParameterColor() {
            return this.mySingleParameterInfo || !this.isHighlighted() ? BACKGROUND : HIGHLIGHTED_BACKGROUND;
        }
    }
}

