/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.hint.ExternalParameterInfoChangesProvider;
import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.codeInsight.hint.ParameterInfoControllerData;
import com.intellij.codeInsight.hint.ParameterInfoControllerProvider;
import com.intellij.codeInsight.hint.ParameterInfoTaskRunnerUtil;
import com.intellij.codeInsight.hint.ShowParameterInfoHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.DeleteParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class ParameterInfoControllerBase
extends UserDataHolderBase
implements Disposable {
    protected static final String WHITESPACE = " \t";
    protected final Project myProject;
    @NotNull
    protected final Editor myEditor;
    protected final RangeMarker myLbraceMarker;
    private final CaretListener myEditorCaretListener;
    @NotNull
    protected final ParameterInfoControllerData myParameterInfoControllerData;
    protected final Alarm myAlarm;
    protected static final int DELAY = 200;
    protected boolean mySingleParameterInfo;
    protected boolean myDisposed;
    private static final Key<List<ParameterInfoControllerBase>> ALL_CONTROLLERS_KEY = Key.create("ParameterInfoControllerBase.ALL_CONTROLLERS_KEY");

    public static ParameterInfoControllerBase findControllerAtOffset(Editor editor2, int offset) {
        for (ParameterInfoControllerBase controller : new ArrayList<ParameterInfoControllerBase>(ParameterInfoControllerBase.getAllControllers(editor2))) {
            int lbraceOffset = controller.myLbraceMarker.getStartOffset();
            if (lbraceOffset != offset) continue;
            if (!controller.canBeDisposed()) {
                return controller;
            }
            Disposer.dispose(controller);
        }
        return null;
    }

    static List<ParameterInfoControllerBase> getAllControllers(@NotNull Editor editor2) {
        List array;
        if (editor2 == null) {
            ParameterInfoControllerBase.$$$reportNull$$$0(0);
        }
        if ((array = (List)editor2.getUserData(ALL_CONTROLLERS_KEY)) == null) {
            array = ((UserDataHolderEx)editor2).putUserDataIfAbsent(ALL_CONTROLLERS_KEY, new CopyOnWriteArrayList());
        }
        return array;
    }

    public static boolean existsForEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            ParameterInfoControllerBase.$$$reportNull$$$0(1);
        }
        return !ParameterInfoControllerBase.getAllControllers(editor2).isEmpty();
    }

    public static boolean existsWithVisibleHintForEditor(@NotNull Editor editor2, boolean anyHintType) {
        if (editor2 == null) {
            ParameterInfoControllerBase.$$$reportNull$$$0(2);
        }
        return ParameterInfoControllerBase.getAllControllers(editor2).stream().anyMatch(c -> c.isHintShown(anyHintType));
    }

    public abstract boolean isHintShown(boolean var1);

    public ParameterInfoControllerBase(@NotNull Project project2, @NotNull Editor editor2, int lbraceOffset, Object[] descriptors, Object highlighted, PsiElement parameterOwner, @NotNull ParameterInfoHandler handler, boolean showHint2) {
        if (project2 == null) {
            ParameterInfoControllerBase.$$$reportNull$$$0(3);
        }
        if (editor2 == null) {
            ParameterInfoControllerBase.$$$reportNull$$$0(4);
        }
        if (handler == null) {
            ParameterInfoControllerBase.$$$reportNull$$$0(5);
        }
        this.myAlarm = new Alarm();
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            Logger.getInstance(ParameterInfoControllerBase.class).error("Constructor should be called on EDT");
        }
        this.myProject = project2;
        this.myEditor = editor2;
        this.myParameterInfoControllerData = this.createParameterInfoControllerData(handler);
        this.myParameterInfoControllerData.setDescriptors(descriptors);
        this.myParameterInfoControllerData.setHighlighted(highlighted);
        this.myParameterInfoControllerData.setParameterOwner(parameterOwner);
        this.myLbraceMarker = editor2.getDocument().createRangeMarker(lbraceOffset, lbraceOffset);
        this.mySingleParameterInfo = !showHint2;
        this.myEditorCaretListener = new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!UndoManager.getInstance(ParameterInfoControllerBase.this.myProject).isUndoOrRedoInProgress()) {
                    ParameterInfoControllerBase.this.syncUpdateOnCaretMove();
                    ParameterInfoControllerBase.this.rescheduleUpdate();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/hint/ParameterInfoControllerBase$1", "caretPositionChanged"));
            }
        };
    }

    protected final void registerSelf() {
        List<ParameterInfoControllerBase> allControllers = ParameterInfoControllerBase.getAllControllers(this.myEditor);
        allControllers.add(this);
    }

    protected void setupListeners() {
        this.myEditor.getCaretModel().addCaretListener(this.myEditorCaretListener);
        this.myEditor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ParameterInfoControllerBase.this.rescheduleUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/hint/ParameterInfoControllerBase$2", "documentChanged"));
            }
        }, this);
        MessageBusConnection connection = this.myProject.getMessageBus().connect(this);
        connection.subscribe(ExternalParameterInfoChangesProvider.TOPIC, (e, offset) -> {
            if (e != null && (e != this.myEditor || this.myLbraceMarker.getStartOffset() != offset)) {
                return;
            }
            this.updateWhenAllCommitted();
        });
        EditorUtil.disposeWithEditor((Editor)this.myEditor, (Disposable)this);
        this.myProject.getMessageBus().connect(this).subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

            @Override
            public void enteredDumbMode() {
                ParameterInfoControllerBase.this.updateComponent();
            }

            @Override
            public void exitDumbMode() {
                ParameterInfoControllerBase.this.updateComponent();
            }
        });
    }

    public void setDescriptors(Object[] descriptors) {
        this.myParameterInfoControllerData.setDescriptors(descriptors);
    }

    protected void syncUpdateOnCaretMove() {
        this.myParameterInfoControllerData.getHandler().syncUpdateOnCaretMove(new MyLazyUpdateParameterInfoContext());
    }

    @NotNull
    protected ParameterInfoControllerData createParameterInfoControllerData(@NotNull ParameterInfoHandler<PsiElement, Object> handler) {
        if (handler == null) {
            ParameterInfoControllerBase.$$$reportNull$$$0(6);
        }
        return new ParameterInfoControllerData(handler);
    }

    protected abstract boolean canBeDisposed();

    @Override
    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        this.hideHint();
        this.myParameterInfoControllerData.getHandler().dispose(new MyDeleteParameterInfoContext());
        List<ParameterInfoControllerBase> allControllers = ParameterInfoControllerBase.getAllControllers(this.myEditor);
        allControllers.remove(this);
        this.myEditor.getCaretModel().removeCaretListener(this.myEditorCaretListener);
    }

    public abstract void showHint(boolean var1, boolean var2);

    static boolean hasPrevOrNextParameter(Editor editor2, int lbraceOffset, boolean isNext) {
        ParameterInfoControllerBase controller = ParameterInfoControllerBase.findControllerAtOffset(editor2, lbraceOffset);
        return controller != null && controller.getPrevOrNextParameterOffset(isNext) != -1;
    }

    protected int getCurrentOffset() {
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        CharSequence chars = this.myEditor.getDocument().getCharsSequence();
        return this.myParameterInfoControllerData.getHandler().isWhitespaceSensitive() ? caretOffset : CharArrayUtil.shiftBackward(chars, caretOffset - 1, WHITESPACE) + 1;
    }

    protected void executeFindElementForUpdatingParameterInfo(UpdateParameterInfoContext context2, @NotNull Consumer<? super PsiElement> elementForUpdatingConsumer) {
        if (elementForUpdatingConsumer == null) {
            ParameterInfoControllerBase.$$$reportNull$$$0(7);
        }
        ParameterInfoTaskRunnerUtil.runTask(this.myProject, ReadAction.nonBlocking(() -> this.myParameterInfoControllerData.getHandler().findElementForUpdatingParameterInfo(context2)).withDocumentsCommitted(this.myProject).expireWhen(() -> this.getCurrentOffset() != context2.getOffset()).coalesceBy(this).expireWith(this), elementForUpdatingConsumer, null, this.myEditor);
    }

    protected void rescheduleUpdate() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> this.updateWhenAllCommitted(), 200, ModalityState.stateForComponent(this.myEditor.getComponent()));
    }

    protected void updateWhenAllCommitted() {
        if (!this.myDisposed && !this.myProject.isDisposed()) {
            PsiDocumentManager.getInstance(this.myProject).performLaterWhenAllCommitted(this::updateComponent);
        }
    }

    public abstract void updateComponent();

    protected abstract void moveToParameterAtOffset(int var1);

    protected int getPrevOrNextParameterOffset(boolean isNext) {
        PsiElement argList;
        if (!(this.myParameterInfoControllerData.getHandler() instanceof ParameterInfoHandlerWithTabActionSupport)) {
            return -1;
        }
        ParameterInfoHandlerWithTabActionSupport handler = (ParameterInfoHandlerWithTabActionSupport)this.myParameterInfoControllerData.getHandler();
        IElementType delimiter = handler.getActualParameterDelimiterType();
        boolean noDelimiter = delimiter == TokenType.WHITE_SPACE;
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        CharSequence text2 = this.myEditor.getDocument().getImmutableCharSequence();
        int offset = noDelimiter ? caretOffset : CharArrayUtil.shiftBackward(text2, caretOffset - 1, WHITESPACE) + 1;
        int lbraceOffset = this.myLbraceMarker.getStartOffset();
        PsiFile file2 = PsiDocumentManager.getInstance(this.myProject).getPsiFile(this.myEditor.getDocument());
        PsiElement psiElement = argList = lbraceOffset < offset ? (PsiElement)ParameterInfoControllerBase.findArgumentList(file2, offset, lbraceOffset) : null;
        if (argList == null) {
            return -1;
        }
        PsiElement[] parameters2 = handler.getActualParameters(argList);
        int currentParameterIndex = ParameterInfoControllerBase.getParameterIndex(parameters2, delimiter, offset);
        if (CodeInsightSettings.getInstance().SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION) {
            int prevOrNextParameterIndex;
            if (currentParameterIndex < 0 || currentParameterIndex >= parameters2.length && parameters2.length > 0) {
                return -1;
            }
            if (offset >= argList.getTextRange().getEndOffset()) {
                currentParameterIndex = isNext ? -1 : parameters2.length;
            }
            if ((prevOrNextParameterIndex = currentParameterIndex + (isNext ? 1 : -1)) < 0 || prevOrNextParameterIndex >= parameters2.length) {
                PsiElement parameterOwner = this.myParameterInfoControllerData.getParameterOwner();
                return parameterOwner != null && parameterOwner.isValid() ? parameterOwner.getTextRange().getEndOffset() : -1;
            }
            return ParameterInfoControllerBase.getParameterNavigationOffset(parameters2[prevOrNextParameterIndex], text2);
        }
        int prevOrNextParameterIndex = isNext && currentParameterIndex < parameters2.length - 1 ? currentParameterIndex + 1 : (!isNext && currentParameterIndex > 0 ? currentParameterIndex - 1 : -1);
        return prevOrNextParameterIndex != -1 ? parameters2[prevOrNextParameterIndex].getTextRange().getStartOffset() : -1;
    }

    private static int getParameterIndex(@NotNull PsiElement[] parameters2, @NotNull IElementType delimiter, int offset) {
        if (delimiter == null) {
            ParameterInfoControllerBase.$$$reportNull$$$0(8);
        }
        if (parameters2 == null) {
            ParameterInfoControllerBase.$$$reportNull$$$0(9);
        }
        for (int i = 0; i < parameters2.length; ++i) {
            PsiElement parameter = parameters2[i];
            TextRange textRange = parameter.getTextRange();
            int startOffset = textRange.getStartOffset();
            if (offset < startOffset) {
                if (i == 0) {
                    return 0;
                }
                PsiElement elementInBetween = parameters2[i - 1];
                int currOffset = elementInBetween.getTextRange().getEndOffset();
                while ((elementInBetween = PsiTreeUtil.nextLeaf(elementInBetween)) != null && currOffset < startOffset) {
                    ASTNode node2 = elementInBetween.getNode();
                    if (node2 != null && node2.getElementType() == delimiter) {
                        return offset <= currOffset ? i - 1 : i;
                    }
                    currOffset += elementInBetween.getTextLength();
                }
                return i;
            }
            if (offset > textRange.getEndOffset()) continue;
            return i;
        }
        return Math.max(0, parameters2.length - 1);
    }

    protected static int getParameterNavigationOffset(@NotNull PsiElement parameter, @NotNull CharSequence text2) {
        if (parameter == null) {
            ParameterInfoControllerBase.$$$reportNull$$$0(10);
        }
        if (text2 == null) {
            ParameterInfoControllerBase.$$$reportNull$$$0(11);
        }
        int rangeStart = parameter.getTextRange().getStartOffset();
        int rangeEnd = parameter.getTextRange().getEndOffset();
        int offset = CharArrayUtil.shiftBackward(text2, rangeEnd - 1, WHITESPACE) + 1;
        return offset > rangeStart ? offset : CharArrayUtil.shiftForward(text2, rangeEnd, WHITESPACE);
    }

    @Nullable
    public static <E extends PsiElement> E findArgumentList(PsiFile file2, int offset, int lbraceOffset) {
        ParameterInfoHandler[] handlers2;
        if (file2 == null) {
            return null;
        }
        for (ParameterInfoHandler handler : handlers2 = ShowParameterInfoHandler.getHandlers(file2.getProject(), PsiUtilCore.getLanguageAtOffset(file2, offset), file2.getViewProvider().getBaseLanguage())) {
            ParameterInfoHandlerWithTabActionSupport parameterInfoHandler2;
            Object e;
            if (!(handler instanceof ParameterInfoHandlerWithTabActionSupport) || (e = ParameterInfoUtils.findArgumentList(file2, offset, lbraceOffset, parameterInfoHandler2 = (ParameterInfoHandlerWithTabActionSupport)handler)) == null) continue;
            return e;
        }
        return null;
    }

    public Object[] getObjects() {
        return this.myParameterInfoControllerData.getDescriptors();
    }

    public Object getHighlighted() {
        return this.myParameterInfoControllerData.getHighlighted();
    }

    public abstract void setPreservedOnHintHidden(boolean var1);

    public abstract boolean isPreservedOnHintHidden();

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public static void waitForDelayedActions(@NotNull Editor editor2, long timeout, @NotNull TimeUnit timeUnit) throws TimeoutException {
        void unit;
        if (editor2 == null) {
            ParameterInfoControllerBase.$$$reportNull$$$0(12);
        }
        if (timeUnit == null) {
            ParameterInfoControllerBase.$$$reportNull$$$0(13);
        }
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < deadline) {
            List<ParameterInfoControllerBase> controllers = ParameterInfoControllerBase.getAllControllers(editor2);
            boolean hasPendingRequests = false;
            for (ParameterInfoControllerBase controller : controllers) {
                if (controller.myAlarm.isEmpty()) continue;
                hasPendingRequests = true;
                break;
            }
            if (hasPendingRequests) {
                LockSupport.parkNanos(10000000L);
                UIUtil.dispatchAllInvocationEvents();
                continue;
            }
            return;
        }
        throw new TimeoutException();
    }

    public static boolean areParameterTemplatesEnabledOnCompletion() {
        return Registry.is("java.completion.argument.live.template") && !CodeInsightSettings.getInstance().SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION;
    }

    @NotNull
    public static ParameterInfoControllerBase createParameterInfoController(@NotNull Project project2, @NotNull Editor editor2, int lbraceOffset, Object[] descriptors, Object highlighted, PsiElement parameterOwner, @NotNull ParameterInfoHandler handler, boolean showHint2, boolean requestFocus) {
        if (project2 == null) {
            ParameterInfoControllerBase.$$$reportNull$$$0(14);
        }
        if (editor2 == null) {
            ParameterInfoControllerBase.$$$reportNull$$$0(15);
        }
        if (handler == null) {
            ParameterInfoControllerBase.$$$reportNull$$$0(16);
        }
        for (ParameterInfoControllerProvider provider2 : ParameterInfoControllerProvider.EP_NAME.getExtensions()) {
            ParameterInfoControllerBase controller = provider2.create(project2, editor2, lbraceOffset, descriptors, highlighted, parameterOwner, handler, showHint2, requestFocus);
            if (controller == null) continue;
            ParameterInfoControllerBase parameterInfoControllerBase = controller;
            if (parameterInfoControllerBase == null) {
                ParameterInfoControllerBase.$$$reportNull$$$0(17);
            }
            return parameterInfoControllerBase;
        }
        return new ParameterInfoController(project2, editor2, lbraceOffset, descriptors, highlighted, parameterOwner, handler, showHint2, requestFocus);
    }

    protected abstract void hideHint();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementForUpdatingConsumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delimiter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/ParameterInfoControllerBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/ParameterInfoControllerBase";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterInfoController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllControllers";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "existsForEditor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "existsWithVisibleHintForEditor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createParameterInfoControllerData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeFindElementForUpdatingParameterInfo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParameterIndex";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getParameterNavigationOffset";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "waitForDelayedActions";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createParameterInfoController";
                break;
            }
            case 17: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDeleteParameterInfoContext
    implements DeleteParameterInfoContext {
        private MyDeleteParameterInfoContext() {
        }

        @Override
        public PsiElement getParameterOwner() {
            return ParameterInfoControllerBase.this.myParameterInfoControllerData.getParameterOwner();
        }

        @Override
        public Editor getEditor() {
            return ParameterInfoControllerBase.this.myEditor;
        }

        @Override
        public UserDataHolderEx getCustomContext() {
            return ParameterInfoControllerBase.this;
        }
    }

    public static class Model {
        public final List<SignatureItemModel> signatures = new ArrayList<SignatureItemModel>();
        public int current = -1;
        public int highlightedSignature = -1;
        public TextRange range;
        public Editor editor;
        public Project project;
    }

    public static class SignatureItem
    implements SignatureItemModel {
        public final String text;
        public final boolean deprecated;
        public final boolean disabled;
        public final List<Integer> startOffsets;
        public final List<Integer> endOffsets;

        public SignatureItem(String text2, boolean deprecated, boolean disabled, List<Integer> startOffsets, List<Integer> endOffsets) {
            this.text = text2;
            this.deprecated = deprecated;
            this.disabled = disabled;
            this.startOffsets = startOffsets;
            this.endOffsets = endOffsets;
        }
    }

    public static class RawSignatureItem
    implements SignatureItemModel {
        public final String htmlText;

        public RawSignatureItem(String htmlText) {
            this.htmlText = htmlText;
        }
    }

    public static interface SignatureItemModel {
    }

    private final class MyLazyUpdateParameterInfoContext
    extends UpdateParameterInfoContextBase {
        private PsiFile myLazyFile;

        private MyLazyUpdateParameterInfoContext() {
            super(ParameterInfoControllerBase.this.myEditor.getCaretModel().getOffset(), null);
        }

        @Override
        public PsiFile getFile() {
            if (this.myLazyFile == null) {
                this.myLazyFile = PsiUtilBase.getPsiFileInEditor(ParameterInfoControllerBase.this.myEditor, ParameterInfoControllerBase.this.myProject);
            }
            return this.myLazyFile;
        }
    }

    protected class UpdateParameterInfoContextBase
    implements UpdateParameterInfoContext {
        protected final int myOffset;
        @Nullable
        protected final PsiFile myFile;
        private final boolean[] enabled;

        public UpdateParameterInfoContextBase(@Nullable int offset, PsiFile file2) {
            this.myOffset = offset;
            this.myFile = file2;
            this.enabled = new boolean[ParameterInfoControllerBase.this.myParameterInfoControllerData.getDescriptors().length];
            for (int i = 0; i < this.enabled.length; ++i) {
                this.enabled[i] = ParameterInfoControllerBase.this.myParameterInfoControllerData.isDescriptorEnabled(i);
            }
        }

        @Override
        public int getParameterListStart() {
            return ParameterInfoControllerBase.this.myLbraceMarker.getStartOffset();
        }

        @Override
        public int getOffset() {
            return this.myOffset;
        }

        @Override
        public Project getProject() {
            return ParameterInfoControllerBase.this.myProject;
        }

        @Override
        @Nullable
        public PsiFile getFile() {
            return this.myFile;
        }

        @Override
        @NotNull
        public Editor getEditor() {
            Editor editor2 = ParameterInfoControllerBase.this.myEditor;
            if (editor2 == null) {
                UpdateParameterInfoContextBase.$$$reportNull$$$0(0);
            }
            return editor2;
        }

        @Override
        public void removeHint() {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!ParameterInfoControllerBase.this.isHintShown(true)) {
                    return;
                }
                ParameterInfoControllerBase.this.hideHint();
                if (!this.isPreservedOnHintHidden()) {
                    Disposer.dispose(ParameterInfoControllerBase.this);
                }
            });
        }

        @Override
        public void setParameterOwner(PsiElement o) {
            ParameterInfoControllerBase.this.myParameterInfoControllerData.setParameterOwner(o);
        }

        @Override
        public PsiElement getParameterOwner() {
            return ParameterInfoControllerBase.this.myParameterInfoControllerData.getParameterOwner();
        }

        @Override
        public void setHighlightedParameter(Object method2) {
            ParameterInfoControllerBase.this.myParameterInfoControllerData.setHighlighted(method2);
        }

        @Override
        public Object getHighlightedParameter() {
            return ParameterInfoControllerBase.this.myParameterInfoControllerData.getHighlighted();
        }

        @Override
        public void setCurrentParameter(int index) {
            ParameterInfoControllerBase.this.myParameterInfoControllerData.setCurrentParameterIndex(index);
        }

        @Override
        public boolean isUIComponentEnabled(int index) {
            return this.enabled[index];
        }

        @Override
        public void setUIComponentEnabled(int index, boolean enabled) {
            this.enabled[index] = enabled;
        }

        @Override
        public Object[] getObjectsToView() {
            return ParameterInfoControllerBase.this.myParameterInfoControllerData.getDescriptors();
        }

        @Override
        public boolean isPreservedOnHintHidden() {
            return ParameterInfoControllerBase.this.isPreservedOnHintHidden();
        }

        @Override
        public void setPreservedOnHintHidden(boolean value) {
            ParameterInfoControllerBase.this.setPreservedOnHintHidden(value);
        }

        @Override
        public boolean isInnermostContext() {
            PsiElement ourOwner = this.getParameterOwner();
            if (ourOwner == null || !ourOwner.isValid()) {
                return false;
            }
            TextRange ourRange = ourOwner.getTextRange();
            if (ourRange == null) {
                return false;
            }
            List<ParameterInfoControllerBase> allControllers = ParameterInfoControllerBase.getAllControllers(ParameterInfoControllerBase.this.myEditor);
            for (ParameterInfoControllerBase controller : allControllers) {
                TextRange range;
                PsiElement parameterOwner;
                if (controller == ParameterInfoControllerBase.this || (parameterOwner = controller.myParameterInfoControllerData.getParameterOwner()) == null || !parameterOwner.isValid() || (range = parameterOwner.getTextRange()) == null || !range.contains(this.myOffset) || !ourRange.contains(range)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isSingleParameterInfo() {
            return ParameterInfoControllerBase.this.mySingleParameterInfo;
        }

        @Override
        public UserDataHolderEx getCustomContext() {
            return ParameterInfoControllerBase.this;
        }

        public void applyUIChanges() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            int len = ParameterInfoControllerBase.this.getObjects().length;
            for (int index = 0; index < len; ++index) {
                boolean enabled = this.isUIComponentEnabled(index);
                if (enabled == ParameterInfoControllerBase.this.myParameterInfoControllerData.isDescriptorEnabled(index)) continue;
                ParameterInfoControllerBase.this.myParameterInfoControllerData.setDescriptorEnabled(index, enabled);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/ParameterInfoControllerBase$UpdateParameterInfoContextBase", "getEditor"));
        }
    }
}

