/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.settings.InlayHintsConfigurable;
import com.intellij.codeInsight.hints.settings.InlayProviderSettingsModel;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/codeInsight/hints/ConfigureInlayHintsProviderAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "providerKey", "Lcom/intellij/codeInsight/hints/SettingsKey;", "(Lcom/intellij/codeInsight/hints/SettingsKey;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.lang.impl"})
public final class ConfigureInlayHintsProviderAction
extends AnAction {
    private final SettingsKey<?> providerKey;

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"e.getData(PSI_FILE) ?: return");
        PsiFile file2 = psiFile;
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"file.language");
        InlayHintsConfigurable.Companion.showSettingsDialogForLanguage(project2, language, new Predicate(this){
            final /* synthetic */ ConfigureInlayHintsProviderAction this$0;

            public final boolean test(@NotNull InlayProviderSettingsModel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getId(), (Object)ConfigureInlayHintsProviderAction.access$getProviderKey$p(this.this$0).getId());
            }
            {
                this.this$0 = configureInlayHintsProviderAction;
            }
        });
    }

    public ConfigureInlayHintsProviderAction(@NotNull SettingsKey<?> providerKey) {
        Intrinsics.checkNotNullParameter(providerKey, (String)"providerKey");
        super(CodeInsightBundle.messagePointer("action.configure.inlay.hints.provider.text", new Object[0]));
        this.providerKey = providerKey;
    }

    public static final /* synthetic */ SettingsKey access$getProviderKey$p(ConfigureInlayHintsProviderAction $this) {
        return $this.providerKey;
    }
}

