/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.ConfigureInlayHintsProviderAction;
import com.intellij.codeInsight.hints.ConstrainedPresentation;
import com.intellij.codeInsight.hints.DisableInlayHintsProviderAction;
import com.intellij.codeInsight.hints.DisableInlayHintsProviderCaseAction;
import com.intellij.codeInsight.hints.InlayPresentationFactory;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.RootInlayPresentation;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.JBIterable;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J^\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u001d\u0010\b\u001a\u0019\u0012\u0015\u0012\u00130\n\u00a2\u0006\u000e\b\u000b\u0012\n\b\f\u0012\u0006\b\n0\r8\u000e0\t2\u0006\u0010\u000f\u001a\u00020\n2\u001d\u0010\u0010\u001a\u0019\u0012\u0015\u0012\u00130\n\u00a2\u0006\u000e\b\u000b\u0012\n\b\f\u0012\u0006\b\n0\r8\u000e0\tJ7\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u001d\u0010\b\u001a\u0019\u0012\u0015\u0012\u00130\n\u00a2\u0006\u000e\b\u000b\u0012\n\b\f\u0012\u0006\b\n0\r8\u000e0\tJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u00b4\u0001\u0010\u0018\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u001a0\u0019j\b\u0012\u0004\u0012\u0002H\u001a`\u001b0\u0004\"\b\b\u0000\u0010\u001a*\u00020\u00012 \u0010\u001c\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u001a0\u0019j\b\u0012\u0004\u0012\u0002H\u001a`\u001b0\u00042 \u0010\u001d\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u001a0\u0019j\b\u0012\u0004\u0012\u0002H\u001a`\u001b0\u000424\u0010\u001e\u001a0\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u001a0\u00190\u001fj\u001c\u0012\u0018\u0012\u0016\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u001a0\u0019j\b\u0012\u0004\u0012\u0002H\u001a`\u001b` 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J8\u0010%\u001a\u00020\u0017\"\b\b\u0000\u0010&*\u00020\u0001*\b\u0012\u0004\u0012\u0002H&0'2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002\u00a8\u0006)"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsUtils;", "", "()V", "getDefaultInlayHintsProviderCasePopupActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "providerKey", "Lcom/intellij/codeInsight/hints/SettingsKey;", "providerName", "Ljava/util/function/Supplier;", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "caseId", "caseName", "getDefaultInlayHintsProviderPopupActions", "getTextRangeWithoutLeadingCommentsAndWhitespaces", "Lcom/intellij/openapi/util/TextRange;", "element", "Lcom/intellij/psi/PsiElement;", "isFirstInLine", "", "produceUpdatedRootList", "Lcom/intellij/codeInsight/hints/ConstrainedPresentation;", "Constraint", "Lcom/intellij/codeInsight/hints/ConstrPresent;", "new", "old", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "editor", "Lcom/intellij/openapi/editor/Editor;", "factory", "Lcom/intellij/codeInsight/hints/InlayPresentationFactory;", "updateIfSame", "Content", "Lcom/intellij/codeInsight/hints/presentation/RootInlayPresentation;", "newPresentation", "intellij.platform.lang.impl"})
public final class InlayHintsUtils {
    @NotNull
    public static final InlayHintsUtils INSTANCE;

    @NotNull
    public final List<AnAction> getDefaultInlayHintsProviderPopupActions(@NotNull SettingsKey<?> providerKey, @NotNull Supplier<String> providerName) {
        Intrinsics.checkNotNullParameter(providerKey, (String)"providerKey");
        Intrinsics.checkNotNullParameter(providerName, (String)"providerName");
        return CollectionsKt.listOf((Object[])new AnAction[]{new DisableInlayHintsProviderAction(providerKey, providerName, false), new ConfigureInlayHintsProviderAction(providerKey)});
    }

    @NotNull
    public final List<AnAction> getDefaultInlayHintsProviderCasePopupActions(@NotNull SettingsKey<?> providerKey, @NotNull Supplier<String> providerName, @NotNull String caseId, @NotNull Supplier<String> caseName) {
        Intrinsics.checkNotNullParameter(providerKey, (String)"providerKey");
        Intrinsics.checkNotNullParameter(providerName, (String)"providerName");
        Intrinsics.checkNotNullParameter((Object)caseId, (String)"caseId");
        Intrinsics.checkNotNullParameter(caseName, (String)"caseName");
        return CollectionsKt.listOf((Object[])new AnAction[]{new DisableInlayHintsProviderCaseAction(providerKey, providerName, caseId, caseName), new DisableInlayHintsProviderAction(providerKey, providerName, true), new ConfigureInlayHintsProviderAction(providerKey)});
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <Constraint> List<ConstrainedPresentation<?, Constraint>> produceUpdatedRootList(@NotNull List<? extends ConstrainedPresentation<?, Constraint>> list2, @NotNull List<? extends ConstrainedPresentation<?, Constraint>> old, @NotNull Comparator<ConstrainedPresentation<?, Constraint>> comparator2, @NotNull Editor editor2, @NotNull InlayPresentationFactory factory2) {
        Intrinsics.checkNotNullParameter(list2, (String)"new");
        Intrinsics.checkNotNullParameter(old, (String)"old");
        Intrinsics.checkNotNullParameter(comparator2, (String)"comparator");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        List updatedPresentations = new SmartList();
        int oldSize = old.size();
        int newSize = list2.size();
        int oldIndex = 0;
        int newIndex = 0;
        while (true) {
            ConstrainedPresentation<?, Constraint> newEl = list2.get(newIndex);
            ConstrainedPresentation<?, Constraint> oldEl = old.get(oldIndex);
            int value = comparator2.compare(newEl, oldEl);
            if (value > 0) {
                if (++oldIndex != oldSize) continue;
                break;
            }
            if (value < 0) {
                updatedPresentations.add(newEl);
                if (++newIndex != newSize) continue;
                break;
            }
            RootInlayPresentation<?> oldRoot = oldEl.getRoot();
            RootInlayPresentation<?> newRoot = newEl.getRoot();
            if (Intrinsics.areEqual(newRoot.getKey(), oldRoot.getKey())) {
                this.updateIfSame(oldRoot, newRoot, editor2, factory2);
                updatedPresentations.add(oldEl);
            } else {
                updatedPresentations.add(newEl);
            }
            if (++newIndex == newSize || ++oldIndex == oldSize) break;
        }
        int newEl = newIndex;
        int n = newSize;
        while (newEl < n) {
            void i;
            updatedPresentations.add(list2.get((int)i));
            ++i;
        }
        return updatedPresentations;
    }

    private final <Content> boolean updateIfSame(RootInlayPresentation<Content> $this$updateIfSame, RootInlayPresentation<?> newPresentation, Editor editor2, InlayPresentationFactory factory2) {
        if (Intrinsics.areEqual($this$updateIfSame.getKey(), newPresentation.getKey()) ^ true) {
            return false;
        }
        Object obj = newPresentation.getContent();
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type Content");
        }
        return $this$updateIfSame.update(obj, editor2, factory2);
    }

    @NotNull
    public final TextRange getTextRangeWithoutLeadingCommentsAndWhitespaces(@NotNull PsiElement element2) {
        PsiElement psiElement;
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            JBIterable<PsiElement> jBIterable = SyntaxTraverser.psiApi().children(element2);
            Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"SyntaxTraverser.psiApi().children(element)");
            Iterable $this$firstOrNull$iv = jBIterable;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(!(it instanceof PsiComment) && !(it instanceof PsiWhiteSpace))) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        if ((psiElement = (PsiElement)v1) == null) {
            psiElement = element2;
        }
        PsiElement start2 = psiElement;
        TextRange textRange = TextRange.create(UtilsKt.getStartOffset(start2), UtilsKt.getEndOffset(element2));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"TextRange.create(start.s\u2026ffset, element.endOffset)");
        return textRange;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isFirstInLine(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement prevSibling = element2.getPrevSibling();
        if (prevSibling instanceof PsiWhiteSpace) {
            if (prevSibling.textContains('\n')) return true;
            TextRange textRange = prevSibling.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"prevSibling.getTextRange()");
            if (textRange.getStartOffset() == 0) return true;
        }
        TextRange textRange = element2.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange");
        if (textRange.getStartOffset() != 0) return false;
        return true;
    }

    private InlayHintsUtils() {
    }

    static {
        InlayHintsUtils inlayHintsUtils;
        INSTANCE = inlayHintsUtils = new InlayHintsUtils();
    }
}

