/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.settings;

import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettingsKt;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.JdomKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ParameterNameHintsSettings", storages={@Storage(value="parameter.hints.xml")}, category=SettingsCategory.CODE)
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0007\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012J\u0015\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u001b\u001a\u00020\u0002H\u0016J\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u001e\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u0007H\u0002J\u0016\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0016J\u0016\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u001d\u0010%\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00062\b\u0010&\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010'J\u001e\u0010(\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007H\u0002R6\u0010\u0004\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005j\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00060\nj\b\u0012\u0004\u0012\u00020\u0006`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u000e\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005j\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "()V", "addedPatterns", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "disabledLanguages", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "options", "", "removedPatterns", "addIgnorePattern", "", "language", "Lcom/intellij/lang/Language;", "pattern", "getAddedPatterns", "getExcludeListDiff", "Lcom/intellij/codeInsight/hints/settings/Diff;", "getOption", "optionId", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getRemovedPatterns", "getState", "isEnabledForLanguage", "loadState", "state", "setAddedPatterns", "added", "setExcludeListDiff", "diff", "setIsEnabledForLanguage", "enabled", "setOption", "value", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "setRemovedPatterns", "removed", "Companion", "intellij.platform.lang"})
public final class ParameterNameHintsSettings
implements PersistentStateComponent<Element> {
    private final HashMap<String, Set<String>> removedPatterns = new HashMap();
    private final HashMap<String, Set<String>> addedPatterns = new HashMap();
    private final HashMap<String, Boolean> options = new HashMap();
    private final HashSet<String> disabledLanguages = new HashSet();
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void addIgnorePattern(@NotNull Language language, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Set<String> patternsBefore = this.getAddedPatterns(language);
        this.setAddedPatterns(language, SetsKt.plus(patternsBefore, (Object)pattern));
    }

    @NotNull
    public final Diff getExcludeListDiff(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Set<String> added = this.getAddedPatterns(language);
        Set<String> removed = this.getRemovedPatterns(language);
        return new Diff(added, removed);
    }

    public final void setExcludeListDiff(@NotNull Language language, @NotNull Diff diff) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        this.setAddedPatterns(language, diff.getAdded());
        this.setRemovedPatterns(language, diff.getRemoved());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Element getState() {
        Object it;
        Object $this$forEach$iv;
        Element root = new Element("settings");
        Map map2 = this.removedPatterns;
        if (!map2.isEmpty() || !(map2 = (Map)this.addedPatterns).isEmpty()) {
            Element blacklists = new Element("blacklists");
            root.addContent(blacklists);
            Set<String> set2 = this.removedPatterns.keySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"removedPatterns.keys");
            Set<String> set3 = this.addedPatterns.keySet();
            Intrinsics.checkNotNullExpressionValue(set3, (String)"addedPatterns.keys");
            Set allLanguages = SetsKt.plus(set2, (Iterable)set3);
            $this$forEach$iv = allLanguages;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                void $this$mapTo$iv$iv;
                Element element2;
                Collection collection;
                void $this$mapTo$iv$iv2;
                Element element3;
                Set set4;
                Set removed;
                Object element$iv = iterator.next();
                it = (String)element$iv;
                boolean bl5 = false;
                Set set5 = this.removedPatterns.get(it);
                if (set5 == null) {
                    set5 = removed = SetsKt.emptySet();
                }
                if ((set4 = this.addedPatterns.get(it)) == null) {
                    set4 = SetsKt.emptySet();
                }
                Set added = set4;
                Element $this$apply = element3 = new Element("blacklist");
                boolean bl2 = false;
                $this$apply.setAttribute("language", (String)it);
                Iterable $this$map$iv = removed;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it2;
                    String string2 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    element2 = ParameterNameHintsSettingsKt.access$toPatternElement((String)it2, "removed");
                    collection.add(element2);
                }
                List removedElements = (List)destination$iv$iv;
                Iterable $this$map$iv2 = added;
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    String bl3 = (String)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl4 = false;
                    element2 = ParameterNameHintsSettingsKt.access$toPatternElement((String)it3, "added");
                    collection.add(element2);
                }
                List addedElements = (List)destination$iv$iv2;
                $this$apply.addContent((Collection)CollectionsKt.plus((Collection)addedElements, (Iterable)removedElements));
                Element languageBlacklist = element3;
                blacklists.addContent(languageBlacklist);
            }
        }
        Object $this$forEach$iv2 = this.options;
        boolean $i$f$forEach2 = false;
        $this$forEach$iv = $this$forEach$iv2.entrySet().iterator();
        while ($this$forEach$iv.hasNext()) {
            void id2;
            Map.Entry element$iv;
            Map.Entry $dstr$id$value = element$iv = $this$forEach$iv.next();
            boolean bl = false;
            it = $dstr$id$value;
            String bl5 = (String)it.getKey();
            it = $dstr$id$value;
            boolean value = (Boolean)it.getValue();
            Element element4 = new Element("option");
            element4.setAttribute("id", (String)id2);
            element4.setAttribute("value", String.valueOf(value));
            root.addContent(element4);
        }
        $this$forEach$iv2 = this.disabledLanguages;
        if (!$this$forEach$iv2.isEmpty()) {
            Collection<Element> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Element disabledLanguagesElement = new Element("disabledLanguages");
            Iterable $i$f$forEach2 = this.disabledLanguages;
            Element element5 = disabledLanguagesElement;
            boolean $i$f$map = false;
            void element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                String value = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Element element6 = new Element("language");
                element6.setAttribute("id", (String)it4);
                Element element7 = element6;
                collection.add(element7);
            }
            collection = (List)destination$iv$iv;
            element5.addContent(collection);
            root.addContent(disabledLanguagesElement);
        }
        return root;
    }

    public final void setIsEnabledForLanguage(boolean enabled, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (!enabled) {
            this.disabledLanguages.add(language.getID());
        } else {
            this.disabledLanguages.remove(language.getID());
        }
    }

    public final boolean isEnabledForLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return !this.disabledLanguages.contains(language.getID());
    }

    @Override
    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.addedPatterns.clear();
        this.removedPatterns.clear();
        this.options.clear();
        this.disabledLanguages.clear();
        Object object = state.getChild("blacklists");
        if (object == null || (object = ((Element)object).getChildren("blacklist")) == null) {
            object = CollectionsKt.emptyList();
        }
        List<Element> allBlacklistElements = object;
        Iterable $this$forEach$iv = allBlacklistElements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String language;
            Element blacklistElement = (Element)element$iv;
            boolean bl = false;
            Element element2 = blacklistElement;
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"blacklistElement");
            if (ParameterNameHintsSettingsKt.access$attributeValue(element2, "language") == null) {
                continue;
            }
            Set added = ParameterNameHintsSettingsKt.access$extractPatterns(blacklistElement, "added");
            Map map2 = this.addedPatterns;
            Set set2 = this.addedPatterns.get(language);
            if (set2 == null || (set2 = SetsKt.plus((Set)set2, (Iterable)added)) == null) {
                set2 = added;
            }
            map2.put(language, set2);
            Set removed = ParameterNameHintsSettingsKt.access$extractPatterns(blacklistElement, "removed");
            Map map3 = this.removedPatterns;
            Set set3 = this.removedPatterns.get(language);
            if (set3 == null || (set3 = SetsKt.plus((Set)set3, (Iterable)removed)) == null) {
                set3 = removed;
            }
            map3.put(language, set3);
        }
        List<Element> list2 = state.getChildren("option");
        Intrinsics.checkNotNullExpressionValue(list2, (String)"state.getChildren(\"option\")");
        $this$forEach$iv = list2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            String id2 = it.getAttributeValue("id");
            Map map4 = this.options;
            String string2 = id2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id");
            Element element3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"it");
            map4.put(string2, JdomKt.getAttributeBooleanValue(element3, "value"));
        }
        Element element4 = state.getChild("disabledLanguages");
        if (element4 != null) {
            Element element5;
            Element $this$apply = element5 = element4;
            boolean bl = false;
            List<Element> list3 = $this$apply.getChildren("language");
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getChildren(XmlTagHelper.DISABLED_LANGUAGE_ITEM)");
            Iterable $this$forEach$iv2 = list3;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String languageId;
                Element it = (Element)element$iv;
                boolean bl2 = false;
                Element element6 = it;
                Intrinsics.checkNotNullExpressionValue((Object)element6, (String)"it");
                if (ParameterNameHintsSettingsKt.access$attributeValue(element6, "id") == null) {
                    continue;
                }
                this.disabledLanguages.add(languageId);
            }
        }
    }

    @Nullable
    public final Boolean getOption(@NotNull String optionId) {
        Intrinsics.checkNotNullParameter((Object)optionId, (String)"optionId");
        return this.options.get(optionId);
    }

    public final void setOption(@NotNull String optionId, @Nullable Boolean value) {
        Intrinsics.checkNotNullParameter((Object)optionId, (String)"optionId");
        if (value == null) {
            this.options.remove(optionId);
        } else {
            ((Map)this.options).put(optionId, value);
        }
    }

    private final Set<String> getAddedPatterns(Language language) {
        String string2 = language.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"language.displayName");
        String key = string2;
        Set set2 = this.addedPatterns.get(key);
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        return set2;
    }

    private final Set<String> getRemovedPatterns(Language language) {
        String string2 = language.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"language.displayName");
        String key = string2;
        Set set2 = this.removedPatterns.get(key);
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        return set2;
    }

    private final void setRemovedPatterns(Language language, Set<String> removed) {
        String string2 = language.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"language.displayName");
        String key = string2;
        ((Map)this.removedPatterns).put(key, removed);
    }

    private final void setAddedPatterns(Language language, Set<String> added) {
        String string2 = language.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"language.displayName");
        String key = string2;
        ((Map)this.addedPatterns).put(key, added);
    }

    @JvmStatic
    @NotNull
    public static final ParameterNameHintsSettings getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings$Companion;", "", "()V", "getInstance", "Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "intellij.platform.lang"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ParameterNameHintsSettings getInstance() {
            ParameterNameHintsSettings parameterNameHintsSettings = ApplicationManager.getApplication().getService(ParameterNameHintsSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)parameterNameHintsSettings, (String)"ApplicationManager.getAp\u2026intsSettings::class.java)");
            return parameterNameHintsSettings;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

