/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionGroup;
import com.intellij.codeInsight.intention.impl.IntentionsOrderProvider;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultIntentionsOrderProvider
implements IntentionsOrderProvider {
    @Override
    @NotNull
    public List<IntentionActionWithTextCaching> getSortedIntentions(@NotNull CachedIntentions context2, @NotNull List<? extends IntentionActionWithTextCaching> intentions) {
        if (context2 == null) {
            DefaultIntentionsOrderProvider.$$$reportNull$$$0(0);
        }
        if (intentions == null) {
            DefaultIntentionsOrderProvider.$$$reportNull$$$0(1);
        }
        List<IntentionActionWithTextCaching> list2 = ContainerUtil.sorted(intentions, (o1, o2) -> {
            int weight2;
            int weight1 = DefaultIntentionsOrderProvider.getWeight(context2, o1);
            if (weight1 != (weight2 = DefaultIntentionsOrderProvider.getWeight(context2, o2))) {
                return weight2 - weight1;
            }
            return o1.compareTo((IntentionActionWithTextCaching)o2);
        });
        if (list2 == null) {
            DefaultIntentionsOrderProvider.$$$reportNull$$$0(2);
        }
        return list2;
    }

    public static int getPriorityWeight(@NotNull IntentionActionWithTextCaching action2) {
        IntentionAction nonDelegatedAction;
        if (action2 == null) {
            DefaultIntentionsOrderProvider.$$$reportNull$$$0(3);
        }
        PriorityAction.Priority priority = (nonDelegatedAction = DefaultIntentionsOrderProvider.findNonDelegatedAction(action2.getAction())) instanceof PriorityAction ? ((PriorityAction)((Object)nonDelegatedAction)).getPriority() : null;
        return DefaultIntentionsOrderProvider.getPriorityWeight(priority);
    }

    public static int getWeight(@NotNull CachedIntentions context2, @NotNull IntentionActionWithTextCaching action2) {
        if (context2 == null) {
            DefaultIntentionsOrderProvider.$$$reportNull$$$0(4);
        }
        if (action2 == null) {
            DefaultIntentionsOrderProvider.$$$reportNull$$$0(5);
        }
        int group = context2.getGroup(action2).getPriority();
        IntentionAction nonDelegatedAction = DefaultIntentionsOrderProvider.findNonDelegatedAction(action2.getAction());
        if (nonDelegatedAction instanceof PriorityAction) {
            return group + DefaultIntentionsOrderProvider.getPriorityWeight(((PriorityAction)((Object)nonDelegatedAction)).getPriority());
        }
        if (nonDelegatedAction instanceof SuppressIntentionActionFromFix && ((SuppressIntentionActionFromFix)nonDelegatedAction).isShouldBeAppliedToInjectionHost() == ThreeState.NO) {
            return group - 1;
        }
        return group;
    }

    private static IntentionAction findNonDelegatedAction(IntentionAction action2) {
        while (action2 instanceof IntentionActionDelegate && !(action2 instanceof PriorityAction)) {
            action2 = ((IntentionActionDelegate)((Object)action2)).getDelegate();
        }
        return action2;
    }

    public static int getPriorityWeight(@Nullable PriorityAction.Priority priority) {
        if (priority == null) {
            return 0;
        }
        switch (priority) {
            case TOP: {
                return 20;
            }
            case HIGH: {
                return 3;
            }
            case LOW: {
                return -3;
            }
            case ERROR_FIX_LESS_IMPORTANT_THAN_INSPECTION_FIX: {
                return IntentionGroup.INSPECTION.getPriority() - IntentionGroup.ERROR.getPriority() - 1;
            }
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/DefaultIntentionsOrderProvider";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/DefaultIntentionsOrderProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedIntentions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSortedIntentions";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPriorityWeight";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getWeight";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

