/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionListStep;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.ClickListener;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileLevelIntentionComponent
extends EditorNotificationPanel {
    public FileLevelIntentionComponent(@NlsContexts.Label String description, @NotNull HighlightSeverity severity, @Nullable GutterMark gutterMark, final @Nullable List<? extends Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> intentions, @NotNull PsiFile psiFile, final @NotNull Editor editor2, @NlsContexts.Tooltip @Nullable String tooltip) {
        if (severity == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(1);
        }
        if (editor2 == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(2);
        }
        super(FileLevelIntentionComponent.getColor(psiFile.getProject(), severity));
        final Project project2 = psiFile.getProject();
        ShowIntentionsPass.IntentionsInfo info = new ShowIntentionsPass.IntentionsInfo();
        if (intentions != null) {
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : intentions) {
                HighlightInfo.IntentionActionDescriptor descriptor = pair.getFirst();
                info.intentionsToShow.add(descriptor);
                IntentionAction action2 = descriptor.getAction();
                if (action2 instanceof EmptyIntentionAction) continue;
                String text2 = action2.getText();
                this.createActionLabel(text2, () -> {
                    PsiDocumentManager.getInstance(project2).commitAllDocuments();
                    ShowIntentionActionsHandler.chooseActionAndInvoke(psiFile, editor2, action2, text2);
                });
            }
        }
        this.myLabel.setText(description);
        this.myLabel.setToolTipText(tooltip);
        if (gutterMark != null) {
            this.myLabel.setIcon(gutterMark.getIcon());
        }
        if (intentions != null && !intentions.isEmpty()) {
            this.myGearLabel.setIcon(AllIcons.General.GearPlain);
            final SmartPsiElementPointer<PsiFile> filePointer = SmartPointerManager.createPointer(psiFile);
            new ClickListener(){

                @Override
                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    PsiFile psiFile;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((psiFile = (PsiFile)filePointer.getElement()) == null) {
                        return true;
                    }
                    CachedIntentions cachedIntentions = new CachedIntentions(project2, psiFile, editor2);
                    IntentionListStep step = new IntentionListStep(null, editor2, psiFile, project2, cachedIntentions);
                    HighlightInfo.IntentionActionDescriptor descriptor = (HighlightInfo.IntentionActionDescriptor)((Pair)intentions.get(0)).getFirst();
                    IntentionActionWithTextCaching actionWithTextCaching = cachedIntentions.wrapAction(descriptor, psiFile, psiFile, editor2);
                    if (step.hasSubstep(actionWithTextCaching)) {
                        step = step.getSubStep(actionWithTextCaching, null);
                    }
                    ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
                    Dimension dimension = popup2.getContent().getPreferredSize();
                    Point at = new Point(-dimension.width + FileLevelIntentionComponent.this.myGearLabel.getWidth(), FileLevelIntentionComponent.this.getHeight());
                    popup2.show(new RelativePoint(e.getComponent(), at));
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/intention/impl/FileLevelIntentionComponent$1", "onClick"));
                }
            }.installOn(this.myGearLabel);
        }
    }

    @NotNull
    private static Color getColor(@NotNull Project project2, @NotNull HighlightSeverity severity) {
        if (project2 == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(3);
        }
        if (severity == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(4);
        }
        if (SeverityRegistrar.getSeverityRegistrar(project2).compare(severity, HighlightSeverity.ERROR) >= 0) {
            Color color = LightColors.RED;
            if (color == null) {
                FileLevelIntentionComponent.$$$reportNull$$$0(5);
            }
            return color;
        }
        if (SeverityRegistrar.getSeverityRegistrar(project2).compare(severity, HighlightSeverity.WARNING) >= 0) {
            Color color = LightColors.YELLOW;
            if (color == null) {
                FileLevelIntentionComponent.$$$reportNull$$$0(6);
            }
            return color;
        }
        Color color = LightColors.GREEN;
        if (color == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(7);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/FileLevelIntentionComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/FileLevelIntentionComponent";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

