/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.impl.config.BeforeAfterMetaData;
import com.intellij.codeInsight.intention.impl.config.PlainTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.ResourceTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BeforeAfterActionMetaData
implements BeforeAfterMetaData {
    private static final Logger LOG = Logger.getInstance(BeforeAfterActionMetaData.class);
    protected static final TextDescriptor[] EMPTY_EXAMPLE = new TextDescriptor[0];
    protected static final TextDescriptor EMPTY_DESCRIPTION = new PlainTextDescriptor("", "");
    @NonNls
    protected static final String DESCRIPTION_FILE_NAME = "description.html";
    @NonNls
    static final String EXAMPLE_USAGE_URL_SUFFIX = ".template";
    @NonNls
    private static final String BEFORE_TEMPLATE_PREFIX = "before";
    @NonNls
    private static final String AFTER_TEMPLATE_PREFIX = "after";
    protected final ClassLoader myLoader;
    protected final String myDescriptionDirectoryName;
    private TextDescriptor[] myExampleUsagesBefore;
    private TextDescriptor[] myExampleUsagesAfter;
    protected TextDescriptor myDescription;

    public BeforeAfterActionMetaData(@Nullable ClassLoader loader, @NotNull String descriptionDirectoryName) {
        if (descriptionDirectoryName == null) {
            BeforeAfterActionMetaData.$$$reportNull$$$0(0);
        }
        this.myLoader = loader;
        this.myDescriptionDirectoryName = descriptionDirectoryName;
    }

    public BeforeAfterActionMetaData(@NotNull TextDescriptor description, TextDescriptor @NotNull [] exampleUsagesBefore, TextDescriptor @NotNull [] exampleUsagesAfter) {
        if (description == null) {
            BeforeAfterActionMetaData.$$$reportNull$$$0(1);
        }
        if (exampleUsagesBefore == null) {
            BeforeAfterActionMetaData.$$$reportNull$$$0(2);
        }
        if (exampleUsagesAfter == null) {
            BeforeAfterActionMetaData.$$$reportNull$$$0(3);
        }
        this.myLoader = null;
        this.myDescriptionDirectoryName = null;
        this.myExampleUsagesBefore = exampleUsagesBefore;
        this.myExampleUsagesAfter = exampleUsagesAfter;
        this.myDescription = description;
    }

    private TextDescriptor @NotNull [] retrieveURLs(@NotNull String prefix, @NotNull String suffix) {
        FileType[] fileTypes;
        if (prefix == null) {
            BeforeAfterActionMetaData.$$$reportNull$$$0(4);
        }
        if (suffix == null) {
            BeforeAfterActionMetaData.$$$reportNull$$$0(5);
        }
        LinkedHashSet<ResourceTextDescriptor> urls = new LinkedHashSet<ResourceTextDescriptor>();
        for (FileType fileType : fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes()) {
            List matchers = FileTypeManager.getInstance().getAssociations(fileType);
            for (FileNameMatcher matcher : matchers) {
                String resourcePath;
                URL resource;
                if (matcher instanceof ExactFileNameMatcher) {
                    ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
                    String fileName = StringUtil.trimStart(exactFileNameMatcher.getFileName(), ".");
                    String resourcePath2 = this.getResourceLocation(prefix + "." + fileName + suffix);
                    URL resource2 = this.myLoader.getResource(resourcePath2);
                    if (resource2 == null) continue;
                    urls.add(new ResourceTextDescriptor(this.myLoader, resourcePath2));
                    continue;
                }
                if (!(matcher instanceof ExtensionFileNameMatcher)) continue;
                ExtensionFileNameMatcher extensionFileNameMatcher = (ExtensionFileNameMatcher)matcher;
                String extension2 = extensionFileNameMatcher.getExtension();
                int i = 0;
                while ((resource = this.myLoader.getResource(resourcePath = this.getResourceLocation(prefix + "." + extension2 + (i == 0 ? "" : Integer.toString(i)) + suffix))) != null) {
                    urls.add(new ResourceTextDescriptor(this.myLoader, resourcePath));
                    ++i;
                }
            }
        }
        if (urls.isEmpty()) {
            String[] children2;
            URL descriptionUrl = this.myLoader.getResource(this.getResourceLocation(DESCRIPTION_FILE_NAME));
            String url = descriptionUrl.toExternalForm();
            URL descriptionDirectory = null;
            Exception cause = null;
            try {
                descriptionDirectory = new URL(url.substring(0, url.lastIndexOf(47)));
                URI uri = descriptionDirectory.toURI();
                children2 = uri.isOpaque() ? null : ObjectUtils.notNull(new File(uri).list(), ArrayUtilRt.EMPTY_STRING_ARRAY);
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
                cause = e;
                children2 = null;
            }
            LOG.error("URLs not found for available file types and prefix: '" + prefix + "', suffix: '" + suffix + "'; in directory: '" + descriptionDirectory + "'" + (String)(children2 == null ? "" : "; directory contents: " + Arrays.asList(children2)), cause);
            if (EMPTY_EXAMPLE == null) {
                BeforeAfterActionMetaData.$$$reportNull$$$0(6);
            }
            return EMPTY_EXAMPLE;
        }
        TextDescriptor[] textDescriptorArray = urls.toArray(new TextDescriptor[0]);
        if (textDescriptorArray == null) {
            BeforeAfterActionMetaData.$$$reportNull$$$0(7);
        }
        return textDescriptorArray;
    }

    @Override
    public TextDescriptor @NotNull [] getExampleUsagesBefore() {
        if (this.myExampleUsagesBefore == null) {
            this.myExampleUsagesBefore = this.retrieveURLs(BEFORE_TEMPLATE_PREFIX, EXAMPLE_USAGE_URL_SUFFIX);
        }
        if (this.myExampleUsagesBefore == null) {
            BeforeAfterActionMetaData.$$$reportNull$$$0(8);
        }
        return this.myExampleUsagesBefore;
    }

    @Override
    public TextDescriptor @NotNull [] getExampleUsagesAfter() {
        if (this.myExampleUsagesAfter == null) {
            this.myExampleUsagesAfter = this.retrieveURLs(AFTER_TEMPLATE_PREFIX, EXAMPLE_USAGE_URL_SUFFIX);
        }
        if (this.myExampleUsagesAfter == null) {
            BeforeAfterActionMetaData.$$$reportNull$$$0(9);
        }
        return this.myExampleUsagesAfter;
    }

    @Override
    @NotNull
    public TextDescriptor getDescription() {
        if (this.myDescription == null) {
            this.myDescription = new ResourceTextDescriptor(this.myLoader, this.getResourceLocation(DESCRIPTION_FILE_NAME));
        }
        TextDescriptor textDescriptor = this.myDescription;
        if (textDescriptor == null) {
            BeforeAfterActionMetaData.$$$reportNull$$$0(10);
        }
        return textDescriptor;
    }

    protected abstract String getResourceLocation(String var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionDirectoryName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exampleUsagesBefore";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exampleUsagesAfter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/config/BeforeAfterActionMetaData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/config/BeforeAfterActionMetaData";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveURLs";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExampleUsagesBefore";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExampleUsagesAfter";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "retrieveURLs";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

