/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ResourceTextDescriptor
implements TextDescriptor {
    private static final Logger LOG = Logger.getInstance(ResourceTextDescriptor.class);
    private final ClassLoader myLoader;
    private final String myResourcePath;

    ResourceTextDescriptor(ClassLoader loader, @NotNull String resourcePath) {
        if (resourcePath == null) {
            ResourceTextDescriptor.$$$reportNull$$$0(0);
        }
        this.myLoader = loader;
        this.myResourcePath = resourcePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceTextDescriptor resource = (ResourceTextDescriptor)o;
        return Objects.equals(this.myLoader, resource.myLoader) && Objects.equals(this.myResourcePath, resource.myResourcePath);
    }

    public int hashCode() {
        return Objects.hash(this.myLoader, this.myResourcePath);
    }

    @Override
    @NotNull
    public String getText() throws IOException {
        InputStream stream;
        InputStream languageStream;
        InputStream inputStream = languageStream = !this.myResourcePath.endsWith("description.html") ? null : this.getLanguageStream();
        if (languageStream != null) {
            String string2;
            try {
                string2 = ResourceUtil.loadText(languageStream);
            }
            catch (IOException e) {
                LOG.error("Cannot find localized resource: " + this.myResourcePath, e);
            }
            if (string2 == null) {
                ResourceTextDescriptor.$$$reportNull$$$0(1);
            }
            return string2;
        }
        if ((stream = this.myLoader.getResourceAsStream(this.myResourcePath)) == null) {
            throw new IOException("Resource not found: " + this.myResourcePath + "; loader: " + this.myLoader);
        }
        String string3 = ResourceUtil.loadText(stream);
        if (string3 == null) {
            ResourceTextDescriptor.$$$reportNull$$$0(2);
        }
        return string3;
    }

    @Nullable
    private InputStream getLanguageStream() {
        DynamicBundle.LanguageBundleEP langBundle = DynamicBundle.findLanguageBundle();
        if (langBundle == null) {
            return null;
        }
        PluginDescriptor descriptor = langBundle.pluginDescriptor;
        if (descriptor == null) {
            return null;
        }
        ClassLoader classLoader = descriptor.getPluginClassLoader();
        return classLoader != null ? classLoader.getResourceAsStream(this.myResourcePath) : null;
    }

    @Override
    @NotNull
    public String getFileName() {
        String string2 = Strings.trimEnd(this.myResourcePath.substring(this.myResourcePath.lastIndexOf(47) + 1), ".template");
        if (string2 == null) {
            ResourceTextDescriptor.$$$reportNull$$$0(3);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/config/ResourceTextDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/config/ResourceTextDescriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

