/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.preview;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewComputableKt;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewDiffResult;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewEditor;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewUnsupportedOperationException;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import java.io.IOException;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\u0002H\u0016J\b\u0010\r\u001a\u0004\u0018\u00010\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0002J\b\u0010\u0013\u001a\u00020\u0002H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewComputable;", "Ljava/util/concurrent/Callable;", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "action", "Lcom/intellij/codeInsight/intention/IntentionAction;", "originalFile", "Lcom/intellij/psi/PsiFile;", "originalEditor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/codeInsight/intention/IntentionAction;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "call", "generatePreview", "mapInjectedOffsetToUnescaped", "", "injectedFile", "injectedOffset", "tryCreateDiffContent", "tryCreateFallbackDescriptionContent", "intellij.platform.lang.impl"})
public final class IntentionPreviewComputable
implements Callable<IntentionPreviewInfo> {
    private final Project project;
    private final IntentionAction action;
    private final PsiFile originalFile;
    private final Editor originalEditor;

    @Override
    @NotNull
    public IntentionPreviewInfo call() {
        IntentionPreviewInfo diffContent = this.tryCreateDiffContent();
        if (diffContent != null) {
            return diffContent;
        }
        return this.tryCreateFallbackDescriptionContent();
    }

    private final IntentionPreviewInfo tryCreateFallbackDescriptionContent() {
        Object object;
        Object v1;
        block5: {
            IntentionAction intentionAction = IntentionActionDelegate.unwrap(this.action);
            Intrinsics.checkNotNullExpressionValue((Object)intentionAction, (String)"IntentionActionDelegate.unwrap(action)");
            IntentionAction originalAction = intentionAction;
            Iterable $this$singleOrNull$iv = IntentionManagerSettings.Companion.getInstance().getMetaData();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IntentionActionMetaData md = (IntentionActionMetaData)element$iv;
                boolean bl = false;
                if (!(IntentionActionDelegate.unwrap(md.getAction()) == originalAction)) continue;
                if (found$iv) {
                    v1 = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        IntentionActionMetaData intentionActionMetaData = v1;
        if (intentionActionMetaData == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"IntentionPreviewInfo.EMPTY");
            return intentionPreviewInfo;
        }
        IntentionActionMetaData actionMetaData = intentionActionMetaData;
        try {
            TextDescriptor textDescriptor = actionMetaData.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)textDescriptor, (String)"actionMetaData.description");
            String string2 = textDescriptor.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"actionMetaData.description.text");
            object = string2;
            Regex $i$f$singleOrNull = IntentionPreviewComputableKt.access$getHTML_COMMENT_REGEX$p();
            String string3 = "";
            object = new IntentionPreviewInfo.Html($i$f$singleOrNull.replace((CharSequence)object, string3));
        }
        catch (IOException ex) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"IntentionPreviewInfo.EMPTY");
            object = intentionPreviewInfo;
        }
        return object;
    }

    private final IntentionPreviewInfo tryCreateDiffContent() {
        try {
            return this.generatePreview();
        }
        catch (IntentionPreviewUnsupportedOperationException e) {
            return null;
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(IntentionPreviewComputable.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.debug("There are exceptions on invocation the intention: '" + this.action.getText() + "' on a copy of the file.", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final IntentionPreviewInfo generatePreview() {
        block18: {
            block17: {
                if (this.project.isDisposed()) {
                    return null;
                }
                v0 = ShowIntentionActionsHandler.chooseFileForAction(this.originalFile, this.originalEditor, this.action);
                if (v0 == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue(v0, (String)"ShowIntentionActionsHand\u2026r, action) ?: return null");
                origPair = v0;
                origFile = null;
                caretOffset = 0;
                fileFactory = PsiFileFactory.getInstance(this.project);
                if (Intrinsics.areEqual((Object)((PsiFile)origPair.first), (Object)this.originalFile) ^ true) {
                    manager = InjectedLanguageManager.getInstance(this.project);
                    v1 = origPair.first;
                    Intrinsics.checkNotNullExpressionValue(v1, (String)"origPair.first");
                    v2 = ((PsiFile)v1).getName();
                    v3 = origPair.first;
                    Intrinsics.checkNotNullExpressionValue(v3, (String)"origPair.first");
                    v4 = fileFactory.createFileFromText(v2, ((PsiFile)v3).getFileType(), (CharSequence)manager.getUnescapedText((PsiElement)origPair.first));
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"fileFactory.createFileFr\u2026apedText(origPair.first))");
                    origFile = v4;
                    v5 = origPair.first;
                    Intrinsics.checkNotNullExpressionValue(v5, (String)"origPair.first");
                    v6 = (PsiFile)v5;
                    v7 = origPair.second;
                    Intrinsics.checkNotNullExpressionValue(v7, (String)"origPair.second");
                    v8 = ((Editor)v7).getCaretModel();
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"origPair.second.caretModel");
                    caretOffset = this.mapInjectedOffsetToUnescaped(v6, v8.getOffset());
                } else {
                    origFile = this.originalFile;
                    v9 = this.originalEditor.getCaretModel();
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"originalEditor.caretModel");
                    caretOffset = v9.getOffset();
                }
                v10 = origFile.copy();
                if (v10 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiFile");
                }
                psiFileCopy = (PsiFile)v10;
                ProgressManager.checkCanceled();
                v11 = this.originalEditor.getSettings();
                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"originalEditor.settings");
                editorCopy = new IntentionPreviewEditor(psiFileCopy, caretOffset, v11);
                v12 = this.originalEditor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"originalEditor.document");
                writable = v12.isWritable();
                try {
                    this.originalEditor.getDocument().setReadOnly(true);
                    ProgressManager.checkCanceled();
                    v13 = this.action.generatePreview(this.project, (Editor)editorCopy, psiFileCopy);
                    Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"action.generatePreview(p\u2026 editorCopy, psiFileCopy)");
                    result = v13;
                    if (!Intrinsics.areEqual((Object)result, (Object)IntentionPreviewInfo.FALLBACK_DIFF)) ** GOTO lbl88
                    v14 = this.action.getElementToMakeWritable(this.originalFile);
                    if ((v14 != null ? v14.getContainingFile() : null) == this.originalFile) break block17;
                    var9_10 = null;
                }
                catch (Throwable var8_9) {
                    this.originalEditor.getDocument().setReadOnly(writable == false);
                    throw var8_9;
                }
                this.originalEditor.getDocument().setReadOnly(writable == false);
                return var9_10;
            }
            if (IntentionPreviewComputableKt.access$findCopyIntention(this.project, (Editor)editorCopy, psiFileCopy, this.action) != null) break block18;
            var10_12 = null;
            this.originalEditor.getDocument().setReadOnly(writable == false);
            return var10_12;
        }
        action = v15;
        v16 = IntentionActionDelegate.unwrap(action);
        Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"IntentionActionDelegate.unwrap(action)");
        unwrapped = v16;
        if (unwrapped instanceof QuickFixWrapper) {
            v17 = ((QuickFixWrapper)unwrapped).getFix();
            Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"unwrapped.fix");
            v18 = v17;
        } else {
            v18 = unwrapped;
        }
        actionClass = Reflection.getOrCreateKotlinClass(v18.getClass()).getQualifiedName();
        $i$f$logger = false;
        v19 = Logger.getInstance(IntentionPreviewComputable.class);
        Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"Logger.getInstance(T::class.java)");
        v19.error("Intention preview fallback is used for action " + actionClass + "|" + action.getFamilyName());
        action.invoke(this.project, (Editor)editorCopy, psiFileCopy);
        v20 = IntentionPreviewInfo.DIFF;
        Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"IntentionPreviewInfo.DIFF");
        result = v20;
lbl88:
        // 2 sources

        ProgressManager.checkCanceled();
        var9_11 = result;
        if (Intrinsics.areEqual((Object)var9_11, (Object)IntentionPreviewInfo.DIFF)) {
            PostprocessReformattingAspect.getInstance((Project)this.project).doPostponedFormatting(psiFileCopy.getViewProvider());
            v21 = ComparisonManager.getInstance();
            v22 = origFile.getText();
            v23 = editorCopy.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)v23, (String)"editorCopy.document");
            v24 = v21.compareLines(v22, (CharSequence)v23.getText(), ComparisonPolicy.TRIM_WHITESPACES, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)v24, (String)"ComparisonManager.getIns\u2026ogressIndicator.INSTANCE)");
            v25 = new IntentionPreviewDiffResult(psiFileCopy, origFile, v24, false, 8, null);
        } else if (Intrinsics.areEqual((Object)var9_11, (Object)IntentionPreviewInfo.EMPTY)) {
            v25 = null;
        } else if (var9_11 instanceof IntentionPreviewInfo.CustomDiff) {
            v26 = fileFactory.createFileFromText("__dummy__", ((IntentionPreviewInfo.CustomDiff)result).fileType(), (CharSequence)((IntentionPreviewInfo.CustomDiff)result).modifiedText());
            Intrinsics.checkNotNullExpressionValue((Object)v26, (String)"fileFactory.createFileFr\u2026), result.modifiedText())");
            v27 = fileFactory.createFileFromText("__dummy__", ((IntentionPreviewInfo.CustomDiff)result).fileType(), (CharSequence)((IntentionPreviewInfo.CustomDiff)result).originalText());
            Intrinsics.checkNotNullExpressionValue((Object)v27, (String)"fileFactory.createFileFr\u2026), result.originalText())");
            v28 = ComparisonManager.getInstance().compareLines((CharSequence)((IntentionPreviewInfo.CustomDiff)result).originalText(), (CharSequence)((IntentionPreviewInfo.CustomDiff)result).modifiedText(), ComparisonPolicy.TRIM_WHITESPACES, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)v28, (String)"ComparisonManager.getIns\u2026ogressIndicator.INSTANCE)");
            v25 = new IntentionPreviewDiffResult(v26, v27, v28, false);
        } else {
            v25 = result;
        }
        var9_11 = v25;
        this.originalEditor.getDocument().setReadOnly(writable == false);
        return var9_11;
    }

    /*
     * WARNING - void declaration
     */
    private final int mapInjectedOffsetToUnescaped(PsiFile injectedFile, int injectedOffset) {
        void escapedOffset;
        void unescapedOffset;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        Ref.IntRef intRef2 = new Ref.IntRef();
        intRef2.element = 0;
        injectedFile.accept(new PsiRecursiveElementWalkingVisitor((Ref.IntRef)unescapedOffset, (Ref.IntRef)escapedOffset, injectedOffset){
            final /* synthetic */ Ref.IntRef $unescapedOffset;
            final /* synthetic */ Ref.IntRef $escapedOffset;
            final /* synthetic */ int $injectedOffset;

            public void visitElement(@NotNull PsiElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                String leafText = InjectedLanguageUtilBase.getUnescapedLeafText(element2, false);
                if (leafText != null) {
                    this.$unescapedOffset.element += leafText.length();
                    this.$escapedOffset.element += element2.getTextLength();
                    if (this.$escapedOffset.element >= this.$injectedOffset) {
                        this.$unescapedOffset.element -= this.$escapedOffset.element - this.$injectedOffset;
                        this.stopWalking();
                    }
                }
                super.visitElement(element2);
            }
            {
                this.$unescapedOffset = $captured_local_variable$0;
                this.$escapedOffset = $captured_local_variable$1;
                this.$injectedOffset = $captured_local_variable$2;
            }
        });
        return unescapedOffset.element;
    }

    public IntentionPreviewComputable(@NotNull Project project2, @NotNull IntentionAction action2, @NotNull PsiFile originalFile, @NotNull Editor originalEditor) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)originalEditor, (String)"originalEditor");
        this.project = project2;
        this.action = action2;
        this.originalFile = originalFile;
        this.originalEditor = originalEditor;
    }
}

