/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import org.jetbrains.annotations.NotNull;

public class BackspaceHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public BackspaceHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void doExecute(@NotNull Editor editor2, Caret caret, DataContext dataContext) {
        LookupImpl lookup2;
        if (editor2 == null) {
            BackspaceHandler.$$$reportNull$$$0(0);
        }
        if ((lookup2 = (LookupImpl)LookupManager.getActiveLookup(editor2)) == null) {
            this.myOriginalHandler.execute(editor2, caret, dataContext);
            return;
        }
        int hideOffset = lookup2.getLookupStart();
        int originalStart = lookup2.getLookupOriginalStart();
        if (originalStart >= 0 && originalStart <= hideOffset) {
            hideOffset = originalStart - 1;
        }
        BackspaceHandler.truncatePrefix(dataContext, lookup2, this.myOriginalHandler, hideOffset, caret);
    }

    static void truncatePrefix(DataContext dataContext, LookupImpl lookup2, EditorActionHandler handler, int hideOffset, Caret caret) {
        Editor editor2 = lookup2.getEditor();
        if (!lookup2.performGuardedChange(() -> handler.execute(editor2, caret, dataContext))) {
            return;
        }
        CompletionProgressIndicator process2 = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        lookup2.truncatePrefix(process2 == null || !process2.isAutopopupCompletion(), hideOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/lookup/impl/BackspaceHandler", "doExecute"));
    }
}

