/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.impl.AsyncRendering;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.icons.RowIcon;
import com.intellij.ui.popup.list.SelectablePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.Alarm;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SingleAlarm;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanOpenHashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class LookupCellRenderer
implements ListCellRenderer<LookupElement> {
    private Icon myEmptyIcon;
    private final Font myNormalFont;
    private final Font myBoldFont;
    private final FontMetrics myNormalMetrics;
    private final FontMetrics myBoldMetrics;
    private static final Key<Font> CUSTOM_NAME_FONT = Key.create("CustomLookupElementNameFont");
    private static final Key<Font> CUSTOM_TAIL_FONT = Key.create("CustomLookupElementTailFont");
    private static final Key<Font> CUSTOM_TYPE_FONT = Key.create("CustomLookupElementTypeFont");
    public static final Color BACKGROUND_COLOR = JBColor.lazy(() -> Objects.requireNonNullElse(EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)Lookup.LOOKUP_COLOR), JBColor.namedColor("CompletionPopup.background", new JBColor(new Color(235, 244, 254), JBColor.background()))));
    public static final Color MATCHED_FOREGROUND_COLOR = JBColor.namedColor("CompletionPopup.matchForeground", JBUI.CurrentTheme.Link.Foreground.ENABLED);
    public static final Color SELECTED_BACKGROUND_COLOR = JBColor.namedColor("CompletionPopup.selectionBackground", new JBColor(12967932, 1129052));
    public static final Color SELECTED_NON_FOCUSED_BACKGROUND_COLOR = JBColor.namedColor("CompletionPopup.selectionInactiveBackground", new JBColor(0xE0E0E0, 5330007));
    private static final Color NON_FOCUSED_MASK_COLOR = JBColor.namedColor("CompletionPopup.nonFocusedMask", Gray._0.withAlpha(0));
    public static final SimpleTextAttributes REGULAR_MATCHED_ATTRIBUTES = new SimpleTextAttributes(0, MATCHED_FOREGROUND_COLOR);
    private final LookupImpl myLookup;
    private final SimpleColoredComponent myNameComponent;
    private final SimpleColoredComponent myTailComponent;
    private final SimpleColoredComponent myTypeLabel;
    private final LookupPanel myPanel;
    private final Int2BooleanMap mySelected;
    private static final String ELLIPSIS = "\u2026";
    private int myMaxWidth;
    private volatile int myLookupTextWidth;
    private final Object myWidthLock;
    private final Runnable myLookupWidthUpdater;
    private final boolean myShrinkLookup;
    private final AsyncRendering myAsyncRendering;
    private final List<ItemPresentationCustomizer> myCustomizers;
    private boolean myIsSelected;

    private static Insets selectionInnerInsets() {
        return JBUI.insets("CompletionPopup.selectionInnerInsets", JBUI.insets(2));
    }

    static Insets bodyInsets() {
        return JBUI.insets("CompletionPopup.Body.insets", JBUI.insets(4));
    }

    private static Insets selectionInsets() {
        Insets innerInsets = LookupCellRenderer.selectionInnerInsets();
        Insets bodyInsets = LookupCellRenderer.bodyInsets();
        return new Insets(innerInsets.top, innerInsets.left + bodyInsets.left, innerInsets.bottom, innerInsets.right + bodyInsets.right);
    }

    public LookupCellRenderer(LookupImpl lookup2, @NotNull JComponent editorComponent) {
        if (editorComponent == null) {
            LookupCellRenderer.$$$reportNull$$$0(0);
        }
        this.myEmptyIcon = EmptyIcon.ICON_0;
        this.mySelected = new Int2BooleanOpenHashMap();
        this.myMaxWidth = -1;
        this.myLookupTextWidth = 50;
        this.myWidthLock = ObjectUtils.sentinel("lookup width lock");
        this.myCustomizers = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myIsSelected = false;
        EditorColorsScheme scheme = lookup2.getTopLevelEditor().getColorsScheme();
        this.myNormalFont = scheme.getFont(EditorFontType.PLAIN);
        this.myBoldFont = scheme.getFont(EditorFontType.BOLD);
        this.myLookup = lookup2;
        this.myNameComponent = new MySimpleColoredComponent();
        this.myNameComponent.setOpaque(false);
        this.myNameComponent.setIconTextGap(JBUIScale.scale(4));
        this.myNameComponent.setIpad((Insets)JBUI.insetsLeft(1));
        this.myNameComponent.setMyBorder(null);
        this.myTailComponent = new MySimpleColoredComponent();
        this.myTailComponent.setOpaque(false);
        this.myTailComponent.setIpad((Insets)JBInsets.emptyInsets());
        this.myTailComponent.setBorder((Border)JBUI.Borders.emptyRight(10));
        this.myTypeLabel = new MySimpleColoredComponent();
        this.myTypeLabel.setOpaque(false);
        this.myTypeLabel.setIpad((Insets)JBInsets.emptyInsets());
        this.myTypeLabel.setBorder((Border)JBUI.Borders.emptyRight(10));
        this.myPanel = new LookupPanel();
        this.myPanel.add((Component)this.myNameComponent, "West");
        this.myPanel.add((Component)this.myTailComponent, "Center");
        this.myPanel.add((Component)this.myTypeLabel, "East");
        this.myNormalMetrics = this.myLookup.getTopLevelEditor().getComponent().getFontMetrics(this.myNormalFont);
        this.myBoldMetrics = this.myLookup.getTopLevelEditor().getComponent().getFontMetrics(this.myBoldFont);
        this.myAsyncRendering = new AsyncRendering(this.myLookup);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myLookupWidthUpdater = () -> ApplicationManager.getApplication().invokeLater(this::updateLookupWidthFromVisibleItems);
        } else {
            SingleAlarm alarm2 = new SingleAlarm(this::updateLookupWidthFromVisibleItems, 50, (Disposable)lookup2, Alarm.ThreadToUse.SWING_THREAD, ModalityState.stateForComponent(editorComponent));
            this.myLookupWidthUpdater = () -> {
                SingleAlarm singleAlarm = alarm2;
                synchronized (singleAlarm) {
                    if (!alarm2.isDisposed()) {
                        alarm2.request();
                    }
                }
            };
        }
        this.myShrinkLookup = Registry.is("ide.lookup.shrink");
    }

    @Override
    public Component getListCellRendererComponent(JList list2, LookupElement item, int index, boolean isSelected, boolean hasFocus) {
        boolean useBoxLayout;
        boolean nonFocusedSelection;
        boolean bl = nonFocusedSelection = isSelected && this.myLookup.getLookupFocusDegree() == LookupFocusDegree.SEMI_FOCUSED;
        if (!this.myLookup.isFocused()) {
            isSelected = false;
        }
        this.myIsSelected = isSelected;
        this.myPanel.setSelectionColor(nonFocusedSelection ? SELECTED_NON_FOCUSED_BACKGROUND_COLOR : (isSelected ? SELECTED_BACKGROUND_COLOR : null));
        int allowedWidth = list2.getWidth() - LookupCellRenderer.calcSpacing(this.myNameComponent, this.myEmptyIcon) - LookupCellRenderer.calcSpacing(this.myTailComponent, null) - LookupCellRenderer.calcSpacing(this.myTypeLabel, null);
        LookupElementPresentation presentation2 = this.myAsyncRendering.getLastComputed(item);
        for (ItemPresentationCustomizer customizer : this.myCustomizers) {
            presentation2 = customizer.customizePresentation(item, presentation2);
        }
        if (presentation2.getIcon() != null) {
            LookupCellRenderer.setIconInsets(this.myNameComponent);
        }
        this.myNameComponent.clear();
        Color itemColor = presentation2.getItemTextForeground();
        allowedWidth -= this.setItemTextLabel(item, itemColor, presentation2, allowedWidth);
        this.myTailComponent.setFont(ObjectUtils.notNull(LookupCellRenderer.getCustomFont(item, false, CUSTOM_TAIL_FONT), this.myNormalFont));
        this.myTypeLabel.setFont(ObjectUtils.notNull(LookupCellRenderer.getCustomFont(item, false, CUSTOM_TYPE_FONT), this.myNormalFont));
        this.myNameComponent.setIcon(LookupCellRenderer.augmentIcon(this.myLookup.getTopLevelEditor(), presentation2.getIcon(), this.myEmptyIcon));
        Color grayedForeground = LookupCellRenderer.getGrayedForeground(isSelected);
        this.myTypeLabel.clear();
        if (allowedWidth > 0) {
            allowedWidth -= this.setTypeTextLabel(item, grayedForeground, presentation2, isSelected ? this.getMaxWidth() : allowedWidth, isSelected, nonFocusedSelection, this.getRealFontMetrics(item, false, CUSTOM_TYPE_FONT));
        }
        this.myTailComponent.clear();
        if (isSelected || allowedWidth >= 0) {
            this.setTailTextLabel(isSelected, presentation2, grayedForeground, isSelected ? this.getMaxWidth() : allowedWidth, nonFocusedSelection, this.getRealFontMetrics(item, false, CUSTOM_TAIL_FONT));
        }
        if (this.mySelected.containsKey(index) && !isSelected && this.mySelected.get(index)) {
            this.myPanel.setUpdateExtender(true);
        }
        this.mySelected.put(index, isSelected);
        double w = this.myNameComponent.getPreferredSize().getWidth() + this.myTailComponent.getPreferredSize().getWidth() + this.myTypeLabel.getPreferredSize().getWidth();
        boolean bl2 = useBoxLayout = isSelected && w > (double)list2.getWidth() && ((JBList)list2).getExpandableItemsHandler().isEnabled();
        if (useBoxLayout != this.myPanel.getLayout() instanceof BoxLayout) {
            this.myPanel.removeAll();
            if (useBoxLayout) {
                this.myPanel.setLayout(new BoxLayout((Container)((Object)this.myPanel), 0));
                this.myPanel.add((Component)this.myNameComponent);
                this.myPanel.add((Component)this.myTailComponent);
                this.myPanel.add((Component)this.myTypeLabel);
            } else {
                this.myPanel.setLayout(new BorderLayout());
                this.myPanel.add((Component)this.myNameComponent, "West");
                this.myPanel.add((Component)this.myTailComponent, "Center");
                this.myPanel.add((Component)this.myTypeLabel, "East");
            }
        }
        AccessibleContextUtil.setCombinedName((Component)((Object)this.myPanel), (Component)this.myNameComponent, "", (Component)this.myTailComponent, " - ", (Component)this.myTypeLabel);
        AccessibleContextUtil.setCombinedDescription((Component)((Object)this.myPanel), (Component)this.myNameComponent, "", (Component)this.myTailComponent, " - ", (Component)this.myTypeLabel);
        return this.myPanel;
    }

    @VisibleForTesting
    public int getLookupTextWidth() {
        return this.myLookupTextWidth;
    }

    void addPresentationCustomizer(@NotNull ItemPresentationCustomizer customizer) {
        if (customizer == null) {
            LookupCellRenderer.$$$reportNull$$$0(1);
        }
        this.myCustomizers.add(customizer);
    }

    private static int calcSpacing(@NotNull SimpleColoredComponent component2, @Nullable Icon icon2) {
        Insets insets;
        if (component2 == null) {
            LookupCellRenderer.$$$reportNull$$$0(2);
        }
        Insets iPad = component2.getIpad();
        int width = iPad.left + iPad.right;
        Border myBorder = component2.getMyBorder();
        if (myBorder != null) {
            insets = myBorder.getBorderInsets((Component)component2);
            width += insets.left + insets.right;
        }
        if ((insets = component2.getInsets()) != null) {
            width += insets.left + insets.right;
        }
        if (icon2 != null) {
            width += icon2.getIconWidth() + component2.getIconTextGap();
        }
        return width;
    }

    private int getMaxWidth() {
        if (this.myMaxWidth < 0) {
            Point p = this.myLookup.getComponent().getLocationOnScreen();
            Rectangle rectangle = ScreenUtil.getScreenRectangle(p);
            this.myMaxWidth = rectangle.x + rectangle.width - p.x - 111;
        }
        return this.myMaxWidth;
    }

    private void setTailTextLabel(boolean isSelected, LookupElementPresentation presentation2, Color foreground, int allowedWidth, boolean nonFocusedSelection, FontMetrics fontMetrics) {
        int style = LookupCellRenderer.getStyle(presentation2.isStrikeout(), false, false);
        for (LookupElementPresentation.TextFragment fragment : presentation2.getTailFragments()) {
            if (allowedWidth < 0) {
                return;
            }
            String trimmed = this.trimLabelText(fragment.text, allowedWidth, fontMetrics);
            int fragmentStyle = fragment.isItalic() ? style | 2 : style;
            this.myTailComponent.append(trimmed, new SimpleTextAttributes(fragmentStyle, LookupCellRenderer.getTailTextColor(isSelected, fragment, foreground, nonFocusedSelection)));
            allowedWidth -= LookupCellRenderer.getStringWidth(trimmed, fontMetrics);
        }
    }

    @NlsSafe
    private String trimLabelText(@Nullable String text2, int maxWidth, FontMetrics metrics) {
        if (text2 == null || StringUtil.isEmpty(text2)) {
            return "";
        }
        int strWidth = LookupCellRenderer.getStringWidth(text2, metrics);
        if (strWidth <= maxWidth || this.myIsSelected) {
            return text2;
        }
        if (LookupCellRenderer.getStringWidth(ELLIPSIS, metrics) > maxWidth) {
            return "";
        }
        int insIndex = ObjectUtils.binarySearch(0, text2.length(), mid -> {
            String candidate = text2.substring(0, mid) + ELLIPSIS;
            int width = LookupCellRenderer.getStringWidth(candidate, metrics);
            return width <= maxWidth ? -1 : 1;
        });
        int i = Math.max(0, -insIndex - 2);
        return text2.substring(0, i) + ELLIPSIS;
    }

    private static Color getTypeTextColor(LookupElement item, Color foreground, LookupElementPresentation presentation2, boolean selected, boolean nonFocusedSelection) {
        if (nonFocusedSelection) {
            return foreground;
        }
        return presentation2.isTypeGrayed() ? LookupCellRenderer.getGrayedForeground(selected) : (item instanceof EmptyLookupItem ? JBColor.foreground() : foreground);
    }

    private static Color getTailTextColor(boolean isSelected, LookupElementPresentation.TextFragment fragment, Color defaultForeground, boolean nonFocusedSelection) {
        Color tailForeground;
        if (nonFocusedSelection) {
            return defaultForeground;
        }
        if (fragment.isGrayed()) {
            return LookupCellRenderer.getGrayedForeground(isSelected);
        }
        if (!isSelected && (tailForeground = fragment.getForegroundColor()) != null) {
            return tailForeground;
        }
        return defaultForeground;
    }

    public static Color getGrayedForeground(boolean isSelected) {
        return UIUtil.getContextHelpForeground();
    }

    private int setItemTextLabel(LookupElement item, Color foreground, LookupElementPresentation presentation2, int allowedWidth) {
        boolean bold = presentation2.isItemTextBold();
        Font customItemFont = LookupCellRenderer.getCustomFont(item, bold, CUSTOM_NAME_FONT);
        this.myNameComponent.setFont(customItemFont != null ? customItemFont : (bold ? this.myBoldFont : this.myNormalFont));
        int style = LookupCellRenderer.getStyle(presentation2.isStrikeout(), presentation2.isItemTextUnderlined(), presentation2.isItemTextItalic());
        FontMetrics metrics = this.getRealFontMetrics(item, bold, CUSTOM_NAME_FONT);
        String name2 = this.trimLabelText(presentation2.getItemText(), allowedWidth, metrics);
        int used = LookupCellRenderer.getStringWidth(name2, metrics);
        this.renderItemName(item, foreground, style, name2, this.myNameComponent);
        return used;
    }

    private FontMetrics getRealFontMetrics(LookupElement item, boolean bold, Key<Font> key) {
        Font customFont = LookupCellRenderer.getCustomFont(item, bold, key);
        if (customFont != null) {
            return this.myLookup.getTopLevelEditor().getComponent().getFontMetrics(customFont);
        }
        return bold ? this.myBoldMetrics : this.myNormalMetrics;
    }

    @SimpleTextAttributes.StyleAttributeConstant
    private static int getStyle(boolean strikeout, boolean underlined, boolean italic) {
        int style = 0;
        if (strikeout) {
            style |= 4;
        }
        if (underlined) {
            style |= 0x10;
        }
        if (italic) {
            style |= 2;
        }
        return style;
    }

    private void renderItemName(LookupElement item, Color foreground, @SimpleTextAttributes.StyleAttributeConstant int style, @Nls String name2, SimpleColoredComponent nameComponent) {
        FList<TextRange> ranges2;
        String prefix;
        SimpleTextAttributes base = new SimpleTextAttributes(style, foreground);
        String string2 = prefix = item instanceof EmptyLookupItem ? "" : this.myLookup.itemPattern(item);
        if (prefix.length() > 0 && (ranges2 = LookupCellRenderer.getMatchingFragments(prefix, name2)) != null) {
            SimpleTextAttributes highlighted = new SimpleTextAttributes(style, MATCHED_FOREGROUND_COLOR);
            SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)nameComponent, (String)name2, ranges2, (SimpleTextAttributes)base, (SimpleTextAttributes)highlighted);
            return;
        }
        nameComponent.append(name2, base);
    }

    public static FList<TextRange> getMatchingFragments(String prefix, String name2) {
        return NameUtil.buildMatcher((String)("*" + prefix)).build().matchingFragments(name2);
    }

    private int setTypeTextLabel(LookupElement item, Color foreground, LookupElementPresentation presentation2, int allowedWidth, boolean selected, boolean nonFocusedSelection, FontMetrics normalMetrics) {
        String givenText = presentation2.getTypeText();
        String labelText = this.trimLabelText((String)(StringUtil.isEmpty(givenText) ? "" : " " + givenText), allowedWidth, normalMetrics);
        int used = LookupCellRenderer.getStringWidth(labelText, normalMetrics);
        Icon icon2 = presentation2.getTypeIcon();
        if (icon2 != null) {
            this.myTypeLabel.setIcon(icon2);
            used += icon2.getIconWidth();
        }
        this.myTypeLabel.append(labelText);
        this.myTypeLabel.setForeground(LookupCellRenderer.getTypeTextColor(item, foreground, presentation2, selected, nonFocusedSelection));
        this.myTypeLabel.setIconOnTheRight(presentation2.isTypeIconRightAligned());
        return used;
    }

    @NotNull
    private static Icon removeVisibilityIfNeeded(@Nullable Editor editor2, @NotNull Icon icon2, @NotNull Icon standard) {
        if (icon2 == null) {
            LookupCellRenderer.$$$reportNull$$$0(3);
        }
        if (standard == null) {
            LookupCellRenderer.$$$reportNull$$$0(4);
        }
        if (!Registry.is("ide.completion.show.visibility.icon")) {
            return LookupCellRenderer.removeVisibility(editor2, icon2, standard);
        }
        Icon icon3 = icon2;
        if (icon3 == null) {
            LookupCellRenderer.$$$reportNull$$$0(5);
        }
        return icon3;
    }

    @NotNull
    private static Icon removeVisibility(@Nullable Editor editor2, @NotNull Icon icon2, @NotNull Icon standard) {
        if (icon2 == null) {
            LookupCellRenderer.$$$reportNull$$$0(6);
        }
        if (standard == null) {
            LookupCellRenderer.$$$reportNull$$$0(7);
        }
        if (icon2 instanceof IconDecorator) {
            IconDecorator decoratorIcon = (IconDecorator)icon2;
            Icon delegateIcon = decoratorIcon.getDelegate();
            if (delegateIcon != null) {
                IconDecorator iconDecorator = decoratorIcon.withDelegate(LookupCellRenderer.removeVisibility(editor2, delegateIcon, standard));
                if (iconDecorator == null) {
                    LookupCellRenderer.$$$reportNull$$$0(8);
                }
                return iconDecorator;
            }
        } else if (icon2 instanceof RowIcon) {
            Icon firstIcon;
            RowIcon rowIcon = (RowIcon)icon2;
            if (rowIcon.getIconCount() >= 1 && (firstIcon = rowIcon.getIcon(0)) != null) {
                Icon icon3 = Registry.is("editor.scale.completion.icons") ? EditorUtil.scaleIconAccordingEditorFont((Icon)firstIcon, (Editor)editor2) : firstIcon;
                if (icon3 == null) {
                    LookupCellRenderer.$$$reportNull$$$0(9);
                }
                return icon3;
            }
        } else if (icon2.getIconWidth() > standard.getIconWidth() || icon2.getIconHeight() > standard.getIconHeight()) {
            Icon icon4 = IconUtil.cropIcon((Icon)icon2, (Rectangle)new Rectangle(standard.getIconWidth(), standard.getIconHeight()));
            if (icon4 == null) {
                LookupCellRenderer.$$$reportNull$$$0(10);
            }
            return icon4;
        }
        Icon icon5 = icon2;
        if (icon5 == null) {
            LookupCellRenderer.$$$reportNull$$$0(11);
        }
        return icon5;
    }

    public static Icon augmentIcon(@Nullable Editor editor2, @Nullable Icon icon2, @NotNull Icon standard) {
        if (standard == null) {
            LookupCellRenderer.$$$reportNull$$$0(12);
        }
        if (Registry.is("editor.scale.completion.icons")) {
            standard = EditorUtil.scaleIconAccordingEditorFont((Icon)standard, (Editor)editor2);
            icon2 = EditorUtil.scaleIconAccordingEditorFont((Icon)icon2, (Editor)editor2);
        }
        if (icon2 == null) {
            return standard;
        }
        if (icon2 instanceof IconDecorator) {
            IconDecorator decoratorIcon = (IconDecorator)icon2;
            return decoratorIcon.withDelegate(LookupCellRenderer.augmentIcon(editor2, decoratorIcon.getDelegate(), standard));
        }
        if ((icon2 = LookupCellRenderer.removeVisibilityIfNeeded(editor2, icon2, standard)).getIconHeight() < standard.getIconHeight() || icon2.getIconWidth() < standard.getIconWidth()) {
            LayeredIcon layeredIcon = new LayeredIcon(2);
            layeredIcon.setIcon(icon2, 0, 0, (standard.getIconHeight() - icon2.getIconHeight()) / 2);
            layeredIcon.setIcon(standard, 1);
            return layeredIcon;
        }
        return icon2;
    }

    @Nullable
    private Font getFontAbleToDisplay(@Nullable String sampleString) {
        if (sampleString == null) {
            return null;
        }
        HashSet<Font> fonts = new HashSet<Font>();
        FontPreferences fontPreferences = this.myLookup.getFontPreferences();
        for (int i = 0; i < sampleString.length(); ++i) {
            fonts.add(ComplementaryFontsRegistry.getFontAbleToDisplay((int)sampleString.charAt(i), (int)0, (FontPreferences)fontPreferences, null).getFont());
        }
        block1: for (Font font : fonts) {
            if (font.equals(this.myNormalFont)) continue;
            for (int i = 0; i < sampleString.length(); ++i) {
                if (!font.canDisplay(sampleString.charAt(i))) continue block1;
            }
            return font;
        }
        return null;
    }

    @Nullable
    private static Font getCustomFont(LookupElement item, boolean bold, Key<Font> key) {
        Font font = item.getUserData(key);
        return font == null ? null : (bold ? font.deriveFont(1) : font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLookupWidthFromVisibleItems() {
        List<LookupElement> visibleItems = this.myLookup.getVisibleItems();
        int maxWidth = this.myShrinkLookup ? 0 : this.myLookupTextWidth;
        for (LookupElement item : visibleItems) {
            LookupElementPresentation presentation2 = this.myAsyncRendering.getLastComputed(item);
            item.putUserData(CUSTOM_NAME_FONT, this.getFontAbleToDisplay(presentation2.getItemText()));
            item.putUserData(CUSTOM_TAIL_FONT, this.getFontAbleToDisplay(presentation2.getTailText()));
            item.putUserData(CUSTOM_TYPE_FONT, this.getFontAbleToDisplay(presentation2.getTypeText()));
            int itemWidth = this.updateMaximumWidth(presentation2, item);
            if (itemWidth <= maxWidth) continue;
            maxWidth = itemWidth;
        }
        Object object = this.myWidthLock;
        synchronized (object) {
            if (this.myShrinkLookup || maxWidth > this.myLookupTextWidth) {
                this.myLookupTextWidth = maxWidth;
                this.myLookup.requestResize();
                try (AccessToken ignore = SlowOperations.allowSlowOperations("rendering");){
                    this.myLookup.refreshUi(false, false);
                }
            }
        }
    }

    void scheduleUpdateLookupWidthFromVisibleItems() {
        this.myLookupWidthUpdater.run();
    }

    void itemAdded(@NotNull LookupElement element2, @NotNull LookupElementPresentation fastPresentation) {
        if (element2 == null) {
            LookupCellRenderer.$$$reportNull$$$0(13);
        }
        if (fastPresentation == null) {
            LookupCellRenderer.$$$reportNull$$$0(14);
        }
        this.updateIconWidth(fastPresentation);
        this.scheduleUpdateLookupWidthFromVisibleItems();
        AsyncRendering.rememberPresentation(element2, fastPresentation);
        this.updateItemPresentation(element2);
    }

    void updateItemPresentation(@NotNull LookupElement element2) {
        LookupElementRenderer<? extends LookupElement> renderer;
        if (element2 == null) {
            LookupCellRenderer.$$$reportNull$$$0(15);
        }
        if ((renderer = element2.getExpensiveRenderer()) != null) {
            this.myAsyncRendering.scheduleRendering(element2, renderer);
        }
    }

    private void updateIconWidth(LookupElementPresentation p) {
        Icon icon2 = p.getIcon();
        if (icon2 != null && (icon2.getIconWidth() > this.myEmptyIcon.getIconWidth() || icon2.getIconHeight() > this.myEmptyIcon.getIconHeight())) {
            if (icon2 instanceof DeferredIcon) {
                icon2 = ((DeferredIcon)icon2).getBaseIcon();
            }
            icon2 = LookupCellRenderer.removeVisibilityIfNeeded(this.myLookup.getEditor(), icon2, this.myEmptyIcon);
            this.myEmptyIcon = EmptyIcon.create(Math.max(icon2.getIconWidth(), this.myEmptyIcon.getIconWidth()), Math.max(icon2.getIconHeight(), this.myEmptyIcon.getIconHeight()));
            LookupCellRenderer.setIconInsets(this.myNameComponent);
        }
    }

    private static void setIconInsets(@NotNull SimpleColoredComponent component2) {
        if (component2 == null) {
            LookupCellRenderer.$$$reportNull$$$0(16);
        }
        component2.setIpad((Insets)JBUI.insetsLeft(6));
    }

    private int updateMaximumWidth(LookupElementPresentation p, LookupElement item) {
        this.updateIconWidth(p);
        return LookupCellRenderer.calculateWidth(p, this.getRealFontMetrics(item, false, CUSTOM_NAME_FONT), this.getRealFontMetrics(item, true, CUSTOM_NAME_FONT)) + LookupCellRenderer.calcSpacing(this.myTailComponent, null) + LookupCellRenderer.calcSpacing(this.myTypeLabel, null);
    }

    int getTextIndent() {
        return this.myNameComponent.getIpad().left + this.myEmptyIcon.getIconWidth() + this.myNameComponent.getIconTextGap();
    }

    private static int calculateWidth(LookupElementPresentation presentation2, FontMetrics normalMetrics, FontMetrics boldMetrics) {
        int result2;
        if (ExperimentalUI.isNewUI()) {
            Insets insets = LookupCellRenderer.selectionInsets();
            result2 = insets.left + insets.right;
        } else {
            result2 = 0;
        }
        result2 += LookupCellRenderer.getStringWidth(presentation2.getItemText(), presentation2.isItemTextBold() ? boldMetrics : normalMetrics);
        result2 += LookupCellRenderer.getStringWidth(presentation2.getTailText(), normalMetrics);
        String typeText = presentation2.getTypeText();
        if (StringUtil.isNotEmpty(typeText)) {
            result2 += LookupCellRenderer.getStringWidth("W", normalMetrics);
            result2 += LookupCellRenderer.getStringWidth(typeText, normalMetrics);
        }
        result2 += LookupCellRenderer.getStringWidth("W", boldMetrics);
        Icon typeIcon = presentation2.getTypeIcon();
        if (typeIcon != null) {
            result2 += typeIcon.getIconWidth();
        }
        return result2;
    }

    private static int getStringWidth(@Nullable String text2, FontMetrics metrics) {
        if (text2 != null) {
            return metrics.stringWidth(text2);
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customizer";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standard";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/impl/LookupCellRenderer";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fastPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/impl/LookupCellRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "removeVisibilityIfNeeded";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "removeVisibility";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addPresentationCustomizer";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcSpacing";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeVisibilityIfNeeded";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeVisibility";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "augmentIcon";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "itemAdded";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateItemPresentation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setIconInsets";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface IconDecorator
    extends Icon {
        @Nullable
        public Icon getDelegate();

        @NotNull
        public IconDecorator withDelegate(@Nullable Icon var1);
    }

    @ApiStatus.Internal
    public static interface ItemPresentationCustomizer {
        @NotNull
        public LookupElementPresentation customizePresentation(@NotNull LookupElement var1, @NotNull LookupElementPresentation var2);
    }

    private class LookupPanel
    extends SelectablePanel {
        boolean myUpdateExtender;

        LookupPanel() {
            this.setLayout(new BorderLayout());
            this.setBackground(BACKGROUND_COLOR);
            if (ExperimentalUI.isNewUI()) {
                Insets bodyInsets = LookupCellRenderer.bodyInsets();
                this.setBorder(new EmptyBorder(LookupCellRenderer.selectionInsets()));
                this.setSelectionInsets(new Insets(0, bodyInsets.left, 0, bodyInsets.right));
                this.setSelectionArc(JBUI.CurrentTheme.Popup.Selection.ARC.get());
            }
        }

        public void setUpdateExtender(boolean updateExtender) {
            this.myUpdateExtender = updateExtender;
        }

        public Dimension getPreferredSize() {
            return UIUtil.updateListRowHeight(super.getPreferredSize());
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (NON_FOCUSED_MASK_COLOR.getAlpha() > 0 && !LookupCellRenderer.this.myLookup.isFocused() && LookupCellRenderer.this.myLookup.isCompletion()) {
                g = g.create();
                try {
                    g.setColor(NON_FOCUSED_MASK_COLOR);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                finally {
                    g.dispose();
                }
            }
        }
    }

    private static final class MySimpleColoredComponent
    extends SimpleColoredComponent {
        private MySimpleColoredComponent() {
            this.setFocusBorderAroundIcon(true);
        }
    }
}

