/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.CtrlMouseAction;
import com.intellij.codeInsight.navigation.CtrlMouseResult;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u001c"}, d2={"checkRanges", "", "result", "Lcom/intellij/codeInsight/navigation/CtrlMouseResult;", "document", "Lcom/intellij/openapi/editor/Document;", "editorPoint", "Ljava/awt/Point;", "event", "Ljavax/swing/event/HyperlinkEvent;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getCtrlMouseAction", "Lcom/intellij/codeInsight/navigation/CtrlMouseAction;", "modifiers", "", "actionId", "", "showHint", "Lcom/intellij/ui/LightweightHint;", "hostEditor", "hostOffset", "component", "Ljavax/swing/JComponent;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "navigatable", "wrapInScrollPaneIfNeeded", "intellij.platform.lang.impl"})
public final class CtrlMouseHandlerKt {
    /*
     * WARNING - void declaration
     */
    private static final CtrlMouseAction getCtrlMouseAction(int modifiers) {
        void $this$mapNotNullTo$iv$iv;
        if (modifiers == 0) {
            return null;
        }
        KeymapManager keymapManager = KeymapManager.getInstance();
        if (keymapManager == null) {
            return null;
        }
        KeymapManager keymapManager2 = keymapManager;
        MouseShortcut shortcut = new MouseShortcut(1, modifiers, 1);
        List list2 = keymapManager2.getActiveKeymap().getActionIds(shortcut);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"keymapManager.activeKeymap.getActionIds(shortcut)");
        List actionIds = list2;
        Iterable $this$mapNotNull$iv = actionIds;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CtrlMouseAction ctrlMouseAction;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String p1 = (String)element$iv$iv;
            boolean bl2 = false;
            if (CtrlMouseHandlerKt.getCtrlMouseAction(p1) == null) continue;
            CtrlMouseAction it$iv$iv = ctrlMouseAction;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (CtrlMouseAction)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
    }

    private static final CtrlMouseAction getCtrlMouseAction(String actionId) {
        AnAction anAction = ActionManager.getInstance().getAction(actionId);
        if (!(anAction instanceof CtrlMouseAction)) {
            anAction = null;
        }
        return (CtrlMouseAction)anAction;
    }

    private static final boolean checkRanges(CtrlMouseResult result2, Document document) {
        boolean bl;
        block3: {
            TextRange docRange = new TextRange(0, document.getTextLength());
            Iterable $this$all$iv = result2.getRanges();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    TextRange range = (TextRange)element$iv;
                    boolean bl2 = false;
                    if (docRange.contains(range)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final LightweightHint showHint(Editor hostEditor, int hostOffset, JComponent component2) {
        LightweightHint hint = new LightweightHint(CtrlMouseHandlerKt.wrapInScrollPaneIfNeeded(component2, hostEditor));
        LogicalPosition logicalPosition = hostEditor.offsetToLogicalPosition(hostOffset);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"hostEditor.offsetToLogicalPosition(hostOffset)");
        LogicalPosition position = logicalPosition;
        short constraint = 1;
        Point p = HintManagerImpl.getHintPosition((LightweightHint)hint, (Editor)hostEditor, (LogicalPosition)position, (short)constraint);
        int n = p.y;
        JComponent jComponent = hint.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"hint.component");
        if (n - jComponent.getPreferredSize().height < 0) {
            constraint = 2;
            p = HintManagerImpl.getHintPosition((LightweightHint)hint, (Editor)hostEditor, (LogicalPosition)position, (short)constraint);
        }
        HintHint hintHint = HintManagerImpl.createHintHint((Editor)hostEditor, (Point)p, (LightweightHint)hint, (short)constraint).setContentActive(false);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, hostEditor, p, 42, 0, false, hintHint);
        return hint;
    }

    private static final JComponent wrapInScrollPaneIfNeeded(JComponent component2, Editor editor2) {
        JScrollPane jScrollPane;
        Rectangle rectangle = ScreenUtil.getScreenRectangle(editor2.getContentComponent());
        int n = 640;
        int n2 = rectangle.width;
        int maxWidth = (int)(0.9 * (double)Math.max(n, n2));
        n2 = 480;
        int n3 = rectangle.height;
        int maxHeight = (int)(0.33 * (double)Math.max(n2, n3));
        Dimension preferredSize = component2.getPreferredSize();
        if (preferredSize.width <= maxWidth && preferredSize.height <= maxHeight) {
            return component2;
        }
        JScrollPane it = jScrollPane = ScrollPaneFactory.createScrollPane((Component)component2, (boolean)true);
        boolean bl = false;
        JScrollPane jScrollPane2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane2, (String)"it");
        int n4 = preferredSize.width;
        int n5 = maxWidth;
        int n6 = Math.min(n4, n5);
        n4 = preferredSize.height;
        n5 = maxHeight;
        jScrollPane2.setPreferredSize(new Dimension(n6, Math.min(n4, n5)));
        JScrollPane jScrollPane3 = jScrollPane;
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane3, (String)"ScrollPaneFactory.create\u2026ht, maxHeight),\n    )\n  }");
        return jScrollPane3;
    }

    private static final TextAttributes textAttributes(boolean navigatable) {
        TextAttributes textAttributes;
        if (navigatable) {
            EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
            textAttributes = editorColorsManager.getGlobalScheme().getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR);
        } else {
            textAttributes = new TextAttributes(null, HintUtil.getInformationColor(), null, null, 0);
        }
        return textAttributes;
    }

    private static final Point editorPoint(HyperlinkEvent event, Editor editor2) {
        Point point;
        InputEvent inputEvent = event.getInputEvent();
        if (inputEvent == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.event.MouseEvent");
        }
        MouseEvent inputEvent2 = (MouseEvent)inputEvent;
        Point it = point = new Point(inputEvent2.getLocationOnScreen());
        boolean bl = false;
        SwingUtilities.convertPointFromScreen(it, editor2.getContentComponent());
        return point;
    }

    public static final /* synthetic */ Point access$editorPoint(HyperlinkEvent event, Editor editor2) {
        return CtrlMouseHandlerKt.editorPoint(event, editor2);
    }

    public static final /* synthetic */ CtrlMouseAction access$getCtrlMouseAction(int modifiers) {
        return CtrlMouseHandlerKt.getCtrlMouseAction(modifiers);
    }

    public static final /* synthetic */ boolean access$checkRanges(CtrlMouseResult result2, Document document) {
        return CtrlMouseHandlerKt.checkRanges(result2, document);
    }

    public static final /* synthetic */ TextAttributes access$textAttributes(boolean navigatable) {
        return CtrlMouseHandlerKt.textAttributes(navigatable);
    }

    public static final /* synthetic */ LightweightHint access$showHint(Editor hostEditor, int hostOffset, JComponent component2) {
        return CtrlMouseHandlerKt.showHint(hostEditor, hostOffset, component2);
    }
}

