/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.util.DefaultModuleRendererFactory;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.TargetPresentation;
import com.intellij.navigation.TargetPresentationBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.JBColor;
import com.intellij.util.TextWithIcon;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u000b*\u00020\u0013H\u0002\u001a\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0013H\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"CONTAINER_PATTERN", "Ljava/util/regex/Pattern;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "fileLocation", "Lcom/intellij/util/TextWithIcon;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileStatusAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "presentationError", "", "element", "Lcom/intellij/psi/PsiElement;", "targetPresentation", "Lcom/intellij/navigation/TargetPresentation;", "itemPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getColoredAttributes", "getContainerText", "", "intellij.platform.lang.impl"})
public final class UtilKt {
    private static final Logger LOG;
    private static final Pattern CONTAINER_PATTERN;

    @ApiStatus.Internal
    @NotNull
    public static final TargetPresentation targetPresentation(@NotNull ItemPresentation itemPresentation) {
        Intrinsics.checkNotNullParameter((Object)itemPresentation, (String)"itemPresentation");
        String string2 = itemPresentation.getPresentableText();
        if (string2 == null) {
            string2 = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"itemPresentation.presentableText ?: \"\"");
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(string2).icon(itemPresentation.getIcon(false)).presentableTextAttributes(UtilKt.getColoredAttributes(itemPresentation)).containerText(UtilKt.getContainerText(itemPresentation)).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"TargetPresentation\n    .\u2026xt())\n    .presentation()");
        return targetPresentation;
    }

    private static final TextAttributes getColoredAttributes(ItemPresentation $this$getColoredAttributes) {
        ColoredItemPresentation coloredPresentation;
        Object object;
        ItemPresentation itemPresentation = $this$getColoredAttributes;
        if (!(itemPresentation instanceof ColoredItemPresentation)) {
            itemPresentation = null;
        }
        if ((object = (coloredPresentation = (ColoredItemPresentation)itemPresentation)) == null || (object = object.getTextAttributesKey()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"coloredPresentation?.tex\u2026ributesKey ?: return null");
        Object textAttributesKey = object;
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        return editorColorsManager.getSchemeForCurrentUITheme().getAttributes((TextAttributesKey)textAttributesKey);
    }

    @Nls
    private static final String getContainerText(ItemPresentation $this$getContainerText) {
        String string2 = $this$getContainerText.getLocationString();
        if (string2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"locationString ?: return null");
        String locationString = string2;
        Matcher matcher = CONTAINER_PATTERN.matcher(locationString);
        return matcher.matches() ? matcher.group(2) : locationString;
    }

    @ApiStatus.Internal
    @NotNull
    public static final TargetPresentation targetPresentation(@NotNull PsiElement element2) {
        TextAttributes textAttributes;
        Color color;
        Object object;
        TargetPresentationBuilder targetPresentationBuilder;
        VirtualFile virtualFile2;
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Project project2 = element2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
        Project project3 = project2;
        PsiFile psiFile = element2.getContainingFile();
        VirtualFile file2 = psiFile != null ? psiFile.getVirtualFile() : null;
        PsiElement psiElement = element2;
        if (!(psiElement instanceof NavigationItem)) {
            psiElement = null;
        }
        NavigationItem navigationItem = (NavigationItem)((Object)psiElement);
        ItemPresentation itemPresentation = navigationItem != null ? navigationItem.getPresentation() : null;
        Object object4 = itemPresentation;
        if (object4 == null || (object4 = object4.getPresentableText()) == null) {
            PsiElement psiElement2 = element2;
            if (!(psiElement2 instanceof PsiNamedElement)) {
                psiElement2 = null;
            }
            PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement2;
            object4 = object3 = psiNamedElement != null ? psiNamedElement.getName() : null;
        }
        if (object4 == null) {
            object3 = object2 = element2.getText();
        }
        if (object3 == null) {
            boolean bl = false;
            UtilKt.presentationError(element2);
            object2 = ((Object)element2).toString();
        }
        Object presentableText2 = object2;
        TextWithIcon moduleTextWithIcon = PsiElementListCellRenderer.getModuleTextWithIcon(element2);
        TargetPresentationBuilder targetPresentationBuilder2 = TargetPresentation.Companion.builder((String)presentableText2);
        VirtualFile virtualFile3 = file2;
        if (virtualFile3 != null) {
            VirtualFile virtualFile4 = virtualFile2 = virtualFile3;
            targetPresentationBuilder = targetPresentationBuilder2;
            boolean bl = false;
            object = VfsPresentationUtil.getFileBackgroundColor((Project)project3, (VirtualFile)file2);
            targetPresentationBuilder2 = targetPresentationBuilder;
            color = object;
        } else {
            color = null;
        }
        ItemPresentation itemPresentation2 = itemPresentation;
        TargetPresentationBuilder targetPresentationBuilder3 = targetPresentationBuilder2.backgroundColor(color).icon(element2.getIcon(3)).presentableTextAttributes(itemPresentation2 != null ? UtilKt.getColoredAttributes(itemPresentation2) : null);
        ItemPresentation itemPresentation3 = itemPresentation;
        Object object5 = itemPresentation3 != null ? UtilKt.getContainerText(itemPresentation3) : null;
        VirtualFile virtualFile5 = file2;
        if (virtualFile5 != null) {
            VirtualFile it = virtualFile2 = virtualFile5;
            object = object5;
            targetPresentationBuilder = targetPresentationBuilder3;
            boolean bl = false;
            TextAttributes textAttributes2 = UtilKt.fileStatusAttributes(project3, file2);
            targetPresentationBuilder3 = targetPresentationBuilder;
            object5 = object;
            textAttributes = textAttributes2;
        } else {
            textAttributes = null;
        }
        TextWithIcon textWithIcon = moduleTextWithIcon;
        TextWithIcon textWithIcon2 = moduleTextWithIcon;
        TargetPresentation targetPresentation = targetPresentationBuilder3.containerText((String)object5, textAttributes).locationText(textWithIcon != null ? textWithIcon.getText() : null, textWithIcon2 != null ? textWithIcon2.getIcon() : null).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"TargetPresentation\n    .\u2026icon)\n    .presentation()");
        return targetPresentation;
    }

    private static final void presentationError(PsiElement element2) {
        Object object;
        PsiElement psiElement = element2;
        if (!(psiElement instanceof PomTargetPsiElement)) {
            psiElement = null;
        }
        if ((object = (PomTargetPsiElement)psiElement) == null || (object = object.getTarget()) == null) {
            object = element2;
        }
        Object instance2 = object;
        Class<?> clazz = instance2.getClass();
        LOG.error(PluginException.createByClass(clazz.getName() + " cannot be presented", null, clazz));
    }

    @ApiStatus.Experimental
    @Nullable
    public static final TextAttributes fileStatusAttributes(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project2).getStatus(file2);
        Color fileColor = fileStatus != null ? fileStatus.getColor() : null;
        boolean hasProblem = WolfTheProblemSolver.getInstance(project2).isProblemFile(file2);
        return hasProblem ? new TextAttributes(fileColor, null, JBColor.red, EffectType.WAVE_UNDERSCORE, 0) : (fileColor != null ? new TextAttributes(fileColor, null, null, null, 0) : null);
    }

    @ApiStatus.Experimental
    @Nullable
    public static final TextWithIcon fileLocation(@NotNull Project project2, @NotNull VirtualFile file2) {
        Module module;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectRootManager.getInstance(project).fileIndex");
        ProjectFileIndex fileIndex = projectFileIndex;
        return fileIndex.isInLibrary(file2) ? new DefaultModuleRendererFactory().libraryLocation(fileIndex, file2) : ((module = ModuleUtilCore.findModuleForFile(file2, project2)) != null ? DefaultModuleRendererFactory.projectLocation(file2, module, fileIndex) : null);
    }

    static {
        Logger logger = Logger.getInstance("#com.intellij.codeInsight.navigation");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#com\u2026.codeInsight.navigation\")");
        LOG = logger;
        Pattern pattern = Pattern.compile("(\\(in |\\()?([^)]*)(\\))?");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(\"(\\\\(in |\\\\()?([^)]*)(\\\\))?\")");
        CONTAINER_PATTERN = pattern;
    }
}

