/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateTextLexer;
import com.intellij.codeInsight.template.impl.TemplateTokenType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateBase
extends Template {
    @NotNull
    private String myString;
    @Nullable
    private Throwable myBuildingTemplateTrace;
    private String myTemplateText;
    private List<Segment> mySegments;
    private boolean toParseSegments = true;

    public void parseSegments() {
        IElementType tokenType;
        if (!this.toParseSegments) {
            return;
        }
        if (this.mySegments != null) {
            return;
        }
        this.mySegments = new SmartList<Segment>();
        StringBuilder buffer = new StringBuilder(this.myString.length());
        TemplateTextLexer lexer = new TemplateTextLexer();
        lexer.start(this.myString);
        while ((tokenType = lexer.getTokenType()) != null) {
            int start2 = lexer.getTokenStart();
            int end = lexer.getTokenEnd();
            String token = this.myString.substring(start2, end);
            if (tokenType == TemplateTokenType.VARIABLE) {
                String name2 = token.substring(1, token.length() - 1);
                Segment segment = new Segment(name2, buffer.length());
                this.mySegments.add(segment);
            } else if (tokenType == TemplateTokenType.ESCAPE_DOLLAR) {
                buffer.append("$");
            } else {
                buffer.append(token);
            }
            lexer.advance();
        }
        this.myTemplateText = buffer.toString();
    }

    protected List<Segment> getSegments() {
        return this.mySegments;
    }

    protected void setSegments(List<Segment> segments) {
        this.mySegments = segments;
    }

    protected boolean isToParseSegments() {
        return this.toParseSegments;
    }

    protected void setToParseSegments(boolean toParseSegments) {
        this.toParseSegments = toParseSegments;
    }

    @Override
    @NotNull
    public String getString() {
        this.parseSegments();
        String string2 = this.myString;
        if (string2 == null) {
            TemplateBase.$$$reportNull$$$0(0);
        }
        return string2;
    }

    protected String string() {
        return this.myString;
    }

    public void setString(@NotNull String string2) {
        if (string2 == null) {
            TemplateBase.$$$reportNull$$$0(1);
        }
        this.myString = StringUtil.convertLineSeparators(string2);
        this.mySegments = null;
        this.toParseSegments = true;
        this.myBuildingTemplateTrace = new Throwable();
    }

    @Override
    @NotNull
    public String getTemplateText() {
        this.parseSegments();
        String string2 = this.myTemplateText;
        if (string2 == null) {
            TemplateBase.$$$reportNull$$$0(2);
        }
        return string2;
    }

    protected String templateText() {
        return this.myTemplateText;
    }

    protected void setTemplateText(String templateText) {
        this.myTemplateText = templateText;
    }

    protected void setBuildingTemplateTrace(Throwable buildingTemplateTrace) {
        this.myBuildingTemplateTrace = buildingTemplateTrace;
    }

    @Nullable
    Throwable getBuildingTemplateTrace() {
        return this.myBuildingTemplateTrace;
    }

    int getVariableSegmentNumber(String variableName) {
        this.parseSegments();
        for (int i = 0; i < this.mySegments.size(); ++i) {
            Segment segment = this.mySegments.get(i);
            if (!segment.name.equals(variableName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addTextSegment(@NotNull String text2) {
        if (text2 == null) {
            TemplateBase.$$$reportNull$$$0(3);
        }
        text2 = StringUtil.convertLineSeparators(text2);
        this.myTemplateText = this.myTemplateText + text2;
    }

    @Override
    public void addVariableSegment(@NotNull String name2) {
        if (name2 == null) {
            TemplateBase.$$$reportNull$$$0(4);
        }
        this.mySegments.add(new Segment(name2, this.myTemplateText.length()));
    }

    @Override
    @NotNull
    public String getSegmentName(int i) {
        this.parseSegments();
        String string2 = this.mySegments.get((int)i).name;
        if (string2 == null) {
            TemplateBase.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Override
    public int getSegmentOffset(int i) {
        this.parseSegments();
        return this.mySegments.get((int)i).offset;
    }

    @Override
    public int getSegmentsCount() {
        this.parseSegments();
        return this.mySegments.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getString";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSegmentName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setString";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addTextSegment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addVariableSegment";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    protected static final class Segment {
        @NotNull
        public final String name;
        public final int offset;

        private Segment(@NotNull String name2, int offset) {
            if (name2 == null) {
                Segment.$$$reportNull$$$0(0);
            }
            this.name = name2;
            this.offset = offset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/template/impl/TemplateBase$Segment", "<init>"));
        }
    }
}

