/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.impl.TemplateTextLexer;
import com.intellij.codeInsight.template.impl.TemplateTokenType;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TemplateImplUtil {
    public static @NotNull LinkedHashSet<@NlsSafe String> parseVariableNames(@NotNull CharSequence text2) {
        IElementType tokenType;
        if (text2 == null) {
            TemplateImplUtil.$$$reportNull$$$0(0);
        }
        LinkedHashSet<String> variableNames = new LinkedHashSet<String>();
        TemplateTextLexer lexer = new TemplateTextLexer();
        lexer.start(text2);
        while ((tokenType = lexer.getTokenType()) != null) {
            if (tokenType == TemplateTokenType.VARIABLE) {
                int start2 = lexer.getTokenStart();
                int end = lexer.getTokenEnd();
                String name2 = text2.subSequence(start2 + 1, end - 1).toString();
                variableNames.add(name2);
            }
            lexer.advance();
        }
        LinkedHashSet<String> linkedHashSet = variableNames;
        if (linkedHashSet == null) {
            TemplateImplUtil.$$$reportNull$$$0(1);
        }
        return linkedHashSet;
    }

    @NotNull
    public static Map<String, Variable> parseVariables(@NotNull CharSequence text2) {
        if (text2 == null) {
            TemplateImplUtil.$$$reportNull$$$0(2);
        }
        LinkedHashMap<String, Variable> variables = new LinkedHashMap<String, Variable>();
        for (String name2 : TemplateImplUtil.parseVariableNames(text2)) {
            variables.put(name2, new Variable(name2, "", "", true));
        }
        LinkedHashMap<String, Variable> linkedHashMap = variables;
        if (linkedHashMap == null) {
            TemplateImplUtil.$$$reportNull$$$0(3);
        }
        return linkedHashMap;
    }

    public static boolean isValidVariableName(@NotNull String varName) {
        if (varName == null) {
            TemplateImplUtil.$$$reportNull$$$0(4);
        }
        return TemplateImplUtil.parseVariableNames("$" + varName + "$").contains(varName);
    }

    public static boolean isValidVariable(@Nullable String var) {
        return var != null && var.length() > 2 && StringUtil.startsWithChar(var, '$') && StringUtil.endsWithChar(var, '$') && TemplateImplUtil.isValidVariableName(var.substring(1, var.length() - 1));
    }

    public static TextRange findVariableAtOffset(@NotNull CharSequence text2, int offset) {
        if (text2 == null) {
            TemplateImplUtil.$$$reportNull$$$0(5);
        }
        TemplateTextLexer lexer = new TemplateTextLexer();
        lexer.start(text2);
        IElementType tokenType;
        while ((tokenType = lexer.getTokenType()) != null) {
            int end;
            int start2 = lexer.getTokenStart();
            if (start2 < offset && (end = lexer.getTokenEnd()) >= offset) {
                return tokenType == TemplateTokenType.VARIABLE ? new TextRange(start2 + 1, end - 1) : null;
            }
            lexer.advance();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateImplUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateImplUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVariableNames";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseVariableNames";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseVariables";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValidVariableName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findVariableAtOffset";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

