/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.openapi.diagnostic.Logger;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExMacro
extends MacroBase {
    private static final Logger LOG = Logger.getInstance(RegExMacro.class);

    public RegExMacro() {
        super("regularExpression", "regularExpression(String, Pattern, Replacement)");
    }

    @Override
    @Nullable
    protected Result calculateResult(Expression @NotNull [] params, ExpressionContext context2, boolean quick) {
        if (params == null) {
            RegExMacro.$$$reportNull$$$0(0);
        }
        if (params.length != 3) {
            return null;
        }
        Result value = params[0].calculateResult(context2);
        if (value == null) {
            return null;
        }
        Result pattern = params[1].calculateResult(context2);
        if (pattern == null) {
            return null;
        }
        Result replacement = params[2].calculateResult(context2);
        if (replacement == null) {
            return null;
        }
        try {
            return new TextResult(value.toString().replaceAll(pattern.toString(), replacement.toString()));
        }
        catch (IndexOutOfBoundsException e) {
            LOG.warn("Incorrect replacement value specified in Live Template '" + this.getName() + "' regularExpression() expression");
        }
        catch (PatternSyntaxException e) {
            LOG.warn("Incorrect regex specified in Live Template '" + this.getName() + "' regularExpression() expression");
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/RegExMacro", "calculateResult"));
    }
}

