/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.LiveTemplateCompletionContributor;
import com.intellij.codeInsight.template.postfix.completion.PostfixTemplateCompletionContributor;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.PostfixLiveTemplate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

class PostfixTemplatesCompletionProvider
extends CompletionProvider<CompletionParameters> {
    PostfixTemplatesCompletionProvider() {
    }

    @Override
    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
        if (parameters2 == null) {
            PostfixTemplatesCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            PostfixTemplatesCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            PostfixTemplatesCompletionProvider.$$$reportNull$$$0(2);
        }
        Editor editor2 = parameters2.getEditor();
        if (!PostfixTemplatesCompletionProvider.isCompletionEnabled(parameters2) || LiveTemplateCompletionContributor.shouldShowAllTemplates() || editor2.getCaretModel().getCaretCount() != 1) {
            return;
        }
        PsiFile originalFile = parameters2.getOriginalFile();
        PostfixLiveTemplate postfixLiveTemplate = PostfixTemplateCompletionContributor.getPostfixLiveTemplate(originalFile, editor2);
        if (postfixLiveTemplate != null) {
            postfixLiveTemplate.addCompletions(parameters2, result2.withPrefixMatcher(new MyPrefixMatcher(result2.getPrefixMatcher().getPrefix())));
            String possibleKey = postfixLiveTemplate.computeTemplateKeyWithoutContextChecking(new CustomTemplateCallback(editor2, originalFile));
            if (possibleKey != null) {
                result2 = result2.withPrefixMatcher(possibleKey);
                result2.restartCompletionOnPrefixChange(StandardPatterns.string().oneOf(postfixLiveTemplate.getAllTemplateKeys(originalFile, parameters2.getOffset())));
            }
        }
    }

    private static boolean isCompletionEnabled(@NotNull CompletionParameters parameters2) {
        if (parameters2 == null) {
            PostfixTemplatesCompletionProvider.$$$reportNull$$$0(3);
        }
        ProgressManager.checkCanceled();
        if (!parameters2.isAutoPopup()) {
            return false;
        }
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        return settings.isPostfixTemplatesEnabled() && settings.isTemplatesCompletionEnabled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/postfix/completion/PostfixTemplatesCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompletionEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyPrefixMatcher
    extends PrefixMatcher {
        protected MyPrefixMatcher(String prefix) {
            super(prefix);
        }

        @Override
        public boolean prefixMatches(@NotNull String name2) {
            if (name2 == null) {
                MyPrefixMatcher.$$$reportNull$$$0(0);
            }
            return name2.equalsIgnoreCase(this.myPrefix);
        }

        @Override
        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            if (prefix == null) {
                MyPrefixMatcher.$$$reportNull$$$0(1);
            }
            return new MyPrefixMatcher(prefix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/template/postfix/completion/PostfixTemplatesCompletionProvider$MyPrefixMatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prefixMatches";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cloneWithPrefix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

