/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.DynamicBundle;
import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.impl.LiveTemplateCompletionContributor;
import com.intellij.codeInsight.template.postfix.settings.PostfixDescriptionPanel;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplateMetaData;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplateStorage;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesCheckboxTree;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.LanguagePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Alarm;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostfixTemplatesConfigurable
implements SearchableConfigurable,
EditorOptionsProvider,
Configurable.NoScroll,
Configurable.WithEpDependencies {
    public static final Comparator<PostfixTemplate> TEMPLATE_COMPARATOR = Comparator.comparing(PostfixTemplate::getKey);
    @Nullable
    private PostfixTemplatesCheckboxTree myCheckboxTree;
    @NotNull
    private final PostfixTemplatesSettings myTemplatesSettings;
    @Nullable
    private PostfixDescriptionPanel myInnerPostfixDescriptionPanel;
    private JComponent myPanel;
    private JBCheckBox myCompletionEnabledCheckbox;
    private JBCheckBox myPostfixTemplatesEnabled;
    private JPanel myTemplatesTreeContainer;
    private ComboBox<String> myShortcutComboBox;
    private JPanel myDescriptionPanel;
    private final Alarm myUpdateDescriptionPanelAlarm;

    public PostfixTemplatesConfigurable() {
        this.$$$setupUI$$$();
        this.myUpdateDescriptionPanelAlarm = new Alarm();
        this.myTemplatesSettings = PostfixTemplatesSettings.getInstance();
        this.myPostfixTemplatesEnabled.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PostfixTemplatesConfigurable.this.updateComponents();
            }
        });
        this.myShortcutComboBox.addItem((Object)PostfixTemplatesConfigurable.getTab());
        this.myShortcutComboBox.addItem((Object)PostfixTemplatesConfigurable.getSpace());
        this.myShortcutComboBox.addItem((Object)PostfixTemplatesConfigurable.getEnter());
        this.myDescriptionPanel.setLayout(new BorderLayout());
    }

    @NotNull
    public Collection<BaseExtensionPointName<?>> getDependencies() {
        Set<BaseExtensionPointName<?>> set2 = Collections.singleton(LanguagePostfixTemplate.EP_NAME);
        if (set2 == null) {
            PostfixTemplatesConfigurable.$$$reportNull$$$0(0);
        }
        return set2;
    }

    @NotNull
    private static List<PostfixTemplateProvider> getProviders() {
        List<LanguageExtensionPoint> list2 = LanguagePostfixTemplate.EP_NAME.getExtensionList();
        List<PostfixTemplateProvider> list3 = ContainerUtil.map(list2, el -> (PostfixTemplateProvider)el.getInstance());
        if (list3 == null) {
            PostfixTemplatesConfigurable.$$$reportNull$$$0(1);
        }
        return list3;
    }

    private void createTree() {
        this.myCheckboxTree = new PostfixTemplatesCheckboxTree(){

            @Override
            protected void selectionChanged() {
                PostfixTemplatesConfigurable.this.myUpdateDescriptionPanelAlarm.cancelAllRequests();
                PostfixTemplatesConfigurable.this.myUpdateDescriptionPanelAlarm.addRequest(() -> PostfixTemplatesConfigurable.this.resetDescriptionPanel(), 100);
            }
        };
        JPanel panel2 = new JPanel(new BorderLayout());
        boolean canAddTemplate = ContainerUtil.find(PostfixTemplatesConfigurable.getProviders(), p -> StringUtil.isNotEmpty(p.getPresentableName())) != null;
        panel2.add(ToolbarDecorator.createDecorator((JTree)((Object)this.myCheckboxTree)).setAddActionUpdater(e -> canAddTemplate).setAddAction(button2 -> this.myCheckboxTree.addTemplate((AnActionButton)button2)).setAddIcon(LayeredIcon.ADD_WITH_DROPDOWN).setEditActionUpdater(e -> this.myCheckboxTree.canEditSelectedTemplate()).setEditAction(button2 -> this.myCheckboxTree.editSelectedTemplate()).setRemoveActionUpdater(e -> this.myCheckboxTree.canRemoveSelectedTemplates()).setRemoveAction(button2 -> this.myCheckboxTree.removeSelectedTemplates()).addExtraAction(this.duplicateAction()).createPanel());
        this.myTemplatesTreeContainer.setLayout(new BorderLayout());
        this.myTemplatesTreeContainer.add(panel2);
    }

    private AnActionButton duplicateAction() {
        AnActionButton button2 = new AnActionButton(CodeInsightBundle.messagePointer("action.AnActionButton.text.duplicate", new Object[0]), PlatformIcons.COPY_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (PostfixTemplatesConfigurable.this.myCheckboxTree != null) {
                    PostfixTemplatesConfigurable.this.myCheckboxTree.duplicateSelectedTemplate();
                }
            }

            public void updateButton(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(PostfixTemplatesConfigurable.this.myCheckboxTree != null && PostfixTemplatesConfigurable.this.myCheckboxTree.canDuplicateSelectedTemplate());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesConfigurable$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateButton";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        button2.registerCustomShortcutSet(CommonShortcuts.getDuplicate(), (JComponent)((Object)this.myCheckboxTree), (Disposable)this.myCheckboxTree);
        return button2;
    }

    private void resetDescriptionPanel() {
        if (null != this.myCheckboxTree && null != this.myInnerPostfixDescriptionPanel) {
            this.myInnerPostfixDescriptionPanel.reset(PostfixTemplateMetaData.createMetaData(this.myCheckboxTree.getSelectedTemplate()));
            this.myInnerPostfixDescriptionPanel.resetHeights(this.myDescriptionPanel.getWidth());
        }
    }

    @NotNull
    public String getId() {
        return "reference.settingsdialog.IDE.editor.postfix.templates";
    }

    @Nullable
    public String getHelpTopic() {
        return this.getId();
    }

    @Nls
    public String getDisplayName() {
        return CodeInsightBundle.message("configurable.PostfixTemplatesConfigurable.display.name", new Object[0]);
    }

    @Nullable
    public PostfixTemplatesCheckboxTree getTemplatesTree() {
        return this.myCheckboxTree;
    }

    @NotNull
    public JComponent createComponent() {
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myPanel);
        if (null == this.myInnerPostfixDescriptionPanel) {
            this.myInnerPostfixDescriptionPanel = new PostfixDescriptionPanel();
            this.myDescriptionPanel.add(this.myInnerPostfixDescriptionPanel.getComponent());
        }
        if (null == this.myCheckboxTree) {
            this.createTree();
        }
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            PostfixTemplatesConfigurable.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    public void apply() {
        if (this.myCheckboxTree != null) {
            this.myTemplatesSettings.setProviderToDisabledTemplates(this.myCheckboxTree.getDisabledTemplatesState());
            this.myTemplatesSettings.setPostfixTemplatesEnabled(this.myPostfixTemplatesEnabled.isSelected());
            this.myTemplatesSettings.setTemplatesCompletionEnabled(this.myCompletionEnabledCheckbox.isSelected());
            this.myTemplatesSettings.setShortcut(PostfixTemplatesConfigurable.stringToShortcut((String)this.myShortcutComboBox.getSelectedItem()));
            MultiMap<PostfixTemplateProvider, PostfixTemplate> state = this.myCheckboxTree.getEditableTemplates();
            for (PostfixTemplateProvider provider2 : PostfixTemplatesConfigurable.getProviders()) {
                PostfixTemplateStorage.getInstance().setTemplates(provider2, state.get(provider2));
            }
        }
    }

    public void reset() {
        if (this.myCheckboxTree != null) {
            MultiMap<PostfixTemplateProvider, PostfixTemplate> templatesMap = PostfixTemplatesConfigurable.getProviderToTemplatesMap();
            this.myCheckboxTree.initTree(templatesMap);
            this.myCheckboxTree.setDisabledTemplatesState(this.myTemplatesSettings.getProviderToDisabledTemplates());
            this.myPostfixTemplatesEnabled.setSelected(this.myTemplatesSettings.isPostfixTemplatesEnabled());
            this.myCompletionEnabledCheckbox.setSelected(this.myTemplatesSettings.isTemplatesCompletionEnabled());
            this.myShortcutComboBox.setSelectedItem((Object)PostfixTemplatesConfigurable.shortcutToString((char)this.myTemplatesSettings.getShortcut()));
            this.resetDescriptionPanel();
            this.updateComponents();
        }
    }

    @NotNull
    private static MultiMap<PostfixTemplateProvider, PostfixTemplate> getProviderToTemplatesMap() {
        MultiMap<PostfixTemplateProvider, PostfixTemplate> templatesMap = MultiMap.create();
        for (LanguageExtensionPoint extension2 : LanguagePostfixTemplate.EP_NAME.getExtensionList()) {
            PostfixTemplateProvider provider2 = (PostfixTemplateProvider)extension2.getInstance();
            Set<PostfixTemplate> templates = PostfixTemplatesUtils.getAvailableTemplates(provider2);
            if (templates.isEmpty()) continue;
            templatesMap.putValues(provider2, ContainerUtil.sorted(templates, TEMPLATE_COMPARATOR));
        }
        MultiMap<PostfixTemplateProvider, PostfixTemplate> multiMap = templatesMap;
        if (multiMap == null) {
            PostfixTemplatesConfigurable.$$$reportNull$$$0(3);
        }
        return multiMap;
    }

    public boolean isModified() {
        if (this.myCheckboxTree == null) {
            return false;
        }
        if (this.myPostfixTemplatesEnabled.isSelected() != this.myTemplatesSettings.isPostfixTemplatesEnabled() || this.myCompletionEnabledCheckbox.isSelected() != this.myTemplatesSettings.isTemplatesCompletionEnabled() || PostfixTemplatesConfigurable.stringToShortcut((String)this.myShortcutComboBox.getSelectedItem()) != this.myTemplatesSettings.getShortcut() || !this.myCheckboxTree.getDisabledTemplatesState().equals(this.myTemplatesSettings.getProviderToDisabledTemplates())) {
            return true;
        }
        MultiMap<PostfixTemplateProvider, PostfixTemplate> state = this.myCheckboxTree.getEditableTemplates();
        for (PostfixTemplateProvider provider2 : PostfixTemplatesConfigurable.getProviders()) {
            if (PostfixTemplateStorage.getInstance().getTemplates(provider2).equals(state.get(provider2))) continue;
            return true;
        }
        return false;
    }

    public void disposeUIResources() {
        if (this.myInnerPostfixDescriptionPanel != null) {
            Disposer.dispose(this.myInnerPostfixDescriptionPanel);
        }
        if (this.myCheckboxTree != null) {
            Disposer.dispose(this.myCheckboxTree);
            this.myCheckboxTree = null;
        }
        Disposer.dispose((Disposable)this.myUpdateDescriptionPanelAlarm);
    }

    private void updateComponents() {
        boolean pluginEnabled = this.myPostfixTemplatesEnabled.isSelected();
        this.myCompletionEnabledCheckbox.setVisible(!LiveTemplateCompletionContributor.shouldShowAllTemplates());
        this.myCompletionEnabledCheckbox.setEnabled(pluginEnabled);
        this.myShortcutComboBox.setEnabled(pluginEnabled);
        if (this.myCheckboxTree != null) {
            this.myCheckboxTree.setEnabled(pluginEnabled);
        }
    }

    private static char stringToShortcut(@Nullable String string2) {
        if (PostfixTemplatesConfigurable.getSpace().equals(string2)) {
            return ' ';
        }
        if (PostfixTemplatesConfigurable.getEnter().equals(string2)) {
            return '\n';
        }
        return '\t';
    }

    @NlsContexts.ListItem
    private static String shortcutToString(char shortcut) {
        if (shortcut == ' ') {
            return PostfixTemplatesConfigurable.getSpace();
        }
        if (shortcut == '\n') {
            return PostfixTemplatesConfigurable.getEnter();
        }
        return PostfixTemplatesConfigurable.getTab();
    }

    @NlsContexts.ListItem
    private static String getSpace() {
        return CodeInsightBundle.message("template.shortcut.space", new Object[0]);
    }

    @NlsContexts.ListItem
    private static String getTab() {
        return CodeInsightBundle.message("template.shortcut.tab", new Object[0]);
    }

    @NlsContexts.ListItem
    private static String getEnter() {
        return CodeInsightBundle.message("template.shortcut.enter", new Object[0]);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        ComboBox comboBox;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JPanel jPanel3 = new JPanel();
        this.myPanel = jPanel3;
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPostfixTemplatesEnabled = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle("messages/CodeInsightBundle", PostfixTemplatesConfigurable.class).getString("postfix.completion.option.enabled"));
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 2, 1, 1, 3, 1, null, null, null));
        this.myCompletionEnabledCheckbox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle("messages/CodeInsightBundle", PostfixTemplatesConfigurable.class).getString("postfix.completion.option.autopopup"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle("messages/CodeInsightBundle", PostfixTemplatesConfigurable.class).getString("postfix.completion.expand"));
        jPanel3.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 1, null, null, null, 1));
        this.myShortcutComboBox = comboBox = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        comboBox.setModel(defaultComboBoxModel);
        jPanel3.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JSplitPane jSplitPane = new JSplitPane();
        jPanel4.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        this.myTemplatesTreeContainer = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel2);
        this.myDescriptionPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel);
        jBLabel.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '&') {
                if (++i == string2.length()) break;
                if (!bl && string2.charAt(i) != '&') {
                    bl = true;
                    c = string2.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '&') {
                if (++i == string2.length()) break;
                if (!bl && string2.charAt(i) != '&') {
                    bl = true;
                    c = string2.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderToTemplatesMap";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

