/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.NonAsciiCharactersInspectionFormUi;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.usages.ChunkExtractor;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonAsciiCharactersInspection
extends LocalInspectionTool {
    public boolean CHECK_FOR_NOT_ASCII_IDENTIFIER_NAME = true;
    public boolean CHECK_FOR_NOT_ASCII_STRING_LITERAL;
    public boolean CHECK_FOR_NOT_ASCII_COMMENT;
    public boolean CHECK_FOR_NOT_ASCII_IN_ANY_OTHER_WORD;
    public boolean CHECK_FOR_DIFFERENT_LANGUAGES_IN_IDENTIFIER_NAME = true;
    public boolean CHECK_FOR_DIFFERENT_LANGUAGES_IN_STRING;
    public boolean CHECK_FOR_DIFFERENT_LANGUAGES_IN_COMMENTS;
    public boolean CHECK_FOR_DIFFERENT_LANGUAGES_IN_ANY_OTHER_WORD;
    public boolean CHECK_FOR_FILES_CONTAINING_BOM;

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string2 = InspectionsBundle.message("group.names.internationalization.issues", new Object[0]);
        if (string2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    @NonNls
    @NotNull
    public String getShortName() {
        return "NonAsciiCharacters";
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        PsiFile file2;
        if (holder == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(2);
        }
        if (!NonAsciiCharactersInspection.isFileWorthIt(file2 = session.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                NonAsciiCharactersInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        final SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)file2.getFileType(), (Project)file2.getProject(), (VirtualFile)file2.getVirtualFile());
        return new PsiElementVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(element2 instanceof LeafElement) || element2 instanceof PsiWhiteSpace) {
                    return;
                }
                PsiElementKind kind = NonAsciiCharactersInspection.getKind(element2, syntaxHighlighter);
                switch (kind) {
                    case STRING: {
                        TextRange valueRange;
                        if (!NonAsciiCharactersInspection.this.CHECK_FOR_NOT_ASCII_STRING_LITERAL && !NonAsciiCharactersInspection.this.CHECK_FOR_DIFFERENT_LANGUAGES_IN_STRING) break;
                        String text2 = element2.getText();
                        TextRange textRange = valueRange = StringUtil.isQuotedString(text2) ? new TextRange(1, text2.length() - 1) : null;
                        if (NonAsciiCharactersInspection.this.CHECK_FOR_DIFFERENT_LANGUAGES_IN_STRING) {
                            NonAsciiCharactersInspection.reportMixedLanguages(element2, text2, holder, valueRange);
                        }
                        if (!NonAsciiCharactersInspection.this.CHECK_FOR_NOT_ASCII_STRING_LITERAL) break;
                        NonAsciiCharactersInspection.reportNonAsciiRange(element2, text2, holder, valueRange);
                        break;
                    }
                    case IDENTIFIER: {
                        if (NonAsciiCharactersInspection.this.CHECK_FOR_NOT_ASCII_IDENTIFIER_NAME) {
                            NonAsciiCharactersInspection.reportNonAsciiRange(element2, element2.getText(), holder, null);
                        }
                        if (!NonAsciiCharactersInspection.this.CHECK_FOR_DIFFERENT_LANGUAGES_IN_IDENTIFIER_NAME) break;
                        NonAsciiCharactersInspection.reportMixedLanguages(element2, element2.getText(), holder, null);
                        break;
                    }
                    case COMMENT: {
                        if (!NonAsciiCharactersInspection.this.CHECK_FOR_NOT_ASCII_COMMENT && !NonAsciiCharactersInspection.this.CHECK_FOR_DIFFERENT_LANGUAGES_IN_COMMENTS) break;
                        String text3 = element2.getText();
                        TextRange valueRange = NonAsciiCharactersInspection.getCommentRange(element2, text3);
                        if (NonAsciiCharactersInspection.this.CHECK_FOR_NOT_ASCII_COMMENT) {
                            NonAsciiCharactersInspection.reportNonAsciiRange(element2, text3, holder, valueRange);
                        }
                        if (!NonAsciiCharactersInspection.this.CHECK_FOR_DIFFERENT_LANGUAGES_IN_COMMENTS) break;
                        NonAsciiCharactersInspection.reportMixedLanguages(element2, text3, holder, valueRange);
                        break;
                    }
                    case OTHER: {
                        String text4;
                        if (NonAsciiCharactersInspection.this.CHECK_FOR_NOT_ASCII_IN_ANY_OTHER_WORD) {
                            text4 = element2.getText();
                            NonAsciiCharactersInspection.iterateWordsInLeafElement(text4, range -> NonAsciiCharactersInspection.reportMixedLanguages(element2, text4, holder, range));
                        }
                        if (!NonAsciiCharactersInspection.this.CHECK_FOR_DIFFERENT_LANGUAGES_IN_ANY_OTHER_WORD) break;
                        text4 = element2.getText();
                        NonAsciiCharactersInspection.iterateWordsInLeafElement(text4, range -> NonAsciiCharactersInspection.reportMixedLanguages(element2, text4, holder, range));
                    }
                }
            }

            @Override
            public void visitFile(@NotNull PsiFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitFile(file2);
                if (NonAsciiCharactersInspection.this.CHECK_FOR_FILES_CONTAINING_BOM) {
                    NonAsciiCharactersInspection.checkBOM(file2, holder);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/NonAsciiCharactersInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static void iterateWordsInLeafElement(@NotNull String text2, @NotNull Consumer<? super TextRange> consumer) {
        int c;
        if (text2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(5);
        }
        int start2 = -1;
        for (int i = 0; i <= text2.length(); i += Character.charCount(c)) {
            c = i == text2.length() ? -1 : text2.codePointAt(i);
            boolean isIdentifierPart = Character.isJavaIdentifierPart(c);
            if (isIdentifierPart && start2 == -1) {
                start2 = i;
            }
            if (isIdentifierPart || start2 == -1) continue;
            consumer.accept(new TextRange(start2, i));
            start2 = -1;
        }
    }

    private static TextRange getCommentRange(@NotNull PsiElement comment, @NotNull String text2) {
        Language language;
        Commenter commenter;
        if (comment == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(6);
        }
        if (text2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(7);
        }
        if ((commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language = comment.getLanguage())) == null) {
            return null;
        }
        for (String prefix : commenter.getLineCommentPrefixes()) {
            if (!StringUtil.startsWith(text2, prefix)) continue;
            return new TextRange(prefix.length(), text2.length());
        }
        String blockCommentPrefix = commenter.getBlockCommentPrefix();
        if (blockCommentPrefix != null && StringUtil.startsWith(text2, blockCommentPrefix)) {
            String suffix = commenter.getBlockCommentSuffix();
            int endOffset = text2.length() - (suffix != null && StringUtil.endsWith(text2, blockCommentPrefix.length(), text2.length(), suffix) ? suffix.length() : 0);
            return new TextRange(blockCommentPrefix.length(), endOffset);
        }
        return null;
    }

    private static void checkBOM(@NotNull PsiFile file2, @NotNull ProblemsHolder holder) {
        byte[] bom;
        if (file2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(9);
        }
        if (file2.getViewProvider().getBaseLanguage() != file2.getLanguage()) {
            return;
        }
        VirtualFile virtualFile2 = file2.getVirtualFile();
        byte[] byArray = bom = virtualFile2 == null ? null : virtualFile2.getBOM();
        if (bom != null) {
            String hex = IntStream.range(0, bom.length).map(i -> bom[i]).mapToObj(b -> StringUtil.toUpperCase(Integer.toString(b & 0xFF, 16))).collect(Collectors.joining());
            Charset charsetFromBOM = CharsetToolkit.guessFromBOM(bom);
            String signature = charsetFromBOM == null ? "" : CodeInsightBundle.message("non.ascii.chars.inspection.message.charset.signature", charsetFromBOM.displayName());
            holder.registerProblem((PsiElement)file2, CodeInsightBundle.message("non.ascii.chars.inspection.message.file.contains.bom", hex, signature), new LocalQuickFix[0]);
        }
    }

    private static boolean isIdentifier(@NotNull PsiElement element2) {
        PsiElement identifier;
        if (element2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(10);
        }
        if (element2 instanceof ForeignLeafPsiElement) {
            return false;
        }
        PsiElement parent = element2.getParent();
        if (parent instanceof PsiNameIdentifierOwner && (identifier = ((PsiNameIdentifierOwner)parent).getNameIdentifier()) != null) {
            String text2 = element2.getText();
            return identifier == element2 || text2.equals(identifier.getText());
        }
        if (parent instanceof PsiReference) {
            PsiElement refElement = ((PsiReference)((Object)parent)).getElement();
            return refElement == parent || refElement == element2;
        }
        return false;
    }

    private static boolean isFileWorthIt(@NotNull PsiFile file2) {
        if (file2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(11);
        }
        if (InjectedLanguageManager.getInstance(file2.getProject()).isInjectedFragment(file2)) {
            return false;
        }
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return false;
        }
        CharSequence text2 = file2.getViewProvider().getContents();
        Charset charset = LoadTextUtil.extractCharsetFromFileContent(file2.getProject(), virtualFile2, text2);
        return !(charset instanceof Native2AsciiCharset);
    }

    private static boolean isAsciiCodePoint(int codePoint) {
        return codePoint < 128;
    }

    private static void reportMixedLanguages(@NotNull PsiElement element2, @NotNull String text2, @NotNull ProblemsHolder holder, @Nullable(value="null means natural range") @Nullable(value="null means natural range") TextRange elementRange) {
        int startOffset;
        int codePoint;
        if (element2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(12);
        }
        if (text2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(13);
        }
        if (holder == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(14);
        }
        int nonAsciiStart = -1;
        int endOffset = elementRange == null ? text2.length() : elementRange.getEndOffset();
        for (int i = startOffset = elementRange == null ? 0 : elementRange.getStartOffset(); i <= endOffset; i += Character.charCount(codePoint)) {
            int n = codePoint = i == endOffset ? 0 : text2.codePointAt(i);
            if (codePoint != 0 && NonAsciiCharactersInspection.ignoreScript(Character.UnicodeScript.of(codePoint))) {
                if (i != startOffset) continue;
                ++startOffset;
                continue;
            }
            if (NonAsciiCharactersInspection.isAsciiCodePoint(codePoint)) {
                int j;
                boolean isHighlightWholeWord;
                boolean bl = isHighlightWholeWord = i - nonAsciiStart == endOffset - startOffset;
                if (nonAsciiStart == -1 || isHighlightWholeWord) continue;
                for (j = i; j > nonAsciiStart && NonAsciiCharactersInspection.ignoreScript(Character.UnicodeScript.of(codePoint = text2.codePointAt(j - Character.charCount(codePoint)))); j -= Character.charCount(codePoint)) {
                }
                holder.registerProblem(element2, new TextRange(nonAsciiStart, j), CodeInsightBundle.message("non.ascii.chars.inspection.message.symbols.from.different.languages.found", new Object[0]), new LocalQuickFix[0]);
                nonAsciiStart = -1;
                continue;
            }
            if (nonAsciiStart != -1) continue;
            nonAsciiStart = i;
        }
    }

    private static boolean ignoreScript(@NotNull Character.UnicodeScript script) {
        if (script == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(15);
        }
        return script == Character.UnicodeScript.COMMON || script == Character.UnicodeScript.INHERITED;
    }

    private static void reportNonAsciiRange(@NotNull PsiElement element2, @NotNull String text2, @NotNull ProblemsHolder holder, @Nullable(value="null means natural range") @Nullable(value="null means natural range") TextRange elementRange) {
        if (element2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(16);
        }
        if (text2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(17);
        }
        if (holder == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(18);
        }
        int errorCount = 0;
        int start2 = -1;
        int startOffset = elementRange == null ? 0 : elementRange.getStartOffset();
        int endOffset = elementRange == null ? text2.length() : elementRange.getEndOffset();
        for (int i = startOffset; i <= endOffset; ++i) {
            char c;
            char c2 = c = i >= endOffset ? (char)'\u0000' : text2.charAt(i);
            if (i == endOffset || c < '\u0080') {
                if (start2 == -1) continue;
                TextRange range = new TextRange(start2, i);
                holder.registerProblem(element2, range, CodeInsightBundle.message("non.ascii.chars.inspection.message.non.ascii.characters", new Object[0]), new LocalQuickFix[0]);
                start2 = -1;
                if (errorCount++ <= 200) continue;
                break;
            }
            if (start2 != -1) continue;
            start2 = i;
        }
    }

    @Override
    @NotNull
    public JComponent createOptionsPanel() {
        DialogPanel dialogPanel = new NonAsciiCharactersInspectionFormUi(this).getPanel();
        if (dialogPanel == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(19);
        }
        return dialogPanel;
    }

    @NotNull
    private static PsiElementKind getKind(@NotNull PsiElement element2, @Nullable SyntaxHighlighter syntaxHighlighter) {
        TextAttributesKey[] keys2;
        if (element2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(20);
        }
        if (element2.getParent() instanceof PsiLiteralValue || ChunkExtractor.isHighlightedAsString((TextAttributesKey[])(keys2 = syntaxHighlighter == null ? TextAttributesKey.EMPTY_ARRAY : syntaxHighlighter.getTokenHighlights(((LeafElement)((Object)element2)).getElementType())))) {
            PsiElementKind psiElementKind = PsiElementKind.STRING;
            if (psiElementKind == null) {
                NonAsciiCharactersInspection.$$$reportNull$$$0(21);
            }
            return psiElementKind;
        }
        if (element2 instanceof PsiComment || ChunkExtractor.isHighlightedAsComment((TextAttributesKey[])keys2)) {
            PsiElementKind psiElementKind = PsiElementKind.COMMENT;
            if (psiElementKind == null) {
                NonAsciiCharactersInspection.$$$reportNull$$$0(22);
            }
            return psiElementKind;
        }
        if (NonAsciiCharactersInspection.isIdentifier(element2)) {
            PsiElementKind psiElementKind = PsiElementKind.IDENTIFIER;
            if (psiElementKind == null) {
                NonAsciiCharactersInspection.$$$reportNull$$$0(23);
            }
            return psiElementKind;
        }
        PsiElementKind psiElementKind = PsiElementKind.OTHER;
        if (psiElementKind == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(24);
        }
        return psiElementKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/NonAsciiCharactersInspection";
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: 
            case 7: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 12: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/NonAsciiCharactersInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "iterateWordsInLeafElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCommentRange";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkBOM";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifier";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFileWorthIt";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reportMixedLanguages";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "ignoreScript";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "reportNonAsciiRange";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static enum PsiElementKind {
        IDENTIFIER,
        STRING,
        COMMENT,
        OTHER;

    }
}

