/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.lang.ir;

import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.lang.ir.LiveVariablesAnalyzer;
import com.intellij.codeInspection.dataFlow.lang.ir.LoopAnalyzer;
import com.intellij.codeInspection.dataFlow.lang.ir.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.SpliceInstruction;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.FList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ControlFlow {
    @NotNull
    private final List<Instruction> myInstructions;
    @NotNull
    private final Object2IntMap<PsiElement> myElementToStartOffsetMap;
    @NotNull
    private final Object2IntMap<PsiElement> myElementToEndOffsetMap;
    @NotNull
    private final DfaValueFactory myFactory;
    @NotNull
    private final PsiElement myPsiAnchor;
    private int[] myLoopNumbers;

    public ControlFlow(@NotNull DfaValueFactory factory2, @NotNull PsiElement psiAnchor) {
        if (factory2 == null) {
            ControlFlow.$$$reportNull$$$0(0);
        }
        if (psiAnchor == null) {
            ControlFlow.$$$reportNull$$$0(1);
        }
        this.myFactory = factory2;
        this.myPsiAnchor = psiAnchor;
        this.myInstructions = new ArrayList<Instruction>();
        this.myElementToEndOffsetMap = new Object2IntOpenHashMap<PsiElement>();
        this.myElementToStartOffsetMap = new Object2IntOpenHashMap<PsiElement>();
    }

    public ControlFlow(@NotNull ControlFlow flow2, @NotNull DfaValueFactory factory2) {
        if (flow2 == null) {
            ControlFlow.$$$reportNull$$$0(2);
        }
        if (factory2 == null) {
            ControlFlow.$$$reportNull$$$0(3);
        }
        this.myFactory = factory2;
        this.myPsiAnchor = flow2.myPsiAnchor;
        this.myElementToEndOffsetMap = flow2.myElementToEndOffsetMap;
        this.myElementToStartOffsetMap = flow2.myElementToStartOffsetMap;
        this.myLoopNumbers = flow2.myLoopNumbers;
        this.myInstructions = StreamEx.of(flow2.myInstructions).map(instruction -> {
            Instruction updated = instruction.bindToFactory(factory2);
            if (updated.getIndex() == -1) {
                updated.setIndex(instruction.getIndex());
            }
            return updated;
        }).toImmutableList();
    }

    @NotNull
    public PsiElement getPsiAnchor() {
        PsiElement psiElement = this.myPsiAnchor;
        if (psiElement == null) {
            ControlFlow.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    public Instruction[] getInstructions() {
        return this.myInstructions.toArray(new Instruction[0]);
    }

    public Instruction getInstruction(int index) {
        return this.myInstructions.get(index);
    }

    public int getInstructionCount() {
        return this.myInstructions.size();
    }

    public ControlFlowOffset getNextOffset() {
        return new FixedOffset(this.myInstructions.size());
    }

    public void startElement(PsiElement psiElement) {
        this.myElementToStartOffsetMap.put(psiElement, this.myInstructions.size());
    }

    public void finishElement(PsiElement psiElement) {
        this.myElementToEndOffsetMap.put(psiElement, this.myInstructions.size());
    }

    public void addInstruction(Instruction instruction) {
        instruction.setIndex(this.myInstructions.size());
        this.myInstructions.add(instruction);
    }

    public int[] getLoopNumbers() {
        return this.myLoopNumbers;
    }

    public void finish() {
        try {
            this.addInstruction(new ReturnInstruction(this.myFactory, FList.emptyList(), null));
            this.myLoopNumbers = LoopAnalyzer.calcInLoop(this);
            new LiveVariablesAnalyzer(this).flushDeadVariablesOnStatementFinish();
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new RuntimeExceptionWithAttachments(ex, new Attachment("flow.txt", this.toString()));
        }
    }

    public ControlFlowOffset getStartOffset(PsiElement element2) {
        return new FromMapOffset(element2, this.myElementToStartOffsetMap);
    }

    public ControlFlowOffset getEndOffset(PsiElement element2) {
        return new FromMapOffset(element2, this.myElementToEndOffsetMap);
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        List<Instruction> instructions = this.myInstructions;
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            result2.append(i).append(": ").append(instruction.toString());
            result2.append("\n");
        }
        return result2.toString();
    }

    public void makeNop(int index) {
        SpliceInstruction instruction = new SpliceInstruction(0, new int[0]);
        instruction.setIndex(index);
        this.myInstructions.set(index, instruction);
    }

    @NotNull
    public DfaValueFactory getFactory() {
        DfaValueFactory dfaValueFactory = this.myFactory;
        if (dfaValueFactory == null) {
            ControlFlow.$$$reportNull$$$0(5);
        }
        return dfaValueFactory;
    }

    public static boolean isTempVariable(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            ControlFlow.$$$reportNull$$$0(6);
        }
        return variable.getDescriptor() instanceof Synthetic;
    }

    @NotNull
    public DfaVariableValue createTempVariable(@NotNull DfType dfType) {
        if (dfType == null) {
            ControlFlow.$$$reportNull$$$0(7);
        }
        DfaVariableValue dfaVariableValue = this.getFactory().getVarFactory().createVariableValue(new Synthetic(this.getInstructionCount(), dfType));
        if (dfaVariableValue == null) {
            ControlFlow.$$$reportNull$$$0(8);
        }
        return dfaVariableValue;
    }

    @NotNull
    public List<DfaVariableValue> getSynthetics(PsiElement element2) {
        int startOffset = this.getStartOffset(element2).getInstructionOffset();
        ArrayList<DfaVariableValue> synthetics = new ArrayList<DfaVariableValue>();
        for (DfaValue value : this.myFactory.getValues()) {
            DfaVariableValue var;
            VariableDescriptor descriptor;
            if (!(value instanceof DfaVariableValue) || !((descriptor = (var = (DfaVariableValue)value).getDescriptor()) instanceof Synthetic) || ((Synthetic)descriptor).myLocation < startOffset) continue;
            synthetics.add(var);
        }
        ArrayList<DfaVariableValue> arrayList = synthetics;
        if (arrayList == null) {
            ControlFlow.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnchor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/lang/ir/ControlFlow";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/lang/ir/ControlFlow";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiAnchor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempVariable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSynthetics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTempVariable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTempVariable";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Synthetic
    implements VariableDescriptor {
        private final int myLocation;
        private final DfType myType;

        private Synthetic(int location, DfType type) {
            this.myLocation = location;
            this.myType = type;
        }

        @NotNull
        public String toString() {
            String string2 = "tmp$" + this.myLocation;
            if (string2 == null) {
                Synthetic.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Override
        @NotNull
        public DfType getDfType(@Nullable DfaVariableValue qualifier) {
            DfType dfType = this.myType;
            if (dfType == null) {
                Synthetic.$$$reportNull$$$0(1);
            }
            return dfType;
        }

        @Override
        public boolean isStable() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/dataFlow/lang/ir/ControlFlow$Synthetic";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDfType";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class FromMapOffset
    extends ControlFlowOffset {
        private final PsiElement myElement;
        private final Object2IntMap<PsiElement> myElementMap;

        private FromMapOffset(PsiElement element2, Object2IntMap<PsiElement> map2) {
            this.myElement = element2;
            this.myElementMap = map2;
        }

        @Override
        public int getInstructionOffset() {
            return this.myElementMap.getInt(this.myElement);
        }
    }

    public static class DeferredOffset
    extends ControlFlowOffset {
        private int myOffset = -1;

        @Override
        public int getInstructionOffset() {
            if (this.myOffset == -1) {
                throw new IllegalStateException("Not set");
            }
            return this.myOffset;
        }

        public void setOffset(int offset) {
            if (this.myOffset != -1) {
                throw new IllegalStateException("Already set");
            }
            this.myOffset = offset;
        }

        @Override
        public String toString() {
            return this.myOffset == -1 ? "<not set>" : super.toString();
        }
    }

    public static class FixedOffset
    extends ControlFlowOffset {
        private final int myOffset;

        public FixedOffset(int offset) {
            this.myOffset = offset;
        }

        @Override
        public int getInstructionOffset() {
            return this.myOffset;
        }
    }

    public static abstract class ControlFlowOffset {
        public abstract int getInstructionOffset();

        public String toString() {
            return String.valueOf(this.getInstructionOffset());
        }
    }
}

