/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.lang.ir;

import com.intellij.codeInspection.dataFlow.lang.ir.BaseVariableAnalyzer;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.util.containers.MultiMap;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

final class LiveVariablesAnalyzer
extends BaseVariableAnalyzer {
    LiveVariablesAnalyzer(ControlFlow flow2) {
        super(flow2);
    }

    @Override
    protected boolean isInterestingInstruction(Instruction instruction) {
        if (instruction == this.myInstructions[0]) {
            return true;
        }
        if (!instruction.getRequiredVariables(this.myFactory).isEmpty() || !instruction.getWrittenVariables(this.myFactory).isEmpty()) {
            return true;
        }
        return !instruction.isLinear() || instruction instanceof FinishElementInstruction;
    }

    @Nullable
    private Map<FinishElementInstruction, BitSet> findLiveVars() {
        HashMap<FinishElementInstruction, BitSet> result2 = new HashMap<FinishElementInstruction, BitSet>();
        boolean ok2 = this.runDfa(false, (instruction, liveVars) -> {
            List<DfaVariableValue> writtenVariables;
            if (instruction instanceof FinishElementInstruction) {
                BitSet set2 = (BitSet)result2.get(instruction);
                if (set2 != null) {
                    set2.or((BitSet)liveVars);
                    return (BitSet)set2.clone();
                }
                if (!liveVars.isEmpty()) {
                    result2.put((FinishElementInstruction)instruction, (BitSet)liveVars.clone());
                }
            }
            if (!(writtenVariables = instruction.getWrittenVariables(this.myFactory)).isEmpty()) {
                BitSet newVars = (BitSet)liveVars.clone();
                for (DfaVariableValue written : writtenVariables) {
                    newVars.clear(written.getID());
                    for (DfaVariableValue var : written.getDependentVariables()) {
                        newVars.clear(var.getID());
                    }
                }
                return newVars;
            }
            var processor = new Consumer<DfaVariableValue>((BitSet)liveVars){
                boolean cloned = false;
                BitSet newVars = this.val$liveVars;
                final /* synthetic */ BitSet val$liveVars;
                {
                    this.val$liveVars = bitSet;
                }

                @Override
                public void accept(DfaVariableValue value) {
                    if (!this.newVars.get(value.getID())) {
                        if (!this.cloned) {
                            this.newVars = (BitSet)this.newVars.clone();
                            this.cloned = true;
                        }
                        this.newVars.set(value.getID());
                    }
                }
            };
            ((StreamEx)StreamEx.of(instruction.getRequiredVariables(this.myFactory)).flatMap(v -> StreamEx.of(v.getDependentVariables()).prepend(v)).distinct()).forEach((Consumer)processor);
            return processor.newVars;
        });
        return ok2 ? result2 : null;
    }

    void flushDeadVariablesOnStatementFinish() {
        Map<FinishElementInstruction, BitSet> liveVars = this.findLiveVars();
        if (liveVars == null) {
            return;
        }
        MultiMap toFlush = MultiMap.createSet();
        boolean ok2 = this.runDfa(true, (instruction, prevLiveVars) -> {
            if (instruction instanceof FinishElementInstruction) {
                int setBit;
                BitSet currentlyLive = (BitSet)liveVars.get(instruction);
                if (currentlyLive == null) {
                    currentlyLive = new BitSet();
                }
                int index = 0;
                while ((setBit = prevLiveVars.nextSetBit(index)) >= 0) {
                    if (!currentlyLive.get(setBit)) {
                        toFlush.putValue((FinishElementInstruction)instruction, (DfaVariableValue)this.myFactory.getValue(setBit));
                    }
                    index = setBit + 1;
                }
                return currentlyLive;
            }
            return prevLiveVars;
        });
        if (ok2) {
            for (FinishElementInstruction instruction2 : toFlush.keySet()) {
                Collection values2 = toFlush.get(instruction2);
                values2.removeIf(var -> var.getDescriptor().isImplicitReadPossible());
                instruction2.getVarsToFlush().addAll(values2);
            }
        }
    }
}

