/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class DescriptorComposer
extends HTMLComposerImpl {
    private static final Logger LOG = Logger.getInstance(DescriptorComposer.class);
    private final InspectionToolPresentation myTool;

    public DescriptorComposer(@NotNull InspectionToolPresentation tool) {
        if (tool == null) {
            DescriptorComposer.$$$reportNull$$$0(0);
        }
        this.myTool = tool;
    }

    @Override
    public void compose(@NotNull StringBuilder buf, RefEntity refEntity) {
        if (buf == null) {
            DescriptorComposer.$$$reportNull$$$0(1);
        }
        this.genPageHeader(buf, refEntity);
        if (this.myTool.getDescriptions(refEntity) != null) {
            DescriptorComposer.appendHeading(buf, AnalysisBundle.message("inspection.problem.synopsis", new Object[0]));
            buf.append("<div class=\"problem-description\">");
            CommonProblemDescriptor[] descriptions = this.myTool.getDescriptions(refEntity);
            LOG.assertTrue(descriptions != null);
            this.startList(buf);
            for (int i = 0; i < descriptions.length; ++i) {
                CommonProblemDescriptor description = descriptions[i];
                this.startListItem(buf);
                this.composeDescription(description, i, buf, refEntity);
                DescriptorComposer.doneListItem(buf);
            }
            this.doneList(buf);
            buf.append("</div>");
            this.appendResolution(buf, refEntity, DescriptorComposer.quickFixTexts(refEntity, this.myTool));
        } else {
            this.appendNoProblems(buf);
        }
    }

    public static String @NotNull [] quickFixTexts(RefEntity where, @NotNull InspectionToolPresentation toolPresentation) {
        if (toolPresentation == null) {
            DescriptorComposer.$$$reportNull$$$0(2);
        }
        QuickFixAction[] quickFixes = toolPresentation.getQuickFixes(where);
        ArrayList<String> texts = new ArrayList<String>();
        for (QuickFixAction quickFix : quickFixes) {
            String text2 = quickFix.getText();
            if (text2 == null) continue;
            texts.add(DescriptorComposer.escapeQuickFixText(text2));
        }
        String[] stringArray = ArrayUtilRt.toStringArray(texts);
        if (stringArray == null) {
            DescriptorComposer.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    private static String escapeQuickFixText(@NotNull String text2) {
        if (text2 == null) {
            DescriptorComposer.$$$reportNull$$$0(4);
        }
        return XmlStringUtil.isWrappedInHtml(text2) ? XmlStringUtil.stripHtml(text2) : StringUtil.escapeXmlEntities(text2);
    }

    protected void composeAdditionalDescription(@NotNull StringBuilder buf, @NotNull RefEntity refEntity) {
        if (buf == null) {
            DescriptorComposer.$$$reportNull$$$0(5);
        }
        if (refEntity == null) {
            DescriptorComposer.$$$reportNull$$$0(6);
        }
    }

    @Override
    public void compose(@NotNull StringBuilder buf, RefEntity refElement, CommonProblemDescriptor descriptor) {
        if (buf == null) {
            DescriptorComposer.$$$reportNull$$$0(7);
        }
        CommonProblemDescriptor[] descriptions = this.myTool.getDescriptions(refElement);
        int problemIdx = 0;
        if (descriptions != null) {
            problemIdx = -1;
            for (int i = 0; i < descriptions.length; ++i) {
                CommonProblemDescriptor description = descriptions[i];
                if (description != descriptor) continue;
                problemIdx = i;
                break;
            }
            if (problemIdx == -1) {
                return;
            }
        }
        this.genPageHeader(buf, refElement);
        DescriptorComposer.appendHeading(buf, AnalysisBundle.message("inspection.problem.synopsis", new Object[0]));
        buf.append("<br>");
        DescriptorComposer.appendAfterHeaderIndention(buf);
        this.composeDescription(descriptor, problemIdx, buf, refElement);
        if (refElement instanceof RefElement && !refElement.isValid()) {
            return;
        }
        QuickFix[] fixes = descriptor.getFixes();
        if (fixes != null && fixes.length > 0) {
            buf.append("<br><br>");
            DescriptorComposer.appendHeading(buf, AnalysisBundle.message("inspection.problem.resolution", new Object[0]));
            buf.append("<br>");
            DescriptorComposer.appendAfterHeaderIndention(buf);
            int idx = 0;
            for (QuickFix fix2 : fixes) {
                buf.append("<a HREF=\"file://bred.txt#invokelocal:" + idx++);
                buf.append("\">");
                buf.append(DescriptorComposer.escapeQuickFixText(fix2.getName()));
                buf.append("</a>");
                buf.append("<br>");
                DescriptorComposer.appendAfterHeaderIndention(buf);
            }
        }
    }

    protected void composeDescription(@NotNull CommonProblemDescriptor description, int i, @NotNull StringBuilder buf, @NotNull RefEntity refElement) {
        Document doc;
        if (description == null) {
            DescriptorComposer.$$$reportNull$$$0(8);
        }
        if (buf == null) {
            DescriptorComposer.$$$reportNull$$$0(9);
        }
        if (refElement == null) {
            DescriptorComposer.$$$reportNull$$$0(10);
        }
        PsiElement expression = description instanceof ProblemDescriptor ? ((ProblemDescriptor)description).getPsiElement() : null;
        StringBuilder anchor = new StringBuilder();
        VirtualFile vFile = null;
        if (expression != null) {
            vFile = expression.getContainingFile().getVirtualFile();
            if (vFile instanceof VirtualFileWindow) {
                vFile = ((VirtualFileWindow)((Object)vFile)).getDelegate();
            }
            anchor.append("<a HREF=\"");
            anchor.append(DescriptorComposer.appendURL(vFile, "descr:" + i));
            anchor.append("\">");
            anchor.append(ProblemDescriptorUtil.extractHighlightedText(description, expression).replaceAll("\\$", "\\\\\\$"));
            anchor.append("</a>");
        } else {
            anchor.append("<font style=\"font-weight:bold; color:#FF0000\";>");
            anchor.append(AnalysisBundle.message("inspection.export.results.invalidated.item", new Object[0]));
            anchor.append("</font>");
        }
        String descriptionTemplate = description.getDescriptionTemplate();
        if (XmlStringUtil.isWrappedInHtml(descriptionTemplate)) {
            descriptionTemplate = XmlStringUtil.stripHtml(descriptionTemplate);
        } else {
            descriptionTemplate = StringUtil.replace(descriptionTemplate, "<code>", "'");
            descriptionTemplate = StringUtil.replace(descriptionTemplate, "</code>", "'");
            descriptionTemplate = XmlStringUtil.escapeString(descriptionTemplate);
        }
        String reference2 = "#ref";
        Object res = descriptionTemplate.replaceAll("#ref", anchor.toString());
        int lineNumber = description instanceof ProblemDescriptor ? ((ProblemDescriptor)description).getLineNumber() : -1;
        StringBuilder lineAnchor = new StringBuilder();
        if (expression != null && lineNumber >= 0 && (doc = FileDocumentManager.getInstance().getDocument(vFile)) != null && lineNumber < doc.getLineCount()) {
            lineNumber = Math.min(lineNumber, doc.getLineCount() - 1);
            lineAnchor.append(AnalysisBundle.message("inspection.export.results.at.line", new Object[0])).append(" ");
            lineAnchor.append("<a HREF=\"");
            int offset = doc.getLineStartOffset(lineNumber);
            offset = CharArrayUtil.shiftForward(doc.getCharsSequence(), offset, " \t");
            lineAnchor.append(DescriptorComposer.appendURL(vFile, String.valueOf(offset)));
            lineAnchor.append("\">");
            lineAnchor.append(lineNumber + 1);
            lineAnchor.append("</a>");
            String location = "#loc";
            if (!((String)res).contains("#loc")) {
                res = (String)res + " (#loc)";
            }
            res = ((String)res).replaceAll("#loc", lineAnchor.toString());
        }
        buf.append(((String)res).replace("#end", "").replace("#treeend", ""));
        buf.append("<br>").append("<br>");
        this.composeAdditionalDescription(buf, refElement);
    }

    private static String appendURL(VirtualFile vFile, String anchor) {
        return vFile.getUrl() + "#" + anchor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolPresentation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/DescriptorComposer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/DescriptorComposer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "quickFixTexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compose";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "quickFixTexts";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "escapeQuickFixText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "composeAdditionalDescription";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "composeDescription";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

