/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.DefaultInspectionToolResultExporter;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionToolResultExporter;
import com.intellij.codeInspection.InspectionsResultUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.InspectListener;
import com.intellij.codeInspection.ex.InspectionProblemConsumer;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.AggregateResultsExporter;
import com.intellij.codeInspection.ui.GlobalReportedProblemFilter;
import com.intellij.codeInspection.ui.ReportedProblemFilter;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.BaseKeyedLazyInstance;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalInspectionContextEx
extends GlobalInspectionContextBase {
    public static final Topic<InspectListener> INSPECT_TOPIC = new Topic<InspectListener>(InspectListener.class, Topic.BroadcastDirection.NONE);
    private static final Logger LOG = Logger.getInstance(GlobalInspectionContextEx.class);
    private static final int MAX_OPEN_GLOBAL_INSPECTION_XML_RESULT_FILES = SystemProperties.getIntProperty("max.open.global.inspection.xml.files", 50);
    private final ConcurrentMap<InspectionToolWrapper<?, ?>, InspectionToolResultExporter> myPresentationMap;
    private volatile Path myOutputDir;
    private GlobalReportedProblemFilter myGlobalReportedProblemFilter;
    private ReportedProblemFilter myReportedProblemFilter;
    private Map<Path, Long> myProfile;
    protected InspectionProblemConsumer myProblemConsumer;

    public GlobalInspectionContextEx(@NotNull Project project2) {
        if (project2 == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(0);
        }
        super(project2);
        this.myPresentationMap = new ConcurrentHashMap();
    }

    public void launchInspectionsOffline(@NotNull AnalysisScope scope, @NotNull Path outputPath, boolean runGlobalToolsOnly, @NotNull List<? super Path> inspectionsResults) {
        if (scope == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(1);
        }
        if (outputPath == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(2);
        }
        if (inspectionsResults == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(3);
        }
        this.performInspectionsWithProgressAndExportResults(scope, runGlobalToolsOnly, true, outputPath, inspectionsResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performInspectionsWithProgressAndExportResults(@NotNull AnalysisScope scope, boolean runGlobalToolsOnly, boolean isOfflineInspections, @NotNull Path outputDir, @NotNull List<? super Path> inspectionsResults) {
        if (scope == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(4);
        }
        if (outputDir == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(5);
        }
        if (inspectionsResults == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(6);
        }
        this.cleanupTools();
        this.setCurrentScope(scope);
        this.myOutputDir = outputDir;
        try {
            try {
                this.performInspectionsWithProgress(scope, runGlobalToolsOnly, isOfflineInspections);
            }
            finally {
                if (this.areToolsInitialized()) {
                    this.exportResultsSmart(inspectionsResults, outputDir);
                }
            }
        }
        finally {
            this.myOutputDir = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void exportResults(@NotNull List<? super Path> inspectionsResults, final @NotNull List<? extends Tools> inspections, @NotNull Path outputDir, @Nullable XMLOutputFactory xmlOutputFactory) {
        void var9_14;
        BufferedWriter[] bufferedWriterArray;
        if (inspectionsResults == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(7);
        }
        if (inspections == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(8);
        }
        if (outputDir == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(9);
        }
        if (xmlOutputFactory == null) {
            xmlOutputFactory = XMLOutputFactory.newDefaultFactory();
        }
        final BufferedWriter[] writers = new BufferedWriter[inspections.size()];
        XMLStreamWriter[] xmlWriters = new XMLStreamWriter[inspections.size()];
        try {
            int i = 0;
            for (Tools tools : inspections) {
                inspectionsResults.add(InspectionsResultUtil.getInspectionResultPath(outputDir, tools.getShortName()));
                try {
                    BufferedWriter writer;
                    writers[i] = writer = InspectionsResultUtil.getWriter(outputDir, tools.getShortName());
                    XMLStreamWriter xmlWriter = xmlOutputFactory.createXMLStreamWriter(writer);
                    xmlWriters[i++] = xmlWriter;
                    xmlWriter.writeStartElement("problems");
                    xmlWriter.writeCharacters("\n");
                    xmlWriter.flush();
                }
                catch (IOException | XMLStreamException e) {
                    LOG.error(e);
                }
            }
            this.getRefManager().iterate(new RefVisitor(){

                @Override
                public void visitElement(@NotNull RefEntity refEntity) {
                    if (refEntity == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    int i = 0;
                    for (Tools tools : inspections) {
                        for (ScopeToolState state : tools.getTools()) {
                            try {
                                InspectionToolWrapper<?, ?> toolWrapper = state.getTool();
                                InspectionToolResultExporter presentation2 = GlobalInspectionContextEx.this.getPresentation(toolWrapper);
                                BufferedWriter writer = writers[i];
                                if (writer == null || GlobalInspectionContextEx.this.myGlobalReportedProblemFilter != null && !GlobalInspectionContextEx.this.myGlobalReportedProblemFilter.shouldReportProblem(refEntity, toolWrapper.getShortName())) continue;
                                presentation2.exportResults(e -> {
                                    try {
                                        JbXmlOutputter.collapseMacrosAndWrite(e, GlobalInspectionContextEx.this.getProject(), writer);
                                        writer.flush();
                                    }
                                    catch (IOException e1) {
                                        throw new RuntimeException(e1);
                                    }
                                }, refEntity, d -> false);
                            }
                            catch (Throwable e2) {
                                LOG.error("Problem when exporting: " + refEntity.getExternalName(), e2);
                            }
                        }
                        ++i;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/ex/GlobalInspectionContextEx$1", "visitElement"));
                }
            });
            for (XMLStreamWriter xmlWriter : xmlWriters) {
                if (xmlWriter == null) continue;
                try {
                    xmlWriter.writeEndElement();
                    xmlWriter.flush();
                }
                catch (XMLStreamException e) {
                    LOG.error(e);
                }
            }
            bufferedWriterArray = writers;
        }
        catch (Throwable throwable) {
            for (BufferedWriter writer : writers) {
                if (writer == null) continue;
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
            throw throwable;
        }
        int n = bufferedWriterArray.length;
        boolean bl = false;
        while (var9_14 < n) {
            BufferedWriter writer = bufferedWriterArray[var9_14];
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
            ++var9_14;
        }
    }

    private void exportResultsSmart(@NotNull List<? super Path> inspectionsResults, @NotNull Path outputDir) {
        if (inspectionsResults == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(10);
        }
        if (outputDir == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(11);
        }
        ArrayList<Tools> globalToolsWithProblems = new ArrayList<Tools>();
        ArrayList<Tools> toolsWithResultsToAggregate = new ArrayList<Tools>();
        for (Map.Entry<String, Tools> entry : this.getTools().entrySet()) {
            Tools sameTools = entry.getValue();
            boolean hasProblems = false;
            String toolName = entry.getKey();
            if (sameTools != null) {
                for (ScopeToolState toolDescr : sameTools.getTools()) {
                    InspectionToolWrapper<?, ?> toolWrapper = toolDescr.getTool();
                    InspectionToolResultExporter presentation2 = this.getPresentation(toolWrapper);
                    try {
                        if (presentation2 instanceof AggregateResultsExporter) {
                            presentation2.updateContent();
                            if (presentation2.hasReportedProblems().toBoolean()) {
                                toolsWithResultsToAggregate.add(sameTools);
                                break;
                            }
                        }
                        if (toolWrapper instanceof LocalInspectionToolWrapper) {
                            hasProblems = Files.exists(InspectionsResultUtil.getInspectionResultPath(outputDir, toolWrapper.getShortName()), new LinkOption[0]);
                            continue;
                        }
                        presentation2.updateContent();
                        if (!presentation2.hasReportedProblems().toBoolean()) continue;
                        globalToolsWithProblems.add(sameTools);
                        LOG.assertTrue(!hasProblems, toolName);
                        break;
                    }
                    catch (ProcessCanceledException | IndexNotReadyException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }
            if (!hasProblems) continue;
            try {
                Path file2 = InspectionsResultUtil.getInspectionResultPath(outputDir, sameTools.getShortName());
                inspectionsResults.add(file2);
                Files.write(file2, "</problems>".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
        this.exportResultsWithAggregation(inspectionsResults, toolsWithResultsToAggregate, outputDir);
        if (!globalToolsWithProblems.isEmpty()) {
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newDefaultFactory();
            ContainerUtil.splitListToChunks(globalToolsWithProblems, MAX_OPEN_GLOBAL_INSPECTION_XML_RESULT_FILES).forEach(inspections -> this.exportResults(inspectionsResults, (List<? extends Tools>)inspections, outputDir, xmlOutputFactory));
        }
    }

    private void exportResultsWithAggregation(@NotNull List<? super Path> inspectionsResults, @NotNull List<? extends Tools> toolsWithResultsToAggregate, @NotNull Path outputPath) {
        if (inspectionsResults == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(12);
        }
        if (toolsWithResultsToAggregate == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(13);
        }
        if (outputPath == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(14);
        }
        for (Tools tools : toolsWithResultsToAggregate) {
            String inspectionName = tools.getShortName();
            inspectionsResults.add(InspectionsResultUtil.getInspectionResultPath(outputPath, inspectionName));
            inspectionsResults.add(InspectionsResultUtil.getInspectionResultPath(outputPath, inspectionName + "_aggregate"));
            try {
                List<InspectionToolWrapper> wrappers = ContainerUtil.map(tools.getTools(), ScopeToolState::getTool);
                InspectionsResultUtil.writeInspectionResult(this.getProject(), inspectionName, wrappers, outputPath, this::getPresentation);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    @NotNull
    public InspectionToolResultExporter getPresentation(@NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        InspectionToolResultExporter presentation2;
        if (toolWrapper == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(15);
        }
        if ((presentation2 = (InspectionToolResultExporter)this.myPresentationMap.get(toolWrapper)) == null) {
            presentation2 = this.createPresentation(toolWrapper);
            presentation2 = ConcurrencyUtil.cacheOrGet(this.myPresentationMap, toolWrapper, presentation2);
        }
        InspectionToolResultExporter inspectionToolResultExporter = presentation2;
        if (inspectionToolResultExporter == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(16);
        }
        return inspectionToolResultExporter;
    }

    @NotNull
    protected InspectionToolResultExporter createPresentation(@NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        InspectionToolResultExporter inspectionToolResultExporter;
        if (toolWrapper == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(17);
        }
        String presentationClass = StringUtil.notNullize(toolWrapper.myEP == null ? null : ((InspectionEP)toolWrapper.myEP).presentation, DefaultInspectionToolResultExporter.class.getName());
        try {
            InspectionToolResultExporter presentation2;
            Object extension2 = toolWrapper.getExtension();
            ClassLoader classLoader = extension2 == null ? this.getClass().getClassLoader() : ((BaseKeyedLazyInstance)extension2).getPluginDescriptor().getPluginClassLoader();
            Constructor<?> constructor = Class.forName(presentationClass, true, classLoader).getConstructor(InspectionToolWrapper.class, GlobalInspectionContextEx.class);
            inspectionToolResultExporter = presentation2 = (InspectionToolResultExporter)constructor.newInstance(toolWrapper, this);
        }
        catch (Exception e) {
            LOG.error(e);
            throw new RuntimeException(e);
        }
        if (inspectionToolResultExporter == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(18);
        }
        return inspectionToolResultExporter;
    }

    public ReportedProblemFilter getReportedProblemFilter() {
        return this.myReportedProblemFilter;
    }

    public void setReportedProblemFilter(ReportedProblemFilter reportedProblemFilter) {
        this.myReportedProblemFilter = reportedProblemFilter;
    }

    public GlobalReportedProblemFilter getGlobalReportedProblemFilter() {
        return this.myGlobalReportedProblemFilter;
    }

    public void setGlobalReportedProblemFilter(GlobalReportedProblemFilter reportedProblemFilter) {
        this.myGlobalReportedProblemFilter = reportedProblemFilter;
    }

    @Nullable
    public Path getOutputPath() {
        return this.myOutputDir;
    }

    public void startPathProfiling() {
        this.myProfile = new ConcurrentHashMap<Path, Long>();
    }

    public Map<Path, Long> getPathProfile() {
        return this.myProfile;
    }

    void updateProfile(VirtualFile virtualFile2, long millis) {
        if (this.myProfile != null) {
            Path path2 = Paths.get(virtualFile2.getPath(), new String[0]);
            this.myProfile.merge(path2, millis, Long::sum);
        }
    }

    public void setProblemConsumer(@NotNull InspectionProblemConsumer problemConsumer) {
        if (problemConsumer == null) {
            GlobalInspectionContextEx.$$$reportNull$$$0(19);
        }
        this.myProblemConsumer = problemConsumer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 18: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPath";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionsResults";
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspections";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolsWithResultsToAggregate";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/GlobalInspectionContextEx";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/GlobalInspectionContextEx";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "launchInspectionsOffline";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performInspectionsWithProgressAndExportResults";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "exportResults";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "exportResultsSmart";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "exportResultsWithAggregation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 16: 
            case 18: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setProblemConsumer";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

