/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class InspectionProfileWrapper {
    private static final Logger LOG = Logger.getInstance(InspectionProfileWrapper.class);
    private static final Key<Function<? super InspectionProfile, ? extends InspectionProfileWrapper>> CUSTOMIZATION_KEY = Key.create("Inspection Profile Wrapper Customization");
    public static final Key<Map<Class<? extends PsiElement>, Set<PsiElement>>> PSI_ELEMENTS_BEING_COMMITTED = Key.create("PsiElements that are being committed");
    private static boolean alreadyChecked;
    protected final InspectionProfile myProfile;
    protected final InspectionProfileManager myProfileManager;

    public InspectionProfileWrapper(@NotNull InspectionProfileImpl profile) {
        if (profile == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(0);
        }
        this.myProfile = profile;
        this.myProfileManager = profile.getProfileManager();
    }

    public InspectionProfileWrapper(@NotNull InspectionProfile profile, @NotNull InspectionProfileManager profileManager) {
        if (profile == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(1);
        }
        if (profileManager == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(2);
        }
        this.myProfile = profile;
        this.myProfileManager = profileManager;
    }

    public InspectionProfileManager getProfileManager() {
        return this.myProfileManager;
    }

    public static void checkInspectionsDuplicates(@NotNull List<? extends InspectionToolWrapper<?, ?>> toolWrappers) {
        if (toolWrappers == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(3);
        }
        if (alreadyChecked) {
            return;
        }
        alreadyChecked = true;
        HashSet uniqueTools = new HashSet(toolWrappers.size());
        for (InspectionToolWrapper<?, ?> toolWrapper : toolWrappers) {
            ProgressManager.checkCanceled();
            if (uniqueTools.add(toolWrapper.getTool())) continue;
            LOG.error("Inspection " + toolWrapper.getDisplayName() + " (" + toolWrapper.getTool().getClass() + ") already registered");
        }
    }

    public boolean isToolEnabled(HighlightDisplayKey key, PsiElement element2) {
        return this.myProfile.isToolEnabled(key, element2);
    }

    @NotNull
    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey inspectionToolKey, PsiElement element2) {
        if (inspectionToolKey == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(4);
        }
        HighlightDisplayLevel highlightDisplayLevel = this.myProfile.getErrorLevel(inspectionToolKey, element2);
        if (highlightDisplayLevel == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(5);
        }
        return highlightDisplayLevel;
    }

    public InspectionToolWrapper<?, ?> getInspectionTool(String shortName, PsiElement element2) {
        return this.myProfile.getInspectionTool(shortName, element2);
    }

    @NotNull
    public InspectionProfile getInspectionProfile() {
        InspectionProfile inspectionProfile = this.myProfile;
        if (inspectionProfile == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(6);
        }
        return inspectionProfile;
    }

    public static void runWithCustomInspectionWrapper(@NotNull PsiFile file2, @NotNull Function<? super InspectionProfile, ? extends InspectionProfileWrapper> customizer, @NotNull Runnable runnable) {
        if (file2 == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(7);
        }
        if (customizer == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(8);
        }
        if (runnable == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(9);
        }
        file2.putUserData(CUSTOMIZATION_KEY, customizer);
        try {
            runnable.run();
        }
        finally {
            file2.putUserData(CUSTOMIZATION_KEY, null);
        }
    }

    public static Function<? super InspectionProfile, ? extends InspectionProfileWrapper> getCustomInspectionProfileWrapper(@NotNull PsiFile file2) {
        if (file2 == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(10);
        }
        return file2.getUserData(CUSTOMIZATION_KEY);
    }

    @Deprecated
    public static void setCustomInspectionProfileWrapperTemporarily(@NotNull PsiFile file2, @NotNull Function<? super InspectionProfile, ? extends InspectionProfileWrapper> function) {
        if (file2 == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(11);
        }
        if (function == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(12);
        }
        file2.putUserData(CUSTOMIZATION_KEY, function);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrappers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionToolKey";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionProfileWrapper";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customizer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionProfileWrapper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorLevel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionProfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkInspectionsDuplicates";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getErrorLevel";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runWithCustomInspectionWrapper";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCustomInspectionProfileWrapper";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setCustomInspectionProfileWrapperTemporarily";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

