/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonInspectionsReportConverter
implements InspectionsReportConverter {
    @NonNls
    private static final String FORMAT_NAME = "json";
    @NonNls
    private static final String JSON_EXTENSION = ".json";
    @NonNls
    private static final String FILE = "file";
    @NonNls
    private static final String LINE = "line";
    @NonNls
    private static final String OFFSET = "offset";
    @NonNls
    private static final String LENGTH = "length";
    @NonNls
    private static final String MODULE = "module";
    @NonNls
    private static final String PACKAGE = "package";
    @NonNls
    protected static final String PROBLEM = "problem";
    @NonNls
    protected static final String PROBLEMS = "problems";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String PLUGIN_ID = "pluginId";
    @NonNls
    private static final String PLUGIN_VERSION = "pluginVersion";
    @NonNls
    private static final String GLOBAL_TOOL = "isGlobalTool";
    @NonNls
    private static final String LANGUAGE = "language";
    @NonNls
    private static final String SEVERITY_ATTR = "severity";
    @NonNls
    private static final String ATTRIBUTE_KEY_ATTR = "attribute_key";
    @NonNls
    private static final String HINT = "hint";
    @NonNls
    private static final String HINTS = "hints";
    @NonNls
    private static final String DISPLAY_NAME = "displayName";
    @NonNls
    private static final String DEFAULT_SEVERITY = "defaultSeverity";
    @NonNls
    private static final String SHORT_NAME = "shortName";
    @NonNls
    private static final String ENABLED = "enabled";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String ID = "id";
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String GROUP = "group";
    @NonNls
    private static final String GROUPS = "groups";
    @NonNls
    private static final String INSPECTION = "inspection";
    @NonNls
    private static final String HIGHLIGHTED_ELEMENT = "highlighted_element";
    @NonNls
    public static final String DUPLICATED_CODE = "DuplicatedCode";
    @NonNls
    public static final String DUPLICATED_CODE_AGGREGATE = "DuplicatedCode_aggregate";
    @NonNls
    public static final String PHP_VULNERABLE_PATHS_AGGREGATE = "PhpVulnerablePathsInspection_aggregate";

    @Override
    public String getFormatName() {
        return FORMAT_NAME;
    }

    @Override
    public boolean useTmpDirForRawData() {
        return true;
    }

    @Override
    public void convert(@NotNull String rawDataDirectoryPath, @Nullable String outputPath, @NotNull Map<String, Tools> tools, @NotNull List<? extends File> inspectionsResults) throws InspectionsReportConverter.ConversionException {
        if (rawDataDirectoryPath == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(0);
        }
        if (tools == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(1);
        }
        if (inspectionsResults == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(2);
        }
        if (outputPath == null) {
            throw new InspectionsReportConverter.ConversionException("Output path isn't specified");
        }
        try {
            Files.createDirectories(new File(outputPath).toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new InspectionsReportConverter.ConversionException("Cannot create dirs in output path: " + outputPath + " error: " + e.getMessage());
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        for (File file2 : inspectionsResults) {
            String fileNameWithoutExt = FileUtil.getNameWithoutExtension(file2);
            File jsonFile = new File(outputPath, fileNameWithoutExt + JSON_EXTENSION);
            try {
                BufferedWriter writer = Files.newBufferedWriter(jsonFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
                try {
                    JsonWriter jsonWriter = gson.newJsonWriter((Writer)writer);
                    try {
                        Element element2 = JDOMUtil.load(file2);
                        if (".descriptions".equals(fileNameWithoutExt)) {
                            JsonInspectionsReportConverter.convertDescriptions(jsonWriter, element2);
                            continue;
                        }
                        if (DUPLICATED_CODE_AGGREGATE.equals(fileNameWithoutExt)) {
                            JsonInspectionsReportConverter.convertDuplicatedCode(jsonWriter, element2);
                            continue;
                        }
                        if (PHP_VULNERABLE_PATHS_AGGREGATE.equals(fileNameWithoutExt)) {
                            JsonInspectionsReportConverter.convertPhpVulnerablePaths(jsonWriter, element2);
                            continue;
                        }
                        JsonInspectionsReportConverter.convertProblems(jsonWriter, element2);
                    }
                    finally {
                        if (jsonWriter == null) continue;
                        jsonWriter.close();
                    }
                }
                finally {
                    if (writer == null) continue;
                    ((Writer)writer).close();
                }
            }
            catch (IOException | JDOMException e) {
                throw new InspectionsReportConverter.ConversionException("Cannot convert file: " + file2.getPath() + " error: " + e.getMessage());
            }
        }
    }

    private static void convertDuplicatedCode(@NotNull JsonWriter jsonWriter, @NotNull Element problems) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(3);
        }
        if (problems == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(4);
        }
        jsonWriter.beginObject();
        jsonWriter.name(PROBLEMS);
        jsonWriter.beginArray();
        for (Element duplicates : problems.getChildren("duplicate")) {
            JsonInspectionsReportConverter.convertDuplicates(jsonWriter, duplicates);
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    public static void convertDuplicates(@NotNull JsonWriter jsonWriter, Element duplicates) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(5);
        }
        jsonWriter.beginArray();
        for (Element fragment : duplicates.getChildren("fragment")) {
            JsonInspectionsReportConverter.convertDuplicateFragment(jsonWriter, fragment);
        }
        jsonWriter.endArray();
    }

    private static void convertDuplicateFragment(@NotNull JsonWriter jsonWriter, Element fragment) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(6);
        }
        jsonWriter.beginObject();
        JsonInspectionsReportConverter.writeFileSegmentAttributes(jsonWriter, fragment);
        jsonWriter.endObject();
    }

    private static void writeFileSegmentAttributes(@NotNull JsonWriter jsonWriter, Element fileSegment) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(7);
        }
        JsonInspectionsReportConverter.writeFileAttribute(jsonWriter, fileSegment);
        JsonInspectionsReportConverter.writeSegmentAttributes(jsonWriter, fileSegment);
    }

    private static void writeFileAttribute(@NotNull JsonWriter jsonWriter, Element fileSegment) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(8);
        }
        jsonWriter.name(FILE).value(fileSegment.getAttributeValue(FILE));
    }

    private static void writeSegmentAttributes(@NotNull JsonWriter jsonWriter, Element segment) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(9);
        }
        String line = segment.getAttributeValue(LINE);
        String start2 = segment.getAttributeValue("start");
        String end = segment.getAttributeValue("end");
        assert (line != null);
        assert (start2 != null);
        assert (end != null);
        jsonWriter.name(LINE).value((long)Integer.parseInt(line));
        jsonWriter.name("start").value((long)Integer.parseInt(start2));
        jsonWriter.name("end").value((long)Integer.parseInt(end));
    }

    public static void convertPhpVulnerablePaths(@NotNull JsonWriter jsonWriter, @NotNull Element problems) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(10);
        }
        if (problems == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(11);
        }
        jsonWriter.beginObject();
        jsonWriter.name(PROBLEMS);
        jsonWriter.beginArray();
        for (Element problem : problems.getChildren(PROBLEM)) {
            JsonInspectionsReportConverter.convertPhpVulnerablePath(jsonWriter, problem);
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    public static void convertPhpVulnerablePath(@NotNull JsonWriter jsonWriter, Element problem) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(12);
        }
        jsonWriter.beginObject();
        jsonWriter.name(DESCRIPTION).value("Vulnerable code flow");
        jsonWriter.name("fragments");
        jsonWriter.beginArray();
        Element fragmentsElement = problem.getChild("fragments");
        assert (fragmentsElement != null);
        for (Element element2 : fragmentsElement.getChildren("fragment")) {
            JsonInspectionsReportConverter.convertPhpVulnerableFragment(jsonWriter, element2);
        }
        jsonWriter.endArray();
        JsonInspectionsReportConverter.convertPhpSink(jsonWriter, problem);
        jsonWriter.name("sources");
        jsonWriter.beginArray();
        Element sourcesElement = problem.getChild("sources");
        assert (sourcesElement != null);
        for (Element source : sourcesElement.getChildren("source")) {
            JsonInspectionsReportConverter.convertPhpTaintSource(jsonWriter, source);
        }
        jsonWriter.endArray();
        jsonWriter.name(LANGUAGE).value(problem.getChildText(LANGUAGE));
        Element element3 = problem.getChild("problem_class");
        if (element3 != null) {
            JsonInspectionsReportConverter.convertProblemClass(jsonWriter, element3);
        }
        jsonWriter.endObject();
    }

    private static void convertPhpSink(@NotNull JsonWriter jsonWriter, @NotNull Element problem) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(13);
        }
        if (problem == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(14);
        }
        jsonWriter.name("sink");
        Element sink = problem.getChild("sink");
        assert (sink != null);
        jsonWriter.beginObject();
        jsonWriter.name("text").value(sink.getAttributeValue("text"));
        String sinkFqn = sink.getAttributeValue("fqn");
        if (sinkFqn != null) {
            jsonWriter.name("fqn").value(sinkFqn);
        }
        JsonInspectionsReportConverter.writeOrderAttribute(jsonWriter, sink);
        jsonWriter.name("vulnerabilities");
        jsonWriter.beginArray();
        Collection<String> vulnerabilityValues = JsonInspectionsReportConverter.getVulnerabilityValues(sink, "vulnerabilities");
        for (String vulnerability : vulnerabilityValues) {
            jsonWriter.value(vulnerability);
        }
        jsonWriter.endArray();
        jsonWriter.name("parameters");
        jsonWriter.beginArray();
        String parameterName = JsonInspectionsReportConverter.getParameterName(sink);
        if (parameterName != null) {
            jsonWriter.value(parameterName);
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    private static void convertPhpTaintSource(@NotNull JsonWriter jsonWriter, @NotNull Element source) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(15);
        }
        if (source == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(16);
        }
        jsonWriter.beginObject();
        jsonWriter.name("text").value(source.getAttributeValue("text"));
        JsonInspectionsReportConverter.writeFileAttribute(jsonWriter, source);
        JsonInspectionsReportConverter.writeOrderAttribute(jsonWriter, source);
        JsonInspectionsReportConverter.writeSanitizedVulnerabilities(jsonWriter, source);
        jsonWriter.endObject();
    }

    private static void convertPhpVulnerableFragment(@NotNull JsonWriter jsonWriter, Element fragment) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(17);
        }
        jsonWriter.beginObject();
        JsonInspectionsReportConverter.writeFileSegmentAttributes(jsonWriter, fragment);
        jsonWriter.name("markers");
        jsonWriter.beginArray();
        for (Element marker : fragment.getChildren("marker")) {
            JsonInspectionsReportConverter.convertPhpTaintMarker(jsonWriter, marker);
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    private static void convertPhpTaintMarker(@NotNull JsonWriter jsonWriter, @NotNull Element marker) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(18);
        }
        if (marker == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(19);
        }
        jsonWriter.beginObject();
        JsonInspectionsReportConverter.writeSegmentAttributes(jsonWriter, marker);
        JsonInspectionsReportConverter.writeOrderAttribute(jsonWriter, marker);
        jsonWriter.name("successors");
        jsonWriter.beginArray();
        Element successorsElement = marker.getChild("successors");
        if (successorsElement != null) {
            List<String> markerOrders = ContainerUtil.map(successorsElement.getChildren("marker"), Element::getText);
            for (String markerOrder : markerOrders) {
                jsonWriter.value(markerOrder);
            }
        }
        jsonWriter.endArray();
        jsonWriter.name("predecessors");
        jsonWriter.beginArray();
        Element predecessorsElement = marker.getChild("predecessors");
        if (predecessorsElement != null) {
            List<String> markerOrders = ContainerUtil.map(predecessorsElement.getChildren("marker"), Element::getText);
            for (String markerOrder : markerOrders) {
                jsonWriter.value(markerOrder);
            }
        }
        jsonWriter.endArray();
        JsonInspectionsReportConverter.writeSanitizedVulnerabilities(jsonWriter, marker);
        jsonWriter.endObject();
    }

    private static void writeOrderAttribute(@NotNull JsonWriter jsonWriter, @NotNull Element marker) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(20);
        }
        if (marker == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(21);
        }
        jsonWriter.name("order").value(marker.getAttributeValue("order"));
    }

    private static void writeSanitizedVulnerabilities(@NotNull JsonWriter jsonWriter, @NotNull Element element2) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(22);
        }
        if (element2 == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(23);
        }
        jsonWriter.name("sanitized_vulnerabilities");
        jsonWriter.beginArray();
        Collection<String> vulnerabilityValues = JsonInspectionsReportConverter.getVulnerabilityValues(element2, "sanitized_vulnerabilities");
        for (String vulnerability : vulnerabilityValues) {
            jsonWriter.value(vulnerability);
        }
        jsonWriter.endArray();
    }

    @Nullable
    private static String getParameterName(@NotNull Element element2) {
        Element parameters2;
        if (element2 == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(24);
        }
        List<Element> parameterElements = (parameters2 = element2.getChild("parameters")) != null ? parameters2.getChildren("parameter") : null;
        Element parameter = ContainerUtil.getFirstItem(parameterElements);
        return parameter != null ? parameter.getAttributeValue(NAME) : null;
    }

    @NotNull
    private static Collection<String> getVulnerabilityValues(@NotNull Element element2, @NotNull String vulnerabilitiesTagName) {
        Element vulnerabilities;
        if (element2 == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(25);
        }
        if (vulnerabilitiesTagName == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(26);
        }
        if ((vulnerabilities = element2.getChild(vulnerabilitiesTagName)) == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                JsonInspectionsReportConverter.$$$reportNull$$$0(27);
            }
            return list2;
        }
        List<String> list3 = ContainerUtil.map(vulnerabilities.getChildren("vulnerability"), vulnerability -> vulnerability.getAttributeValue(NAME));
        if (list3 == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(28);
        }
        return list3;
    }

    private static void convertProblems(@NotNull JsonWriter jsonWriter, @NotNull Element problems) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(29);
        }
        if (problems == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(30);
        }
        jsonWriter.beginObject();
        jsonWriter.name(PROBLEMS);
        jsonWriter.beginArray();
        for (Element problem : problems.getChildren(PROBLEM)) {
            JsonInspectionsReportConverter.convertProblem(jsonWriter, problem);
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    public static void convertProblem(@NotNull JsonWriter writer, @NotNull Element problem) throws IOException {
        Element hints;
        Element entryPoint;
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(31);
        }
        if (problem == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(32);
        }
        writer.beginObject();
        writer.name(FILE).value(problem.getChildText(FILE));
        JsonInspectionsReportConverter.writeInt(writer, problem, LINE);
        JsonInspectionsReportConverter.writeInt(writer, problem, OFFSET);
        JsonInspectionsReportConverter.writeInt(writer, problem, LENGTH);
        writer.name(MODULE).value(problem.getChildText(MODULE));
        writer.name(PACKAGE).value(problem.getChildText(PACKAGE));
        Element problemClassElement = problem.getChild("problem_class");
        if (problemClassElement != null) {
            JsonInspectionsReportConverter.convertProblemClass(writer, problemClassElement);
        }
        if ((entryPoint = problem.getChild("entry_point")) != null) {
            JsonInspectionsReportConverter.convertEntryPoint(writer, entryPoint);
        }
        if ((hints = problem.getChild(HINTS)) != null) {
            JsonInspectionsReportConverter.convertHints(writer, hints);
        }
        writer.name(HIGHLIGHTED_ELEMENT).value(problem.getChildText(HIGHLIGHTED_ELEMENT));
        writer.name(LANGUAGE).value(problem.getChildText(LANGUAGE));
        writer.name(DESCRIPTION).value(problem.getChildText(DESCRIPTION));
        writer.endObject();
    }

    private static void writeInt(@NotNull JsonWriter writer, @NotNull Element problem, @NotNull String elementName) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(33);
        }
        if (problem == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(34);
        }
        if (elementName == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(35);
        }
        try {
            int intValue = Integer.parseInt(problem.getChildText(elementName));
            writer.name(elementName).value((long)intValue);
        }
        catch (NumberFormatException e) {
            writer.name(elementName).nullValue();
        }
    }

    private static void convertProblemClass(@NotNull JsonWriter writer, @NotNull Element problemClass) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(36);
        }
        if (problemClass == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(37);
        }
        writer.name("problem_class");
        writer.beginObject().name(NAME).value(problemClass.getText());
        String inspectionId = problemClass.getAttributeValue(ID);
        if (inspectionId != null) {
            writer.name(ID).value(inspectionId);
        }
        writer.name(SEVERITY_ATTR).value(problemClass.getAttributeValue(SEVERITY_ATTR)).name(ATTRIBUTE_KEY_ATTR).value(problemClass.getAttributeValue(ATTRIBUTE_KEY_ATTR)).endObject();
    }

    private static void convertEntryPoint(@NotNull JsonWriter writer, @NotNull Element entryPoint) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(38);
        }
        if (entryPoint == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(39);
        }
        writer.name("entry_point");
        writer.beginObject().name("TYPE").value(entryPoint.getAttributeValue("TYPE")).name("FQNAME").value(entryPoint.getAttributeValue("FQNAME")).endObject();
    }

    private static void convertHints(@NotNull JsonWriter writer, @NotNull Element hints) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(40);
        }
        if (hints == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(41);
        }
        writer.name(HINTS);
        writer.beginArray();
        for (Element hint : hints.getChildren(HINT)) {
            writer.value(hint.getAttributeValue(VALUE));
        }
        writer.endArray();
    }

    private static void convertDescriptions(@NotNull JsonWriter writer, @NotNull Element descriptions) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(42);
        }
        if (descriptions == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(43);
        }
        writer.beginObject();
        JsonInspectionsReportConverter.convertDescriptionsContents(writer, descriptions, null);
        writer.endObject();
    }

    protected static void convertDescriptionsContents(@NotNull JsonWriter writer, @NotNull Element inspectionsElement, @Nullable Predicate<? super String> inspectionFilter) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(44);
        }
        if (inspectionsElement == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(45);
        }
        writer.name("profile").value(inspectionsElement.getAttributeValue("profile"));
        writer.name(GROUPS);
        writer.beginArray();
        for (Element group : inspectionsElement.getChildren(GROUP)) {
            JsonInspectionsReportConverter.convertGroup(writer, group, inspectionFilter);
        }
        writer.endArray();
    }

    private static void convertGroup(@NotNull JsonWriter writer, @NotNull Element group, @Nullable Predicate<? super String> inspectionFilter) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(46);
        }
        if (group == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(47);
        }
        if (inspectionFilter != null) {
            boolean anyInspectionsInFilter = false;
            for (Element inspection : group.getChildren(INSPECTION)) {
                if (!inspectionFilter.test(inspection.getAttributeValue(SHORT_NAME))) continue;
                anyInspectionsInFilter = true;
                break;
            }
            if (!anyInspectionsInFilter) {
                return;
            }
        }
        writer.beginObject();
        writer.name(NAME).value(group.getAttributeValue(NAME));
        writer.name("inspections").beginArray();
        for (Element inspection : group.getChildren(INSPECTION)) {
            if (inspectionFilter != null && !inspectionFilter.test(inspection.getAttributeValue(SHORT_NAME))) continue;
            JsonInspectionsReportConverter.convertInspectionDescription(writer, inspection);
        }
        writer.endArray();
        writer.endObject();
    }

    private static void convertInspectionDescription(@NotNull JsonWriter writer, @NotNull Element inspection) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(48);
        }
        if (inspection == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(49);
        }
        writer.beginObject().name(SHORT_NAME).value(inspection.getAttributeValue(SHORT_NAME)).name(DISPLAY_NAME).value(inspection.getAttributeValue(DISPLAY_NAME)).name(DEFAULT_SEVERITY).value(inspection.getAttributeValue(DEFAULT_SEVERITY)).name(PLUGIN_ID).value(inspection.getAttributeValue(PLUGIN_ID)).name(PLUGIN_VERSION).value(inspection.getAttributeValue(PLUGIN_VERSION)).name(LANGUAGE).value(inspection.getAttributeValue(LANGUAGE)).name(GLOBAL_TOOL).value(Boolean.parseBoolean(inspection.getAttributeValue(GLOBAL_TOOL))).name(ENABLED).value(Boolean.parseBoolean(inspection.getAttributeValue(ENABLED))).name(DESCRIPTION).value(inspection.getValue()).endObject();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 28: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawDataDirectoryPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionsResults";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonWriter";
                break;
            }
            case 4: 
            case 11: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROBLEMS;
                break;
            }
            case 14: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROBLEM;
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vulnerabilitiesTagName";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/JsonInspectionsReportConverter";
                break;
            }
            case 31: 
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemClass";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryPoint";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = HINTS;
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptions";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionsElement";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = GROUP;
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = INSPECTION;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/JsonInspectionsReportConverter";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getVulnerabilityValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertDuplicatedCode";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertDuplicates";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertDuplicateFragment";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeFileSegmentAttributes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeFileAttribute";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeSegmentAttributes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertPhpVulnerablePaths";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "convertPhpVulnerablePath";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convertPhpSink";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "convertPhpTaintSource";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convertPhpVulnerableFragment";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "convertPhpTaintMarker";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "writeOrderAttribute";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "writeSanitizedVulnerabilities";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getParameterName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getVulnerabilityValues";
                break;
            }
            case 27: 
            case 28: {
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "convertProblems";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "convertProblem";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "writeInt";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "convertProblemClass";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "convertEntryPoint";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "convertHints";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "convertDescriptions";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "convertDescriptionsContents";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "convertGroup";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "convertInspectionDescription";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

