/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.util.SequentialTask;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PerformFixesModalTask
implements SequentialTask {
    @NotNull
    protected final Project myProject;
    private final List<CommonProblemDescriptor[]> myDescriptorPacks;
    private final PsiDocumentManager myDocumentManager;
    private final PostprocessReformattingAspect myReformattingAspect;
    private final int myLength;
    private int myProcessed;
    private int myPackIdx;
    private int myDescriptorIdx;

    protected PerformFixesModalTask(@NotNull Project project2, CommonProblemDescriptor @NotNull [] descriptors) {
        if (project2 == null) {
            PerformFixesModalTask.$$$reportNull$$$0(0);
        }
        if (descriptors == null) {
            PerformFixesModalTask.$$$reportNull$$$0(1);
        }
        this(project2, Collections.singletonList(descriptors));
    }

    protected PerformFixesModalTask(@NotNull Project project2, @NotNull List<CommonProblemDescriptor[]> descriptorPacks) {
        if (project2 == null) {
            PerformFixesModalTask.$$$reportNull$$$0(2);
        }
        if (descriptorPacks == null) {
            PerformFixesModalTask.$$$reportNull$$$0(3);
        }
        this.myProject = project2;
        this.myDescriptorPacks = descriptorPacks;
        this.myLength = descriptorPacks.stream().mapToInt(ds -> ((CommonProblemDescriptor[])ds).length).sum();
        this.myDocumentManager = PsiDocumentManager.getInstance(this.myProject);
        this.myReformattingAspect = PostprocessReformattingAspect.getInstance((Project)this.myProject);
    }

    @Override
    public boolean isDone() {
        return this.myPackIdx > this.myDescriptorPacks.size() - 1;
    }

    @Override
    public boolean iteration() {
        return true;
    }

    public void doRun(ProgressIndicator indicator) {
        indicator.setIndeterminate(false);
        while (!this.isDone() && !indicator.isCanceled()) {
            this.iteration(indicator);
        }
    }

    @Override
    public boolean iteration(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            PerformFixesModalTask.$$$reportNull$$$0(4);
        }
        Pair<CommonProblemDescriptor, Boolean> pair = this.nextDescriptor();
        CommonProblemDescriptor descriptor = pair.getFirst();
        boolean shouldDoPostponedOperations = pair.getSecond();
        this.beforeProcessing(descriptor);
        indicator.setFraction((double)this.myProcessed++ / (double)this.myLength);
        String presentableText2 = StringUtil.notNullize(this.getPresentableText(descriptor), "usages");
        indicator.setText(InspectionsBundle.message("processing.progress.text", presentableText2));
        boolean runInReadAction = PerformFixesModalTask.mustRunInReadAction(descriptor);
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.myDocumentManager.commitAllDocuments();
            if (!runInReadAction) {
                this.applyFix(this.myProject, descriptor);
                if (shouldDoPostponedOperations) {
                    this.myReformattingAspect.doPostponedFormatting();
                }
            }
        });
        if (runInReadAction) {
            this.applyFix(this.myProject, descriptor);
        }
        return this.isDone();
    }

    private static boolean mustRunInReadAction(@NotNull CommonProblemDescriptor descriptor) {
        if (descriptor == null) {
            PerformFixesModalTask.$$$reportNull$$$0(5);
        }
        boolean runInReadAction = false;
        QuickFix[] fixes = descriptor.getFixes();
        if (fixes != null) {
            for (QuickFix fix2 : fixes) {
                if (fix2.startInWriteAction()) {
                    runInReadAction = false;
                    break;
                }
                runInReadAction = true;
            }
        }
        return runInReadAction;
    }

    protected abstract void applyFix(Project var1, CommonProblemDescriptor var2);

    protected void beforeProcessing(@NotNull CommonProblemDescriptor descriptor) {
        if (descriptor == null) {
            PerformFixesModalTask.$$$reportNull$$$0(6);
        }
    }

    @Nullable
    @NlsSafe
    protected String getPresentableText(@NotNull CommonProblemDescriptor descriptor) {
        if (descriptor == null) {
            PerformFixesModalTask.$$$reportNull$$$0(7);
        }
        if (!(descriptor instanceof ProblemDescriptor)) {
            return null;
        }
        PsiElement psiElement = ((ProblemDescriptor)descriptor).getPsiElement();
        return psiElement != null ? StringUtil.notNullize(SymbolPresentationUtil.getSymbolPresentableText(psiElement)) : null;
    }

    private Pair<CommonProblemDescriptor, Boolean> nextDescriptor() {
        CommonProblemDescriptor[] descriptors = this.myDescriptorPacks.get(this.myPackIdx);
        CommonProblemDescriptor descriptor = descriptors[this.myDescriptorIdx++];
        boolean shouldDoPostponedOperations = false;
        if (this.myDescriptorIdx == descriptors.length) {
            shouldDoPostponedOperations = true;
            ++this.myPackIdx;
            this.myDescriptorIdx = 0;
        }
        return Pair.create(descriptor, shouldDoPostponedOperations);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorPacks";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/ex/PerformFixesModalTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "iteration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "mustRunInReadAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeProcessing";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getPresentableText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

