/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.InspectionOptionContainer;
import com.intellij.codeInspection.ui.OptionAccessor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionOptionsPanel
extends JPanel
implements InspectionOptionContainer {
    @Nullable
    private final OptionAccessor myOptionAccessor;
    private final @NotNull Map<@NonNls String, @NlsContexts.Checkbox String> myCheckBoxLabels;

    public InspectionOptionsPanel() {
        this((OptionAccessor)null);
    }

    public InspectionOptionsPanel(@NotNull InspectionProfileEntry owner) {
        if (owner == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(0);
        }
        this(new OptionAccessor.Default(owner));
    }

    public InspectionOptionsPanel(@Nullable OptionAccessor optionAccessor) {
        super((LayoutManager)new MigLayout("fillx, ins 0"));
        this.myCheckBoxLabels = new HashMap<String, String>();
        this.myOptionAccessor = optionAccessor;
    }

    public static InspectionOptionsPanel singleCheckBox(@NotNull InspectionProfileEntry owner, @NotNull @NlsContexts.Checkbox String label2, @NonNls String property) {
        if (owner == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(1);
        }
        if (label2 == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(2);
        }
        InspectionOptionsPanel panel2 = new InspectionOptionsPanel(owner);
        panel2.addCheckbox(label2, property);
        return panel2;
    }

    public void addRow(Component label2, Component component2) {
        this.add(label2, "");
        this.add(component2, "pushx, wrap");
    }

    public void addLabeledRow(@NlsContexts.Label String labelText, Component component2) {
        JLabel label2 = new JLabel(labelText);
        label2.setLabelFor(component2);
        this.addRow(label2, component2);
    }

    public void addGrowing(Component component2) {
        this.add(component2, "push, grow, wrap");
    }

    @Override
    public Component add(Component comp) {
        super.add(comp, "span, wrap");
        return comp;
    }

    public void addCheckbox(@NotNull @NlsContexts.Checkbox String label2, @NotNull @NonNls String property) {
        if (label2 == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(3);
        }
        if (property == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(4);
        }
        this.addCheckboxEx(label2, property);
    }

    public JCheckBox addCheckboxEx(@NotNull @NlsContexts.Checkbox String label2, @NotNull @NonNls String property) {
        if (label2 == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(5);
        }
        if (property == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(6);
        }
        if (this.myOptionAccessor == null) {
            throw new IllegalStateException("No option accessor or owner specified in constructor call");
        }
        boolean selected = this.myOptionAccessor.getOption(property);
        JCheckBox checkBox = new JCheckBox(label2, selected);
        checkBox.addItemListener(e -> this.myOptionAccessor.setOption(property, e.getStateChange() == 1));
        this.addComponent(checkBox);
        this.myCheckBoxLabels.put(property, label2);
        return checkBox;
    }

    @Override
    @NotNull
    public HtmlChunk getLabelForCheckbox(@NotNull @NonNls String property) {
        String label2;
        if (property == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(7);
        }
        if ((label2 = this.myCheckBoxLabels.get(property)) == null) {
            throw new IllegalArgumentException("Invalid property name: " + property);
        }
        HtmlChunk htmlChunk = HtmlChunk.text(label2);
        if (htmlChunk == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(8);
        }
        return htmlChunk;
    }

    public JCheckBox addDependentCheckBox(@NotNull @NlsContexts.Checkbox String label2, @NotNull @NonNls String property, @NotNull JCheckBox controller) {
        if (label2 == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(9);
        }
        if (property == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(10);
        }
        if (controller == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(11);
        }
        JCheckBox checkBox = this.addCheckboxEx(label2, property);
        checkBox.setBorder(new EmptyBorder(new JBInsets(0, 20, 0, 0)));
        controller.addItemListener(e -> checkBox.setEnabled(((JCheckBox)e.getSource()).isEnabled() && e.getStateChange() == 1));
        checkBox.setEnabled(controller.isEnabled() && controller.isSelected());
        return checkBox;
    }

    public void addComponent(JComponent component2) {
        this.add((Component)component2, "span, wrap, grow");
    }

    @NotNull
    public static Dimension getMinimumListSize() {
        JBDimension jBDimension = JBUI.size(150, 100);
        if (jBDimension == null) {
            InspectionOptionsPanel.$$$reportNull$$$0(12);
        }
        return jBDimension;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/InspectionOptionsPanel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/InspectionOptionsPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelForCheckbox";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimumListSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "singleCheckBox";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addCheckbox";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addCheckboxEx";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLabelForCheckbox";
                break;
            }
            case 8: 
            case 12: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addDependentCheckBox";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

