/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.actions.InspectionViewActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public abstract class KeyAwareInspectionViewAction
extends InspectionViewActionBase {
    private static final Logger LOG = Logger.getInstance(KeyAwareInspectionViewAction.class);

    public KeyAwareInspectionViewAction(String name2) {
        this(() -> name2);
    }

    public KeyAwareInspectionViewAction(@NotNull Supplier<String> name2) {
        if (name2 == null) {
            KeyAwareInspectionViewAction.$$$reportNull$$$0(0);
        }
        super(name2);
    }

    @Override
    protected boolean isEnabled(@NotNull InspectionResultsView view, AnActionEvent e) {
        InspectionToolWrapper<?, ?> wrapper2;
        if (view == null) {
            KeyAwareInspectionViewAction.$$$reportNull$$$0(1);
        }
        return (wrapper2 = KeyAwareInspectionViewAction.getToolWrapper(e)) != null && HighlightDisplayKey.find(wrapper2.getShortName()) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RunInspectionOn
    extends KeyAwareInspectionViewAction {
        public RunInspectionOn() {
            super(InspectionsBundle.messagePointer("run.inspection.on.file.intention.text", new Object[0]));
        }

        @Override
        protected boolean isEnabled(@NotNull InspectionResultsView view, AnActionEvent e) {
            if (view == null) {
                RunInspectionOn.$$$reportNull$$$0(0);
            }
            return super.isEnabled(view, e) && InspectionTree.getSelectedElement(e) != null;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            AnalysisScope scope;
            PsiFile context2;
            if (e == null) {
                RunInspectionOn.$$$reportNull$$$0(1);
            }
            InspectionResultsView view = RunInspectionOn.getView(e);
            HashSet<PsiFile> files2 = new HashSet<PsiFile>();
            for (RefEntity entity : Objects.requireNonNull(view).getTree().getSelectedElements()) {
                if (!(entity instanceof RefElement) || !entity.isValid()) continue;
                PsiElement element2 = ((RefElement)entity).getPsiElement();
                PsiFile file2 = element2.getContainingFile();
                files2.add(file2);
            }
            boolean useModule = true;
            Module module = null;
            for (PsiFile file3 : files2) {
                Module currentFileModule = ModuleUtilCore.findModuleForPsiElement(file3);
                if (currentFileModule != null) {
                    if (module == null) {
                        module = currentFileModule;
                        continue;
                    }
                    if (currentFileModule == module) continue;
                    useModule = false;
                    break;
                }
                useModule = false;
                break;
            }
            switch (files2.size()) {
                case 0: {
                    context2 = null;
                    scope = view.getScope();
                    break;
                }
                case 1: {
                    PsiFile theFile = (PsiFile)ContainerUtil.getFirstItem(files2);
                    LOG.assertTrue(theFile != null);
                    context2 = theFile;
                    scope = new AnalysisScope(theFile);
                    break;
                }
                default: {
                    context2 = null;
                    scope = new AnalysisScope(view.getProject(), ContainerUtil.map(files2, PsiFile::getVirtualFile));
                }
            }
            RunInspectionIntention.selectScopeAndRunInspection(Objects.requireNonNull(RunInspectionOn.getToolWrapper(e)).getShortName(), scope, useModule ? module : null, context2, view.getProject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction$RunInspectionOn";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DisableInspection
    extends KeyAwareInspectionViewAction {
        public DisableInspection() {
            super(DisableInspectionToolAction.getNameText());
        }

        @Override
        protected boolean isEnabled(@NotNull InspectionResultsView view, AnActionEvent e) {
            InspectionToolWrapper<?, ?> wrapper2;
            if (view == null) {
                DisableInspection.$$$reportNull$$$0(0);
            }
            if ((wrapper2 = DisableInspection.getToolWrapper(e)) == null) {
                return false;
            }
            HighlightDisplayKey key = HighlightDisplayKey.find(wrapper2.getShortName());
            if (key == null) {
                return false;
            }
            return InspectionProjectProfileManager.getInstance(view.getProject()).getCurrentProfile().isToolEnabled(key);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DisableInspection.$$$reportNull$$$0(1);
            }
            InspectionResultsView view = DisableInspection.getView(e);
            InspectionToolWrapper<?, ?> wrapper2 = DisableInspection.getToolWrapper(e);
            String shortName = Objects.requireNonNull(wrapper2).getShortName();
            if (Objects.requireNonNull(view).isSingleInspectionRun()) {
                view.getCurrentProfile().modifyProfile(it -> it.setToolEnabled(shortName, false));
            } else {
                RefEntity[] selectedElements = view.getTree().getSelectedElements();
                HashSet<PsiElement> files2 = new HashSet<PsiElement>();
                for (RefEntity selectedElement : selectedElements) {
                    if (!(selectedElement instanceof RefElement)) continue;
                    files2.add(((RefElement)selectedElement).getPsiElement());
                }
                if (files2.isEmpty()) {
                    view.getCurrentProfile().modifyProfile(it -> it.setToolEnabled(shortName, false));
                } else {
                    InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile(view.getProject(), it -> {
                        for (PsiElement element2 : files2) {
                            it.disableTool(shortName, element2);
                        }
                    });
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction$DisableInspection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

