/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions.suppress;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialTask;
import com.intellij.util.ThrowableRunnable;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressActionSequentialTask
implements SequentialTask {
    private static final Logger LOG = Logger.getInstance(SuppressActionSequentialTask.class);
    private final SuppressableInspectionTreeNode[] myNodesToSuppress;
    @NotNull
    private final SuppressIntentionAction mySuppressAction;
    @NotNull
    private final InspectionToolWrapper myWrapper;
    private int myCount;

    public SuppressActionSequentialTask(SuppressableInspectionTreeNode @NotNull [] nodesToSuppress, @NotNull SuppressIntentionAction suppressAction, @NotNull InspectionToolWrapper wrapper2) {
        if (suppressAction == null) {
            SuppressActionSequentialTask.$$$reportNull$$$0(0);
        }
        if (wrapper2 == null) {
            SuppressActionSequentialTask.$$$reportNull$$$0(1);
        }
        if (nodesToSuppress == null) {
            SuppressActionSequentialTask.$$$reportNull$$$0(2);
        }
        this.myCount = 0;
        this.myNodesToSuppress = nodesToSuppress;
        this.mySuppressAction = suppressAction;
        this.myWrapper = wrapper2;
    }

    @Override
    public boolean iteration() {
        return true;
    }

    @Override
    public boolean iteration(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            SuppressActionSequentialTask.$$$reportNull$$$0(3);
        }
        SuppressableInspectionTreeNode node2 = this.myNodesToSuppress[this.myCount++];
        indicator.setFraction((double)this.myCount / (double)this.myNodesToSuppress.length);
        Pair<PsiElement, CommonProblemDescriptor> content2 = node2.getSuppressContent();
        if (content2.first != null) {
            this.suppress((PsiElement)content2.first, (CommonProblemDescriptor)content2.second, this.mySuppressAction, this.myWrapper, node2);
        }
        return this.isDone();
    }

    @Override
    public boolean isDone() {
        return this.myCount > this.myNodesToSuppress.length - 1;
    }

    @Override
    public void prepare() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(InspectionsBundle.message("inspection.action.suppress", this.myWrapper.getDisplayName()));
        }
    }

    private void suppress(@NotNull PsiElement element2, @Nullable CommonProblemDescriptor descriptor, @NotNull SuppressIntentionAction action2, @NotNull InspectionToolWrapper wrapper2, @NotNull SuppressableInspectionTreeNode node2) {
        if (element2 == null) {
            SuppressActionSequentialTask.$$$reportNull$$$0(4);
        }
        if (action2 == null) {
            SuppressActionSequentialTask.$$$reportNull$$$0(5);
        }
        if (wrapper2 == null) {
            SuppressActionSequentialTask.$$$reportNull$$$0(6);
        }
        if (node2 == null) {
            SuppressActionSequentialTask.$$$reportNull$$$0(7);
        }
        if (action2 instanceof SuppressIntentionActionFromFix && !(descriptor instanceof ProblemDescriptor)) {
            LOG.info("local suppression fix for specific problem descriptor:  " + wrapper2.getTool().getClass().getName());
        }
        Project project2 = element2.getProject();
        try {
            PsiElement container = null;
            if (action2 instanceof SuppressIntentionActionFromFix) {
                container = ((SuppressIntentionActionFromFix)action2).getContainer(element2);
            }
            if (container == null) {
                container = element2;
            }
            if (action2.isAvailable(project2, null, element2)) {
                ThrowableRunnable runnable = () -> action2.invoke(project2, null, element2);
                if (action2.startInWriteAction()) {
                    WriteAction.run(runnable);
                } else {
                    runnable.run();
                }
            }
            Set<GlobalInspectionContextImpl> globalInspectionContexts = ((InspectionManagerEx)InspectionManager.getInstance(element2.getProject())).getRunningContexts();
            for (GlobalInspectionContextImpl context2 : globalInspectionContexts) {
                context2.resolveElement((InspectionProfileEntry)wrapper2.getTool(), container);
                if (descriptor == null) continue;
                context2.getPresentation(wrapper2).suppressProblem(descriptor);
            }
        }
        catch (IncorrectOperationException e1) {
            LOG.error(e1);
        }
        node2.removeSuppressActionFromAvailable(this.mySuppressAction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressAction";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesToSuppress";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/ui/actions/suppress/SuppressActionSequentialTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "iteration";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "suppress";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

