/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.DefaultStateSerializerKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.text.UniqueNameGenerator;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u001c\b\u0002\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\u0004\u0018\u0001`\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0000J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u0019\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0016\b\u0002\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001dJL\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\u001d2\u001e\u0010!\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\"H\u0016J.\u0010$\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0014\u0010%\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010#\u0012\u0004\u0012\u00020\u00130\u001dH\u0016J(\u0010&\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010*\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bR\"\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\u0004\u0018\u0001`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000fj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/configurationStore/SchemeManagerIprProvider;", "Lcom/intellij/configurationStore/StreamProvider;", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "subStateTagName", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Ljava/lang/String;Ljava/util/Comparator;)V", "isExclusive", "", "()Z", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "nameToData", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "copyIfNotExists", "", "provider", "delete", "fileSpec", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "load", "state", "Lorg/jdom/Element;", "keyGetter", "Lkotlin/Function1;", "processChildren", "path", "filter", "processor", "Lkotlin/Function3;", "Ljava/io/InputStream;", "read", "consumer", "write", "content", "size", "", "writeState", "intellij.platform.projectModel.impl"})
public final class SchemeManagerIprProvider
extends SimpleModificationTracker
implements StreamProvider {
    private final ReentrantReadWriteLock lock;
    private LinkedHashMap<String, byte[]> nameToData;
    private final boolean isExclusive;
    private final String subStateTagName;
    private final Comparator<String> comparator;

    @Override
    public boolean isExclusive() {
        return this.isExclusive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean read(@NotNull String fileSpec, @NotNull RoamingType roamingType, @NotNull Function1<? super InputStream, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)((Object)roamingType), (String)"roamingType");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            ByteArrayInputStream byteArrayInputStream;
            boolean bl = false;
            Function1<? super InputStream, Unit> function1 = consumer;
            byte[] byArray = this.nameToData.get(PathUtilRt.getFileName(fileSpec));
            if (byArray != null) {
                void p1;
                byte[] byArray2;
                byte[] byArray3 = byArray2 = byArray;
                Function1<? super InputStream, Unit> function12 = function1;
                boolean bl2 = false;
                void var11_13 = p1;
                ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream((byte[])var11_13);
                function1 = function12;
                byteArrayInputStream = byteArrayInputStream2;
            } else {
                byteArrayInputStream = null;
            }
            function1.invoke(byteArrayInputStream);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        int n;
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)((Object)roamingType), (String)"roamingType");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            byte[] byArray = (byte[])this.nameToData.remove(PathUtilRt.getFileName(fileSpec));
        }
        finally {
            n = 0;
            while (n < n2) {
                int n5 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
        this.incModificationCount();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean processChildren(@NotNull String path2, @NotNull RoamingType roamingType, @NotNull Function1<? super String, Boolean> filter2, @NotNull Function3<? super String, ? super InputStream, ? super Boolean, Boolean> processor) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)roamingType), (String)"roamingType");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            Object object = this.nameToData;
            for (Map.Entry entry : object.entrySet()) {
                boolean bl2;
                void name2;
                Object object2 = entry;
                object = (String)object2.getKey();
                object2 = entry;
                byte[] data2 = (byte[])object2.getValue();
                if (!((Boolean)filter2.invoke((Object)name2)).booleanValue()) continue;
                object2 = data2;
                object2 = new ByteArrayInputStream((byte[])object2);
                Throwable throwable = null;
                try {
                    ByteArrayInputStream it = (ByteArrayInputStream)object2;
                    boolean bl3 = false;
                    bl2 = (Boolean)processor.invoke((Object)name2, (Object)it, (Object)false);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
                if (bl2) continue;
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull String fileSpec, @NotNull byte[] content2, int size, @NotNull RoamingType roamingType) {
        int n;
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)((Object)roamingType), (String)"roamingType");
        Object object = content2;
        DefaultStateSerializerKt.getLOG().assertTrue(!(((byte[])object).length == 0));
        object = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n2 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            byte[] byArray = this.nameToData.put(PathUtilRt.getFileName(fileSpec), ArrayUtil.realloc(content2, size));
        }
        finally {
            n = 0;
            while (n < n2) {
                int n5 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
        this.incModificationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(@Nullable Element state, @Nullable Function1<? super Element, String> keyGetter) {
        int n;
        if (state == null) {
            int n2;
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n4 = 0;
            while (n4 < n3) {
                int n5 = n4++;
                n2 = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                this.nameToData.clear();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n2 = 0;
                while (n2 < n3) {
                    int n6 = n2++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
            this.incModificationCount();
            return;
        }
        LinkedHashMap<String, byte[]> nameToData = new LinkedHashMap<String, byte[]>();
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        for (Element child : state.getChildren(this.subStateTagName)) {
            CharSequence charSequence;
            Object name2;
            block23: {
                Object object;
                block22: {
                    if (JDOMUtil.isEmpty(child)) continue;
                    object = keyGetter;
                    if (object == null) break block22;
                    Element element2 = child;
                    Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"child");
                    if ((object = (String)object.invoke((Object)element2)) != null) break block23;
                }
                object = name2 = child.getAttributeValue("name");
            }
            if (name2 == null) {
                for (Element optionElement : child.getChildren("option")) {
                    if (!Intrinsics.areEqual((Object)optionElement.getAttributeValue("name"), (Object)"myName")) continue;
                    name2 = optionElement.getAttributeValue("value");
                }
            }
            if ((charSequence = (CharSequence)name2) == null || charSequence.length() == 0) continue;
            String string2 = nameGenerator.generateUniqueName(FileUtil.sanitizeFileName(name2, false) + ".xml");
            Element element3 = child;
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"child");
            nameToData.put(string2, JdomKt.toBufferExposingByteArray$default(element3, null, 1, null).toByteArray());
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n7 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n8 = 0;
        while (n8 < n7) {
            int n9 = n8++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            if (this.comparator == null) {
                this.nameToData = nameToData;
            } else {
                this.nameToData.clear();
                this.nameToData.putAll(MapsKt.toSortedMap((Map)nameToData, this.comparator));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n = 0;
            while (n < n7) {
                int n10 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
        this.incModificationCount();
    }

    public static /* synthetic */ void load$default(SchemeManagerIprProvider schemeManagerIprProvider, Element element2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        schemeManagerIprProvider.load(element2, (Function1<? super Element, String>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            Set<String> set2 = this.nameToData.keySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"nameToData.keys");
            Comparable[] $this$toTypedArray$iv = (Comparable[])set2;
            boolean $i$f$toTypedArray = false;
            Comparable[] thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new String[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            Object[] names = objectArray;
            if (this.comparator == null) {
                $this$toTypedArray$iv = (Comparable[])names;
                ArraysKt.sort((Object[])$this$toTypedArray$iv);
            } else {
                ArraysKt.sortWith((Object[])names, this.comparator);
            }
            for (Object name2 : names) {
                byte[] byArray;
                if (this.nameToData.get(name2) == null) continue;
                byte[] it = byArray;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                byte[] byArray2 = it;
                state.addContent(JDOMUtil.load(new ByteArrayInputStream(byArray2)));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyIfNotExists(@NotNull SchemeManagerIprProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            int n;
            boolean bl = false;
            ReentrantReadWriteLock reentrantReadWriteLock2 = provider2.lock;
            ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock2.readLock();
            int n2 = reentrantReadWriteLock2.getWriteHoldCount() == 0 ? reentrantReadWriteLock2.getReadHoldCount() : 0;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3++;
                n = 0;
                readLock2.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock2.writeLock();
            writeLock.lock();
            try {
                boolean bl2 = false;
                for (String key : this.nameToData.keySet()) {
                    if (provider2.nameToData.containsKey(key)) continue;
                    LinkedHashMap<String, byte[]> linkedHashMap = provider2.nameToData;
                    byte[] byArray = this.nameToData.get(key);
                    Intrinsics.checkNotNull((Object)byArray);
                    linkedHashMap.put(key, byArray);
                    provider2.incModificationCount();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n = 0;
                while (n < n2) {
                    int n5 = n++;
                    readLock2.lock();
                }
                writeLock.unlock();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    public SchemeManagerIprProvider(@NotNull String subStateTagName, @Nullable Comparator<String> comparator2) {
        Intrinsics.checkNotNullParameter((Object)subStateTagName, (String)"subStateTagName");
        this.subStateTagName = subStateTagName;
        this.comparator = comparator2;
        this.lock = new ReentrantReadWriteLock();
        this.nameToData = new LinkedHashMap();
    }

    public /* synthetic */ SchemeManagerIprProvider(String string2, Comparator comparator2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            comparator2 = null;
        }
        this(string2, comparator2);
    }

    @Override
    public void write(@NotNull String path2, @NotNull BufferExposingByteArrayOutputStream content2, @NotNull RoamingType roamingType) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)((Object)roamingType), (String)"roamingType");
        StreamProvider.DefaultImpls.write(this, path2, content2, roamingType);
    }

    @Override
    public boolean getEnabled() {
        return StreamProvider.DefaultImpls.getEnabled(this);
    }

    @Override
    public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)((Object)roamingType), (String)"roamingType");
        return StreamProvider.DefaultImpls.isApplicable(this, fileSpec, roamingType);
    }
}

