/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ComponentManagerSettings;
import com.intellij.conversion.WorkspaceSettings;
import com.intellij.openapi.util.JDOMUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

class SettingsXmlFile
implements ComponentManagerSettings,
WorkspaceSettings {
    private static final Element EMPTY_ELEMENT = new Element("root");
    private final Path file;
    @Nullable
    private Element element;

    SettingsXmlFile(@NotNull Path file2) throws CannotConvertException {
        if (file2 == null) {
            SettingsXmlFile.$$$reportNull$$$0(0);
        }
        this.file = file2;
    }

    @NotNull
    public Path getFile() {
        Path path2 = this.file;
        if (path2 == null) {
            SettingsXmlFile.$$$reportNull$$$0(1);
        }
        return path2;
    }

    @Override
    public Element getComponentElement(@NotNull @NonNls String componentName) {
        if (componentName == null) {
            SettingsXmlFile.$$$reportNull$$$0(2);
        }
        return this.findComponent(componentName);
    }

    @Override
    @NotNull
    public Path getPath() {
        Path path2 = this.file;
        if (path2 == null) {
            SettingsXmlFile.$$$reportNull$$$0(3);
        }
        return path2;
    }

    @NotNull
    private Element getElement() {
        Element result2 = this.element;
        if (result2 == null) {
            try {
                result2 = JDOMUtil.load(this.file);
            }
            catch (NoSuchFileException e) {
                result2 = EMPTY_ELEMENT;
            }
            catch (IOException | JDOMException e) {
                this.element = EMPTY_ELEMENT;
                throw new CannotConvertException("Cannot load " + this.file, (Throwable)e);
            }
            this.element = result2;
        }
        Element element2 = result2;
        if (element2 == null) {
            SettingsXmlFile.$$$reportNull$$$0(4);
        }
        return element2;
    }

    @Override
    @NotNull
    public Element getRootElement() {
        return this.getElement();
    }

    public void save() throws IOException {
        if (this.element == null || this.element == EMPTY_ELEMENT) {
            return;
        }
        Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(this.file, new OpenOption[0]);){
            JDOMUtil.writeElement(this.getElement(), writer, System.lineSeparator());
        }
    }

    @Nullable
    public Element findComponent(@NotNull String componentName) {
        if (componentName == null) {
            SettingsXmlFile.$$$reportNull$$$0(5);
        }
        return this.element == EMPTY_ELEMENT ? null : JDomSerializationUtil.findComponent((Element)this.getElement(), (String)componentName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/conversion/impl/SettingsXmlFile";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/conversion/impl/SettingsXmlFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getComponentElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findComponent";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

