/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.ConsolePromptDecorator;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleExecutionEditor
implements Disposable {
    private final EditorEx myConsoleEditor;
    private EditorEx myCurrentEditor;
    private final Document myEditorDocument;
    private final LanguageConsoleImpl.Helper myHelper;
    private final MessageBusConnection myBusConnection;
    private final ConsolePromptDecorator myConsolePromptDecorator;
    private final FocusChangeListener myFocusListener;

    public ConsoleExecutionEditor(@NotNull LanguageConsoleImpl.Helper helper) {
        if (helper == null) {
            ConsoleExecutionEditor.$$$reportNull$$$0(0);
        }
        this.myFocusListener = new FocusChangeListener(){

            public void focusGained(@NotNull Editor editor2) {
                if (editor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ConsoleExecutionEditor.this.myCurrentEditor = (EditorEx)editor2;
                if (GeneralSettings.getInstance().isSaveOnFrameDeactivation()) {
                    ApplicationManager.getApplication().invokeLater(() -> FileDocumentManager.getInstance().saveAllDocuments());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/ConsoleExecutionEditor$1", "focusGained"));
            }
        };
        this.myHelper = helper;
        EditorFactory editorFactory = EditorFactory.getInstance();
        this.myEditorDocument = helper.getDocument();
        this.myConsoleEditor = (EditorEx)editorFactory.createEditor(this.myEditorDocument, helper.project);
        this.myConsoleEditor.getScrollPane().getHorizontalScrollBar().setEnabled(false);
        this.myConsoleEditor.addFocusListener(this.myFocusListener);
        this.myConsoleEditor.getSettings().setVirtualSpace(false);
        this.myCurrentEditor = this.myConsoleEditor;
        this.myConsoleEditor.putUserData(IncrementalFindAction.SEARCH_DISABLED, (Object)true);
        this.myConsolePromptDecorator = new ConsolePromptDecorator(this.myConsoleEditor);
        this.myConsoleEditor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)this.myConsolePromptDecorator);
        this.myBusConnection = this.getProject().getMessageBus().connect();
        ApplicationManager.getApplication().invokeLater(() -> this.installEditorFactoryListener(), o -> Disposer.isDisposed(this.myBusConnection));
    }

    public void initComponent() {
        this.myConsoleEditor.setContextMenuGroupId("ConsoleEditorPopupMenu");
        this.myConsoleEditor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(this.getVirtualFile(), this.myConsoleEditor.getColorsScheme(), this.getProject()));
        this.myConsolePromptDecorator.update();
    }

    @NotNull
    public final VirtualFile getVirtualFile() {
        VirtualFile virtualFile2 = this.myHelper.virtualFile;
        if (virtualFile2 == null) {
            ConsoleExecutionEditor.$$$reportNull$$$0(1);
        }
        return virtualFile2;
    }

    public EditorEx getEditor() {
        return this.myConsoleEditor;
    }

    @NotNull
    public EditorEx getCurrentEditor() {
        EditorEx editorEx = ObjectUtils.notNull(this.myCurrentEditor, this.myConsoleEditor);
        if (editorEx == null) {
            ConsoleExecutionEditor.$$$reportNull$$$0(2);
        }
        return editorEx;
    }

    public Document getDocument() {
        return this.myEditorDocument;
    }

    public JComponent getComponent() {
        return this.myConsoleEditor.getComponent();
    }

    @NotNull
    public ConsolePromptDecorator getConsolePromptDecorator() {
        ConsolePromptDecorator consolePromptDecorator = this.myConsolePromptDecorator;
        if (consolePromptDecorator == null) {
            ConsoleExecutionEditor.$$$reportNull$$$0(3);
        }
        return consolePromptDecorator;
    }

    public void setConsoleEditorEnabled(boolean consoleEditorEnabled) {
        if (this.isConsoleEditorEnabled() == consoleEditorEnabled) {
            return;
        }
        if (consoleEditorEnabled) {
            FileEditorManager.getInstance(this.getProject()).closeFile(this.getVirtualFile());
            this.myCurrentEditor = this.myConsoleEditor;
        }
        this.myConsoleEditor.getComponent().setVisible(consoleEditorEnabled);
    }

    private Project getProject() {
        return this.myHelper.project;
    }

    public final boolean isConsoleEditorEnabled() {
        return this.myConsoleEditor.getComponent().isVisible();
    }

    @Nullable
    public String getPrompt() {
        return this.myConsolePromptDecorator.getMainPrompt();
    }

    @NotNull
    public ConsoleViewContentType getPromptAttributes() {
        ConsoleViewContentType consoleViewContentType = this.myConsolePromptDecorator.getPromptAttributes();
        if (consoleViewContentType == null) {
            ConsoleExecutionEditor.$$$reportNull$$$0(4);
        }
        return consoleViewContentType;
    }

    public void setPromptAttributes(@NotNull ConsoleViewContentType textAttributes) {
        if (textAttributes == null) {
            ConsoleExecutionEditor.$$$reportNull$$$0(5);
        }
        this.myConsolePromptDecorator.setPromptAttributes(textAttributes);
    }

    public void setPrompt(@Nullable String prompt) {
        this.setPromptInner(prompt);
    }

    public void setEditable(boolean editable) {
        this.myConsoleEditor.setRendererMode(!editable);
        this.myConsolePromptDecorator.update();
    }

    public boolean isEditable() {
        return !this.myConsoleEditor.isRendererMode();
    }

    private void setPromptInner(@Nullable String prompt) {
        if (!this.myConsoleEditor.isDisposed()) {
            this.myConsolePromptDecorator.setMainPrompt(prompt != null ? prompt : "");
        }
    }

    private void installEditorFactoryListener() {
        FileEditorManagerListener fileEditorListener = new FileEditorManagerListener(){

            @Override
            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (ConsoleExecutionEditor.this.myConsoleEditor == null || !Comparing.equal(file2, ConsoleExecutionEditor.this.getVirtualFile())) {
                    return;
                }
                Editor selectedTextEditor = source.getSelectedTextEditor();
                for (FileEditor fileEditor : source.getAllEditors(file2)) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    EditorEx editor2 = (EditorEx)((TextEditor)fileEditor).getEditor();
                    editor2.addFocusListener(ConsoleExecutionEditor.this.myFocusListener);
                    if (selectedTextEditor == editor2) {
                        ConsoleExecutionEditor.this.myCurrentEditor = editor2;
                    }
                    EmptyAction.registerActionShortcuts((JComponent)editor2.getComponent(), (JComponent)ConsoleExecutionEditor.this.myConsoleEditor.getComponent());
                }
            }

            @Override
            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (!Comparing.equal(file2, ConsoleExecutionEditor.this.getVirtualFile())) {
                    return;
                }
                if (!Boolean.TRUE.equals(file2.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN)) && ConsoleExecutionEditor.this.myCurrentEditor != null && ConsoleExecutionEditor.this.myCurrentEditor.isDisposed()) {
                    ConsoleExecutionEditor.this.myCurrentEditor = null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/console/ConsoleExecutionEditor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myBusConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, fileEditorListener);
        FileEditorManager editorManager = FileEditorManager.getInstance(this.getProject());
        if (editorManager.isFileOpen(this.getVirtualFile())) {
            fileEditorListener.fileOpened(editorManager, this.getVirtualFile());
        }
    }

    @Override
    public void dispose() {
        this.myBusConnection.deliverImmediately();
        Disposer.dispose(this.myBusConnection);
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.releaseEditor((Editor)this.myConsoleEditor);
    }

    public void setInputText(@NotNull String query2) {
        if (query2 == null) {
            ConsoleExecutionEditor.$$$reportNull$$$0(6);
        }
        DocumentUtil.writeInRunUndoTransparentAction(() -> this.myConsoleEditor.getDocument().setText(StringUtil.convertLineSeparators(query2)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/console/ConsoleExecutionEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/console/ConsoleExecutionEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsolePromptDecorator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPromptAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setPromptAttributes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setInputText";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

